/*
 * Decompiled with CFR 0.152.
 */
package eu.mc.sync.rest.service;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.mc.sync.logic.model.rest.DiscordMessageTO;
import eu.mc.sync.platform.PlatformAdapter;
import eu.mc.sync.rest.service.ApiErrorState;
import eu.mc.sync.rest.service.HttpConnectionService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class MessageService {
    private static final String API_BASE_URL = "https://api.mc-sync.eu/v1/message";
    private final PlatformAdapter platform;
    private final Gson gson;
    private final HttpConnectionService connectionService;

    public MessageService(PlatformAdapter platform, Gson gson, HttpConnectionService connectionService) {
        this.platform = platform;
        this.gson = gson;
        this.connectionService = connectionService;
    }

    public void broadcastMessagesFromDiscord() {
        List<DiscordMessageTO> messages = this.fetchDiscordMessages();
        messages.sort(Comparator.comparing(DiscordMessageTO::created).reversed());
        for (DiscordMessageTO message : messages) {
            this.platform.broadcast(message.message());
        }
    }

    private List<DiscordMessageTO> fetchDiscordMessages() {
        if (ApiErrorState.hasAuthenticationFailed()) {
            return new ArrayList<DiscordMessageTO>();
        }
        try {
            URL url = new URI(API_BASE_URL).toURL();
            HttpURLConnection connection = this.connectionService.createGetConnection(url);
            this.logRequestIfDevMode(url);
            return this.processMessageResponse(connection);
        }
        catch (Exception e) {
            this.platform.logSevere("Error while fetching messages: " + e.getMessage());
            return new ArrayList<DiscordMessageTO>();
        }
    }

    private void logRequestIfDevMode(URL url) {
        if (this.platform.getDevMode()) {
            this.platform.logInfo("Sending GET request to: " + url.toString());
        }
    }

    private List<DiscordMessageTO> processMessageResponse(HttpURLConnection connection) throws Exception {
        int responseCode = connection.getResponseCode();
        if (responseCode >= 200 && responseCode < 300) {
            return this.parseMessageResponse(connection);
        }
        if (responseCode == 401) {
            ApiErrorState.markAuthenticationFailed();
            this.platform.logSevere("Please set the token in the server config and restart the server.");
            return new ArrayList<DiscordMessageTO>();
        }
        this.platform.logSevere("Error while fetching messages: " + responseCode);
        return new ArrayList<DiscordMessageTO>();
    }

    private List<DiscordMessageTO> parseMessageResponse(HttpURLConnection connection) throws Exception {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            Type listType = new TypeToken<List<DiscordMessageTO>>(this){}.getType();
            List list = (List)this.gson.fromJson(response.toString(), listType);
            return list;
        }
    }
}

