/*
 * Decompiled with CFR 0.152.
 */
package eu.mc.sync.rest.service;

import com.google.gson.Gson;
import eu.mc.sync.logic.model.rest.VersionResponseTO;
import eu.mc.sync.platform.PlatformAdapter;
import eu.mc.sync.rest.service.ApiErrorState;
import eu.mc.sync.rest.service.HttpConnectionService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class VersionService {
    private static final String UPDATE_CHECK_URL = "https://api.mc-sync.eu/v1/version";
    private static final double CURRENT_VERSION = 2.0;
    private final PlatformAdapter platform;
    private final Gson gson;
    private final HttpConnectionService connectionService;

    public VersionService(PlatformAdapter platform, Gson gson, HttpConnectionService connectionService) {
        this.platform = platform;
        this.gson = gson;
        this.connectionService = connectionService;
    }

    public void checkForUpdates(String platformName) {
        if (ApiErrorState.hasAuthenticationFailed()) {
            return;
        }
        try {
            String urlWithParams = "https://api.mc-sync.eu/v1/version?platform=" + platformName;
            URL url = new URI(urlWithParams).toURL();
            HttpURLConnection connection = this.connectionService.createGetConnection(url);
            this.handleVersionResponse(connection);
        }
        catch (Exception e) {
            this.logDetailedError(platformName, e);
        }
    }

    private void handleVersionResponse(HttpURLConnection connection) throws Exception {
        int responseCode = connection.getResponseCode();
        if (responseCode >= 200 && responseCode < 300) {
            this.processSuccessfulResponse(connection);
        } else if (responseCode == 401) {
            ApiErrorState.markAuthenticationFailed();
            this.platform.logSevere("Please set the token in the server config and restart the server.");
        } else if (responseCode == 405) {
            this.platform.logSevere("Method not allowed. Please check the API endpoint.");
        } else {
            this.platform.logSevere("Error checking version: " + responseCode);
        }
    }

    private void processSuccessfulResponse(HttpURLConnection connection) throws Exception {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            VersionResponseTO versionResponse = this.gson.fromJson(response.toString(), VersionResponseTO.class);
            this.logVersionStatus(versionResponse);
        }
    }

    private void logVersionStatus(VersionResponseTO versionResponse) {
        if (versionResponse.version() > 2.0) {
            this.platform.logInfo("MC-Sync is outdated! Current Version: 2.0, Latest Version: " + versionResponse.version());
            this.platform.logInfo("Download the latest version at https://plugin.mc-sync.eu");
        } else {
            this.platform.logInfo("MC-Sync is up to date (2.0)");
        }
    }

    private void logDetailedError(String platformName, Exception e) {
        this.platform.logSevere("Error checking version for platform '" + platformName + "':");
        this.platform.logSevere("  URL: https://api.mc-sync.eu/v1/version");
        this.platform.logSevere("  Exception: " + e.getClass().getSimpleName() + " - " + e.getMessage());
        if (this.platform.getDevMode()) {
            this.platform.logSevere("  Stack trace: " + this.getStackTraceString(e));
        }
    }

    private String getStackTraceString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
}

