/*
 * Decompiled with CFR 0.152.
 */
package eu.mc.sync.rest.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public class JsonUtils {
    public static Gson createGson() {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)ZonedDateTime.class), new ZonedDateTimeSerializer()).registerTypeAdapter((Type)((Object)LocalDateTime.class), new LocalDateTimeDeserializer()).registerTypeAdapter((Type)((Object)LocalDateTime.class), new LocalDateTimeSerializer()).create();
    }

    private static class ZonedDateTimeSerializer
    implements JsonSerializer<ZonedDateTime> {
        private ZonedDateTimeSerializer() {
        }

        @Override
        public JsonElement serialize(ZonedDateTime src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toEpochSecond());
        }
    }

    private static class LocalDateTimeDeserializer
    implements JsonDeserializer<LocalDateTime> {
        private LocalDateTimeDeserializer() {
        }

        @Override
        public LocalDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return LocalDateTime.parse(json.getAsString());
        }
    }

    private static class LocalDateTimeSerializer
    implements JsonSerializer<LocalDateTime> {
        private LocalDateTimeSerializer() {
        }

        @Override
        public JsonElement serialize(LocalDateTime src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }
}

