/*
 * Decompiled with CFR 0.152.
 */
package dev.gxlg.autoenchanter;

import com.mojang.brigadier.context.CommandContext;
import dev.gxlg.autoenchanter.DataStructures;
import dev.gxlg.autoenchanter.MultiVersion;
import dev.gxlg.autoenchanter.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_471;
import net.minecraft.class_636;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7842;

public class Worker {
    private static class_7842 textDisplay;
    private static class_4185 buttonSelect;
    private static class_4185 buttonCalculate;
    private static class_4185 buttonCancel;
    private static class_4185 buttonStart;
    private static State state;
    private static final List<Integer> selected;
    private static int enchantCost;
    private static boolean readyToEnchant;
    private static Utils.ShapePool search;
    private static DataStructures.IterItem<DataStructures.Shape> current;
    private static List<DataStructures.AnvilItem> operations;
    private static int opid;
    private static int sopid;
    private static int timer;

    public static void setup(class_7842 text, class_4185 select, class_4185 calculate, class_4185 start, class_4185 cancel) {
        textDisplay = text;
        buttonSelect = select;
        buttonCalculate = calculate;
        buttonStart = start;
        buttonCancel = cancel;
        if (state == State.CALCULATE) {
            Worker.showText("Calculating...", -7889207);
            Worker.buttonSelect.field_22764 = false;
            Worker.buttonCalculate.field_22764 = false;
            Worker.buttonCancel.field_22764 = true;
            Worker.buttonStart.field_22764 = false;
        } else if (readyToEnchant) {
            Worker.ready();
        } else {
            Worker.cancel();
        }
    }

    public static void ready() {
        Worker.showText("Can enchant for " + enchantCost + " lvls", -4725903);
        Worker.buttonSelect.field_22764 = false;
        Worker.buttonCalculate.field_22764 = false;
        Worker.buttonCancel.field_22764 = true;
        Worker.buttonStart.field_22764 = true;
        state = State.UNSET;
    }

    public static void select() {
        Worker.showText("Select items to use", -131211);
        Worker.buttonSelect.field_22764 = false;
        Worker.buttonCalculate.field_22764 = true;
        Worker.buttonCancel.field_22764 = true;
        Worker.buttonStart.field_22764 = false;
        state = State.SELECT;
    }

    public static int cancelCommand(CommandContext<FabricClientCommandSource> context) {
        Worker.cancel();
        ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)"Cancelled everything"));
        return 0;
    }

    public static void cancel() {
        if (search != null) {
            search.cancel();
            search = null;
        }
        current = null;
        readyToEnchant = false;
        operations = null;
        selected.clear();
        Worker.hideText();
        Worker.buttonSelect.field_22764 = true;
        Worker.buttonCalculate.field_22764 = false;
        Worker.buttonCancel.field_22764 = false;
        Worker.buttonStart.field_22764 = false;
        state = State.UNSET;
    }

    public static void calculate() {
        if (selected.size() < 2) {
            Worker.showText("Not enough items selected", -3599340);
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_1703 handler = player.field_7512;
        if (handler == null) {
            return;
        }
        ArrayList<DataStructures.Enchant> collection = new ArrayList<DataStructures.Enchant>();
        DataStructures.Enchant mainItem = null;
        for (int slot : selected) {
            class_1799 stack = handler.method_7611(slot).method_7677();
            DataStructures.Enchant item = DataStructures.Enchant.from(stack);
            collection.add(item);
            if (mainItem != null) continue;
            mainItem = item;
        }
        boolean conflicts = false;
        HashSet<class_6880<class_1887>> ignoredEncs = new HashSet<class_6880<class_1887>>();
        for (int i2 = 0; i2 < collection.size() - 1; ++i2) {
            DataStructures.Enchant b = (DataStructures.Enchant)collection.get(i2);
            if (b.enchantments().size() == 0) continue;
            boolean anyToItem = false;
            block2: for (int j = i2 + 1; j < collection.size(); ++j) {
                DataStructures.Enchant enchant = (DataStructures.Enchant)collection.get(j);
                for (class_6880<class_1887> d : b.enchantments().keySet()) {
                    boolean anyCompat = false;
                    for (class_6880<class_1887> e2 : enchant.enchantments().keySet()) {
                        if (d == e2 || MultiVersion.canCombine(d, e2)) {
                            anyCompat = true;
                        }
                        if (d == e2 || MultiVersion.canCombine(d, e2) || b != mainItem) continue;
                        ignoredEncs.add(e2);
                    }
                    if (!anyCompat) {
                        conflicts = true;
                        continue block2;
                    }
                    if (!((class_1887)d.comp_349()).method_8192(mainItem.item().method_7854()) && mainItem.item() != class_1802.field_8598) continue;
                    anyToItem = true;
                }
            }
            if (anyToItem) continue;
            conflicts = true;
            break;
        }
        if (conflicts) {
            Worker.showText("Some items are incompatible or useless", -3599340);
            return;
        }
        HashMap map = new HashMap();
        for (DataStructures.Enchant item : collection) {
            for (Map.Entry<class_6880<class_1887>, DataStructures.EMap> entry : item.enchantments().entrySet()) {
                Map listMap;
                class_6880<class_1887> class_68802 = entry.getKey();
                int lvl = entry.getValue().lvl();
                if (!map.containsKey(class_68802)) {
                    map.put(class_68802, new HashMap());
                }
                if (!(listMap = (Map)map.get(class_68802)).containsKey(lvl)) {
                    listMap.put(lvl, new ArrayList());
                }
                ((List)listMap.get(lvl)).add(item);
            }
        }
        HashMap<class_6880<class_1887>, Map<Integer, List<DataStructures.Enchant>>> trueMap = new HashMap<class_6880<class_1887>, Map<Integer, List<DataStructures.Enchant>>>();
        HashMap<class_6880, Integer> wasted = new HashMap<class_6880, Integer>();
        HashMap<class_6880<class_1887>, Integer> maxMap = new HashMap<class_6880<class_1887>, Integer>();
        for (Map.Entry entry : map.entrySet()) {
            List en = (List)((Map)entry.getValue()).values().stream().findFirst().orElseThrow();
            if (((Map)entry.getValue()).size() == 1 && en.size() == 1) {
                maxMap.put((class_6880<class_1887>)((class_6880)entry.getKey()), (Integer)((Map)entry.getValue()).keySet().stream().toList().getFirst());
                continue;
            }
            trueMap.put((class_6880)entry.getKey(), (Map)entry.getValue());
            ArrayList<Integer> stack = new ArrayList<Integer>();
            Iterator<Object> iterator = ((Map)entry.getValue()).entrySet().stream().flatMap(x -> ((List)x.getValue()).stream().map(z -> (Integer)x.getKey())).sorted().toList().iterator();
            while (iterator.hasNext()) {
                int i3 = (Integer)iterator.next();
                stack.add(i3);
                while (stack.size() > 1 && ((Integer)stack.getLast()).equals(stack.get(stack.size() - 2)) && (Integer)stack.getLast() < ((class_1887)((class_6880)entry.getKey()).comp_349()).method_8183()) {
                    int j = (Integer)stack.removeLast();
                    stack.removeLast();
                    stack.add(j + 1);
                }
            }
            if (stack.size() > 1 && !ignoredEncs.contains(entry.getKey())) {
                if (((Integer)stack.getLast()).intValue() == ((class_1887)((class_6880)entry.getKey()).comp_349()).method_8183()) {
                    wasted.put((class_6880)entry.getKey(), stack.subList(0, stack.size() - 1).stream().mapToInt(i -> i).min().orElse(0));
                } else {
                    Worker.showText(String.valueOf(((class_6880)entry.getKey()).comp_349()) + " has wasted items", -3599340);
                    return;
                }
            }
            maxMap.put((class_6880<class_1887>)((class_6880)entry.getKey()), (Integer)stack.getLast());
        }
        if (!ignoredEncs.isEmpty()) {
            for (DataStructures.Enchant enchant : collection) {
                if (!ignoredEncs.containsAll(enchant.enchantments().keySet())) continue;
                Worker.showText("Some items' every enchantment is ignored", -3599340);
                return;
            }
        }
        if (!wasted.isEmpty()) {
            for (DataStructures.Enchant enchant : collection) {
                if (!enchant.enchantments().entrySet().stream().allMatch(e -> wasted.containsKey(e.getKey()) && ((DataStructures.EMap)e.getValue()).lvl() <= (Integer)wasted.get(e.getKey()))) continue;
                Worker.showText("Some items' every enchantment is wasted", -3599340);
                return;
            }
        }
        ArrayList<DataStructures.Enchant> arrayList = new ArrayList<DataStructures.Enchant>(collection.subList(1, collection.size()));
        arrayList.sort(Comparator.comparingInt(e -> e.enchantments().values().stream().mapToInt(j -> j.lvl() * j.cost(e.item())).sum()));
        search = new Utils.ShapePool(collection.size(), arrayList, trueMap, mainItem, ignoredEncs, maxMap);
        Worker.showText("Calculating...", -7889207);
        Worker.buttonSelect.field_22764 = false;
        Worker.buttonCalculate.field_22764 = false;
        Worker.buttonCancel.field_22764 = true;
        Worker.buttonStart.field_22764 = false;
        state = State.CALCULATE;
        opid = 0;
        sopid = 0;
        timer = 0;
    }

    public static void start() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_1703 handler = player.field_7512;
        List<DataStructures.EnchantedItem> outputs = operations.subList(opid, operations.size()).stream().map(DataStructures.AnvilItem::result).toList();
        List<DataStructures.EnchantedItem> inputs = operations.subList(opid, operations.size()).stream().flatMap(e -> Stream.of(e.target(), e.sacrifice())).filter(i -> outputs.stream().noneMatch(j -> j == i)).toList();
        HashSet<Integer> found = new HashSet<Integer>();
        for (DataStructures.EnchantedItem inp : inputs) {
            int slot = IntStream.range(3, handler.method_7602().size()).boxed().filter(i -> !found.contains(i) && inp.matches(handler.method_7611(i.intValue()).method_7677())).findFirst().orElse(-1);
            if (slot == -1) {
                Worker.showText("Not all items for enchanting are present", -3599340);
                return;
            }
            found.add(slot);
        }
        Worker.showText("Enchanting, please don't use the mouse...", -4725903);
        Worker.buttonSelect.field_22764 = false;
        Worker.buttonCalculate.field_22764 = false;
        Worker.buttonCancel.field_22764 = true;
        Worker.buttonStart.field_22764 = false;
        state = State.EXEC;
    }

    public static void closeScreen() {
        if (state == State.UNSET || state == State.CALCULATE || state == State.EXEC) {
            return;
        }
        Worker.cancel();
    }

    public static void tick() {
        if (state == State.UNSET || state == State.SELECT) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_636 manager = client.field_1761;
        class_746 player = client.field_1724;
        if (player == null || manager == null) {
            return;
        }
        class_1703 handler = player.field_7512;
        if (state == State.CALCULATE) {
            if (search.working()) {
                current = search.peek();
                return;
            }
            DataStructures.FilledShape m = search.getBestShape();
            enchantCost = search.getMinCost();
            if (m == null) {
                Worker.cancel();
                Worker.showText("Couldn't find a tree", -3599340);
                if (!(client.field_1755 instanceof class_471)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Couldn't find a tree").method_27692(class_124.field_1061), false);
                }
                return;
            }
            readyToEnchant = true;
            operations = m.execute();
            Worker.ready();
            if (!(client.field_1755 instanceof class_471)) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Can enchant for " + enchantCost + " lvls")).method_27692(class_124.field_1060), false);
            }
        } else if (state == State.EXEC) {
            if (!(client.field_1755 instanceof class_471)) {
                sopid = 0;
                return;
            }
            if (timer < 5) {
                ++timer;
                return;
            }
            timer = 0;
            DataStructures.AnvilItem current = operations.get(opid);
            int cost = current.result().cost() - current.sacrifice().cost() - current.target().cost();
            if (!player.method_56992() && player.field_7520 < cost) {
                Worker.showText("Not enough levels for the current combo, needed: " + cost, -3599340);
                return;
            }
            if (sopid == 0) {
                DataStructures.EnchantedItem item = current.target();
                if (item.matches(handler.method_7611(0).method_7677())) {
                    sopid = 1;
                    return;
                }
                int slot = IntStream.range(3, handler.method_7602().size()).boxed().filter(i -> item.matches(handler.method_7611(i.intValue()).method_7677())).findFirst().orElse(-1);
                if (slot == -1) {
                    return;
                }
                manager.method_2906(handler.field_7763, slot, 0, class_1713.field_7794, (class_1657)player);
            } else if (sopid == 1) {
                DataStructures.EnchantedItem item = current.sacrifice();
                if (item.matches(handler.method_7611(1).method_7677())) {
                    sopid = 2;
                    return;
                }
                int slot = IntStream.range(3, handler.method_7602().size()).boxed().filter(i -> item.matches(handler.method_7611(i.intValue()).method_7677())).findFirst().orElse(-1);
                if (slot == -1) {
                    return;
                }
                manager.method_2906(handler.field_7763, slot, 0, class_1713.field_7794, (class_1657)player);
            } else if (sopid == 2) {
                DataStructures.EnchantedItem item = current.result();
                if (!item.matches(handler.method_7611(2).method_7677())) {
                    return;
                }
                manager.method_2906(handler.field_7763, 2, 0, class_1713.field_7794, (class_1657)player);
                timer = -10;
                sopid = 0;
                if (++opid == operations.size()) {
                    Worker.cancel();
                    Worker.showText("Done", -4725903);
                }
            }
        }
    }

    private static void showText(String text, int color) {
        textDisplay.method_25355(class_2561.method_30163((String)text));
        textDisplay.method_46438(color);
        Worker.textDisplay.field_22764 = true;
    }

    private static void hideText() {
        Worker.textDisplay.field_22764 = false;
    }

    public static DataStructures.Shape getShape() {
        if (state != State.CALCULATE || current == null) {
            return null;
        }
        return current.current();
    }

    public static double getProgress() {
        if (state != State.CALCULATE) {
            return -1.0;
        }
        if (current == null) {
            return 0.0;
        }
        return (double)current.index() / (double)current.total();
    }

    public static State getState() {
        return state;
    }

    public static List<Integer> getSelected() {
        if (state != State.SELECT) {
            return Collections.emptyList();
        }
        return selected;
    }

    public static void toggleSelection(int slot) {
        if (selected.contains(slot)) {
            selected.remove((Object)slot);
        } else {
            selected.add(slot);
        }
    }

    static {
        state = State.UNSET;
        selected = new ArrayList<Integer>();
        enchantCost = 0;
        readyToEnchant = false;
        search = null;
        current = null;
        operations = null;
        opid = 0;
        sopid = 0;
        timer = 0;
    }

    public static enum State {
        UNSET,
        SELECT,
        CALCULATE,
        EXEC;

    }
}

