/*
 * Decompiled with CFR 0.152.
 */
package dev.gxlg.autoenchanter;

import dev.gxlg.autoenchanter.MultiVersion;
import dev.gxlg.autoenchanter.Reflection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_6880;
import net.minecraft.class_9304;

public class DataStructures {

    public record AnvilItem(EnchantedItem target, EnchantedItem sacrifice, EnchantedItem result) {
    }

    public record EMap(int lvl, int itemCost, int bookCost) {
        public int cost(class_1792 item) {
            return item == class_1802.field_8598 ? this.bookCost : this.itemCost;
        }

        public static EMap from(int lvl, int itemCost) {
            return new EMap(lvl, itemCost, Math.max(itemCost / 2, 1));
        }
    }

    public static class FilledShape {
        private final Enchant item;
        private final FilledShape left;
        private final FilledShape right;

        public FilledShape(FilledShape left, FilledShape right) {
            this.left = left;
            this.right = right;
            this.item = new Enchant(Collections.emptyMap(), 0, null);
        }

        private FilledShape(Enchant item) {
            this.left = null;
            this.right = null;
            this.item = item;
        }

        public String toString() {
            return "[" + String.valueOf(this.isLeaf() ? this.item : String.valueOf(Objects.requireNonNull(this.left)) + ", " + String.valueOf(Objects.requireNonNull(this.right))) + "]";
        }

        public boolean isLeaf() {
            return this.left == null || this.right == null;
        }

        public static FilledShape leaf(Enchant item) {
            return new FilledShape(item);
        }

        public List<AnvilItem> execute() {
            assert (this.left != null && this.right != null);
            if (this.left.isLeaf() && this.right.isLeaf()) {
                EnchantedItem l = new EnchantedItem(this.left.item.enchantments(), this.left.item.anvilUse(), 0, this.left.item.item());
                EnchantedItem r = new EnchantedItem(this.right.item.enchantments(), this.right.item.anvilUse(), 0, this.right.item.item());
                return List.of(new AnvilItem(l, r, FilledShape.combine(l, r)));
            }
            List l = this.left.isLeaf() ? Collections.emptyList() : this.left.execute();
            List r = this.right.isLeaf() ? Collections.emptyList() : this.right.execute();
            EnchantedItem ll = this.left.isLeaf() ? new EnchantedItem(this.left.item.enchantments(), this.left.item.anvilUse(), 0, this.left.item.item()) : ((AnvilItem)l.getLast()).result;
            EnchantedItem rr = this.right.isLeaf() ? new EnchantedItem(this.right.item.enchantments(), this.right.item.anvilUse(), 0, this.right.item.item()) : ((AnvilItem)r.getLast()).result();
            ArrayList<AnvilItem> x = new ArrayList<AnvilItem>();
            if (this.left.isLeaf() && !this.right.isLeaf()) {
                x.addAll(r);
                x.addAll(l);
            } else {
                x.addAll(l);
                x.addAll(r);
            }
            x.add(new AnvilItem(ll, rr, FilledShape.combine(ll, rr)));
            return x;
        }

        private static EnchantedItem combine(EnchantedItem l, EnchantedItem r) {
            if (l == EnchantedItem.INVALID || r == EnchantedItem.INVALID) {
                return EnchantedItem.INVALID;
            }
            if (l.item() == class_1802.field_8598 && r.item() != class_1802.field_8598) {
                return EnchantedItem.INVALID;
            }
            HashMap<class_6880<class_1887>, EMap> enchantments = new HashMap<class_6880<class_1887>, EMap>();
            int c = 0;
            boolean anyValid = false;
            for (Map.Entry<class_6880<class_1887>, EMap> e : r.enchantments().entrySet()) {
                class_6880<class_1887> sacrifice = e.getKey();
                EMap sacrificeData = e.getValue();
                boolean pair = false;
                for (Map.Entry<class_6880<class_1887>, EMap> d : l.enchantments().entrySet()) {
                    class_6880<class_1887> target = d.getKey();
                    EMap targetData = d.getValue();
                    if (target == sacrifice) {
                        int m;
                        pair = true;
                        anyValid = true;
                        if (targetData.lvl() == sacrificeData.lvl()) {
                            if (sacrificeData.lvl() == ((class_1887)sacrifice.comp_349()).method_8183()) {
                                enchantments.put(sacrifice, sacrificeData);
                                m = sacrificeData.lvl();
                            } else {
                                enchantments.put(sacrifice, EMap.from(sacrificeData.lvl() + 1, sacrificeData.itemCost()));
                                m = sacrificeData.lvl() + 1;
                            }
                        } else {
                            m = Math.max(targetData.lvl(), sacrificeData.lvl());
                            enchantments.put(sacrifice, EMap.from(m, sacrificeData.itemCost()));
                        }
                        c += sacrificeData.cost(r.item()) * m;
                        break;
                    }
                    if (MultiVersion.canCombine(target, sacrifice)) continue;
                    pair = true;
                    ++c;
                }
                if (pair || !((class_1887)sacrifice.comp_349()).method_8192(l.item().method_7854()) && l.item() != class_1802.field_8598) continue;
                anyValid = true;
                enchantments.put(sacrifice, sacrificeData);
                c += sacrificeData.cost(r.item()) * sacrificeData.lvl();
            }
            if (!anyValid) {
                return EnchantedItem.INVALID;
            }
            for (Map.Entry<class_6880<class_1887>, EMap> d : l.enchantments().entrySet()) {
                if (enchantments.containsKey(d.getKey())) continue;
                enchantments.put(d.getKey(), d.getValue());
            }
            if ((c += (1 << l.anvilUse()) + (1 << r.anvilUse()) - 2) >= 40) {
                return EnchantedItem.INVALID;
            }
            return new EnchantedItem(enchantments, Math.max(l.anvilUse(), r.anvilUse()) + 1, l.cost() + r.cost() + c, l.item());
        }

        public EnchantedItem finalItem() {
            if (this.isLeaf()) {
                return new EnchantedItem(this.item.enchantments, this.item.anvilUse(), 0, this.item.item());
            }
            assert (this.left != null && this.right != null);
            EnchantedItem l = this.left.finalItem();
            EnchantedItem r = this.right.finalItem();
            return FilledShape.combine(l, r);
        }
    }

    public record EnchantedItem(Map<class_6880<class_1887>, EMap> enchantments, int anvilUse, int cost, class_1792 item) {
        public static EnchantedItem INVALID = new EnchantedItem(Collections.emptyMap(), -1, -1, null);

        public boolean matches(class_1799 stack) {
            Enchant citem = Enchant.from(stack);
            return this.item == citem.item() && this.anvilUse == citem.anvilUse() && this.enchantments.equals(citem.enchantments());
        }
    }

    public record Enchant(Map<class_6880<class_1887>, EMap> enchantments, int anvilUse, class_1792 item) {
        public static Enchant from(class_1799 stack) {
            Object rc = Reflection.field(Reflection.clazz("net.minecraft.class_9334", "net.minecraft.component.DataComponentTypes"), null, "field_49639", "REPAIR_COST");
            Integer r = Reflection.getVersion().higher("1.21.5") || Reflection.getVersion().equals("1.21.5") ? (Integer)Reflection.invokeMethod(Reflection.clazz("net.minecraft.class_9323", "net.minecraft.component.ComponentMap"), (Object)stack.method_57353(), new Object[]{rc}, new Class[]{Reflection.clazz("net.minecraft.class_9331", "net.minecraft.component.ComponentType")}, "method_58694", "get") : (Reflection.getVersion().higher("1.21") || Reflection.getVersion().equals("1.21") ? (Integer)Reflection.invokeMethod(Reflection.clazz("net.minecraft.class_9323", "net.minecraft.component.ComponentMap"), (Object)stack.method_57353(), new Object[]{rc}, new Class[]{Reflection.clazz("net.minecraft.class_9331", "net.minecraft.component.ComponentType")}, "method_57829", "get") : (Integer)Reflection.invokeMethod(Reflection.clazz("net.minecraft.class_9323", "net.minecraft.component.ComponentMap"), (Object)stack.method_57353(), new Object[]{rc}, new Class[]{Reflection.clazz("net.minecraft.class_9331", "net.minecraft.component.DataComponentType")}, "method_57829", "get"));
            int repair = Optional.ofNullable(r).orElse(0);
            int anvilUse = Integer.bitCount(repair);
            class_9304 component = class_1890.method_57532((class_1799)stack);
            Map<class_6880<class_1887>, EMap> enchantments = component.method_57534().stream().collect(Collectors.toMap(i -> i, i -> {
                int lvl = (Integer)(Reflection.getVersion().higher("1.21") || Reflection.getVersion().equals("1.21") ? ((Function<Object[], Object>)$args -> Reflection.invokeMethod($args[0].getClass(), $args[0], new Object[]{i}, new Class[]{class_6880.class}, "method_57536", "getLevel")).apply(new Object[]{component}) : ((Function<Object[], Object>)$args -> Reflection.invokeMethod($args[0].getClass(), $args[0], new Object[]{i.comp_349()}, new Class[]{class_1887.class}, "method_57536", "getLevel")).apply(new Object[]{component}));
                return EMap.from(lvl, ((class_1887)i.comp_349()).method_58446());
            }));
            return new Enchant(enchantments, anvilUse, stack.method_7909());
        }
    }

    public record MergeTree(MergeTree left, MergeTree right, int value) {
        public static MergeTree leaf(int value) {
            return new MergeTree(null, null, value);
        }

        public boolean hasChildren() {
            return this.left != null && this.right != null;
        }

        public boolean same(MergeTree tree) {
            if (this.value != tree.value()) {
                return false;
            }
            if (this.hasChildren() != tree.hasChildren()) {
                return false;
            }
            if (this.hasChildren()) {
                return this.left.same(tree.left()) && this.right.same(tree.right());
            }
            return true;
        }

        public static MergeTree from(Map<Integer, List<Enchant>> map) {
            ArrayList<MergeTree> stack = new ArrayList<MergeTree>();
            for (Integer i2 : map.entrySet().stream().flatMap(i -> ((List)i.getValue()).stream().map(x -> (Integer)i.getKey())).sorted().toList()) {
                stack.add(MergeTree.leaf(i2));
                while (stack.size() > 1 && ((MergeTree)stack.getLast()).value() == ((MergeTree)stack.get(stack.size() - 2)).value()) {
                    MergeTree right = (MergeTree)stack.removeLast();
                    MergeTree left = (MergeTree)stack.removeLast();
                    stack.add(new MergeTree(left, right, left.value() + 1));
                }
            }
            return stack.isEmpty() ? MergeTree.leaf(0) : (MergeTree)stack.getLast();
        }
    }

    public record Leaf(int depth, int cost, Shape shape) {
    }

    public record Shape(Shape left, Shape right, int leafs) {
        public boolean isLeaf() {
            return this.left == null || this.right == null;
        }

        public static Shape leaf() {
            return new Shape(null, null, 1);
        }

        public List<Leaf> getLeafs() {
            ArrayList<Leaf> list = new ArrayList<Leaf>();
            this.leafs(0, 0, list);
            return list;
        }

        private void leafs(int depth, int cost, List<Leaf> list) {
            if (this.isLeaf()) {
                list.add(new Leaf(depth, cost, this));
            } else {
                this.left.leafs(depth + 1, cost, list);
                this.right.leafs(depth + 1, cost + 1, list);
            }
        }

        public FilledShape fill(List<Enchant> filler) {
            ArrayList<Enchant> copy = new ArrayList<Enchant>(filler);
            return this.fillInternal(copy);
        }

        private FilledShape fillInternal(List<Enchant> list) {
            if (this.isLeaf()) {
                return FilledShape.leaf(list.removeFirst());
            }
            return new FilledShape(this.left.fillInternal(list), this.right.fillInternal(list));
        }

        public Stream<List<Enchant>> possibleFills(List<Enchant> alreadyFilled, Map<Integer, List<Enchant>> map, class_6880<class_1887> current, Enchant main) {
            List<Enchant> allItems = map.values().stream().flatMap(Collection::stream).toList();
            return this.possibleFillsInternal(alreadyFilled, MergeTree.from(map), 0, allItems, current, main);
        }

        private Stream<List<Enchant>> possibleFillsInternal(List<Enchant> alreadyFilled, MergeTree tree, int indexOffset, List<Enchant> items, class_6880<class_1887> currentEnchantment, Enchant main) {
            if (tree.value() == 0) {
                return Stream.of(alreadyFilled.subList(indexOffset, indexOffset + this.leafs()));
            }
            if (this.isLeaf()) {
                if (tree.hasChildren()) {
                    return Stream.empty();
                }
                if (indexOffset == 0) {
                    Enchant m = items.stream().filter(i -> i == main).findFirst().orElse(null);
                    if (m == null) {
                        return Stream.empty();
                    }
                    return Stream.of(List.of(m));
                }
                if (alreadyFilled.get(indexOffset) != null) {
                    if (!items.contains(alreadyFilled.get(indexOffset))) {
                        return Stream.empty();
                    }
                    return Stream.of(List.of(alreadyFilled.get(indexOffset)));
                }
                return items.stream().filter(i -> i != main && i.enchantments().containsKey(currentEnchantment) && i.enchantments().get(currentEnchantment).lvl() == tree.value()).map(List::of);
            }
            ArrayList<Map.Entry<MergeTree, MergeTree>> splits = new ArrayList<Map.Entry<MergeTree, MergeTree>>();
            if (tree.hasChildren()) {
                splits.add(Map.entry(tree.left(), tree.right()));
                if (!tree.left().same(tree.right())) {
                    splits.add(Map.entry(tree.right(), tree.left()));
                }
            }
            splits.add(Map.entry(tree, MergeTree.leaf(0)));
            splits.add(Map.entry(MergeTree.leaf(0), tree));
            return splits.stream().flatMap(split -> this.left.possibleFillsInternal(alreadyFilled, (MergeTree)split.getKey(), indexOffset, items, currentEnchantment, main).flatMap(ll -> this.right.possibleFillsInternal(alreadyFilled, (MergeTree)split.getValue(), indexOffset + this.left.leafs(), items.stream().filter(i -> ll.stream().noneMatch(j -> i == j)).toList(), currentEnchantment, main).map(rr -> Stream.concat(ll.stream(), rr.stream()).toList())));
        }

        public void draw(class_332 context, class_327 textRenderer, int x, int y, int w, int h) {
            this.draw(context, textRenderer, x, y, w, h, 0, 0);
        }

        private void draw(class_332 context, class_327 textRenderer, int x, int y, int w, int h, int depth, int cost) {
            int color = 15916192 + -8767994 * depth / 6;
            int base = -16777216;
            context.method_25294(x, y, x + w, y + h, base + color / 2);
            context.method_25294(x + 1, y + 1, x + w - 1, y + h - 1, base + color);
            if (this.isLeaf()) {
                Object ignored = ((Function<Object[], Object>)$args -> Reflection.invokeMethod($args[0].getClass(), $args[0], new Object[]{$args[1], $args[2], x + 3, y + 3, -16777216, false}, new Class[]{$args[1].getClass(), $args[2].getClass(), Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE}, "method_51433", "drawText")).apply(new Object[]{context, textRenderer, String.valueOf(cost)});
                return;
            }
            if (h > w) {
                this.left.draw(context, textRenderer, x, y, w, h / 2, depth + 1, cost);
                this.right.draw(context, textRenderer, x, y + h / 2, w, h / 2, depth + 1, cost + 1);
            } else {
                this.left.draw(context, textRenderer, x, y, w / 2, h, depth + 1, cost);
                this.right.draw(context, textRenderer, x + w / 2, y, w / 2, h, depth + 1, cost + 1);
            }
        }
    }

    public record IterItem<S>(long index, long total, S current) {
    }
}

