/*
 * Decompiled with CFR 0.152.
 */
package dev.gxlg.autoenchanter;

import dev.gxlg.autoenchanter.DataStructures;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1887;
import net.minecraft.class_6880;

public class Utils {
    private static BigInteger countWithDepth(int amount, int depth, int maxDepth, Map<Long, BigInteger> memo) {
        long key = (long)amount << 32 | (long)depth & 0xFFFFFFFFL;
        if (memo.containsKey(key)) {
            return memo.get(key);
        }
        if (depth > maxDepth) {
            memo.put(key, BigInteger.ZERO);
            return BigInteger.ZERO;
        }
        if (amount == 1) {
            memo.put(key, BigInteger.ONE);
            return BigInteger.ONE;
        }
        BigInteger sum = BigInteger.ZERO;
        for (int l = 1; l <= amount - 1; ++l) {
            BigInteger rightCount;
            int r = amount - l;
            BigInteger leftCount = Utils.countWithDepth(l, depth + 1, maxDepth, memo);
            if (leftCount.equals(BigInteger.ZERO) || (rightCount = Utils.countWithDepth(r, depth + 1, maxDepth, memo)).equals(BigInteger.ZERO)) continue;
            sum = sum.add(leftCount.multiply(rightCount));
        }
        memo.put(key, sum);
        return sum;
    }

    public static Stream<DataStructures.IterItem<DataStructures.Shape>> genShapes(int amount) {
        return Utils.genShapesInternal(amount, 0, true);
    }

    private static Stream<DataStructures.IterItem<DataStructures.Shape>> genShapesInternal(int amount, int depth, boolean count) {
        if (depth > 6) {
            return Stream.empty();
        }
        if (amount == 1) {
            return Stream.of(new DataStructures.IterItem<DataStructures.Shape>(0L, 0L, DataStructures.Shape.leaf()));
        }
        long total = count ? Utils.countWithDepth(amount, 0, 6, new HashMap<Long, BigInteger>()).longValue() : 0L;
        AtomicLong p = new AtomicLong(0L);
        return IntStream.range(0, amount).boxed().flatMap(l -> {
            int r = amount - l;
            return Utils.genShapesInternal(l, depth + 1, false).flatMap(ileft -> Utils.genShapesInternal(r, depth + 1, false).map(iright -> {
                DataStructures.Shape left = (DataStructures.Shape)ileft.current();
                DataStructures.Shape right = (DataStructures.Shape)iright.current();
                return new DataStructures.IterItem<DataStructures.Shape>(p.addAndGet(1L), total, new DataStructures.Shape(left, right, left.leafs() + right.leafs()));
            }));
        });
    }

    private static Stream<List<DataStructures.Enchant>> fills(DataStructures.Shape tree, List<DataStructures.Enchant> filled, Map<class_6880<class_1887>, Map<Integer, List<DataStructures.Enchant>>> map, DataStructures.Enchant main, Set<class_6880<class_1887>> ignoredEncs) {
        class_6880 first;
        if (map.size() == 0) {
            return Stream.of(filled);
        }
        HashMap<class_6880<class_1887>, Map<Integer, List<DataStructures.Enchant>>> m = new HashMap<class_6880<class_1887>, Map<Integer, List<DataStructures.Enchant>>>(map);
        do {
            first = (class_6880)m.keySet().stream().findFirst().orElseThrow();
            m.remove(first);
        } while (ignoredEncs.contains(first));
        return tree.possibleFills(filled, map.get(first), (class_6880<class_1887>)first, main).flatMap(f -> Utils.fills(tree, f, m, main, ignoredEncs));
    }

    public static class ShapePool {
        private final AtomicReference<DataStructures.IterItem<DataStructures.Shape>> current = new AtomicReference();
        private final AtomicReference<Map.Entry<DataStructures.FilledShape, Integer>> bestShape = new AtomicReference();
        private final int amount;
        private final DataStructures.Enchant mainItem;
        private final Map<class_6880<class_1887>, Map<Integer, List<DataStructures.Enchant>>> trueMap;
        private final List<DataStructures.Enchant> collection;
        private final ExecutorService pool;
        private final int threads;
        private final BlockingQueue<DataStructures.IterItem<DataStructures.Shape>> queue;
        private final Set<class_6880<class_1887>> ignoredEncs;
        private final Map<class_6880<class_1887>, Integer> maxMap;
        private volatile boolean submitting = true;
        private final AtomicInteger finished = new AtomicInteger(0);

        public ShapePool(int amount, List<DataStructures.Enchant> collection, Map<class_6880<class_1887>, Map<Integer, List<DataStructures.Enchant>>> trueMap, DataStructures.Enchant mainItem, Set<class_6880<class_1887>> ignoredEncs, Map<class_6880<class_1887>, Integer> maxMap) {
            this.amount = amount;
            this.collection = collection;
            this.trueMap = trueMap;
            this.mainItem = mainItem;
            this.ignoredEncs = ignoredEncs;
            this.maxMap = maxMap;
            this.threads = Runtime.getRuntime().availableProcessors();
            this.pool = Executors.newFixedThreadPool(this.threads);
            this.queue = new ArrayBlockingQueue<DataStructures.IterItem<DataStructures.Shape>>(4096);
            for (int i = 0; i < this.threads; ++i) {
                this.pool.submit(() -> {
                    try {
                        while (true) {
                            DataStructures.IterItem<DataStructures.Shape> shape;
                            if ((shape = this.queue.poll(100L, TimeUnit.MILLISECONDS)) == null) {
                                if (this.submitting) {
                                    continue;
                                }
                                break;
                            }
                            this.current.set(shape);
                            List<DataStructures.Leaf> leafs = shape.current().getLeafs();
                            this.processShape(shape, leafs);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        this.finished.updateAndGet(j -> j + 1);
                    }
                });
            }
            new Thread(() -> {
                Iterator si = Utils.genShapes(amount).iterator();
                while (si.hasNext() && this.submitting) {
                    try {
                        this.queue.put((DataStructures.IterItem)si.next());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.submitting = false;
                this.pool.shutdown();
                try {
                    boolean e = this.pool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
        }

        private void processShape(DataStructures.IterItem<DataStructures.Shape> shape, List<DataStructures.Leaf> leafs) {
            List<DataStructures.Enchant> prefilled;
            DataStructures.Shape s = shape.current();
            Map.Entry m = Utils.fills(s, prefilled = IntStream.range(0, this.amount).mapToObj(i -> i == 0 ? this.mainItem : null).toList(), this.trueMap, this.mainItem, this.ignoredEncs).map(f -> {
                int i2;
                ArrayList<DataStructures.Enchant> filled = new ArrayList<DataStructures.Enchant>((Collection<DataStructures.Enchant>)f);
                List<DataStructures.Enchant> available = this.collection.stream().filter(i -> filled.stream().noneMatch(j -> i == j)).toList();
                ArrayList<Integer> empty = new ArrayList<Integer>();
                for (i2 = 0; i2 < this.amount; ++i2) {
                    if (filled.get(i2) != null) continue;
                    empty.add(i2);
                }
                empty.sort(Comparator.comparingInt(i -> -((DataStructures.Leaf)leafs.get((int)i)).cost()));
                for (i2 = 0; i2 < available.size(); ++i2) {
                    filled.set((Integer)empty.get(i2), available.get(i2));
                }
                DataStructures.FilledShape fs = s.fill(filled);
                DataStructures.EnchantedItem i3 = fs.finalItem();
                if (i3 == DataStructures.EnchantedItem.INVALID) {
                    return Map.entry(fs, -1);
                }
                if (this.ignoredEncs.stream().anyMatch(e -> i3.enchantments().containsKey(e))) {
                    return Map.entry(fs, -1);
                }
                if (i3.enchantments().size() != this.maxMap.size() || !i3.enchantments().entrySet().stream().allMatch(e -> this.maxMap.containsKey(e.getKey()) && this.maxMap.get(e.getKey()).intValue() == ((DataStructures.EMap)e.getValue()).lvl())) {
                    return Map.entry(fs, -1);
                }
                return Map.entry(fs, i3.cost());
            }).filter(e -> (Integer)e.getValue() != -1).min(Comparator.comparingInt(Map.Entry::getValue)).orElse(null);
            if (m == null) {
                return;
            }
            this.bestShape.updateAndGet(e -> e == null || (Integer)e.getValue() > (Integer)m.getValue() ? m : e);
        }

        public DataStructures.IterItem<DataStructures.Shape> peek() {
            return this.current.get();
        }

        public void cancel() {
            this.submitting = false;
            this.pool.shutdownNow();
        }

        public boolean working() {
            return this.finished.get() < this.threads;
        }

        public DataStructures.FilledShape getBestShape() {
            return this.bestShape.get() == null ? null : this.bestShape.get().getKey();
        }

        public int getMinCost() {
            return this.bestShape.get() == null ? -1 : this.bestShape.get().getValue();
        }
    }
}

