/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.compat.jei;

import com.asger.mechtrowel.compat.jei.GhostIngredientHandler;
import com.asger.mechtrowel.gui.PaletteScreen;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;

public class JeiGhostIngredientHandlerAdapter
implements IGhostIngredientHandler<PaletteScreen> {
    private final GhostIngredientHandler handler = new GhostIngredientHandler();

    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(PaletteScreen gui, ITypedIngredient<I> typedIngredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> jeiTargets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        Object ingredient = typedIngredient.getIngredient();
        List<Object> targets = this.handler.getTargets(gui, ingredient, doStart);
        for (Object target : targets) {
            if (target instanceof GhostIngredientHandler.GhostIngredientTarget) {
                GhostIngredientHandler.GhostIngredientTarget ghostTarget = (GhostIngredientHandler.GhostIngredientTarget)target;
                jeiTargets.add(new JeiTargetAdapter(ghostTarget));
                continue;
            }
            if (target instanceof GhostIngredientHandler.IconSlotTarget) {
                GhostIngredientHandler.IconSlotTarget iconTarget = (GhostIngredientHandler.IconSlotTarget)target;
                jeiTargets.add(new JeiIconTargetAdapter(iconTarget));
                continue;
            }
            if (!(target instanceof GhostIngredientHandler.CopycatMaterialTarget)) continue;
            GhostIngredientHandler.CopycatMaterialTarget materialTarget = (GhostIngredientHandler.CopycatMaterialTarget)target;
            jeiTargets.add(new JeiCopycatTargetAdapter(materialTarget));
        }
        return jeiTargets;
    }

    public void onComplete() {
        this.handler.onComplete();
    }

    private static class JeiTargetAdapter<I>
    implements IGhostIngredientHandler.Target<I> {
        private final GhostIngredientHandler.GhostIngredientTarget target;

        public JeiTargetAdapter(GhostIngredientHandler.GhostIngredientTarget target) {
            this.target = target;
        }

        public Rect2i getArea() {
            return this.target.getArea();
        }

        public void accept(I ingredient) {
            this.target.accept(ingredient);
        }
    }

    private static class JeiIconTargetAdapter<I>
    implements IGhostIngredientHandler.Target<I> {
        private final GhostIngredientHandler.IconSlotTarget target;

        public JeiIconTargetAdapter(GhostIngredientHandler.IconSlotTarget target) {
            this.target = target;
        }

        public Rect2i getArea() {
            return this.target.getArea();
        }

        public void accept(I ingredient) {
            this.target.accept(ingredient);
        }
    }

    private static class JeiCopycatTargetAdapter<I>
    implements IGhostIngredientHandler.Target<I> {
        private final GhostIngredientHandler.CopycatMaterialTarget target;

        public JeiCopycatTargetAdapter(GhostIngredientHandler.CopycatMaterialTarget target) {
            this.target = target;
        }

        public Rect2i getArea() {
            return this.target.getArea();
        }

        public void accept(I ingredient) {
            this.target.accept(ingredient);
        }
    }
}

