/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.data;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.data.GradientData;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.RotationLockData;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class TrowelData {
    private static final String TAG_PALETTES = "Palettes";
    private static final String TAG_ACTIVE_PALETTE = "ActivePalette";
    private static final String TAG_ROTATION_DATA = "RotationData";
    private static final String TAG_BUILDING_MODE = "BuildingMode";
    private static final String TAG_REPLACE_MODE = "ReplaceMode";
    private static final String TAG_PREVIEW_ACTIVE = "PreviewActive";
    private static final String TAG_PREVIEW_BEFORE_WAND = "PreviewBeforeWand";
    private static final String TAG_WAND_ENABLED = "WandEnabled";
    private static final String TAG_CAPACITY_UPGRADED = "CapacityUpgraded";
    private static final String TAG_REACH_UPGRADED = "ReachUpgraded";
    private static final String TAG_GRADIENT_DATA = "GradientData";
    private static final String TAG_POINT_SELECTION_MODE = "PointSelectionMode";
    private static final String TAG_LAST_GRADIENT_POSITION = "LastGradientPosition";
    private static final String TAG_MILESTONE_COOLDOWNS = "MilestoneCooldowns";
    private static final String TAG_GRADIENT_ENABLED = "GradientEnabled";
    private static final String TAG_CHIPPED_CONVERSION_ENABLED = "ChippedConversionEnabled";
    private static final String TAG_CHIPPED_CONVERSION_ACTIVE = "ChippedConversionActive";
    private static final String TAG_CAPACITY_ACTIVE = "CapacityActive";
    private static final String TAG_REACH_ACTIVE = "ReachActive";
    private final List<PaletteData> palettes;
    private int activePaletteIndex = 0;
    private final RotationLockData rotationData;
    private final GradientData gradientData;
    private BuildingMode buildingMode;
    private boolean replaceMode = false;
    private boolean previewActive = false;
    private boolean previewBeforeWandMode = false;
    private boolean wandEnabled;
    private boolean capacityUpgraded = false;
    private boolean reachUpgraded = false;
    private boolean gradientConfirmed = true;
    private boolean gradientEnabled = false;
    private PointSelectionMode pointSelectionMode = PointSelectionMode.NONE;
    private float lastGradientPosition = -999.0f;
    private final Map<String, Long> milestoneCooldowns = new HashMap<String, Long>();
    private boolean chippedConversionEnabled = false;
    private boolean chippedConversionActive = true;
    private boolean capacityActive = true;
    private boolean reachActive = true;

    public TrowelData() {
        this.palettes = new ArrayList<PaletteData>();
        this.rotationData = new RotationLockData();
        this.gradientData = new GradientData();
        this.buildingMode = BuildingMode.QUICK;
        this.wandEnabled = MechTrowel.Config.isWandModeWithoutUpgrade();
    }

    public static TrowelData getOrCreate(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        TrowelData data = new TrowelData();
        data.load(tag);
        return data;
    }

    public void save(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        this.save(tag);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public void load(CompoundTag tag) {
        this.palettes.clear();
        if (tag.contains(TAG_PALETTES)) {
            ListTag paletteList = tag.getList(TAG_PALETTES, 10);
            for (int i = 0; i < paletteList.size(); ++i) {
                PaletteData palette = new PaletteData();
                palette.load(paletteList.getCompound(i));
                this.palettes.add(palette);
            }
        }
        if (this.palettes.isEmpty()) {
            PaletteData defaultPalette = new PaletteData();
            defaultPalette.setName("Default");
            this.palettes.add(defaultPalette);
        }
        this.activePaletteIndex = tag.getInt(TAG_ACTIVE_PALETTE);
        if (this.activePaletteIndex >= this.palettes.size()) {
            this.activePaletteIndex = 0;
        }
        if (tag.contains(TAG_ROTATION_DATA)) {
            this.rotationData.load(tag.getCompound(TAG_ROTATION_DATA));
        }
        if (tag.contains(TAG_GRADIENT_DATA)) {
            CompoundTag gradientTag = tag.getCompound(TAG_GRADIENT_DATA);
            GradientData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)gradientTag).resultOrPartial(error -> MechTrowel.LOGGER.error("Failed to load gradient data: {}", error)).ifPresent(data -> {
                this.gradientData.setSections(data.getSections());
                this.gradientData.setAxis(data.getAxis());
                this.gradientData.setPositionMode(data.getPositionMode());
                this.gradientData.setStartPos(data.getStartPos());
                this.gradientData.setEndPos(data.getEndPos());
                this.gradientData.setRelativeDistance(data.getRelativeDistance());
            });
        }
        if (tag.contains(TAG_BUILDING_MODE)) {
            String modeName = tag.getString(TAG_BUILDING_MODE);
            try {
                this.buildingMode = BuildingMode.valueOf(modeName);
            }
            catch (IllegalArgumentException e) {
                this.buildingMode = BuildingMode.BUILDER;
            }
        }
        if (tag.contains(TAG_REPLACE_MODE)) {
            this.replaceMode = tag.getBoolean(TAG_REPLACE_MODE);
        }
        if (tag.contains(TAG_PREVIEW_ACTIVE)) {
            this.previewActive = tag.getBoolean(TAG_PREVIEW_ACTIVE);
        }
        this.previewBeforeWandMode = tag.contains(TAG_PREVIEW_BEFORE_WAND) ? tag.getBoolean(TAG_PREVIEW_BEFORE_WAND) : this.previewActive;
        if (tag.contains(TAG_WAND_ENABLED)) {
            this.wandEnabled = tag.getBoolean(TAG_WAND_ENABLED);
        }
        if (MechTrowel.Config.isWandModeWithoutUpgrade()) {
            this.wandEnabled = true;
        }
        if (tag.contains(TAG_CAPACITY_UPGRADED)) {
            this.capacityUpgraded = tag.getBoolean(TAG_CAPACITY_UPGRADED);
        }
        if (tag.contains(TAG_REACH_UPGRADED)) {
            this.reachUpgraded = tag.getBoolean(TAG_REACH_UPGRADED);
        }
        if (tag.contains("GradientConfirmed")) {
            this.gradientConfirmed = tag.getBoolean("GradientConfirmed");
        }
        if (tag.contains(TAG_POINT_SELECTION_MODE)) {
            this.pointSelectionMode = PointSelectionMode.valueOf(tag.getString(TAG_POINT_SELECTION_MODE));
        }
        if (tag.contains(TAG_LAST_GRADIENT_POSITION)) {
            this.lastGradientPosition = tag.getFloat(TAG_LAST_GRADIENT_POSITION);
        }
        if (tag.contains(TAG_GRADIENT_ENABLED)) {
            this.gradientEnabled = tag.getBoolean(TAG_GRADIENT_ENABLED);
        }
        if (tag.contains(TAG_CHIPPED_CONVERSION_ENABLED)) {
            this.chippedConversionEnabled = tag.getBoolean(TAG_CHIPPED_CONVERSION_ENABLED);
        }
        if (tag.contains(TAG_CHIPPED_CONVERSION_ACTIVE)) {
            this.chippedConversionActive = tag.getBoolean(TAG_CHIPPED_CONVERSION_ACTIVE);
        }
        if (tag.contains(TAG_CAPACITY_ACTIVE)) {
            this.capacityActive = tag.getBoolean(TAG_CAPACITY_ACTIVE);
        }
        if (tag.contains(TAG_REACH_ACTIVE)) {
            this.reachActive = tag.getBoolean(TAG_REACH_ACTIVE);
        }
    }

    public void save(CompoundTag tag) {
        ListTag paletteList = new ListTag();
        for (PaletteData palette : this.palettes) {
            CompoundTag paletteTag = new CompoundTag();
            palette.save(paletteTag);
            paletteList.add((Object)paletteTag);
        }
        tag.put(TAG_PALETTES, (Tag)paletteList);
        tag.putInt(TAG_ACTIVE_PALETTE, this.activePaletteIndex);
        CompoundTag rotationTag = new CompoundTag();
        this.rotationData.save(rotationTag);
        tag.put(TAG_ROTATION_DATA, (Tag)rotationTag);
        GradientData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.gradientData).resultOrPartial(error -> MechTrowel.LOGGER.error("Failed to save gradient data: {}", error)).ifPresent(gradientTag -> tag.put(TAG_GRADIENT_DATA, gradientTag));
        tag.putString(TAG_BUILDING_MODE, this.buildingMode.name());
        tag.putBoolean(TAG_REPLACE_MODE, this.replaceMode);
        tag.putBoolean(TAG_PREVIEW_ACTIVE, this.previewActive);
        tag.putBoolean(TAG_PREVIEW_BEFORE_WAND, this.previewBeforeWandMode);
        tag.putBoolean(TAG_WAND_ENABLED, this.wandEnabled);
        tag.putBoolean(TAG_CAPACITY_UPGRADED, this.capacityUpgraded);
        tag.putBoolean(TAG_REACH_UPGRADED, this.reachUpgraded);
        tag.putBoolean("GradientConfirmed", this.gradientConfirmed);
        tag.putString(TAG_POINT_SELECTION_MODE, this.pointSelectionMode.name());
        tag.putFloat(TAG_LAST_GRADIENT_POSITION, this.lastGradientPosition);
        tag.putBoolean(TAG_GRADIENT_ENABLED, this.gradientEnabled);
        tag.putBoolean(TAG_CHIPPED_CONVERSION_ENABLED, this.chippedConversionEnabled);
        tag.putBoolean(TAG_CHIPPED_CONVERSION_ACTIVE, this.chippedConversionActive);
        tag.putBoolean(TAG_CAPACITY_ACTIVE, this.capacityActive);
        tag.putBoolean(TAG_REACH_ACTIVE, this.reachActive);
    }

    public PaletteData getActivePalette() {
        if (this.palettes.isEmpty() || this.activePaletteIndex >= this.palettes.size()) {
            return null;
        }
        return this.palettes.get(this.activePaletteIndex);
    }

    public void cycleActivePalette() {
        if (!this.palettes.isEmpty()) {
            this.activePaletteIndex = (this.activePaletteIndex + 1) % this.palettes.size();
        }
    }

    public boolean addPalette(PaletteData palette) {
        if (this.palettes.size() < MechTrowel.Config.getMaxPalettes()) {
            this.palettes.add(palette);
            return true;
        }
        return false;
    }

    public void removePalette(int index) {
        if (index >= 0 && index < this.palettes.size()) {
            this.palettes.remove(index);
            if (this.activePaletteIndex >= this.palettes.size() && !this.palettes.isEmpty()) {
                this.activePaletteIndex = this.palettes.size() - 1;
            }
        }
    }

    public List<PaletteData> getPalettes() {
        return this.palettes;
    }

    public GradientData getGradientData() {
        return this.gradientData;
    }

    public void setGradientData(GradientData newGradientData) {
        this.gradientData.setSections(newGradientData.getSections());
        this.gradientData.setAxis(newGradientData.getAxis());
        this.gradientData.setPositionMode(newGradientData.getPositionMode());
        this.gradientData.setStartPos(newGradientData.getStartPos());
        this.gradientData.setEndPos(newGradientData.getEndPos());
        this.gradientData.setRelativeDistance(newGradientData.getRelativeDistance());
    }

    public int getActivePaletteIndex() {
        return this.activePaletteIndex;
    }

    public void setActivePaletteIndex(int index) {
        if (index >= 0 && index < this.palettes.size()) {
            this.activePaletteIndex = index;
        }
    }

    public RotationLockData getRotationLockData() {
        return this.rotationData;
    }

    public BuildingMode getBuildingMode() {
        return this.buildingMode;
    }

    public void setBuildingMode(BuildingMode mode) {
        BuildingMode previousMode = this.buildingMode;
        this.buildingMode = mode;
        if (mode == BuildingMode.WAND && previousMode != BuildingMode.WAND) {
            this.previewBeforeWandMode = this.previewActive;
            this.previewActive = true;
        } else if (previousMode == BuildingMode.WAND && mode != BuildingMode.WAND) {
            this.previewActive = this.previewBeforeWandMode;
        }
    }

    public void toggleBuildingMode() {
        switch (this.buildingMode.ordinal()) {
            case 0: {
                this.buildingMode = BuildingMode.BUILDER;
                break;
            }
            case 1: {
                if (this.wandEnabled) {
                    this.buildingMode = BuildingMode.WAND;
                    this.previewBeforeWandMode = this.previewActive;
                    this.previewActive = true;
                    break;
                }
                this.buildingMode = BuildingMode.QUICK;
                break;
            }
            case 2: {
                this.buildingMode = BuildingMode.QUICK;
                this.previewActive = this.previewBeforeWandMode;
            }
        }
    }

    public boolean isReplaceMode() {
        return this.replaceMode;
    }

    public void setReplaceMode(boolean replaceMode) {
        this.replaceMode = replaceMode;
    }

    public boolean isPreviewActive() {
        return this.previewActive;
    }

    public void setPreviewActive(boolean previewActive) {
        this.previewActive = previewActive;
    }

    public void togglePreview() {
        this.previewActive = !this.previewActive;
    }

    public boolean isWandEnabled() {
        return this.wandEnabled;
    }

    public void setWandEnabled(boolean enabled) {
        this.wandEnabled = enabled;
        if (!enabled && this.buildingMode == BuildingMode.WAND) {
            this.buildingMode = BuildingMode.BUILDER;
        }
    }

    public boolean isCapacityUpgraded() {
        return this.capacityUpgraded;
    }

    public void setCapacityUpgraded(boolean upgraded) {
        this.capacityUpgraded = upgraded;
    }

    public int getMaxWandBlocks() {
        return this.capacityUpgraded && this.capacityActive ? 128 : MechTrowel.Config.getWandMaxBlocks();
    }

    public boolean isReachUpgraded() {
        return this.reachUpgraded;
    }

    public void setReachUpgraded(boolean upgraded) {
        this.reachUpgraded = upgraded;
    }

    public double getReachBonus() {
        return this.reachUpgraded && this.reachActive ? MechTrowel.Config.getReachUpgradeBonus() : 0.0;
    }

    public boolean isCapacityActive() {
        return this.capacityActive;
    }

    public void setCapacityActive(boolean active) {
        this.capacityActive = active;
    }

    public boolean isReachActive() {
        return this.reachActive;
    }

    public void setReachActive(boolean active) {
        this.reachActive = active;
    }

    public boolean isGradientConfirmed() {
        return this.gradientConfirmed;
    }

    public void setGradientConfirmed(boolean confirmed) {
        this.gradientConfirmed = confirmed;
    }

    public PointSelectionMode getPointSelectionMode() {
        return this.pointSelectionMode;
    }

    public void setPointSelectionMode(PointSelectionMode mode) {
        this.pointSelectionMode = mode;
    }

    public float getLastGradientPosition() {
        return this.lastGradientPosition;
    }

    public void setLastGradientPosition(float position) {
        this.lastGradientPosition = position;
    }

    public boolean canShowMilestone(String milestoneKey) {
        Long lastShown = this.milestoneCooldowns.get(milestoneKey);
        if (lastShown == null) {
            return true;
        }
        return System.currentTimeMillis() - lastShown > 3000L;
    }

    public void markMilestoneShown(String milestoneKey) {
        this.milestoneCooldowns.put(milestoneKey, System.currentTimeMillis());
        this.milestoneCooldowns.entrySet().removeIf(entry -> System.currentTimeMillis() - (Long)entry.getValue() > 10000L);
    }

    public boolean isGradientEnabled() {
        return this.gradientEnabled;
    }

    public void setGradientEnabled(boolean enabled) {
        this.gradientEnabled = enabled;
    }

    public boolean isChippedConversionEnabled() {
        return this.chippedConversionEnabled;
    }

    public void setChippedConversionEnabled(boolean enabled) {
        this.chippedConversionEnabled = enabled;
    }

    public boolean isChippedConversionActive() {
        return this.chippedConversionActive;
    }

    public void setChippedConversionActive(boolean active) {
        this.chippedConversionActive = active;
    }

    public static enum PointSelectionMode {
        NONE,
        START_POINT,
        END_POINT;

    }

    public static enum BuildingMode {
        QUICK("Quick"),
        BUILDER("Palette"),
        WAND("Wand");

        private final String displayName;

        private BuildingMode(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

