/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.registry;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.compat.chipped.ChippedCompat;
import com.asger.mechtrowel.compat.rechiseled.RechiseledCompat;
import com.asger.mechtrowel.gui.GradientMenu;
import com.asger.mechtrowel.gui.PaletteMenu;
import com.asger.mechtrowel.gui.RotationMenu;
import com.asger.mechtrowel.item.MechTrowelItem;
import com.asger.mechtrowel.item.ReachUpgradeTemplateItem;
import com.asger.mechtrowel.item.VariantConversionTemplateItem;
import com.asger.mechtrowel.item.WandCapacityTemplateItem;
import com.asger.mechtrowel.item.WandTemplateItem;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModRegistry {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"mechtrowel");
    private static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"mechtrowel");
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"mechtrowel");
    public static final DeferredHolder<Item, MechTrowelItem> MECH_TROWEL = ITEMS.register("mech_trowel", () -> new MechTrowelItem(new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, WandTemplateItem> WAND_TEMPLATE = ITEMS.register("wand_template", WandTemplateItem::new);
    public static final DeferredHolder<Item, WandCapacityTemplateItem> WAND_CAPACITY_TEMPLATE = ITEMS.register("wand_capacity_template", WandCapacityTemplateItem::new);
    public static final DeferredHolder<Item, VariantConversionTemplateItem> VARIANT_TEMPLATE = ITEMS.register("variant_conversion_template", VariantConversionTemplateItem::new);
    public static final DeferredHolder<Item, ReachUpgradeTemplateItem> REACH_UPGRADE_TEMPLATE = ITEMS.register("reach_upgrade_template", ReachUpgradeTemplateItem::new);
    public static final DeferredHolder<MenuType<?>, MenuType<PaletteMenu>> PALETTE_MENU = MENU_TYPES.register("palette_menu", () -> IMenuTypeExtension.create((windowId, inv, data) -> {
        if (data.readableBytes() >= 4) {
            int slot = data.readInt();
            ItemStack trowelStack = inv.player.getInventory().getItem(slot);
            MechTrowel.LOGGER.debug("Creating PaletteMenu from slot {} - Item: {}", (Object)slot, (Object)trowelStack.getItem().getDescriptionId());
            return new PaletteMenu(windowId, inv, trowelStack);
        }
        MechTrowel.LOGGER.debug("Creating PaletteMenu from main hand");
        return new PaletteMenu(windowId, inv, inv.player.getMainHandItem());
    }));
    public static final DeferredHolder<MenuType<?>, MenuType<RotationMenu>> ROTATION_MENU = MENU_TYPES.register("rotation_menu", () -> IMenuTypeExtension.create((windowId, inv, data) -> {
        if (data.readableBytes() >= 4) {
            int slot = data.readInt();
            return new RotationMenu(windowId, inv, inv.player.getInventory().getItem(slot));
        }
        return new RotationMenu(windowId, inv, inv.player.getMainHandItem());
    }));
    public static final DeferredHolder<MenuType<?>, MenuType<GradientMenu>> GRADIENT_MENU_TYPE = MENU_TYPES.register("gradient_menu", () -> IMenuTypeExtension.create(GradientMenu::new));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MECHTROWEL_TAB = CREATIVE_MODE_TABS.register("main", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.mechtrowel.main")).icon(() -> new ItemStack((ItemLike)MECH_TROWEL.get())).displayItems((parameters, output) -> {
        output.accept((ItemLike)MECH_TROWEL.get());
        if (MechTrowel.Config.isWandUpgradeEnabled()) {
            output.accept((ItemLike)WAND_TEMPLATE.get());
        }
        if (MechTrowel.Config.isWandCapacityUpgradeEnabled()) {
            output.accept((ItemLike)WAND_CAPACITY_TEMPLATE.get());
        }
        if (MechTrowel.Config.isChippedConversionUpgradeEnabled() && (ChippedCompat.isChippedLoaded() || RechiseledCompat.isRechiseledLoaded())) {
            output.accept((ItemLike)VARIANT_TEMPLATE.get());
        }
        if (MechTrowel.Config.isReachUpgradeEnabled()) {
            output.accept((ItemLike)REACH_UPGRADE_TEMPLATE.get());
        }
    }).build());

    public static void init(IEventBus modEventBus) {
        MechTrowel.LOGGER.debug("Initializing mod registries");
        ITEMS.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(ModRegistry::addCreative);
    }

    private static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept((ItemLike)MECH_TROWEL.get());
        }
    }

    public static ResourceLocation modLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"mechtrowel", (String)path);
    }
}

