/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.data.GradientData;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.TrowelData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;

public class GradientSelector {
    public static GradientSectionResult selectGradientSection(TrowelData trowelData, BlockPos placePos, Player player) {
        GradientData gradientData = trowelData.getGradientData();
        List<GradientData.GradientSection> sections = gradientData.getSections();
        if (sections.isEmpty()) {
            PaletteData activePalette = trowelData.getActivePalette();
            return new GradientSectionResult(activePalette, null, 0.0f, false);
        }
        float gradientPosition = GradientSelector.calculateGradientPosition(gradientData, placePos, player);
        if (gradientPosition < 0.0f) {
            GradientData.GradientSection firstSection = sections.get(0);
            PaletteData firstPalette = GradientSelector.getPaletteByIndex(trowelData, firstSection.getPaletteIndex());
            return new GradientSectionResult(firstPalette, null, 0.0f, false);
        }
        if (gradientPosition > 1.0f) {
            GradientData.GradientSection lastSection = sections.get(sections.size() - 1);
            PaletteData lastPalette = GradientSelector.getPaletteByIndex(trowelData, lastSection.getPaletteIndex());
            return new GradientSectionResult(lastPalette, null, 0.0f, false);
        }
        float totalSize = 0.0f;
        for (int i = 0; i < sections.size(); ++i) {
            GradientData.GradientSection section = sections.get(i);
            totalSize += section.getSize();
        }
        float currentPosition = 0.0f;
        for (int i = 0; i < sections.size(); ++i) {
            float transitionEnd;
            float transitionStart;
            float rightTransitionSize;
            float leftTransitionSize;
            GradientData.GradientSection section = sections.get(i);
            float sectionStart = currentPosition;
            float sectionEnd = currentPosition + section.getSize();
            if (i > 0 && sections.get(i - 1).isSmoothTransition()) {
                GradientData.GradientSection prevSection = sections.get(i - 1);
                float prevSectionEnd = sectionStart;
                leftTransitionSize = prevSection.getSize() * prevSection.getLeftTransitionPercent();
                rightTransitionSize = section.getSize() * section.getRightTransitionPercent();
                transitionStart = prevSectionEnd - leftTransitionSize;
                transitionEnd = prevSectionEnd + rightTransitionSize;
                if (gradientPosition >= sectionStart && gradientPosition < transitionEnd && gradientPosition >= transitionStart) {
                    PaletteData primaryPalette = GradientSelector.getPaletteByIndex(trowelData, prevSection.getPaletteIndex());
                    PaletteData secondaryPalette = GradientSelector.getPaletteByIndex(trowelData, section.getPaletteIndex());
                    float totalTransitionSize = leftTransitionSize + rightTransitionSize;
                    float transitionProgress = totalTransitionSize > 0.0f ? (gradientPosition - transitionStart) / totalTransitionSize : 0.5f;
                    return new GradientSectionResult(primaryPalette, secondaryPalette, transitionProgress, true);
                }
            }
            if (gradientPosition >= sectionStart && gradientPosition < sectionEnd) {
                PaletteData primaryPalette = GradientSelector.getPaletteByIndex(trowelData, section.getPaletteIndex());
                if (!section.isSmoothTransition() || i == sections.size() - 1) {
                    return new GradientSectionResult(primaryPalette, null, 0.0f, false);
                }
                GradientData.GradientSection nextSection = sections.get(i + 1);
                leftTransitionSize = section.getSize() * section.getLeftTransitionPercent();
                rightTransitionSize = nextSection.getSize() * nextSection.getRightTransitionPercent();
                transitionStart = sectionEnd - leftTransitionSize;
                transitionEnd = sectionEnd + rightTransitionSize;
                if (gradientPosition >= transitionStart) {
                    PaletteData secondaryPalette = GradientSelector.getPaletteByIndex(trowelData, nextSection.getPaletteIndex());
                    float totalTransitionSize = leftTransitionSize + rightTransitionSize;
                    float transitionProgress = totalTransitionSize > 0.0f ? (gradientPosition - transitionStart) / totalTransitionSize : 0.5f;
                    return new GradientSectionResult(primaryPalette, secondaryPalette, transitionProgress, true);
                }
                return new GradientSectionResult(primaryPalette, null, 0.0f, false);
            }
            currentPosition = sectionEnd;
        }
        if (!sections.isEmpty()) {
            GradientData.GradientSection lastSection = sections.get(sections.size() - 1);
            PaletteData lastPalette = GradientSelector.getPaletteByIndex(trowelData, lastSection.getPaletteIndex());
            return new GradientSectionResult(lastPalette, null, 0.0f, false);
        }
        PaletteData activePalette = trowelData.getActivePalette();
        return new GradientSectionResult(activePalette, null, 0.0f, false);
    }

    public static float calculateGradientPosition(GradientData gradientData, BlockPos placePos, Player player) {
        switch (gradientData.getPositionMode()) {
            case RELATIVE: {
                return GradientSelector.calculateRelativePosition(gradientData, placePos, player);
            }
            case ABSOLUTE: {
                return GradientSelector.calculateAbsolutePosition(gradientData, placePos);
            }
            case CLICK_POINTS: {
                return GradientSelector.calculateClickPointsPosition(gradientData, placePos);
            }
        }
        return 0.0f;
    }

    private static float calculateRelativePosition(GradientData gradientData, BlockPos placePos, Player player) {
        float distance;
        BlockPos startPos = gradientData.getStartPos();
        if (startPos == null) {
            MechTrowel.LOGGER.warn("RELATIVE mode gradient has no start position set. This should not happen.");
            return 0.0f;
        }
        int configuredDistance = gradientData.getRelativeDistance();
        if (configuredDistance <= 0) {
            return 0.0f;
        }
        switch (gradientData.getAxis()) {
            case HORIZONTAL: {
                float dx = placePos.getX() - startPos.getX();
                float dz = placePos.getZ() - startPos.getZ();
                distance = (float)Math.sqrt(dx * dx + dz * dz);
                break;
            }
            case VERTICAL: {
                distance = Math.abs(placePos.getY() - startPos.getY());
                break;
            }
            case BOTH: {
                float dx3d = placePos.getX() - startPos.getX();
                float dy3d = placePos.getY() - startPos.getY();
                float dz3d = placePos.getZ() - startPos.getZ();
                distance = (float)Math.sqrt(dx3d * dx3d + dy3d * dy3d + dz3d * dz3d);
                break;
            }
            default: {
                return 0.0f;
            }
        }
        float position = distance / (float)configuredDistance;
        return position;
    }

    private static float calculateAbsolutePosition(GradientData gradientData, BlockPos placePos) {
        float totalDistanceSq;
        float dotProduct;
        BlockPos startPos = gradientData.getStartPos();
        BlockPos endPos = gradientData.getEndPos();
        if (startPos == null || endPos == null) {
            return 0.0f;
        }
        float dx = endPos.getX() - startPos.getX();
        float dy = endPos.getY() - startPos.getY();
        float dz = endPos.getZ() - startPos.getZ();
        float px = placePos.getX() - startPos.getX();
        float py = placePos.getY() - startPos.getY();
        float pz = placePos.getZ() - startPos.getZ();
        switch (gradientData.getAxis()) {
            case HORIZONTAL: {
                dotProduct = px * dx + pz * dz;
                totalDistanceSq = dx * dx + dz * dz;
                break;
            }
            case VERTICAL: {
                dotProduct = py * dy;
                totalDistanceSq = dy * dy;
                break;
            }
            case BOTH: {
                dotProduct = px * dx + py * dy + pz * dz;
                totalDistanceSq = dx * dx + dy * dy + dz * dz;
                break;
            }
            default: {
                return 0.0f;
            }
        }
        return totalDistanceSq > 0.0f ? dotProduct / totalDistanceSq : 0.0f;
    }

    private static float calculateClickPointsPosition(GradientData gradientData, BlockPos placePos) {
        return GradientSelector.calculateAbsolutePosition(gradientData, placePos);
    }

    private static PaletteData getPaletteByIndex(TrowelData trowelData, int index) {
        List<PaletteData> palettes = trowelData.getPalettes();
        if (index >= 0 && index < palettes.size()) {
            return palettes.get(index);
        }
        return trowelData.getActivePalette();
    }

    public static MilestoneInfo detectMilestone(TrowelData trowelData, BlockPos placePos, Player player, float previousPosition) {
        GradientData gradientData = trowelData.getGradientData();
        List<GradientData.GradientSection> sections = gradientData.getSections();
        if (sections.isEmpty()) {
            return null;
        }
        float currentPosition = GradientSelector.calculateGradientPosition(gradientData, placePos, player);
        if (Math.abs(currentPosition - previousPosition) < 0.001f) {
            return null;
        }
        float checkPosition = 0.0f;
        for (int i = 0; i < sections.size(); ++i) {
            float sectionBoundary;
            GradientData.GradientSection section = sections.get(i);
            float sectionEnd = checkPosition + section.getSize();
            if (i > 0 && GradientSelector.crossedThreshold(previousPosition, currentPosition, checkPosition)) {
                PaletteData palette = GradientSelector.getPaletteByIndex(trowelData, section.getPaletteIndex());
                String paletteName = palette != null ? palette.getName() : "Palette " + (i + 1);
                return new MilestoneInfo(MilestoneInfo.MilestoneType.SECTION_CHANGE, "message.mechtrowel.gradient_milestone_section_change", paletteName);
            }
            if (section.isSmoothTransition() && i < sections.size() - 1) {
                GradientData.GradientSection nextSection = sections.get(i + 1);
                float leftTransitionSize = section.getSize() * section.getLeftTransitionPercent();
                float transitionStart = sectionEnd - leftTransitionSize;
                if (GradientSelector.crossedThreshold(previousPosition, currentPosition, transitionStart)) {
                    PaletteData primaryPalette = GradientSelector.getPaletteByIndex(trowelData, section.getPaletteIndex());
                    PaletteData secondaryPalette = GradientSelector.getPaletteByIndex(trowelData, nextSection.getPaletteIndex());
                    String primaryName = primaryPalette != null ? primaryPalette.getName() : "Palette " + (i + 1);
                    String secondaryName = secondaryPalette != null ? secondaryPalette.getName() : "Palette " + (i + 2);
                    return new MilestoneInfo(MilestoneInfo.MilestoneType.TRANSITION_START, "message.mechtrowel.gradient_milestone_transition_start", primaryName, secondaryName);
                }
            }
            if (!section.isSmoothTransition() && i < sections.size() - 1 && GradientSelector.crossedThreshold(previousPosition, currentPosition, sectionBoundary = checkPosition + section.getSize())) {
                PaletteData nextPalette = GradientSelector.getPaletteByIndex(trowelData, sections.get(i + 1).getPaletteIndex());
                String nextName = nextPalette != null ? nextPalette.getName() : "Palette " + (i + 2);
                return new MilestoneInfo(MilestoneInfo.MilestoneType.SECTION_BOUNDARY, "message.mechtrowel.gradient_milestone_section_boundary", nextName);
            }
            checkPosition = sectionEnd;
        }
        return null;
    }

    private static boolean crossedThreshold(float prev, float current, float threshold) {
        float tolerance = 0.02f;
        return prev < threshold - tolerance && current >= threshold - tolerance || prev > threshold + tolerance && current <= threshold + tolerance;
    }

    private static int findSectionIndex(List<GradientData.GradientSection> sections, float position) {
        float currentPos = 0.0f;
        for (int i = 0; i < sections.size(); ++i) {
            float sectionEnd = currentPos + sections.get(i).getSize();
            if (position >= currentPos && position <= sectionEnd) {
                return i;
            }
            currentPos = sectionEnd;
        }
        return sections.size() - 1;
    }

    public static class GradientSectionResult {
        private final PaletteData primaryPalette;
        private final PaletteData secondaryPalette;
        private final float transitionWeight;
        private final boolean isTransition;

        public GradientSectionResult(PaletteData primaryPalette, PaletteData secondaryPalette, float transitionWeight, boolean isTransition) {
            this.primaryPalette = primaryPalette;
            this.secondaryPalette = secondaryPalette;
            this.transitionWeight = Math.max(0.0f, Math.min(1.0f, transitionWeight));
            this.isTransition = isTransition;
        }

        public PaletteData getPrimaryPalette() {
            return this.primaryPalette;
        }

        public PaletteData getSecondaryPalette() {
            return this.secondaryPalette;
        }

        public float getTransitionWeight() {
            return this.transitionWeight;
        }

        public boolean isTransition() {
            return this.isTransition;
        }
    }

    public static class MilestoneInfo {
        private final MilestoneType type;
        private final String message;
        private final Object[] messageParams;

        public MilestoneInfo(MilestoneType type, String message, Object ... messageParams) {
            this.type = type;
            this.message = message;
            this.messageParams = messageParams;
        }

        public MilestoneType getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public Object[] getMessageParams() {
            return this.messageParams;
        }

        public String getUniqueKey() {
            StringBuilder key = new StringBuilder(this.type.name());
            for (Object param : this.messageParams) {
                key.append("_").append(param.toString());
            }
            return key.toString();
        }

        public static enum MilestoneType {
            SECTION_CHANGE,
            TRANSITION_START,
            SECTION_BOUNDARY;

        }
    }
}

