/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.compat;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class CuriosCompat {
    private static boolean CURIOS_LOADED = false;
    private static Class<?> CURIOS_API_CLASS = null;
    private static Method GET_CURIOS_INVENTORY = null;

    public static ItemStack findBlockInCurios(Player player, Block block) {
        if (!CURIOS_LOADED || GET_CURIOS_INVENTORY == null) {
            return ItemStack.EMPTY;
        }
        try {
            Method getEquippedMethod;
            Object equipped;
            Method orElseMethod;
            Object inventory;
            Object lazyOptional = GET_CURIOS_INVENTORY.invoke(null, player);
            if (lazyOptional != null && (inventory = (orElseMethod = lazyOptional.getClass().getMethod("orElse", Object.class)).invoke(lazyOptional, new Object[]{null})) != null && (equipped = (getEquippedMethod = inventory.getClass().getMethod("getEquippedCurios", new Class[0])).invoke(inventory, new Object[0])) != null) {
                Method getSlotsMethod = equipped.getClass().getMethod("getSlots", new Class[0]);
                int slots = (Integer)getSlotsMethod.invoke(equipped, new Object[0]);
                Method getStackInSlotMethod = equipped.getClass().getMethod("getStackInSlot", Integer.TYPE);
                for (int i = 0; i < slots; ++i) {
                    BlockItem blockItem;
                    Item item;
                    ItemStack stack = (ItemStack)getStackInSlotMethod.invoke(equipped, i);
                    if (stack.isEmpty() || CuriosCompat.isBackpackItem(stack) || !((item = stack.getItem()) instanceof BlockItem) || (blockItem = (BlockItem)item).getBlock() != block) continue;
                    return stack;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ItemStack.EMPTY;
    }

    public static int countBlocksInCurios(Player player, Block block) {
        if (!CURIOS_LOADED || GET_CURIOS_INVENTORY == null) {
            return 0;
        }
        int count = 0;
        try {
            Method getEquippedMethod;
            Object equipped;
            Method orElseMethod;
            Object inventory;
            Object lazyOptional = GET_CURIOS_INVENTORY.invoke(null, player);
            if (lazyOptional != null && (inventory = (orElseMethod = lazyOptional.getClass().getMethod("orElse", Object.class)).invoke(lazyOptional, new Object[]{null})) != null && (equipped = (getEquippedMethod = inventory.getClass().getMethod("getEquippedCurios", new Class[0])).invoke(inventory, new Object[0])) != null) {
                Method getSlotsMethod = equipped.getClass().getMethod("getSlots", new Class[0]);
                int slots = (Integer)getSlotsMethod.invoke(equipped, new Object[0]);
                Method getStackInSlotMethod = equipped.getClass().getMethod("getStackInSlot", Integer.TYPE);
                for (int i = 0; i < slots; ++i) {
                    BlockItem blockItem;
                    Item item;
                    ItemStack stack = (ItemStack)getStackInSlotMethod.invoke(equipped, i);
                    if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || (blockItem = (BlockItem)item).getBlock() != block) continue;
                    count += stack.getCount();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public static List<ItemStack> getContainersFromCurios(Player player) {
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        if (!CURIOS_LOADED || GET_CURIOS_INVENTORY == null) {
            return containers;
        }
        try {
            Method getEquippedMethod;
            Object equipped;
            Method orElseMethod;
            Object inventory;
            Object lazyOptional = GET_CURIOS_INVENTORY.invoke(null, player);
            if (lazyOptional != null && (inventory = (orElseMethod = lazyOptional.getClass().getMethod("orElse", Object.class)).invoke(lazyOptional, new Object[]{null})) != null && (equipped = (getEquippedMethod = inventory.getClass().getMethod("getEquippedCurios", new Class[0])).invoke(inventory, new Object[0])) != null) {
                Method getSlotsMethod = equipped.getClass().getMethod("getSlots", new Class[0]);
                int slots = (Integer)getSlotsMethod.invoke(equipped, new Object[0]);
                Method getStackInSlotMethod = equipped.getClass().getMethod("getStackInSlot", Integer.TYPE);
                for (int i = 0; i < slots; ++i) {
                    ItemStack stack = (ItemStack)getStackInSlotMethod.invoke(equipped, i);
                    if (stack.isEmpty() || !CuriosCompat.isBackpackItem(stack)) continue;
                    containers.add(stack);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return containers;
    }

    private static boolean isBackpackItem(ItemStack stack) {
        boolean isBackpack;
        String itemClass = stack.getItem().getClass().getName().toLowerCase();
        String itemId = stack.getItem().toString().toLowerCase();
        String registryName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().toLowerCase();
        boolean bl = isBackpack = itemClass.contains("backpack") || itemClass.contains("bag") || itemClass.contains("pouch") || itemId.contains("backpack") || itemId.contains("bag") || itemId.contains("pouch") || registryName.contains("backpack") || registryName.contains("bag") || registryName.contains("pouch");
        if (!isBackpack) {
            IItemHandler cap = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
            isBackpack = cap != null;
        }
        return isBackpack;
    }

    static {
        CURIOS_LOADED = ModList.get().isLoaded("curios");
        if (CURIOS_LOADED) {
            try {
                CURIOS_API_CLASS = Class.forName("top.theillusivec4.curios.api.CuriosApi");
                GET_CURIOS_INVENTORY = CURIOS_API_CLASS.getMethod("getCuriosInventory", LivingEntity.class);
            }
            catch (Exception e) {
                CURIOS_LOADED = false;
            }
        }
    }
}

