/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.data;

import com.asger.mechtrowel.data.RotationLockData;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class BlockRotationConfig {
    private static final String TAG_LOCKED_FACES = "LockedFaces";
    private static final String TAG_STAIR_MODE = "StairMode";
    private static final String TAG_SLAB_MODE = "SlabMode";
    private static final String TAG_OPEN_MODE = "OpenMode";
    private static final String TAG_STAIR_LINK = "StairLink";
    private final Set<Direction> lockedFaces;
    private RotationLockData.StairMode stairMode;
    private RotationLockData.SlabMode slabMode;
    private RotationLockData.OpenMode openMode;
    private boolean stairLink;

    public BlockRotationConfig() {
        this.lockedFaces = EnumSet.noneOf(Direction.class);
        this.stairMode = RotationLockData.StairMode.AUTO;
        this.slabMode = RotationLockData.SlabMode.AUTO;
        this.openMode = RotationLockData.OpenMode.AUTO;
        this.stairLink = true;
    }

    public BlockRotationConfig(BlockRotationConfig other) {
        this.lockedFaces = EnumSet.copyOf(other.lockedFaces.isEmpty() ? EnumSet.noneOf(Direction.class) : other.lockedFaces);
        this.stairMode = other.stairMode;
        this.slabMode = other.slabMode;
        this.openMode = other.openMode;
        this.stairLink = other.stairLink;
    }

    public void load(CompoundTag tag) {
        this.lockedFaces.clear();
        if (tag.contains(TAG_LOCKED_FACES)) {
            int faces = tag.getInt(TAG_LOCKED_FACES);
            for (Direction dir : Direction.values()) {
                if ((faces & 1 << dir.ordinal()) == 0) continue;
                this.lockedFaces.add(dir);
            }
        }
        this.stairMode = RotationLockData.StairMode.fromString(tag.getString(TAG_STAIR_MODE));
        this.slabMode = RotationLockData.SlabMode.fromString(tag.getString(TAG_SLAB_MODE));
        this.openMode = RotationLockData.OpenMode.fromString(tag.getString(TAG_OPEN_MODE));
        this.stairLink = !tag.contains(TAG_STAIR_LINK) || tag.getBoolean(TAG_STAIR_LINK);
    }

    public void save(CompoundTag tag) {
        int faces = 0;
        for (Direction dir : this.lockedFaces) {
            faces |= 1 << dir.ordinal();
        }
        tag.putInt(TAG_LOCKED_FACES, faces);
        tag.putString(TAG_STAIR_MODE, this.stairMode.getName());
        tag.putString(TAG_SLAB_MODE, this.slabMode.getName());
        tag.putString(TAG_OPEN_MODE, this.openMode.getName());
        tag.putBoolean(TAG_STAIR_LINK, this.stairLink);
    }

    public boolean isConfigured() {
        return !this.lockedFaces.isEmpty() || this.stairMode != RotationLockData.StairMode.AUTO || this.slabMode != RotationLockData.SlabMode.AUTO || this.openMode != RotationLockData.OpenMode.AUTO || !this.stairLink;
    }

    public void toggleDirectionLock(Direction direction) {
        if (this.lockedFaces.contains(direction)) {
            this.lockedFaces.remove(direction);
        } else {
            if (direction.getAxis().isHorizontal()) {
                this.lockedFaces.removeIf(d -> d.getAxis().isHorizontal());
            } else {
                this.lockedFaces.removeIf(d -> d.getAxis().isVertical());
            }
            this.lockedFaces.add(direction);
        }
    }

    public void setDirectionLock(Direction direction) {
        if (direction.getAxis().isHorizontal()) {
            this.lockedFaces.removeIf(d -> d.getAxis().isHorizontal());
        } else {
            this.lockedFaces.removeIf(d -> d.getAxis().isVertical());
        }
        this.lockedFaces.add(direction);
    }

    public boolean isDirectionLocked(Direction direction) {
        return this.lockedFaces.contains(direction);
    }

    public Direction getLockedHorizontalDirection() {
        for (Direction dir : this.lockedFaces) {
            if (!dir.getAxis().isHorizontal()) continue;
            return dir;
        }
        return null;
    }

    public Direction getLockedVerticalDirection() {
        for (Direction dir : this.lockedFaces) {
            if (!dir.getAxis().isVertical()) continue;
            return dir;
        }
        return null;
    }

    public void clearLocks() {
        this.lockedFaces.clear();
    }

    public void clear() {
        this.lockedFaces.clear();
        this.stairMode = RotationLockData.StairMode.AUTO;
        this.slabMode = RotationLockData.SlabMode.AUTO;
        this.openMode = RotationLockData.OpenMode.AUTO;
        this.stairLink = true;
    }

    public Set<Direction> getLockedFaces() {
        return this.lockedFaces;
    }

    public RotationLockData.StairMode getStairMode() {
        return this.stairMode;
    }

    public void setStairMode(RotationLockData.StairMode stairMode) {
        this.stairMode = stairMode;
    }

    public RotationLockData.SlabMode getSlabMode() {
        return this.slabMode;
    }

    public void setSlabMode(RotationLockData.SlabMode slabMode) {
        this.slabMode = slabMode;
    }

    public RotationLockData.OpenMode getOpenMode() {
        return this.openMode;
    }

    public void setOpenMode(RotationLockData.OpenMode openMode) {
        this.openMode = openMode;
    }

    public boolean isStairLink() {
        return this.stairLink;
    }

    public void setStairLink(boolean stairLink) {
        this.stairLink = stairLink;
    }
}

