/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui.widget;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class InteractivePercentageBar
extends AbstractWidget {
    private static final int WIDTH = 22;
    private static final int HEIGHT = 10;
    private static final int TRACK_DARK = -14013910;
    private static final int TRACK_SHADOW = -15066598;
    private static final int TRACK_MAIN = -11908534;
    private static final int FILL_HIGHLIGHT = 0x44FFFFFF;
    private static final int FILL_SHADOW = 0x44000000;
    private static final int TEXT_COLOR = -1;
    private static final int TEXT_SHADOW = -16777216;
    private static final int HOVER_OVERLAY = 0x22FFFFFF;
    private static final int BAR_COLOR_LOCKED = -5614081;
    private int percentage = 0;
    private boolean locked = false;
    private boolean isTextInputMode = false;
    private final Consumer<Integer> onPercentageChanged;
    private final Consumer<Boolean> onLockToggled;
    private EditBox textInput;
    private final Screen parentScreen;

    public InteractivePercentageBar(int x, int y, int width, Screen parentScreen, Consumer<Integer> onPercentageChanged) {
        this(x, y, width, parentScreen, onPercentageChanged, null);
    }

    public InteractivePercentageBar(int x, int y, int width, Screen parentScreen, Consumer<Integer> onPercentageChanged, Consumer<Boolean> onLockToggled) {
        super(x, y, 22, 10, (Component)Component.empty());
        this.onPercentageChanged = onPercentageChanged;
        this.onLockToggled = onLockToggled;
        this.parentScreen = parentScreen;
        this.textInput = new EditBox(parentScreen.getMinecraft().font, x, y, 22, 10, (Component)Component.empty());
        this.textInput.setMaxLength(3);
        this.textInput.setValue("0");
        this.textInput.setFilter(s -> s.matches("\\d*"));
        this.textInput.setVisible(false);
        this.visible = true;
    }

    public void setPercentage(int percentage) {
        this.percentage = Mth.clamp((int)percentage, (int)0, (int)100);
        if (!this.isTextInputMode) {
            this.textInput.setValue(String.valueOf(this.percentage));
        }
    }

    public int getPercentage() {
        return this.percentage;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        if (this.isTextInputMode) {
            this.textInput.render(guiGraphics, mouseX, mouseY, partialTick);
        } else {
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + 22, this.getY() + 10, -14013910);
            guiGraphics.hLine(this.getX() + 1, this.getX() + 22 - 2, this.getY() + 1, -15066598);
            guiGraphics.vLine(this.getX() + 1, this.getY() + 1, this.getY() + 10 - 2, -15066598);
            guiGraphics.fill(this.getX() + 2, this.getY() + 2, this.getX() + 22 - 1, this.getY() + 10 - 1, -11908534);
            if (this.percentage > 0) {
                int fillWidth = Math.max(1, 18 * this.percentage / 100);
                int fillColor = this.locked ? -5614081 : this.calculateGradientColor(this.percentage);
                guiGraphics.fill(this.getX() + 2, this.getY() + 2, this.getX() + 2 + fillWidth, this.getY() + 10 - 1, fillColor);
                guiGraphics.hLine(this.getX() + 2, this.getX() + 1 + fillWidth, this.getY() + 2, 0x44FFFFFF);
                guiGraphics.hLine(this.getX() + 2, this.getX() + 1 + fillWidth, this.getY() + 10 - 2, 0x44000000);
                if (fillWidth > 1 && this.percentage < 100) {
                    guiGraphics.vLine(this.getX() + 1 + fillWidth, this.getY() + 2, this.getY() + 10 - 2, 0x44FFFFFF);
                }
            }
            if (this.locked) {
                guiGraphics.fill(this.getX(), this.getY(), this.getX() + 1, this.getY() + 10, -2002102785);
                guiGraphics.fill(this.getX() + 22 - 1, this.getY(), this.getX() + 22, this.getY() + 10, -2002102785);
            }
            if (this.isHovered()) {
                guiGraphics.fill(this.getX(), this.getY(), this.getX() + 22, this.getY() + 10, 0x22FFFFFF);
            }
            String percentText = String.valueOf(this.percentage);
            int textX = this.getX() + (22 - this.parentScreen.getMinecraft().font.width(percentText)) / 2;
            int textY = this.getY() + 1;
            guiGraphics.drawString(this.parentScreen.getMinecraft().font, percentText, textX + 1, textY + 1, -16777216, false);
            guiGraphics.drawString(this.parentScreen.getMinecraft().font, percentText, textX, textY, -1, false);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible || !this.active) {
            return false;
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            if (button == 0 && !this.locked) {
                this.startTextInput();
                return true;
            }
            if (button == 1) {
                boolean bl = this.locked = !this.locked;
                if (this.onLockToggled != null) {
                    this.onLockToggled.accept(this.locked);
                }
                return true;
            }
        }
        if (this.isTextInputMode) {
            return this.textInput.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isTextInputMode) {
            return this.textInput.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!this.visible || !this.active || this.locked) {
            return false;
        }
        if (this.isMouseOver(mouseX, mouseY) && !this.isTextInputMode) {
            boolean shiftHeld = Screen.hasShiftDown();
            int increment = shiftHeld ? 1 : 5;
            int change = (int)Math.signum(deltaY) * increment;
            int newPercentage = Mth.clamp((int)(this.percentage + change), (int)1, (int)100);
            if (newPercentage != this.percentage) {
                this.percentage = newPercentage;
                this.onPercentageChanged.accept(this.percentage);
            }
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isTextInputMode) {
            if (keyCode == 257) {
                this.finishTextInput();
                return true;
            }
            if (keyCode == 256) {
                this.cancelTextInput();
                return true;
            }
            return this.textInput.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.isTextInputMode) {
            return this.textInput.charTyped(codePoint, modifiers);
        }
        return false;
    }

    private int calculateGradientColor(int percentage) {
        int green;
        int red;
        float ratio = (float)percentage / 100.0f;
        if (ratio <= 0.5f) {
            red = 255;
            green = (int)(255.0f * (ratio * 2.0f));
        } else {
            red = (int)(255.0f * (2.0f - ratio * 2.0f));
            green = 255;
        }
        return 0xFF000000 | red << 16 | green << 8;
    }

    private void startTextInput() {
        this.isTextInputMode = true;
        this.textInput.setValue(String.valueOf(this.percentage));
        this.textInput.setVisible(true);
        this.textInput.setFocused(true);
        this.textInput.setPosition(this.getX(), this.getY());
        this.textInput.setSize(22, 10);
        this.textInput.setHighlightPos(0);
        this.textInput.setCursorPosition(this.textInput.getValue().length());
    }

    private void finishTextInput() {
        try {
            int newPercentage = Integer.parseInt(this.textInput.getValue());
            newPercentage = Mth.clamp((int)newPercentage, (int)1, (int)100);
            if (newPercentage != this.percentage) {
                this.percentage = newPercentage;
                this.onPercentageChanged.accept(this.percentage);
                this.textInput.setValue(String.valueOf(this.percentage));
            }
        }
        catch (NumberFormatException ignored) {
            this.textInput.setValue(String.valueOf(this.percentage));
        }
        this.cancelTextInput();
    }

    private void cancelTextInput() {
        this.isTextInputMode = false;
        this.textInput.setVisible(false);
        this.textInput.setFocused(false);
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (this.textInput != null) {
            this.textInput.setVisible(visible && this.isTextInputMode);
        }
    }

    public void setY(int y) {
        super.setY(y);
        if (this.textInput != null) {
            this.textInput.setY(y);
        }
    }

    public void setX(int x) {
        super.setX(x);
        if (this.textInput != null) {
            this.textInput.setX(x);
        }
    }

    public boolean isInTextInputMode() {
        return this.isTextInputMode;
    }

    public int getWidth() {
        return 22;
    }
}

