/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import com.asger.mechtrowel.data.BlockRotationConfig;
import com.asger.mechtrowel.data.RotationLockData;
import com.asger.mechtrowel.util.CopycatSlabHelper;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class BlockRotationHelper {
    public static BlockState applyRotation(BlockState state, RotationLockData globalRotation, BlockRotationConfig blockRotation, Player player, Direction clickedFace) {
        Iterator<Direction> iterator;
        Direction lockedDirection = null;
        if (BlockRotationHelper.hasActiveGlobalDirectionLocks(globalRotation)) {
            iterator = globalRotation.getLockedFaces().iterator();
            if (iterator.hasNext()) {
                lockedDirection = dir = iterator.next();
            }
        } else if (blockRotation != null && !blockRotation.getLockedFaces().isEmpty() && (iterator = blockRotation.getLockedFaces().iterator()).hasNext()) {
            lockedDirection = dir = iterator.next();
        }
        RotationLockData.StairMode stairMode = RotationLockData.StairMode.AUTO;
        RotationLockData.SlabMode slabMode = RotationLockData.SlabMode.AUTO;
        RotationLockData.OpenMode openMode = RotationLockData.OpenMode.AUTO;
        if (blockRotation != null && blockRotation.getStairMode() != RotationLockData.StairMode.AUTO) {
            stairMode = blockRotation.getStairMode();
        } else if (globalRotation.getStairMode() != RotationLockData.StairMode.AUTO) {
            stairMode = globalRotation.getStairMode();
        }
        if (blockRotation != null && blockRotation.getSlabMode() != RotationLockData.SlabMode.AUTO) {
            slabMode = blockRotation.getSlabMode();
        } else if (globalRotation.getSlabMode() != RotationLockData.SlabMode.AUTO) {
            slabMode = globalRotation.getSlabMode();
        }
        if (blockRotation != null && blockRotation.getOpenMode() != RotationLockData.OpenMode.AUTO) {
            openMode = blockRotation.getOpenMode();
        } else if (globalRotation.getOpenMode() != RotationLockData.OpenMode.AUTO) {
            openMode = globalRotation.getOpenMode();
        }
        return BlockRotationHelper.applyRotationCombined(state, lockedDirection, stairMode, slabMode, openMode, player, clickedFace);
    }

    public static boolean hasActiveGlobalDirectionLocks(RotationLockData data) {
        return !data.getLockedFaces().isEmpty();
    }

    public static boolean hasActiveGlobalSettings(RotationLockData data) {
        return !data.getLockedFaces().isEmpty() || data.getStairMode() != RotationLockData.StairMode.AUTO || data.getSlabMode() != RotationLockData.SlabMode.AUTO || data.getOpenMode() != RotationLockData.OpenMode.AUTO;
    }

    private static BlockState applyRotationCombined(BlockState state, Direction lockedDirection, RotationLockData.StairMode stairMode, RotationLockData.SlabMode slabMode, RotationLockData.OpenMode openMode, Player player, Direction clickedFace) {
        Block block = state.getBlock();
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            state = lockedDirection != null ? (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)clickedFace);
        }
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && !(block instanceof StairBlock) && !(block instanceof FenceGateBlock)) {
            state = lockedDirection != null && lockedDirection.getAxis() != Direction.Axis.Y ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection().getOpposite());
        }
        if (block instanceof FenceGateBlock) {
            state = BlockRotationHelper.applyFenceGateRotationCombined(state, lockedDirection, openMode, player);
        }
        if (block instanceof StairBlock && state.hasProperty((Property)BlockStateProperties.HALF)) {
            state = BlockRotationHelper.applyStairRotationCombined(state, lockedDirection, stairMode, player, clickedFace);
        }
        if (block instanceof SlabBlock && state.hasProperty((Property)BlockStateProperties.SLAB_TYPE) && !CopycatSlabHelper.isCopycatSlab(state)) {
            state = BlockRotationHelper.applySlabRotationCombined(state, slabMode, player, clickedFace);
        }
        if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
            state = lockedDirection != null ? (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)lockedDirection.getAxis()) : (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)clickedFace.getAxis());
        }
        if (state.hasProperty((Property)BlockStateProperties.OPEN) && !(block instanceof FenceGateBlock)) {
            boolean shouldBeOpen = switch (openMode) {
                default -> throw new MatchException(null, null);
                case RotationLockData.OpenMode.OPEN -> true;
                case RotationLockData.OpenMode.CLOSED -> false;
                case RotationLockData.OpenMode.AUTO -> false;
            };
            state = (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(shouldBeOpen));
        }
        return state;
    }

    private static BlockState applyStairRotationCombined(BlockState state, Direction lockedDirection, RotationLockData.StairMode stairMode, Player player, Direction clickedFace) {
        state = (BlockState)state.setValue((Property)BlockStateProperties.HALF, (Comparable)(switch (stairMode) {
            case RotationLockData.StairMode.TOP -> Half.TOP;
            case RotationLockData.StairMode.BOTTOM -> Half.BOTTOM;
            default -> clickedFace == Direction.DOWN || clickedFace != Direction.UP && player.getXRot() > 0.0f ? Half.TOP : Half.BOTTOM;
        }));
        state = lockedDirection != null && lockedDirection.getAxis() != Direction.Axis.Y ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection());
        return state;
    }

    private static BlockState applySlabRotationCombined(BlockState state, RotationLockData.SlabMode slabMode, Player player, Direction clickedFace) {
        return (BlockState)state.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)(switch (slabMode) {
            case RotationLockData.SlabMode.TOP -> SlabType.TOP;
            case RotationLockData.SlabMode.BOTTOM -> SlabType.BOTTOM;
            default -> clickedFace == Direction.DOWN || clickedFace != Direction.UP && player.getXRot() > 0.0f ? SlabType.TOP : SlabType.BOTTOM;
        }));
    }

    private static BlockState applyFenceGateRotationCombined(BlockState state, Direction lockedDirection, RotationLockData.OpenMode openMode, Player player) {
        state = lockedDirection != null && lockedDirection.getAxis() != Direction.Axis.Y ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection());
        boolean shouldBeOpen = switch (openMode) {
            default -> throw new MatchException(null, null);
            case RotationLockData.OpenMode.OPEN -> true;
            case RotationLockData.OpenMode.CLOSED -> false;
            case RotationLockData.OpenMode.AUTO -> false;
        };
        state = (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(shouldBeOpen));
        return state;
    }

    private static BlockState applyBlockRotation(BlockState state, BlockRotationConfig blockConfig, Player player, Direction clickedFace) {
        Block block = state.getBlock();
        Direction lockedDirection = null;
        Iterator<Direction> iterator = blockConfig.getLockedFaces().iterator();
        if (iterator.hasNext()) {
            Direction dir;
            lockedDirection = dir = iterator.next();
        }
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            state = lockedDirection != null ? (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)clickedFace);
        }
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && !(block instanceof StairBlock) && !(block instanceof FenceGateBlock)) {
            state = lockedDirection != null && lockedDirection.getAxis() != Direction.Axis.Y ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection().getOpposite());
        }
        if (block instanceof FenceGateBlock) {
            state = BlockRotationHelper.applyFenceGateRotationFromConfig(state, blockConfig, player, lockedDirection);
        }
        if (block instanceof StairBlock && state.hasProperty((Property)BlockStateProperties.HALF)) {
            state = BlockRotationHelper.applyStairRotationFromConfig(state, blockConfig, player, clickedFace, lockedDirection);
        }
        if (block instanceof SlabBlock && state.hasProperty((Property)BlockStateProperties.SLAB_TYPE) && !CopycatSlabHelper.isCopycatSlab(state)) {
            state = BlockRotationHelper.applySlabRotationFromConfig(state, blockConfig, player, clickedFace);
        }
        if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
            state = lockedDirection != null ? (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)lockedDirection.getAxis()) : (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)clickedFace.getAxis());
        }
        if (state.hasProperty((Property)BlockStateProperties.OPEN) && !(block instanceof FenceGateBlock)) {
            boolean shouldBeOpen = switch (blockConfig.getOpenMode()) {
                default -> throw new MatchException(null, null);
                case RotationLockData.OpenMode.OPEN -> true;
                case RotationLockData.OpenMode.CLOSED -> false;
                case RotationLockData.OpenMode.AUTO -> false;
            };
            state = (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(shouldBeOpen));
        }
        return state;
    }

    private static BlockState applyStairRotationFromConfig(BlockState state, BlockRotationConfig blockConfig, Player player, Direction clickedFace, Direction lockedDirection) {
        state = (BlockState)state.setValue((Property)BlockStateProperties.HALF, (Comparable)(switch (blockConfig.getStairMode()) {
            case RotationLockData.StairMode.TOP -> Half.TOP;
            case RotationLockData.StairMode.BOTTOM -> Half.BOTTOM;
            default -> clickedFace == Direction.DOWN || clickedFace != Direction.UP && player.getXRot() > 0.0f ? Half.TOP : Half.BOTTOM;
        }));
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            state = lockedDirection != null && lockedDirection.getAxis() != Direction.Axis.Y ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)lockedDirection.getOpposite()) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection());
        }
        return state;
    }

    private static BlockState applySlabRotationFromConfig(BlockState state, BlockRotationConfig blockConfig, Player player, Direction clickedFace) {
        SlabType type;
        if (state.getValue((Property)BlockStateProperties.SLAB_TYPE) == SlabType.DOUBLE) {
            return state;
        }
        switch (blockConfig.getSlabMode()) {
            case TOP: {
                type = SlabType.TOP;
                break;
            }
            case BOTTOM: {
                type = SlabType.BOTTOM;
                break;
            }
            default: {
                return state;
            }
        }
        return (BlockState)state.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)type);
    }

    private static BlockState applyFenceGateRotationFromConfig(BlockState state, BlockRotationConfig blockConfig, Player player, Direction lockedDirection) {
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            state = lockedDirection != null && lockedDirection.getAxis() != Direction.Axis.Y ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection().getOpposite());
        }
        if (state.hasProperty((Property)BlockStateProperties.OPEN)) {
            boolean shouldBeOpen = switch (blockConfig.getOpenMode()) {
                default -> throw new MatchException(null, null);
                case RotationLockData.OpenMode.OPEN -> true;
                case RotationLockData.OpenMode.CLOSED -> false;
                case RotationLockData.OpenMode.AUTO -> false;
            };
            state = (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(shouldBeOpen));
        }
        if (state.hasProperty((Property)BlockStateProperties.IN_WALL)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.IN_WALL, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public static BlockState applyRotation(BlockState state, RotationLockData rotationData, Player player, Direction clickedFace) {
        Block block = state.getBlock();
        Direction lockedDirection = null;
        Iterator<Direction> iterator = rotationData.getLockedFaces().iterator();
        if (iterator.hasNext()) {
            Direction dir;
            lockedDirection = dir = iterator.next();
        }
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            state = lockedDirection != null ? (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)clickedFace);
        }
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && !(block instanceof StairBlock) && !(block instanceof FenceGateBlock)) {
            state = lockedDirection != null && lockedDirection.getAxis() != Direction.Axis.Y ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection().getOpposite());
        }
        if (block instanceof FenceGateBlock) {
            state = BlockRotationHelper.applyFenceGateRotation(state, rotationData, player, lockedDirection);
        }
        if (block instanceof StairBlock && state.hasProperty((Property)BlockStateProperties.HALF)) {
            state = BlockRotationHelper.applyStairRotation(state, rotationData, player, clickedFace, lockedDirection);
        }
        if (block instanceof SlabBlock && state.hasProperty((Property)BlockStateProperties.SLAB_TYPE) && !CopycatSlabHelper.isCopycatSlab(state)) {
            state = BlockRotationHelper.applySlabRotation(state, rotationData, player, clickedFace);
        }
        if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
            state = lockedDirection != null ? (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)lockedDirection.getAxis()) : (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)clickedFace.getAxis());
        }
        if (state.hasProperty((Property)BlockStateProperties.OPEN) && !(block instanceof FenceGateBlock)) {
            boolean shouldBeOpen = switch (rotationData.getOpenMode()) {
                default -> throw new MatchException(null, null);
                case RotationLockData.OpenMode.OPEN -> true;
                case RotationLockData.OpenMode.CLOSED -> false;
                case RotationLockData.OpenMode.AUTO -> false;
            };
            state = (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(shouldBeOpen));
        }
        return state;
    }

    private static BlockState applyStairRotation(BlockState state, RotationLockData rotationData, Player player, Direction clickedFace, Direction lockedDirection) {
        state = (BlockState)state.setValue((Property)BlockStateProperties.HALF, (Comparable)(switch (rotationData.getStairMode()) {
            case RotationLockData.StairMode.TOP -> Half.TOP;
            case RotationLockData.StairMode.BOTTOM -> Half.BOTTOM;
            default -> clickedFace == Direction.DOWN || clickedFace != Direction.UP && player.getXRot() > 0.0f ? Half.TOP : Half.BOTTOM;
        }));
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            state = lockedDirection != null && lockedDirection.getAxis() != Direction.Axis.Y ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)lockedDirection.getOpposite()) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection());
        }
        return state;
    }

    private static BlockState applySlabRotation(BlockState state, RotationLockData rotationData, Player player, Direction clickedFace) {
        SlabType type;
        if (state.getValue((Property)BlockStateProperties.SLAB_TYPE) == SlabType.DOUBLE) {
            return state;
        }
        switch (rotationData.getSlabMode()) {
            case TOP: {
                type = SlabType.TOP;
                break;
            }
            case BOTTOM: {
                type = SlabType.BOTTOM;
                break;
            }
            default: {
                return state;
            }
        }
        return (BlockState)state.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)type);
    }

    private static BlockState applyFenceGateRotation(BlockState state, RotationLockData rotationData, Player player, Direction lockedDirection) {
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            state = lockedDirection != null && lockedDirection.getAxis() != Direction.Axis.Y ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection().getOpposite());
        }
        if (state.hasProperty((Property)BlockStateProperties.OPEN)) {
            boolean shouldBeOpen = switch (rotationData.getOpenMode()) {
                default -> throw new MatchException(null, null);
                case RotationLockData.OpenMode.OPEN -> true;
                case RotationLockData.OpenMode.CLOSED -> false;
                case RotationLockData.OpenMode.AUTO -> false;
            };
            state = (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(shouldBeOpen));
        }
        if (state.hasProperty((Property)BlockStateProperties.IN_WALL)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.IN_WALL, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }
}

