/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import com.asger.mechtrowel.compat.CuriosCompat;
import com.asger.mechtrowel.compat.chipped.ChippedCompat;
import com.asger.mechtrowel.compat.rechiseled.RechiseledCompat;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.util.BlockTransformHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class InventorySearchHelper {
    public static SearchResult findBlockInAllInventories(Player player, Block block) {
        SearchResult result = InventorySearchHelper.findInPlayerInventory(player, block);
        if (result != null) {
            return result;
        }
        result = InventorySearchHelper.findInShulkerBoxes(player, block);
        if (result != null) {
            return result;
        }
        result = InventorySearchHelper.findInArmorSlots(player, block);
        if (result != null) {
            return result;
        }
        result = InventorySearchHelper.findInModdedContainers(player, block);
        if (result != null) {
            return result;
        }
        if (ModList.get().isLoaded("curios") && (result = InventorySearchHelper.findInCuriosSlots(player, block)) != null) {
            return result;
        }
        Block standingVariant = BlockTransformHelper.getStandingVariant(block);
        if (standingVariant != block) {
            return InventorySearchHelper.findBlockInAllInventories(player, standingVariant);
        }
        return null;
    }

    public static boolean consumeBlock(Player player, Block block, boolean simulate) {
        SearchResult result = InventorySearchHelper.findBlockInAllInventories(player, block);
        if (result == null) {
            return false;
        }
        if (!simulate && !player.isCreative()) {
            switch (result.location.ordinal()) {
                case 0: 
                case 4: {
                    result.stack.shrink(1);
                    break;
                }
                case 1: {
                    if (result.container == null) break;
                    InventorySearchHelper.consumeFromShulkerBox(result.container, result.slot);
                    break;
                }
                case 2: 
                case 5: {
                    if (result.container == null) break;
                    InventorySearchHelper.consumeFromModdedContainer(result.container, result.slot);
                    break;
                }
                case 3: {
                    if (!ModList.get().isLoaded("curios")) break;
                    InventorySearchHelper.consumeFromCuriosSlot(player, result.container, result.slot);
                }
            }
        }
        return true;
    }

    public static int countBlocksInAllInventories(Player player, Block block) {
        int count = 0;
        count += InventorySearchHelper.countInPlayerInventory(player, block);
        count += InventorySearchHelper.countInShulkerBoxes(player, block);
        count += InventorySearchHelper.countInArmorSlots(player, block);
        count += InventorySearchHelper.countInModdedContainers(player, block);
        if (ModList.get().isLoaded("curios")) {
            count += InventorySearchHelper.countInCuriosSlots(player, block);
        }
        return count;
    }

    public static int countBlocks(Player player, Block block) {
        return InventorySearchHelper.countBlocksInAllInventories(player, block);
    }

    public static int countBlocksWithVariantFallback(Player player, Block block, TrowelData trowelData) {
        boolean isRechiseledVariant;
        int count = InventorySearchHelper.countBlocksInAllInventories(player, block);
        if (count > 0) {
            return count;
        }
        if (trowelData == null || !trowelData.isChippedConversionEnabled() || !trowelData.isChippedConversionActive()) {
            return 0;
        }
        boolean isChippedVariant = ChippedCompat.isChippedLoaded() && ChippedCompat.isChippedVariant(block);
        boolean bl = isRechiseledVariant = RechiseledCompat.isRechiseledLoaded() && RechiseledCompat.isRechiseledVariant(block);
        if (!isChippedVariant && !isRechiseledVariant) {
            return 0;
        }
        Block baseBlock = null;
        if (isChippedVariant) {
            baseBlock = ChippedCompat.getBaseBlock(block);
        }
        if (baseBlock == null && isRechiseledVariant) {
            baseBlock = RechiseledCompat.getBaseBlock(block);
        }
        if (baseBlock == null || baseBlock == block) {
            return 0;
        }
        return InventorySearchHelper.countBlocksInAllInventories(player, baseBlock);
    }

    @Deprecated
    public static int countBlocksWithChippedFallback(Player player, Block block, TrowelData trowelData) {
        return InventorySearchHelper.countBlocksWithVariantFallback(player, block, trowelData);
    }

    private static SearchResult findInPlayerInventory(Player player, Block block) {
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            BlockItem blockItem;
            Item item;
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || (blockItem = (BlockItem)item).getBlock() != block) continue;
            return new SearchResult(stack, SearchLocation.PLAYER_INVENTORY, i, null);
        }
        return null;
    }

    private static int countInPlayerInventory(Player player, Block block) {
        int count = 0;
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            BlockItem blockItem;
            Item item;
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || (blockItem = (BlockItem)item).getBlock() != block) continue;
            count += stack.getCount();
        }
        return count;
    }

    private static SearchResult findInShulkerBoxes(Player player, Block block) {
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            SearchResult result;
            BlockItem blockItem;
            Item item;
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock) || (result = InventorySearchHelper.findInShulkerBox(stack, block)) == null) continue;
            return result;
        }
        return null;
    }

    private static int countInShulkerBoxes(Player player, Block block) {
        int count = 0;
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            BlockItem blockItem;
            Item item;
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock)) continue;
            count += InventorySearchHelper.countInShulkerBox(stack, block);
        }
        return count;
    }

    private static SearchResult findInShulkerBox(ItemStack shulkerBox, Block block) {
        ItemContainerContents contents = (ItemContainerContents)shulkerBox.get(DataComponents.CONTAINER);
        if (contents != null) {
            List items = contents.stream().toList();
            for (int i = 0; i < items.size(); ++i) {
                BlockItem blockItem;
                Item item;
                ItemStack stack = (ItemStack)items.get(i);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || (blockItem = (BlockItem)item).getBlock() != block) continue;
                return new SearchResult(stack, SearchLocation.SHULKER_BOX, i, shulkerBox);
            }
        }
        return null;
    }

    private static int countInShulkerBox(ItemStack shulkerBox, Block block) {
        int count = 0;
        ItemContainerContents contents = (ItemContainerContents)shulkerBox.get(DataComponents.CONTAINER);
        if (contents != null) {
            for (ItemStack stack : contents.stream().toList()) {
                BlockItem blockItem;
                Item item;
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || (blockItem = (BlockItem)item).getBlock() != block) continue;
                count += stack.getCount();
            }
        }
        return count;
    }

    private static void consumeFromShulkerBox(ItemStack shulkerBox, int slot) {
        ItemContainerContents contents = (ItemContainerContents)shulkerBox.get(DataComponents.CONTAINER);
        if (contents != null) {
            ItemStack targetStack;
            ArrayList items = new ArrayList(contents.stream().toList());
            while (items.size() < 27) {
                items.add(ItemStack.EMPTY);
            }
            if (slot < items.size() && !(targetStack = (ItemStack)items.get(slot)).isEmpty()) {
                targetStack.shrink(1);
                if (targetStack.isEmpty()) {
                    items.set(slot, ItemStack.EMPTY);
                } else {
                    items.set(slot, targetStack);
                }
                ItemContainerContents newContents = ItemContainerContents.fromItems(items);
                shulkerBox.set(DataComponents.CONTAINER, (Object)newContents);
            }
        }
    }

    private static SearchResult findInArmorSlots(Player player, Block block) {
        for (ItemStack stack : player.getArmorSlots()) {
            BlockItem blockItem;
            if (stack.isEmpty()) continue;
            if (InventorySearchHelper.isBackpack(stack)) {
                SearchResult result = InventorySearchHelper.findInModdedContainer(stack, block);
                if (result == null) continue;
                return result;
            }
            Item item = stack.getItem();
            if (!(item instanceof BlockItem) || (blockItem = (BlockItem)item).getBlock() != block) continue;
            return new SearchResult(stack, SearchLocation.ARMOR_SLOT, -1, null);
        }
        return null;
    }

    private static int countInArmorSlots(Player player, Block block) {
        int count = 0;
        for (ItemStack stack : player.getArmorSlots()) {
            BlockItem blockItem;
            if (stack.isEmpty()) continue;
            if (InventorySearchHelper.isBackpack(stack)) {
                count += InventorySearchHelper.countInModdedContainer(stack, block);
                continue;
            }
            Item item = stack.getItem();
            if (!(item instanceof BlockItem) || (blockItem = (BlockItem)item).getBlock() != block) continue;
            count += stack.getCount();
        }
        return count;
    }

    private static SearchResult findInModdedContainers(Player player, Block block) {
        SearchResult result;
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !InventorySearchHelper.isModdedContainer(stack) || (result = InventorySearchHelper.findInModdedContainer(stack, block)) == null) continue;
            return result;
        }
        for (ItemStack stack : player.getArmorSlots()) {
            if (stack.isEmpty() || !InventorySearchHelper.isModdedContainer(stack) || (result = InventorySearchHelper.findInModdedContainer(stack, block)) == null) continue;
            return result;
        }
        return null;
    }

    private static int countInModdedContainers(Player player, Block block) {
        int count = 0;
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !InventorySearchHelper.isModdedContainer(stack)) continue;
            count += InventorySearchHelper.countInModdedContainer(stack, block);
        }
        return count;
    }

    private static boolean isModdedContainer(ItemStack stack) {
        String itemClass;
        if (ModList.get().isLoaded("sophisticatedbackpacks") && (itemClass = stack.getItem().getClass().getName()).contains("sophisticatedbackpacks")) {
            return true;
        }
        itemClass = stack.getItem().getClass().getName().toLowerCase();
        String itemId = stack.getItem().toString().toLowerCase();
        String registryName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().toLowerCase();
        if (itemClass.contains("backpack") || itemClass.contains("bag") || itemClass.contains("pouch") || itemId.contains("backpack") || itemId.contains("bag") || itemId.contains("pouch") || registryName.contains("backpack") || registryName.contains("bag") || registryName.contains("pouch")) {
            IItemHandler cap = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
            return cap != null;
        }
        return false;
    }

    private static boolean isBackpack(ItemStack stack) {
        return InventorySearchHelper.isModdedContainer(stack);
    }

    private static SearchResult findInModdedContainer(ItemStack container, Block block) {
        IItemHandler cap = (IItemHandler)container.getCapability(Capabilities.ItemHandler.ITEM);
        if (cap != null) {
            for (int slot = 0; slot < cap.getSlots(); ++slot) {
                BlockItem blockItem;
                Item item;
                ItemStack stack = cap.getStackInSlot(slot);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || (blockItem = (BlockItem)item).getBlock() != block) continue;
                SearchLocation location = container.getItem().getClass().getName().contains("sophisticatedbackpacks") ? SearchLocation.SOPHISTICATED_BACKPACK : SearchLocation.OTHER_CONTAINER;
                return new SearchResult(stack, location, slot, container);
            }
        }
        return null;
    }

    private static int countInModdedContainer(ItemStack container, Block block) {
        int count = 0;
        IItemHandler cap = (IItemHandler)container.getCapability(Capabilities.ItemHandler.ITEM);
        if (cap != null) {
            for (int slot = 0; slot < cap.getSlots(); ++slot) {
                BlockItem blockItem;
                Item item;
                ItemStack stack = cap.getStackInSlot(slot);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || (blockItem = (BlockItem)item).getBlock() != block) continue;
                count += stack.getCount();
            }
        }
        return count;
    }

    private static void consumeFromModdedContainer(ItemStack container, int slot) {
        IItemHandler cap = (IItemHandler)container.getCapability(Capabilities.ItemHandler.ITEM);
        if (cap != null && slot >= 0 && slot < cap.getSlots()) {
            cap.extractItem(slot, 1, false);
        }
    }

    private static SearchResult findInCuriosSlots(Player player, Block block) {
        ItemStack found = CuriosCompat.findBlockInCurios(player, block);
        if (!found.isEmpty()) {
            return new SearchResult(found, SearchLocation.CURIOS_SLOT, -1, null);
        }
        List<ItemStack> containers = CuriosCompat.getContainersFromCurios(player);
        for (ItemStack container : containers) {
            SearchResult result = InventorySearchHelper.findInModdedContainer(container, block);
            if (result == null) continue;
            return new SearchResult(result.stack, SearchLocation.CURIOS_SLOT, result.slot, container);
        }
        return null;
    }

    private static int countInCuriosSlots(Player player, Block block) {
        int count = CuriosCompat.countBlocksInCurios(player, block);
        List<ItemStack> containers = CuriosCompat.getContainersFromCurios(player);
        for (ItemStack container : containers) {
            count += InventorySearchHelper.countInModdedContainer(container, block);
        }
        return count;
    }

    private static void consumeFromCuriosSlot(Player player, ItemStack container, int slot) {
        if (container != null && slot >= 0) {
            InventorySearchHelper.consumeFromModdedContainer(container, slot);
        }
    }

    public static SearchResult findBlockWithVariantFallback(Player player, Block block, TrowelData trowelData) {
        boolean isRechiseledVariant;
        SearchResult result = InventorySearchHelper.findBlockInAllInventories(player, block);
        if (result != null) {
            return result;
        }
        if (trowelData == null || !trowelData.isChippedConversionEnabled() || !trowelData.isChippedConversionActive()) {
            return null;
        }
        boolean isChippedVariant = ChippedCompat.isChippedLoaded() && ChippedCompat.isChippedVariant(block);
        boolean bl = isRechiseledVariant = RechiseledCompat.isRechiseledLoaded() && RechiseledCompat.isRechiseledVariant(block);
        if (!isChippedVariant && !isRechiseledVariant) {
            return null;
        }
        Block baseBlock = null;
        if (isChippedVariant) {
            baseBlock = ChippedCompat.getBaseBlock(block);
        }
        if (baseBlock == null && isRechiseledVariant) {
            baseBlock = RechiseledCompat.getBaseBlock(block);
        }
        if (baseBlock == null || baseBlock == block) {
            return null;
        }
        SearchResult baseResult = InventorySearchHelper.findBlockInAllInventories(player, baseBlock);
        if (baseResult != null) {
            baseResult.isChippedConversion = true;
            baseResult.chippedVariantBlock = block;
        }
        return baseResult;
    }

    public static boolean consumeBlockWithVariantFallback(Player player, Block block, boolean simulate, TrowelData trowelData) {
        SearchResult result = InventorySearchHelper.findBlockWithVariantFallback(player, block, trowelData);
        if (result == null) {
            return false;
        }
        if (!simulate && !player.isCreative()) {
            switch (result.location.ordinal()) {
                case 0: 
                case 4: {
                    result.stack.shrink(1);
                    break;
                }
                case 1: {
                    InventorySearchHelper.consumeFromShulkerBox(result.container, result.slot);
                    break;
                }
                case 2: 
                case 5: {
                    InventorySearchHelper.consumeFromModdedContainer(result.container, result.slot);
                    break;
                }
                case 3: {
                    InventorySearchHelper.consumeFromCuriosSlot(player, result.container, result.slot);
                }
            }
        }
        return true;
    }

    @Deprecated
    public static SearchResult findBlockWithChippedFallback(Player player, Block block, TrowelData trowelData) {
        return InventorySearchHelper.findBlockWithVariantFallback(player, block, trowelData);
    }

    @Deprecated
    public static boolean consumeBlockWithChippedFallback(Player player, Block block, boolean simulate, TrowelData trowelData) {
        return InventorySearchHelper.consumeBlockWithVariantFallback(player, block, simulate, trowelData);
    }

    public static class SearchResult {
        public final ItemStack stack;
        public final SearchLocation location;
        public final int slot;
        @Nullable
        public final ItemStack container;
        public boolean isChippedConversion = false;
        public Block chippedVariantBlock = null;

        public SearchResult(ItemStack stack, SearchLocation location, int slot, @Nullable ItemStack container) {
            this.stack = stack;
            this.location = location;
            this.slot = slot;
            this.container = container;
        }
    }

    public static enum SearchLocation {
        PLAYER_INVENTORY,
        SHULKER_BOX,
        SOPHISTICATED_BACKPACK,
        CURIOS_SLOT,
        ARMOR_SLOT,
        OTHER_CONTAINER;

    }
}

