/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import com.asger.mechtrowel.data.PaletteData;
import java.util.ArrayList;
import java.util.Iterator;

public class PaletteBalancer {
    public static void autoBalance(PaletteData palette) {
        int i;
        if (palette.getBlocks().isEmpty()) {
            return;
        }
        int currentTotal = 0;
        int lockedTotal = 0;
        ArrayList<Integer> unlockedIndices = new ArrayList<Integer>();
        for (i = 0; i < palette.getBlocks().size(); ++i) {
            int percentage = palette.getPercentage(i);
            currentTotal += percentage;
            if (palette.isLocked(i)) {
                lockedTotal += percentage;
                continue;
            }
            unlockedIndices.add(i);
        }
        if (currentTotal == 100) {
            return;
        }
        if (unlockedIndices.isEmpty()) {
            for (i = 0; i < palette.getBlocks().size(); ++i) {
                palette.setLocked(i, false);
                unlockedIndices.add(i);
            }
            lockedTotal = 0;
        }
        if (lockedTotal >= 100) {
            for (i = 0; i < palette.getBlocks().size(); ++i) {
                palette.setLocked(i, false);
            }
            PaletteBalancer.equalDistribution(palette);
            return;
        }
        int targetForUnlocked = 100 - lockedTotal;
        int currentUnlockedTotal = currentTotal - lockedTotal;
        if (currentUnlockedTotal <= 0 || unlockedIndices.isEmpty()) {
            int basePercentage = targetForUnlocked / unlockedIndices.size();
            int remainder = targetForUnlocked % unlockedIndices.size();
            for (int i2 = 0; i2 < unlockedIndices.size(); ++i2) {
                int index = (Integer)unlockedIndices.get(i2);
                int percentage = basePercentage + (i2 < remainder ? 1 : 0);
                palette.setPercentage(index, Math.max(1, percentage));
            }
        } else {
            float scaleFactor = (float)targetForUnlocked / (float)currentUnlockedTotal;
            int distributed = 0;
            for (int i3 = 0; i3 < unlockedIndices.size() - 1; ++i3) {
                int index = (Integer)unlockedIndices.get(i3);
                int currentPct = palette.getPercentage(index);
                int newPct = Math.max(1, Math.round((float)currentPct * scaleFactor));
                palette.setPercentage(index, newPct);
                distributed += newPct;
            }
            if (!unlockedIndices.isEmpty()) {
                int lastIndex = (Integer)unlockedIndices.get(unlockedIndices.size() - 1);
                palette.setPercentage(lastIndex, Math.max(1, targetForUnlocked - distributed));
            }
        }
    }

    public static void handlePercentageChange(PaletteData palette, int changedIndex, int oldPercentage, int newPercentage) {
        int i;
        int i2;
        if (oldPercentage == newPercentage) {
            return;
        }
        palette.setPercentage(changedIndex, newPercentage);
        int difference = oldPercentage - newPercentage;
        ArrayList<Integer> otherUnlockedIndices = new ArrayList<Integer>();
        ArrayList<Integer> otherUnlockedPercentages = new ArrayList<Integer>();
        for (i2 = 0; i2 < palette.getBlocks().size(); ++i2) {
            if (i2 == changedIndex || palette.isLocked(i2)) continue;
            otherUnlockedIndices.add(i2);
            otherUnlockedPercentages.add(palette.getPercentage(i2));
        }
        if (otherUnlockedIndices.isEmpty()) {
            return;
        }
        if (difference > 0) {
            for (i2 = 0; i2 < difference; ++i2) {
                int lowestIndex = -1;
                int lowestPercentage = Integer.MAX_VALUE;
                for (int j = 0; j < otherUnlockedIndices.size(); ++j) {
                    blockIndex = (Integer)otherUnlockedIndices.get(j);
                    int currentPct = palette.getPercentage(blockIndex);
                    if (currentPct >= lowestPercentage) continue;
                    lowestPercentage = currentPct;
                    lowestIndex = j;
                }
                if (lowestIndex == -1) continue;
                int blockIndex = (Integer)otherUnlockedIndices.get(lowestIndex);
                palette.setPercentage(blockIndex, palette.getPercentage(blockIndex) + 1);
            }
        } else {
            int needed = Math.abs(difference);
            for (i = 0; i < needed; ++i) {
                int highestIndex = -1;
                int highestPercentage = 0;
                for (int j = 0; j < otherUnlockedIndices.size(); ++j) {
                    int blockIndex = (Integer)otherUnlockedIndices.get(j);
                    int currentPct = palette.getPercentage(blockIndex);
                    if (currentPct <= 1 || currentPct <= highestPercentage) continue;
                    highestPercentage = currentPct;
                    highestIndex = j;
                }
                if (highestIndex == -1) {
                    int currentTotal = 0;
                    for (int j = 0; j < palette.getBlocks().size(); ++j) {
                        if (j == changedIndex) continue;
                        currentTotal += palette.getPercentage(j);
                    }
                    palette.setPercentage(changedIndex, 100 - currentTotal);
                    break;
                }
                blockIndex = (Integer)otherUnlockedIndices.get(highestIndex);
                palette.setPercentage(blockIndex, palette.getPercentage(blockIndex) - 1);
            }
        }
        int total = 0;
        for (i = 0; i < palette.getBlocks().size(); ++i) {
            total += palette.getPercentage(i);
        }
        if (total != 100 && !otherUnlockedIndices.isEmpty()) {
            int adjustIndex = -1;
            if (total > 100) {
                Iterator highestIndex = otherUnlockedIndices.iterator();
                while (highestIndex.hasNext()) {
                    int idx = (Integer)highestIndex.next();
                    if (palette.getPercentage(idx) <= 1) continue;
                    adjustIndex = idx;
                    break;
                }
            } else {
                adjustIndex = (Integer)otherUnlockedIndices.get(0);
            }
            if (adjustIndex != -1) {
                int adjustment = 100 - total;
                int currentValue = palette.getPercentage(adjustIndex);
                palette.setPercentage(adjustIndex, Math.max(1, currentValue + adjustment));
            }
        }
    }

    public static boolean isBalanced(PaletteData palette) {
        int total = 0;
        for (int i = 0; i < palette.getBlocks().size(); ++i) {
            total += palette.getPercentage(i);
        }
        return total == 100;
    }

    public static void equalDistribution(PaletteData palette) {
        PaletteBalancer.equalDistribution(palette, false);
    }

    public static void equalDistribution(PaletteData palette, boolean respectLocks) {
        int blockCount = palette.getBlocks().size();
        if (blockCount == 0) {
            return;
        }
        if (!respectLocks) {
            int basePercentage = 100 / blockCount;
            int remainder = 100 % blockCount;
            for (int i = 0; i < blockCount; ++i) {
                int percentage = basePercentage + (i < remainder ? 1 : 0);
                palette.setPercentage(i, percentage);
            }
        } else {
            int lockedTotal = 0;
            ArrayList<Integer> unlockedIndices = new ArrayList<Integer>();
            for (int i = 0; i < palette.getBlocks().size(); ++i) {
                if (palette.isLocked(i)) {
                    lockedTotal += palette.getPercentage(i);
                    continue;
                }
                unlockedIndices.add(i);
            }
            if (unlockedIndices.isEmpty() || lockedTotal >= 100) {
                PaletteBalancer.equalDistribution(palette, false);
                return;
            }
            int availablePercentage = 100 - lockedTotal;
            int basePercentage = availablePercentage / unlockedIndices.size();
            int remainder = availablePercentage % unlockedIndices.size();
            for (int i = 0; i < unlockedIndices.size(); ++i) {
                int index = (Integer)unlockedIndices.get(i);
                int percentage = basePercentage + (i < remainder ? 1 : 0);
                palette.setPercentage(index, Math.max(1, percentage));
            }
        }
    }

    public static void redistributeAfterBlockChange(PaletteData palette) {
        int i;
        if (palette.getBlocks().isEmpty()) {
            return;
        }
        int lockedTotal = 0;
        ArrayList<Integer> unlockedIndices = new ArrayList<Integer>();
        for (i = 0; i < palette.getBlocks().size(); ++i) {
            if (palette.isLocked(i)) {
                lockedTotal += palette.getPercentage(i);
                continue;
            }
            unlockedIndices.add(i);
        }
        if (!unlockedIndices.isEmpty() && lockedTotal < 100) {
            int availablePercentage = 100 - lockedTotal;
            int basePercentage = availablePercentage / unlockedIndices.size();
            int remainder = availablePercentage % unlockedIndices.size();
            for (int i2 = 0; i2 < unlockedIndices.size(); ++i2) {
                int index = (Integer)unlockedIndices.get(i2);
                int percentage = basePercentage + (i2 < remainder ? 1 : 0);
                palette.setPercentage(index, Math.max(1, percentage));
            }
        } else {
            for (i = 0; i < palette.getBlocks().size(); ++i) {
                palette.setLocked(i, false);
            }
            PaletteBalancer.equalDistribution(palette);
        }
    }
}

