/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.client;

import com.asger.mechtrowel.data.GradientData;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.item.MechTrowelItem;
import com.asger.mechtrowel.util.GradientSelector;
import com.asger.mechtrowel.util.ReplaceSystem;
import com.asger.mechtrowel.util.WandModeHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="mechtrowel", value={Dist.CLIENT})
public class WireframeRenderer {
    private static final float[] COLOR_VALID = new float[]{0.0f, 0.0f, 0.0f};
    private static final float[] COLOR_INVALID = new float[]{0.0f, 0.0f, 0.0f};
    private static final int[] PALETTE_COLORS = new int[]{-10185235, -3368449, -16711809, -10496, -65536, -16711936, -256, -65329, -16711681, -29696, -16777216, -5197648, -1};
    private static final float ALPHA_BASE = 0.5f;
    private static final float ALPHA_PULSE_AMOUNT = 0.3f;
    private static final float PULSE_SPEED = 4.0f;
    private static final int WAND_PREVIEW_LIMIT = 128;

    @SubscribeEvent
    public static void onRenderHighlight(RenderHighlightEvent.Block event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack heldItem = WireframeRenderer.getHeldTrowel((Player)player);
        if (heldItem.isEmpty()) {
            return;
        }
        TrowelData data = TrowelData.getOrCreate(heldItem);
        if (data.isPreviewActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelStageEvent event) {
        BlockHitResult blockHit;
        TrowelData data;
        LocalPlayer player;
        block22: {
            block21: {
                PaletteData palette;
                if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
                    return;
                }
                Minecraft mc = Minecraft.getInstance();
                player = mc.player;
                if (player == null) {
                    return;
                }
                ItemStack heldItem = WireframeRenderer.getHeldTrowel((Player)player);
                if (heldItem.isEmpty()) {
                    return;
                }
                if (player.isShiftKeyDown()) {
                    return;
                }
                data = TrowelData.getOrCreate(heldItem);
                if (!data.isPreviewActive()) {
                    return;
                }
                if (!(data.getBuildingMode() != TrowelData.BuildingMode.BUILDER && data.getBuildingMode() != TrowelData.BuildingMode.WAND || (palette = data.getActivePalette()) != null && !palette.isEmpty())) {
                    return;
                }
                HitResult hitResult = mc.hitResult;
                if (!(hitResult instanceof BlockHitResult)) break block21;
                blockHit = (BlockHitResult)hitResult;
                if (hitResult.getType() == HitResult.Type.BLOCK) break block22;
            }
            return;
        }
        Level level = player.level();
        BlockPos targetPos = blockHit.getBlockPos();
        Direction face = blockHit.getDirection();
        if (data.getBuildingMode() == TrowelData.BuildingMode.WAND) {
            boolean isGradientMode = data.isGradientEnabled() && !data.getGradientData().getSections().isEmpty();
            List<Object> wandPositions = new ArrayList();
            boolean isReplaceMode = ReplaceSystem.isReplaceModeActive((Player)player, data.isReplaceMode());
            ItemStack offhandItem = player.getOffhandItem();
            if (isGradientMode) {
                GradientData gradientData = data.getGradientData();
                List<PaletteData> allPalettes = data.getPalettes();
                wandPositions = isReplaceMode ? WandModeHelper.findConnectedPositionsGradientReplace(level, targetPos, gradientData, allPalettes, offhandItem, face, (Player)player, data.getMaxWandBlocks()) : (!offhandItem.isEmpty() && offhandItem.getItem() instanceof BlockItem ? WandModeHelper.findConnectedPositionsGradientWithOffhand(level, targetPos, offhandItem, face, (Player)player, data.getMaxWandBlocks()) : WandModeHelper.findConnectedPositionsGradient(level, targetPos, gradientData, allPalettes, face, (Player)player, data.getMaxWandBlocks()));
            } else {
                PaletteData palette = data.getActivePalette();
                if (palette != null && !palette.isEmpty()) {
                    wandPositions = isReplaceMode ? WandModeHelper.findConnectedPositionsForReplace(level, targetPos, palette, offhandItem, face, (Player)player, data.getMaxWandBlocks()) : (!offhandItem.isEmpty() && offhandItem.getItem() instanceof BlockItem ? WandModeHelper.findConnectedPositionsWithOffhand(level, targetPos, offhandItem, face, (Player)player, data.getMaxWandBlocks()) : WandModeHelper.findConnectedPositions(level, targetPos, palette, face, (Player)player, data.getMaxWandBlocks()));
                }
            }
            int count = 0;
            for (BlockPos pos : wandPositions) {
                if (count++ < 128) {
                    boolean isValid = isReplaceMode ? ReplaceSystem.canReplaceBlock(level, pos, level.getBlockState(pos), (Player)player) : WireframeRenderer.canPlaceAt(level, pos, (Player)player);
                    WireframeRenderer.renderWireframe(event.getPoseStack(), pos, (Player)player, isValid);
                    continue;
                }
                break;
            }
        } else {
            boolean isValid;
            BlockPos placePos;
            boolean isReplacing = false;
            BlockState targetState = level.getBlockState(targetPos);
            if (ReplaceSystem.isReplaceModeActive((Player)player, data.isReplaceMode()) && !targetState.isAir()) {
                placePos = targetPos;
                isReplacing = true;
                isValid = ReplaceSystem.canReplaceBlock(level, placePos, targetState, (Player)player);
            } else {
                placePos = targetPos.relative(face);
                isValid = WireframeRenderer.canPlaceAt(level, placePos, (Player)player);
            }
            WireframeRenderer.renderWireframe(event.getPoseStack(), placePos, (Player)player, isValid);
        }
    }

    @SubscribeEvent
    public static void onRenderGradientPoints(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack heldItem = WireframeRenderer.getHeldTrowel((Player)player);
        if (heldItem.isEmpty()) {
            return;
        }
        TrowelData data = TrowelData.getOrCreate(heldItem);
        WireframeRenderer.renderGradientPointWireframes(event.getPoseStack(), data, (Player)player);
    }

    private static ItemStack getHeldTrowel(Player player) {
        ItemStack mainHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (mainHand.getItem() instanceof MechTrowelItem) {
            return mainHand;
        }
        ItemStack offHand = player.getItemInHand(InteractionHand.OFF_HAND);
        if (offHand.getItem() instanceof MechTrowelItem) {
            return offHand;
        }
        return ItemStack.EMPTY;
    }

    private static boolean canPlaceAt(Level level, BlockPos pos, Player player) {
        Vec3 blockCenter;
        BlockState currentState = level.getBlockState(pos);
        if (!currentState.canBeReplaced()) {
            return false;
        }
        double reach = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vec3 eyePos = player.getEyePosition();
        return eyePos.distanceToSqr(blockCenter = Vec3.atCenterOf((Vec3i)pos)) <= reach * reach;
    }

    private static void renderWireframe(PoseStack poseStack, BlockPos pos, Player player, boolean isValid) {
        GradientData.GradientSection section;
        Minecraft mc = Minecraft.getInstance();
        Vec3 camPos = mc.gameRenderer.getMainCamera().getPosition();
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() - camPos.x, (double)pos.getY() - camPos.y, (double)pos.getZ() - camPos.z);
        ItemStack heldItem = WireframeRenderer.getHeldTrowel(player);
        TrowelData data = TrowelData.getOrCreate(heldItem);
        float[] color = COLOR_VALID;
        float alpha = 0.5f;
        if (data.isGradientEnabled() && !data.getGradientData().getSections().isEmpty() && (section = WireframeRenderer.findSectionByPosition(data, pos, player)) != null) {
            int colorIndex;
            int sectionColor = section.isUsingCustomColor() ? section.getCustomColor() : ((colorIndex = section.getColorIndex()) >= 0 && colorIndex < PALETTE_COLORS.length ? PALETTE_COLORS[colorIndex] : -16777216);
            color = new float[]{(float)(sectionColor >> 16 & 0xFF) / 255.0f, (float)(sectionColor >> 8 & 0xFF) / 255.0f, (float)(sectionColor & 0xFF) / 255.0f};
        }
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.lines());
        AABB aabb = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (AABB)aabb, (float)color[0], (float)color[1], (float)color[2], (float)alpha);
        bufferSource.endBatch();
        poseStack.popPose();
    }

    private static void renderWireframeGradient(PoseStack poseStack, BlockPos pos, Player player, boolean isValid, GradientSelector.GradientSectionResult gradientResult) {
        Minecraft mc = Minecraft.getInstance();
        Vec3 camPos = mc.gameRenderer.getMainCamera().getPosition();
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() - camPos.x, (double)pos.getY() - camPos.y, (double)pos.getZ() - camPos.z);
        float[] color = COLOR_VALID;
        if (gradientResult != null && gradientResult.getPrimaryPalette() != null) {
            PaletteData primaryPalette = gradientResult.getPrimaryPalette();
            ItemStack heldItem = WireframeRenderer.getHeldTrowel(player);
            TrowelData data = TrowelData.getOrCreate(heldItem);
            List<PaletteData> palettes = data.getPalettes();
            int paletteIndex = -1;
            for (int i = 0; i < palettes.size(); ++i) {
                if (palettes.get(i) != primaryPalette) continue;
                paletteIndex = i;
                break;
            }
            if (paletteIndex >= 0 && paletteIndex < PALETTE_COLORS.length) {
                int sectionColor = PALETTE_COLORS[paletteIndex];
                color = new float[]{(float)(sectionColor >> 16 & 0xFF) / 255.0f, (float)(sectionColor >> 8 & 0xFF) / 255.0f, (float)(sectionColor & 0xFF) / 255.0f};
            }
        }
        if (!isValid) {
            color = COLOR_INVALID;
        }
        float alpha = 0.5f;
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.lines());
        AABB aabb = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (AABB)aabb, (float)color[0], (float)color[1], (float)color[2], (float)alpha);
        bufferSource.endBatch();
        poseStack.popPose();
    }

    private static GradientData.GradientSection findSectionByPosition(TrowelData data, BlockPos pos, Player player) {
        GradientData gradientData = data.getGradientData();
        List<GradientData.GradientSection> sections = gradientData.getSections();
        if (sections.isEmpty()) {
            return null;
        }
        float position = GradientSelector.calculateGradientPosition(gradientData, pos, player);
        float currentPos = 0.0f;
        for (int i = 0; i < sections.size(); ++i) {
            GradientData.GradientSection section = sections.get(i);
            float sectionEnd = currentPos + section.getSize();
            if (position >= currentPos && position <= sectionEnd) {
                return section;
            }
            if (i < sections.size() - 1 && position > sectionEnd) {
                GradientData.GradientSection nextSection = sections.get(i + 1);
                float leftTransitionSize = section.getSize() * section.getRightTransitionPercent();
                float rightTransitionSize = nextSection.getSize() * nextSection.getLeftTransitionPercent();
                float transitionStart = sectionEnd - leftTransitionSize;
                float transitionEnd = sectionEnd + rightTransitionSize;
                if (position >= transitionStart && position <= transitionEnd) {
                    float transitionProgress = (position - transitionStart) / (transitionEnd - transitionStart);
                    return transitionProgress > 0.5f ? nextSection : section;
                }
            }
            currentPos = sectionEnd;
        }
        return sections.get(sections.size() - 1);
    }

    private static void renderGradientPointWireframes(PoseStack poseStack, TrowelData data, Player player) {
        double distanceSq;
        BlockPos endPos;
        double distanceSq2;
        if (!data.isGradientEnabled() || data.getGradientData().getSections().isEmpty() || data.isGradientConfirmed()) {
            return;
        }
        GradientData gradientData = data.getGradientData();
        GradientData.GradientPositionMode mode = gradientData.getPositionMode();
        if (mode != GradientData.GradientPositionMode.CLICK_POINTS && mode != GradientData.GradientPositionMode.ABSOLUTE) {
            return;
        }
        if (data.isGradientConfirmed()) {
            return;
        }
        BlockPos startPos = gradientData.getStartPos();
        if (startPos != null && (distanceSq2 = player.distanceToSqr((double)startPos.getX() + 0.5, (double)startPos.getY() + 0.5, (double)startPos.getZ() + 0.5)) <= 4096.0) {
            float[] greenColor = new float[]{0.0f, 1.0f, 0.0f};
            WireframeRenderer.renderGradientPoint(poseStack, startPos, greenColor, player);
        }
        if ((endPos = gradientData.getEndPos()) != null && (distanceSq = player.distanceToSqr((double)endPos.getX() + 0.5, (double)endPos.getY() + 0.5, (double)endPos.getZ() + 0.5)) <= 4096.0) {
            float[] redColor = new float[]{1.0f, 0.0f, 0.0f};
            WireframeRenderer.renderGradientPoint(poseStack, endPos, redColor, player);
        }
    }

    private static void renderGradientPoint(PoseStack poseStack, BlockPos pos, float[] color, Player player) {
        Minecraft mc = Minecraft.getInstance();
        Vec3 camPos = mc.gameRenderer.getMainCamera().getPosition();
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() - camPos.x, (double)pos.getY() - camPos.y, (double)pos.getZ() - camPos.z);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.lineWidth((float)2.0f);
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.lines());
        AABB aabb = new AABB(0.002, 0.002, 0.002, 0.998, 0.998, 0.998);
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (AABB)aabb, (float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        bufferSource.endBatch();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
        poseStack.popPose();
    }
}

