/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.compat.framedblocks;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;

public class FramedBlockConfig {
    private static final String TAG_CAMO = "Camo";
    private BlockState camo;

    public FramedBlockConfig() {
        this.camo = null;
    }

    public FramedBlockConfig(BlockState camo) {
        this.camo = camo;
    }

    public void load(CompoundTag tag) {
        if (tag.contains(TAG_CAMO)) {
            try {
                this.camo = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag.getCompound(TAG_CAMO));
            }
            catch (Exception e) {
                this.camo = null;
            }
        }
    }

    public void save(CompoundTag tag) {
        if (this.camo != null) {
            tag.put(TAG_CAMO, (Tag)NbtUtils.writeBlockState((BlockState)this.camo));
        }
    }

    public boolean isConfigured() {
        return this.camo != null;
    }

    public BlockState getCamo() {
        return this.camo;
    }

    public void setCamo(BlockState camo) {
        this.camo = camo;
    }

    public void clear() {
        this.camo = null;
    }
}

