/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class GradientData {
    public static final int MAX_SECTIONS = 10;
    public static final float MIN_SECTION_SIZE = 0.1f;
    private List<GradientSection> sections = new ArrayList<GradientSection>();
    private GradientAxis axis = GradientAxis.BOTH;
    private GradientPositionMode positionMode = GradientPositionMode.RELATIVE;
    private BlockPos startPos = null;
    private BlockPos endPos = null;
    private int relativeDistance = 10;
    public static final Codec<GradientData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GradientSection.CODEC.listOf().fieldOf("sections").forGetter(GradientData::getSections), (App)Codec.STRING.xmap(GradientAxis::valueOf, Enum::name).fieldOf("axis").forGetter(GradientData::getAxis), (App)Codec.STRING.xmap(GradientPositionMode::valueOf, Enum::name).fieldOf("position_mode").forGetter(GradientData::getPositionMode), (App)BlockPos.CODEC.optionalFieldOf("start_pos").forGetter(data -> Optional.ofNullable(data.getStartPos())), (App)BlockPos.CODEC.optionalFieldOf("end_pos").forGetter(data -> Optional.ofNullable(data.getEndPos())), (App)Codec.INT.fieldOf("relative_distance").forGetter(GradientData::getRelativeDistance)).apply((Applicative)instance, (sections, axis, positionMode, startPos, endPos, relativeDistance) -> {
        GradientData data = new GradientData();
        data.setSections((List<GradientSection>)sections);
        data.setAxis((GradientAxis)((Object)((Object)axis)));
        data.setPositionMode((GradientPositionMode)((Object)((Object)positionMode)));
        data.setStartPos(startPos.orElse(null));
        data.setEndPos(endPos.orElse(null));
        data.setRelativeDistance((int)relativeDistance);
        data.normalizeSections();
        return data;
    }));
    public static final StreamCodec<FriendlyByteBuf, GradientData> STREAM_CODEC = StreamCodec.composite((StreamCodec)GradientSection.STREAM_CODEC.apply(ByteBufCodecs.list()), GradientData::getSections, (StreamCodec)ByteBufCodecs.fromCodec((Codec)Codec.STRING.xmap(GradientAxis::valueOf, Enum::name)), GradientData::getAxis, (StreamCodec)ByteBufCodecs.fromCodec((Codec)Codec.STRING.xmap(GradientPositionMode::valueOf, Enum::name)), GradientData::getPositionMode, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), data -> Optional.ofNullable(data.getStartPos()), (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), data -> Optional.ofNullable(data.getEndPos()), (StreamCodec)ByteBufCodecs.VAR_INT, GradientData::getRelativeDistance, (sections, axis, positionMode, startPos, endPos, relativeDistance) -> {
        GradientData data = new GradientData();
        data.setSections((List<GradientSection>)sections);
        data.setAxis((GradientAxis)((Object)axis));
        data.setPositionMode((GradientPositionMode)((Object)positionMode));
        data.setStartPos(startPos.orElse(null));
        data.setEndPos(endPos.orElse(null));
        data.setRelativeDistance((int)relativeDistance);
        data.normalizeSections();
        return data;
    });

    public List<GradientSection> getSections() {
        return this.sections;
    }

    public void setSections(List<GradientSection> sections) {
        this.sections = sections;
    }

    public GradientAxis getAxis() {
        return this.axis;
    }

    public void setAxis(GradientAxis axis) {
        this.axis = axis;
    }

    public GradientPositionMode getPositionMode() {
        return this.positionMode;
    }

    public void setPositionMode(GradientPositionMode positionMode) {
        this.positionMode = positionMode;
    }

    public BlockPos getStartPos() {
        return this.startPos;
    }

    public void setStartPos(BlockPos startPos) {
        this.startPos = startPos;
    }

    public BlockPos getEndPos() {
        return this.endPos;
    }

    public void setEndPos(BlockPos endPos) {
        this.endPos = endPos;
    }

    public int getRelativeDistance() {
        return this.relativeDistance;
    }

    public void setRelativeDistance(int relativeDistance) {
        this.relativeDistance = relativeDistance;
    }

    public void normalizeSections() {
        block9: {
            float scaleFactor;
            block8: {
                if (this.sections.isEmpty()) {
                    return;
                }
                float total = 0.0f;
                for (GradientSection section : this.sections) {
                    total += section.getSize();
                }
                if (Math.abs(total - 1.0f) < 0.001f) {
                    return;
                }
                scaleFactor = 1.0f / total;
                boolean allAboveMin = true;
                for (GradientSection section : this.sections) {
                    if (!(section.getSize() * scaleFactor < 0.1f)) continue;
                    allAboveMin = false;
                    break;
                }
                if (!allAboveMin) break block8;
                for (GradientSection section : this.sections) {
                    section.setSize(section.getSize() * scaleFactor);
                }
                break block9;
            }
            float reservedForMins = 0.0f;
            float flexibleTotal = 0.0f;
            for (GradientSection section : this.sections) {
                if (section.getSize() * scaleFactor < 0.1f) {
                    section.setSize(0.1f);
                    reservedForMins += 0.1f;
                    continue;
                }
                flexibleTotal += section.getSize();
            }
            float remainingSpace = 1.0f - reservedForMins;
            if (!(flexibleTotal > 0.0f) || !(remainingSpace > 0.0f)) break block9;
            float flexibleScale = remainingSpace / flexibleTotal;
            for (GradientSection section : this.sections) {
                if (!(section.getSize() > 0.1f)) continue;
                section.setSize(section.getSize() * flexibleScale);
            }
        }
    }

    public static enum GradientAxis {
        HORIZONTAL,
        VERTICAL,
        BOTH;

    }

    public static enum GradientPositionMode {
        RELATIVE("Relative to Player"),
        ABSOLUTE("Absolute Coordinates"),
        CLICK_POINTS("Click Start/End Points");

        private final String displayName;

        private GradientPositionMode(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static class GradientSection {
        private int paletteIndex;
        private float size;
        private boolean smoothTransition;
        private float leftTransitionPercent;
        private float rightTransitionPercent;
        private int colorIndex;
        private int customColor;
        private boolean usingCustomColor;
        public static final Codec<GradientSection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("palette_index").forGetter(GradientSection::getPaletteIndex), (App)Codec.FLOAT.fieldOf("size").forGetter(GradientSection::getSize), (App)Codec.BOOL.fieldOf("smooth_transition").forGetter(GradientSection::isSmoothTransition), (App)Codec.FLOAT.fieldOf("left_transition_percent").forGetter(GradientSection::getLeftTransitionPercent), (App)Codec.FLOAT.fieldOf("right_transition_percent").forGetter(GradientSection::getRightTransitionPercent), (App)Codec.INT.fieldOf("color_index").orElse((Object)0).forGetter(GradientSection::getColorIndex), (App)Codec.INT.fieldOf("custom_color").orElse((Object)-1).forGetter(GradientSection::getCustomColor), (App)Codec.BOOL.fieldOf("using_custom_color").orElse((Object)false).forGetter(GradientSection::isUsingCustomColor)).apply((Applicative)instance, GradientSection::new));
        public static final StreamCodec<FriendlyByteBuf, GradientSection> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, GradientSection>(){

            public void encode(FriendlyByteBuf buffer, GradientSection section) {
                buffer.writeVarInt(section.getPaletteIndex());
                buffer.writeFloat(section.getSize());
                buffer.writeBoolean(section.isSmoothTransition());
                buffer.writeFloat(section.getLeftTransitionPercent());
                buffer.writeFloat(section.getRightTransitionPercent());
                buffer.writeVarInt(section.getColorIndex());
                buffer.writeInt(section.getCustomColor());
                buffer.writeBoolean(section.isUsingCustomColor());
            }

            public GradientSection decode(FriendlyByteBuf buffer) {
                return new GradientSection(buffer.readVarInt(), buffer.readFloat(), buffer.readBoolean(), buffer.readFloat(), buffer.readFloat(), buffer.readVarInt(), buffer.readInt(), buffer.readBoolean());
            }
        };

        public GradientSection() {
            this.paletteIndex = 0;
            this.size = 0.5f;
            this.smoothTransition = true;
            this.leftTransitionPercent = 0.25f;
            this.rightTransitionPercent = 0.25f;
            this.colorIndex = 0;
            this.customColor = -1;
            this.usingCustomColor = false;
        }

        public GradientSection(int paletteIndex, float size, boolean smoothTransition) {
            this.paletteIndex = paletteIndex;
            this.size = size;
            this.smoothTransition = smoothTransition;
            this.leftTransitionPercent = 0.25f;
            this.rightTransitionPercent = 0.25f;
            this.colorIndex = 0;
            this.customColor = -1;
            this.usingCustomColor = false;
        }

        public GradientSection(int paletteIndex, float size, boolean smoothTransition, float leftTransitionPercent, float rightTransitionPercent) {
            this.paletteIndex = paletteIndex;
            this.size = size;
            this.smoothTransition = smoothTransition;
            this.leftTransitionPercent = leftTransitionPercent;
            this.rightTransitionPercent = rightTransitionPercent;
            this.colorIndex = 0;
            this.customColor = -1;
            this.usingCustomColor = false;
        }

        public GradientSection(int paletteIndex, float size, boolean smoothTransition, float leftTransitionPercent, float rightTransitionPercent, int colorIndex) {
            this.paletteIndex = paletteIndex;
            this.size = size;
            this.smoothTransition = smoothTransition;
            this.leftTransitionPercent = leftTransitionPercent;
            this.rightTransitionPercent = rightTransitionPercent;
            this.colorIndex = colorIndex;
            this.customColor = -1;
            this.usingCustomColor = false;
        }

        public GradientSection(int paletteIndex, float size, boolean smoothTransition, float leftTransitionPercent, float rightTransitionPercent, int colorIndex, int customColor, boolean usingCustomColor) {
            this.paletteIndex = paletteIndex;
            this.size = size;
            this.smoothTransition = smoothTransition;
            this.leftTransitionPercent = leftTransitionPercent;
            this.rightTransitionPercent = rightTransitionPercent;
            this.colorIndex = colorIndex;
            this.customColor = customColor;
            this.usingCustomColor = usingCustomColor;
        }

        public int getPaletteIndex() {
            return this.paletteIndex;
        }

        public void setPaletteIndex(int paletteIndex) {
            this.paletteIndex = paletteIndex;
        }

        public float getSize() {
            return this.size;
        }

        public void setSize(float size) {
            this.size = Math.max(0.0f, Math.min(1.0f, size));
        }

        public boolean isSmoothTransition() {
            return this.smoothTransition;
        }

        public void setSmoothTransition(boolean smoothTransition) {
            this.smoothTransition = smoothTransition;
        }

        public float getLeftTransitionPercent() {
            return this.leftTransitionPercent;
        }

        public void setLeftTransitionPercent(float leftTransitionPercent) {
            this.leftTransitionPercent = Math.max(0.0f, Math.min(1.0f, leftTransitionPercent));
        }

        public float getRightTransitionPercent() {
            return this.rightTransitionPercent;
        }

        public void setRightTransitionPercent(float rightTransitionPercent) {
            this.rightTransitionPercent = Math.max(0.0f, Math.min(1.0f, rightTransitionPercent));
        }

        public int getColorIndex() {
            return this.colorIndex;
        }

        public void setColorIndex(int colorIndex) {
            this.colorIndex = Math.max(0, Math.min(colorIndex, 12));
        }

        public int getCustomColor() {
            return this.customColor;
        }

        public void setCustomColor(int customColor) {
            this.customColor = customColor;
        }

        public boolean isUsingCustomColor() {
            return this.usingCustomColor;
        }

        public void setUsingCustomColor(boolean usingCustomColor) {
            this.usingCustomColor = usingCustomColor;
        }
    }
}

