/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui.widget;

import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

public class GhostSlot
extends Slot {
    public GhostSlot(Container container, int index, int x, int y) {
        super(container, index, x, y);
    }

    public boolean mayPlace(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem() instanceof BlockItem;
    }

    public boolean mayPickup(Player player) {
        return false;
    }

    public ItemStack remove(int amount) {
        this.set(ItemStack.EMPTY);
        return ItemStack.EMPTY;
    }

    public void onTake(Player player, ItemStack stack) {
        this.set(ItemStack.EMPTY);
    }

    public void setByPlayer(ItemStack stack, ItemStack oldStack) {
        if (!stack.isEmpty() && this.mayPlace(stack)) {
            ItemStack ghostStack = stack.copy();
            ghostStack.setCount(1);
            this.set(ghostStack);
        }
    }

    public ItemStack safeInsert(ItemStack stack, int count) {
        if (!stack.isEmpty() && this.mayPlace(stack)) {
            ItemStack ghostStack = stack.copy();
            ghostStack.setCount(1);
            this.set(ghostStack);
        }
        return stack;
    }

    public ItemStack safeTake(int min, int max, Player player) {
        this.set(ItemStack.EMPTY);
        return ItemStack.EMPTY;
    }

    public Optional<ItemStack> tryRemove(int count, int decrement, Player player) {
        return Optional.empty();
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public boolean allowModification(Player player) {
        return true;
    }
}

