/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class NoFocusButton
extends Button {
    private NoFocusButton(int x, int y, int width, int height, Component text, Button.OnPress onPress) {
        super(x, y, width, height, text, onPress, DEFAULT_NARRATION);
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean originalFocused = this.isFocused();
        this.setFocused(false);
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        this.setFocused(originalFocused);
    }

    public static NoFocusBuilder noFocusBuilder(Component text, Button.OnPress onPress) {
        return new NoFocusBuilder(text, onPress);
    }

    public static class NoFocusBuilder {
        private final Component text;
        private final Button.OnPress onPress;
        private int x = 0;
        private int y = 0;
        private int width = 150;
        private int height = 20;
        private Tooltip tooltip;

        public NoFocusBuilder(Component text, Button.OnPress onPress) {
            this.text = text;
            this.onPress = onPress;
        }

        public NoFocusBuilder bounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            return this;
        }

        public NoFocusBuilder tooltip(Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public NoFocusButton build() {
            NoFocusButton button = new NoFocusButton(this.x, this.y, this.width, this.height, this.text, this.onPress);
            if (this.tooltip != null) {
                button.setTooltip(this.tooltip);
            }
            return button;
        }
    }
}

