/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.data.GradientData;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.util.ReplaceSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class WandModeHelper {
    public static List<BlockPos> findConnectedPositionsGradient(Level level, BlockPos clickedPos, GradientData gradientData, List<PaletteData> palettes, Direction clickedFace, Player player, int maxBlocks) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        HashSet<BlockPos> visitedBlocks = new HashSet<BlockPos>();
        LinkedList<BlockPos> toProcess = new LinkedList<BlockPos>();
        BlockState clickedState = level.getBlockState(clickedPos);
        Set<Integer> relevantPaletteIndices = WandModeHelper.getRelevantPaletteIndices(gradientData, clickedPos, player);
        boolean foundInGradient = false;
        for (int paletteIndex : relevantPaletteIndices) {
            PaletteData palette;
            if (paletteIndex < 0 || paletteIndex >= palettes.size() || !WandModeHelper.isBlockInPalette(clickedState, palette = palettes.get(paletteIndex))) continue;
            foundInGradient = true;
            break;
        }
        if (!foundInGradient) {
            return result;
        }
        BlockPos startPos = clickedPos.relative(clickedFace);
        if (!WandModeHelper.canPlaceAt(level, startPos)) {
            return result;
        }
        BlockPos[] offsetsToCheck = WandModeHelper.getOffsetsForPlane(clickedFace);
        toProcess.offer(clickedPos);
        visitedBlocks.add(clickedPos);
        int iterations = 0;
        int MAX_ITERATIONS = 10000;
        while (!toProcess.isEmpty() && result.size() < maxBlocks) {
            if (++iterations > 10000) {
                MechTrowel.LOGGER.error("[WAND] SAFETY BREAK: Exceeded max iterations ({}) in gradient detection!", (Object)10000);
                break;
            }
            BlockPos currentPos = (BlockPos)toProcess.poll();
            BlockPos placePos = currentPos.relative(clickedFace);
            if (WandModeHelper.canPlaceAt(level, placePos) && WandModeHelper.isWithinRange(startPos, placePos, MechTrowel.Config.getWandMaxRange()) && !result.contains(placePos)) {
                result.add(placePos);
                if (result.size() >= maxBlocks) break;
            }
            for (BlockPos offset : offsetsToCheck) {
                BlockPos potentialPlacePos;
                BlockPos adjacentPos = currentPos.offset((Vec3i)offset);
                if (visitedBlocks.contains(adjacentPos)) continue;
                visitedBlocks.add(adjacentPos);
                BlockState adjacentState = level.getBlockState(adjacentPos);
                boolean adjacentInGradient = false;
                for (int paletteIndex : relevantPaletteIndices) {
                    PaletteData palette;
                    if (paletteIndex < 0 || paletteIndex >= palettes.size() || !WandModeHelper.isBlockInPalette(adjacentState, palette = palettes.get(paletteIndex))) continue;
                    adjacentInGradient = true;
                    break;
                }
                if (!adjacentInGradient || !WandModeHelper.isWithinRange(startPos, potentialPlacePos = adjacentPos.relative(clickedFace), MechTrowel.Config.getWandMaxRange()) || !WandModeHelper.canPlaceAt(level, potentialPlacePos)) continue;
                toProcess.offer(adjacentPos);
            }
        }
        Vec3 clickOrigin = Vec3.atCenterOf((Vec3i)startPos);
        result.sort((a, b) -> {
            double distA = Vec3.atCenterOf((Vec3i)a).distanceToSqr(clickOrigin);
            double distB = Vec3.atCenterOf((Vec3i)b).distanceToSqr(clickOrigin);
            return Double.compare(distA, distB);
        });
        return result;
    }

    public static List<BlockPos> findConnectedPositionsGradientReplace(Level level, BlockPos clickedPos, GradientData gradientData, List<PaletteData> palettes, ItemStack offhandItem, Direction clickedFace, Player player, int maxBlocks) {
        Item item;
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        HashSet<BlockPos> visitedBlocks = new HashSet<BlockPos>();
        LinkedList<BlockPos> toProcess = new LinkedList<BlockPos>();
        BlockState clickedState = level.getBlockState(clickedPos);
        if (clickedState.isAir()) {
            return result;
        }
        boolean shouldReplace = false;
        if (!offhandItem.isEmpty() && (item = offhandItem.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block offhandBlock = blockItem.getBlock();
            shouldReplace = clickedState.getBlock() == offhandBlock;
        } else {
            Set<Integer> relevantPaletteIndices = WandModeHelper.getRelevantPaletteIndices(gradientData, clickedPos, player);
            for (int paletteIndex : relevantPaletteIndices) {
                PaletteData palette;
                if (paletteIndex < 0 || paletteIndex >= palettes.size() || !WandModeHelper.isBlockInPalette(clickedState, palette = palettes.get(paletteIndex))) continue;
                shouldReplace = true;
                break;
            }
        }
        if (!shouldReplace) {
            return result;
        }
        BlockPos[] offsetsToCheck = WandModeHelper.getOffsetsForPlane(clickedFace);
        toProcess.offer(clickedPos);
        visitedBlocks.add(clickedPos);
        int iterations = 0;
        int MAX_ITERATIONS = 10000;
        while (!toProcess.isEmpty() && result.size() < maxBlocks) {
            Item item2;
            if (++iterations > 10000) {
                MechTrowel.LOGGER.error("[WAND] SAFETY BREAK: Exceeded max iterations ({}) in gradient replace detection!", (Object)10000);
                break;
            }
            BlockPos currentPos = (BlockPos)toProcess.poll();
            BlockState currentState = level.getBlockState(currentPos);
            boolean replaceThis = false;
            if (!offhandItem.isEmpty() && (item2 = offhandItem.getItem()) instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item2;
                replaceThis = currentState.getBlock() == blockItem.getBlock();
            } else {
                Set<Integer> currentRelevantPalettes = WandModeHelper.getRelevantPaletteIndices(gradientData, currentPos, player);
                for (int paletteIndex : currentRelevantPalettes) {
                    PaletteData palette;
                    if (paletteIndex < 0 || paletteIndex >= palettes.size() || !WandModeHelper.isBlockInPalette(currentState, palette = palettes.get(paletteIndex))) continue;
                    replaceThis = true;
                    break;
                }
            }
            if (replaceThis && ReplaceSystem.canReplaceBlock(level, currentPos, currentState, player)) {
                result.add(currentPos);
            }
            for (BlockPos offset : offsetsToCheck) {
                Item item3;
                BlockPos adjacentPos = currentPos.offset((Vec3i)offset);
                if (visitedBlocks.contains(adjacentPos) || !WandModeHelper.isWithinRange(clickedPos, adjacentPos, MechTrowel.Config.getWandMaxRange())) continue;
                visitedBlocks.add(adjacentPos);
                BlockState adjacentState = level.getBlockState(adjacentPos);
                boolean shouldCheck = false;
                if (!offhandItem.isEmpty() && (item3 = offhandItem.getItem()) instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item3;
                    shouldCheck = adjacentState.getBlock() == blockItem.getBlock();
                } else {
                    Set<Integer> adjacentRelevantPalettes = WandModeHelper.getRelevantPaletteIndices(gradientData, adjacentPos, player);
                    for (int paletteIndex : adjacentRelevantPalettes) {
                        PaletteData palette;
                        if (paletteIndex < 0 || paletteIndex >= palettes.size() || !WandModeHelper.isBlockInPalette(adjacentState, palette = palettes.get(paletteIndex))) continue;
                        shouldCheck = true;
                        break;
                    }
                }
                if (!shouldCheck) continue;
                toProcess.offer(adjacentPos);
            }
        }
        Vec3 clickOrigin = Vec3.atCenterOf((Vec3i)clickedPos);
        result.sort((a, b) -> {
            double distA = Vec3.atCenterOf((Vec3i)a).distanceToSqr(clickOrigin);
            double distB = Vec3.atCenterOf((Vec3i)b).distanceToSqr(clickOrigin);
            return Double.compare(distA, distB);
        });
        return result;
    }

    public static List<BlockPos> findConnectedPositionsGradientWithOffhand(Level level, BlockPos clickedPos, ItemStack offhandStack, Direction clickedFace, Player player, int maxBlocks) {
        return WandModeHelper.findConnectedPositionsWithOffhand(level, clickedPos, offhandStack, clickedFace, player, maxBlocks);
    }

    public static List<BlockPos> findConnectedPositions(Level level, BlockPos clickedPos, PaletteData palette, Direction clickedFace, Player player, int maxBlocks) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        HashSet<BlockPos> visitedBlocks = new HashSet<BlockPos>();
        LinkedList<BlockPos> toProcess = new LinkedList<BlockPos>();
        BlockState clickedState = level.getBlockState(clickedPos);
        if (!WandModeHelper.isBlockInPalette(clickedState, palette)) {
            return result;
        }
        BlockPos startPos = clickedPos.relative(clickedFace);
        if (!WandModeHelper.canPlaceAt(level, startPos)) {
            return result;
        }
        boolean isHorizontalPlane = clickedFace.getAxis() == Direction.Axis.Y;
        BlockPos[] offsetsToCheck = WandModeHelper.getOffsetsForPlane(clickedFace);
        toProcess.offer(clickedPos);
        visitedBlocks.add(clickedPos);
        int iterations = 0;
        int MAX_ITERATIONS = 10000;
        while (!toProcess.isEmpty() && result.size() < maxBlocks) {
            if (++iterations > 10000) {
                MechTrowel.LOGGER.error("[WAND] SAFETY BREAK: Exceeded max iterations ({}) in palette detection!", (Object)10000);
                break;
            }
            BlockPos currentPos = (BlockPos)toProcess.poll();
            BlockPos placePos = currentPos.relative(clickedFace);
            if (WandModeHelper.canPlaceAt(level, placePos) && WandModeHelper.isWithinRange(startPos, placePos, MechTrowel.Config.getWandMaxRange()) && !result.contains(placePos)) {
                result.add(placePos);
                if (result.size() >= maxBlocks) break;
            }
            for (BlockPos offset : offsetsToCheck) {
                BlockPos potentialPlacePos;
                BlockPos adjacentPos = currentPos.offset((Vec3i)offset);
                if (visitedBlocks.contains(adjacentPos)) continue;
                visitedBlocks.add(adjacentPos);
                BlockState adjacentState = level.getBlockState(adjacentPos);
                if (!WandModeHelper.isBlockInPalette(adjacentState, palette) || !WandModeHelper.isWithinRange(startPos, potentialPlacePos = adjacentPos.relative(clickedFace), MechTrowel.Config.getWandMaxRange()) || !WandModeHelper.canPlaceAt(level, potentialPlacePos)) continue;
                toProcess.offer(adjacentPos);
            }
        }
        Vec3 clickOrigin = Vec3.atCenterOf((Vec3i)startPos);
        result.sort((a, b) -> {
            double distA = Vec3.atCenterOf((Vec3i)a).distanceToSqr(clickOrigin);
            double distB = Vec3.atCenterOf((Vec3i)b).distanceToSqr(clickOrigin);
            return Double.compare(distA, distB);
        });
        return result;
    }

    public static List<BlockPos> findConnectedPositionsWithOffhand(Level level, BlockPos clickedPos, ItemStack offhandStack, Direction clickedFace, Player player, int maxBlocks) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (offhandStack.isEmpty() || !(offhandStack.getItem() instanceof BlockItem)) {
            return result;
        }
        BlockItem blockItem = (BlockItem)offhandStack.getItem();
        Block targetBlock = blockItem.getBlock();
        HashSet<BlockPos> visitedBlocks = new HashSet<BlockPos>();
        LinkedList<BlockPos> toProcess = new LinkedList<BlockPos>();
        BlockState clickedState = level.getBlockState(clickedPos);
        if (clickedState.getBlock() != targetBlock) {
            return result;
        }
        BlockPos startPos = clickedPos.relative(clickedFace);
        if (!WandModeHelper.canPlaceAt(level, startPos)) {
            return result;
        }
        BlockPos[] offsetsToCheck = WandModeHelper.getOffsetsForPlane(clickedFace);
        toProcess.offer(clickedPos);
        visitedBlocks.add(clickedPos);
        int iterations = 0;
        int MAX_ITERATIONS = 10000;
        while (!toProcess.isEmpty() && result.size() < maxBlocks) {
            if (++iterations > 10000) {
                MechTrowel.LOGGER.error("[WAND] SAFETY BREAK: Exceeded max iterations ({}) in offhand detection!", (Object)10000);
                break;
            }
            BlockPos currentPos = (BlockPos)toProcess.poll();
            BlockPos placePos = currentPos.relative(clickedFace);
            if (WandModeHelper.canPlaceAt(level, placePos) && WandModeHelper.isWithinRange(startPos, placePos, MechTrowel.Config.getWandMaxRange()) && !result.contains(placePos)) {
                result.add(placePos);
                if (result.size() >= maxBlocks) break;
            }
            for (BlockPos offset : offsetsToCheck) {
                BlockPos potentialPlacePos;
                BlockPos adjacentPos = currentPos.offset((Vec3i)offset);
                if (visitedBlocks.contains(adjacentPos)) continue;
                visitedBlocks.add(adjacentPos);
                BlockState adjacentState = level.getBlockState(adjacentPos);
                if (adjacentState.getBlock() != targetBlock || !WandModeHelper.isWithinRange(startPos, potentialPlacePos = adjacentPos.relative(clickedFace), MechTrowel.Config.getWandMaxRange()) || !WandModeHelper.canPlaceAt(level, potentialPlacePos)) continue;
                toProcess.offer(adjacentPos);
            }
        }
        Vec3 clickOrigin = Vec3.atCenterOf((Vec3i)startPos);
        result.sort((a, b) -> {
            double distA = Vec3.atCenterOf((Vec3i)a).distanceToSqr(clickOrigin);
            double distB = Vec3.atCenterOf((Vec3i)b).distanceToSqr(clickOrigin);
            return Double.compare(distA, distB);
        });
        return result;
    }

    private static Set<Integer> getRelevantPaletteIndices(GradientData gradientData, BlockPos clickedPos, Player player) {
        HashSet<Integer> indices = new HashSet<Integer>();
        if (gradientData.getSections().isEmpty()) {
            return indices;
        }
        HashSet<Integer> uniquePalettes = new HashSet<Integer>();
        for (GradientData.GradientSection section : gradientData.getSections()) {
            uniquePalettes.add(section.getPaletteIndex());
            if (uniquePalettes.size() < 3) continue;
            break;
        }
        return uniquePalettes;
    }

    private static boolean isBlockInPalette(BlockState state, PaletteData palette) {
        if (palette == null || palette.isEmpty()) {
            return false;
        }
        Block block = state.getBlock();
        for (PaletteData.WeightedBlock weightedBlock : palette.getBlocks()) {
            if (weightedBlock.getState().getBlock() != block) continue;
            return true;
        }
        return false;
    }

    private static boolean isSameBlock(BlockState state1, BlockState state2) {
        return state1.getBlock() == state2.getBlock();
    }

    private static boolean canPlaceAt(Level level, BlockPos pos) {
        BlockState currentState = level.getBlockState(pos);
        return currentState.canBeReplaced();
    }

    private static boolean isWithinRange(BlockPos origin, BlockPos target, int maxRange) {
        return origin.distSqr((Vec3i)target) <= (double)(maxRange * maxRange);
    }

    private static BlockPos[] getOffsetsForPlane(Direction clickedFace) {
        switch (clickedFace) {
            case UP: 
            case DOWN: {
                return new BlockPos[]{new BlockPos(0, 0, -1), new BlockPos(0, 0, 1), new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0), new BlockPos(-1, 0, -1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(1, 0, 1)};
            }
            case NORTH: 
            case SOUTH: {
                return new BlockPos[]{new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0), new BlockPos(-1, 1, 0), new BlockPos(1, 1, 0), new BlockPos(-1, -1, 0), new BlockPos(1, -1, 0)};
            }
            case EAST: 
            case WEST: {
                return new BlockPos[]{new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(0, 0, -1), new BlockPos(0, 0, 1), new BlockPos(0, 1, -1), new BlockPos(0, 1, 1), new BlockPos(0, -1, -1), new BlockPos(0, -1, 1)};
            }
        }
        return new BlockPos[]{new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(0, 0, -1), new BlockPos(0, 0, 1), new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0)};
    }

    public static List<BlockPos> findConnectedPositionsForReplace(Level level, BlockPos clickedPos, PaletteData palette, ItemStack offhandItem, Direction clickedFace, Player player, int maxBlocks) {
        Item item;
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        HashSet<BlockPos> visitedBlocks = new HashSet<BlockPos>();
        LinkedList<BlockPos> toProcess = new LinkedList<BlockPos>();
        BlockState clickedState = level.getBlockState(clickedPos);
        if (clickedState.isAir()) {
            return result;
        }
        boolean shouldReplace = false;
        if (!offhandItem.isEmpty() && (item = offhandItem.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block offhandBlock = blockItem.getBlock();
            shouldReplace = clickedState.getBlock() == offhandBlock;
        } else if (palette != null && !palette.isEmpty()) {
            shouldReplace = WandModeHelper.isBlockInPalette(clickedState, palette);
        }
        if (!shouldReplace) {
            return result;
        }
        BlockPos[] offsetsToCheck = WandModeHelper.getOffsetsForPlane(clickedFace);
        toProcess.offer(clickedPos);
        visitedBlocks.add(clickedPos);
        int iterations = 0;
        int MAX_ITERATIONS = 10000;
        while (!toProcess.isEmpty() && result.size() < maxBlocks) {
            Item item2;
            if (++iterations > 10000) {
                MechTrowel.LOGGER.error("[WAND] SAFETY BREAK: Exceeded max iterations ({}) in replace detection!", (Object)10000);
                break;
            }
            BlockPos currentPos = (BlockPos)toProcess.poll();
            BlockState currentState = level.getBlockState(currentPos);
            boolean replaceThis = false;
            if (!offhandItem.isEmpty() && (item2 = offhandItem.getItem()) instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item2;
                replaceThis = currentState.getBlock() == blockItem.getBlock();
            } else if (palette != null) {
                replaceThis = WandModeHelper.isBlockInPalette(currentState, palette);
            }
            if (replaceThis && ReplaceSystem.canReplaceBlock(level, currentPos, currentState, player)) {
                result.add(currentPos);
            }
            for (BlockPos offset : offsetsToCheck) {
                Item item3;
                BlockPos adjacentPos = currentPos.offset((Vec3i)offset);
                if (visitedBlocks.contains(adjacentPos) || !WandModeHelper.isWithinRange(clickedPos, adjacentPos, MechTrowel.Config.getWandMaxRange())) continue;
                visitedBlocks.add(adjacentPos);
                BlockState adjacentState = level.getBlockState(adjacentPos);
                boolean shouldCheck = false;
                if (!offhandItem.isEmpty() && (item3 = offhandItem.getItem()) instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item3;
                    shouldCheck = adjacentState.getBlock() == blockItem.getBlock();
                } else if (palette != null) {
                    shouldCheck = WandModeHelper.isBlockInPalette(adjacentState, palette);
                }
                if (!shouldCheck) continue;
                toProcess.offer(adjacentPos);
            }
        }
        Vec3 clickOrigin = Vec3.atCenterOf((Vec3i)clickedPos);
        result.sort((a, b) -> {
            double distA = Vec3.atCenterOf((Vec3i)a).distanceToSqr(clickOrigin);
            double distB = Vec3.atCenterOf((Vec3i)b).distanceToSqr(clickOrigin);
            return Double.compare(distA, distB);
        });
        return result;
    }
}

