/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel;

import com.asger.mechtrowel.client.KeyBindings;
import com.asger.mechtrowel.compat.jei.JeiCompat;
import com.asger.mechtrowel.network.ModNetwork;
import com.asger.mechtrowel.registry.ModConditions;
import com.asger.mechtrowel.registry.ModRegistry;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.slf4j.Logger;

@Mod(value="mechtrowel")
public class MechTrowel {
    public static final String MOD_ID = "mechtrowel";
    public static final Logger LOGGER = LogUtils.getLogger();

    public MechTrowel(IEventBus modEventBus, ModContainer modContainer) {
        LOGGER.info("Initializing MechTrowel mod");
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        ModRegistry.init(modEventBus);
        ModConditions.register(modEventBus);
        ModNetwork.init();
        modEventBus.addListener(ModNetwork::registerPayloads);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(this::onRegisterKeyMappings);
        }
        JeiCompat.init();
    }

    private void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        LOGGER.debug("Registering key mappings");
        KeyBindings.register(event);
    }

    public static class Config {
        private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
        private static final ModConfigSpec.BooleanValue REPLACE_MODE_ENABLED = BUILDER.comment("Enable replace mode functionality").define("replaceModeEnabled", true);
        private static final ModConfigSpec.IntValue MAX_PALETTES = BUILDER.comment("Maximum number of palettes that can be stored (will be rounded to nearest multiple of 7)").defineInRange("maxPalettes", 28, 7, 70);
        private static final ModConfigSpec.IntValue WAND_MAX_BLOCKS = BUILDER.comment("Maximum number of blocks that can be placed in one wand mode action as default").defineInRange("wandMaxBlocks", 64, 1, 256);
        private static final ModConfigSpec.IntValue WAND_MAX_RANGE = BUILDER.comment("Maximum range from clicked block for wand mode").defineInRange("wandMaxRange", 64, 2, 256);
        private static final ModConfigSpec.BooleanValue WAND_UPGRADE_ENABLED = BUILDER.comment("Enable wand upgrade functionality").define("wandUpgradeEnabled", true);
        private static final ModConfigSpec.BooleanValue WAND_CAPACITY_UPGRADE_ENABLED = BUILDER.comment("Enable wand capacity upgrade functionality").define("wandCapacityUpgradeEnabled", true);
        private static final ModConfigSpec.BooleanValue WAND_MODE_WITHOUT_UPGRADE = BUILDER.comment("Allow wand mode without requiring upgrade item (default: false)").define("wandModeWithoutUpgrade", false);
        private static final ModConfigSpec.ConfigValue<List<? extends String>> REPLACE_BLACKLIST_BLOCKS = BUILDER.comment("List of blocks that cannot be replaced (e.g., 'minecraft:bedrock')").defineList("replaceBlacklistBlocks", List.of("minecraft:bedrock", "minecraft:end_portal", "minecraft:command_block", "minecraft:barrier"), obj -> obj instanceof String);
        private static final ModConfigSpec.ConfigValue<List<? extends String>> REPLACE_BLACKLIST_TAGS = BUILDER.comment("List of block tags that cannot be replaced (e.g., '#minecraft:wither_immune')").defineList("replaceBlacklistTags", List.of("#minecraft:wither_immune"), obj -> obj instanceof String && ((String)obj).startsWith("#"));
        private static final ModConfigSpec.BooleanValue CHIPPED_CONVERSION_UPGRADE_ENABLED = BUILDER.comment("Enable Chipped block auto-conversion upgrade functionality").define("chippedConversionUpgradeEnabled", true);
        static final ModConfigSpec SPEC = BUILDER.build();

        public static int getMaxPalettes() {
            int configValue = (Integer)MAX_PALETTES.get();
            int rounded = Math.round((float)configValue / 7.0f) * 7;
            return Math.max(7, Math.min(70, rounded));
        }

        public static boolean isReplaceModeEnabled() {
            return (Boolean)REPLACE_MODE_ENABLED.get();
        }

        public static List<? extends String> getReplaceBlacklistBlocks() {
            return (List)REPLACE_BLACKLIST_BLOCKS.get();
        }

        public static List<? extends String> getReplaceBlacklistTags() {
            return (List)REPLACE_BLACKLIST_TAGS.get();
        }

        public static int getWandMaxBlocks() {
            return (Integer)WAND_MAX_BLOCKS.get();
        }

        public static int getWandMaxRange() {
            return (Integer)WAND_MAX_RANGE.get();
        }

        public static boolean isWandUpgradeEnabled() {
            return (Boolean)WAND_UPGRADE_ENABLED.get();
        }

        public static boolean isWandCapacityUpgradeEnabled() {
            return (Boolean)WAND_CAPACITY_UPGRADE_ENABLED.get();
        }

        public static boolean isWandModeWithoutUpgrade() {
            return (Boolean)WAND_MODE_WITHOUT_UPGRADE.get();
        }

        public static boolean isChippedConversionUpgradeEnabled() {
            return (Boolean)CHIPPED_CONVERSION_UPGRADE_ENABLED.get();
        }
    }
}

