/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.client;

import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.network.TrowelPacket;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4f;

public class RadialMenuScreen
extends Screen {
    private static final int PALETTES_PER_PAGE = 8;
    private static final float BASE_INNER_RADIUS = 60.0f;
    private static final float BASE_OUTER_RADIUS = 160.0f;
    private static final float BASE_CENTER_RADIUS = 45.0f;
    private static final int SEGMENTS = 64;
    private float innerRadius;
    private float outerRadius;
    private float centerRadius;
    private float scaleFactor = 1.0f;
    private boolean isCompactMode = false;
    private final TrowelData trowelData;
    private final List<PaletteData> sortedPalettes;
    private int currentPage = 0;
    private int totalPages;
    private int hoveredIndex = -1;
    private long openTime;
    private float animationProgress = 0.0f;
    private boolean isClosing = false;
    private final float[] segmentHoverProgress;
    private long lastFrameTime;
    private final List<SegmentInfo> segments = new ArrayList<SegmentInfo>();
    private static final int BACKGROUND_COLOR = -1442840576;
    private static final int SEGMENT_COLOR = 0x33FFFFFF;
    private static final int SEGMENT_HOVER_COLOR = 0x66FFFFFF;
    private static final int SEGMENT_ACTIVE_COLOR = -1711276033;
    private static final int CENTER_COLOR = 0x44FFFFFF;
    private static final int TEXT_COLOR = -1;
    private static final int DIVIDER_COLOR = 0x77FFFFFF;
    private static final int GLASS_BORDER_COLOR = -1426063361;

    public RadialMenuScreen(TrowelData trowelData) {
        super((Component)Component.literal((String)"Radial Menu"));
        this.trowelData = trowelData;
        this.sortedPalettes = new ArrayList<PaletteData>(trowelData.getPalettes());
        this.sortedPalettes.sort(Comparator.comparingLong(PaletteData::getLastUsedTime).reversed());
        this.totalPages = (int)Math.ceil((double)this.sortedPalettes.size() / 8.0);
        if (this.totalPages == 0) {
            this.totalPages = 1;
        }
        this.segmentHoverProgress = new float[8];
        this.currentPage = 0;
        this.openTime = System.currentTimeMillis();
        this.lastFrameTime = System.nanoTime();
    }

    protected void init() {
        super.init();
        int screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        if (screenHeight <= 270) {
            this.isCompactMode = true;
            this.scaleFactor = 0.7f;
        } else {
            this.isCompactMode = false;
            this.scaleFactor = 1.0f;
        }
        this.innerRadius = 60.0f * this.scaleFactor;
        this.outerRadius = 160.0f * this.scaleFactor;
        this.centerRadius = 45.0f * this.scaleFactor;
        this.currentPage = Math.max(0, Math.min(this.currentPage, this.totalPages - 1));
        this.segments.clear();
        int startIdx = this.currentPage * 8;
        int endIdx = Math.min(startIdx + 8, this.sortedPalettes.size());
        int segmentCount = Math.max(0, endIdx - startIdx);
        if (segmentCount > 0) {
            float angleStep = 45.0f;
            float startAngle = -90.0f - angleStep / 2.0f;
            for (int i = 0; i < 8; ++i) {
                float segStart;
                float segEnd = segStart + angleStep;
                for (segStart = startAngle + (float)i * angleStep; segStart < 0.0f; segStart += 360.0f) {
                }
                while (segEnd < 0.0f) {
                    segEnd += 360.0f;
                }
                while (segStart >= 360.0f) {
                    segStart -= 360.0f;
                }
                while (segEnd >= 360.0f) {
                    segEnd -= 360.0f;
                }
                this.segments.add(new SegmentInfo(segStart, segEnd, i));
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isClosing) {
            return;
        }
        long currentTime = System.nanoTime();
        float deltaTime = (float)(currentTime - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = currentTime;
        this.animationProgress = Math.min(1.0f, (float)(System.currentTimeMillis() - this.openTime) / 200.0f);
        float easedProgress = this.easeOutQuart(this.animationProgress);
        this.drawVignetteBackground(graphics);
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        this.hoveredIndex = -1;
        for (SegmentInfo segment : this.segments) {
            if (!segment.contains(mouseX, mouseY, centerX, centerY, this.innerRadius, this.outerRadius)) continue;
            this.hoveredIndex = segment.index;
            break;
        }
        for (int i = 0; i < this.segmentHoverProgress.length; ++i) {
            float target = i == this.hoveredIndex ? 1.0f : 0.0f;
            this.segmentHoverProgress[i] = Mth.lerp((float)(deltaTime * 10.0f), (float)this.segmentHoverProgress[i], (float)target);
        }
        int startIdx = this.currentPage * 8;
        for (int i = 0; i < this.segments.size(); ++i) {
            SegmentInfo segment = this.segments.get(i);
            int paletteIdx = startIdx + i;
            if (paletteIdx < this.sortedPalettes.size()) {
                float normalizedStart;
                PaletteData palette = this.sortedPalettes.get(paletteIdx);
                boolean isActive = this.trowelData.getActivePalette() == palette;
                float innerR = this.innerRadius * easedProgress;
                float outerR = this.outerRadius * easedProgress;
                float hoverOffset = this.segmentHoverProgress[i] * 15.0f;
                this.drawSegment(graphics, centerX, centerY, innerR, outerR + hoverOffset, segment.startAngle, segment.endAngle, this.getSegmentColor(isActive, i == this.hoveredIndex, this.segmentHoverProgress[i]), easedProgress);
                if (!(this.animationProgress > 0.3f)) continue;
                float contentAlpha = (this.animationProgress - 0.3f) / 0.7f;
                float normalizedEnd = segment.endAngle;
                for (normalizedStart = segment.startAngle; normalizedStart < 0.0f; normalizedStart += 360.0f) {
                }
                while (normalizedEnd < 0.0f) {
                    normalizedEnd += 360.0f;
                }
                while (normalizedStart >= 360.0f) {
                    normalizedStart -= 360.0f;
                }
                while (normalizedEnd >= 360.0f) {
                    normalizedEnd -= 360.0f;
                }
                this.drawSegmentContent(graphics, palette, centerX, centerY, normalizedStart, normalizedEnd, contentAlpha);
                continue;
            }
            float innerR = this.innerRadius * easedProgress;
            float outerR = this.outerRadius * easedProgress;
            this.drawSegment(graphics, centerX, centerY, innerR, outerR, segment.startAngle, segment.endAngle, 0x1AFFFFFF, easedProgress);
        }
        this.drawCenterCircle(graphics, centerX, centerY, easedProgress);
        if (this.totalPages > 1 && this.animationProgress > 0.5f) {
            this.drawPageIndicator(graphics, centerX, centerY);
        }
    }

    private void drawVignetteBackground(GuiGraphics graphics) {
        graphics.fill(0, 0, this.width, this.height, -1442840576);
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        float maxDist = (float)Math.sqrt(centerX * centerX + centerY * centerY);
        for (int i = 10; i > 0; --i) {
            float radius = maxDist * ((float)i / 10.0f);
            int alpha = (int)(30.0f * (1.0f - (float)i / 10.0f));
            this.drawFilledCircle(graphics, centerX, centerY, radius, alpha << 24);
        }
    }

    private void drawSegment(GuiGraphics graphics, float centerX, float centerY, float innerRadius, float outerRadius, float startAngle, float endAngle, int color, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        int a = (int)((float)(color >> 24 & 0xFF) * alpha);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float angleRange = endAngle - startAngle;
        if (angleRange < 0.0f) {
            angleRange += 360.0f;
        }
        int steps = Math.max(8, (int)(angleRange / 5.0f));
        float angleStep = angleRange / (float)steps;
        for (int i = 0; i <= steps; ++i) {
            float angle = (float)Math.toRadians(startAngle + (float)i * angleStep);
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float x1 = centerX + cos * innerRadius;
            float y1 = centerY + sin * innerRadius;
            float x2 = centerX + cos * outerRadius;
            float y2 = centerY + sin * outerRadius;
            if (i <= 0) continue;
            float prevAngle = (float)Math.toRadians(startAngle + (float)(i - 1) * angleStep);
            float prevCos = (float)Math.cos(prevAngle);
            float prevSin = (float)Math.sin(prevAngle);
            float px1 = centerX + prevCos * innerRadius;
            float py1 = centerY + prevSin * innerRadius;
            float px2 = centerX + prevCos * outerRadius;
            float py2 = centerY + prevSin * outerRadius;
            buffer.addVertex(matrix, px1, py1, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, px2, py2, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x2, y2, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, px2, py2, 0.0f).setColor(r, g, b, a);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        this.drawSegmentBorder(graphics, centerX, centerY, innerRadius, outerRadius, startAngle, endAngle, alpha);
        this.drawSegmentDivider(graphics, centerX, centerY, innerRadius, outerRadius, startAngle, alpha);
        this.drawSegmentDivider(graphics, centerX, centerY, innerRadius, outerRadius, endAngle, alpha);
        RenderSystem.disableBlend();
    }

    private void drawSegmentDivider(GuiGraphics graphics, float centerX, float centerY, float innerRadius, float outerRadius, float angle, float alpha) {
        float cos = (float)Math.cos(Math.toRadians(angle));
        float sin = (float)Math.sin(Math.toRadians(angle));
        float x1 = centerX + cos * innerRadius;
        float y1 = centerY + sin * innerRadius;
        float x2 = centerX + cos * outerRadius;
        float y2 = centerY + sin * outerRadius;
        int dividerAlpha = (int)(119.0f * alpha);
        int color = dividerAlpha << 24 | 0xFFFFFF;
        this.drawLine(graphics, x1, y1, x2, y2, color);
    }

    private void drawSegmentBorder(GuiGraphics graphics, float centerX, float centerY, float innerRadius, float outerRadius, float startAngle, float endAngle, float alpha) {
        float y2;
        float x2;
        float y1;
        float x1;
        float angle2;
        float angle1;
        int i;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        int borderAlpha = (int)(170.0f * alpha * 0.5f);
        int r = 255;
        int g = 255;
        int b = 255;
        float angleRange = endAngle - startAngle;
        if (angleRange < 0.0f) {
            angleRange += 360.0f;
        }
        int steps = Math.max(4, (int)(angleRange / 10.0f));
        float angleStep = angleRange / (float)steps;
        for (i = 0; i < steps; ++i) {
            angle1 = (float)Math.toRadians(startAngle + (float)i * angleStep);
            angle2 = (float)Math.toRadians(startAngle + (float)(i + 1) * angleStep);
            x1 = centerX + (float)Math.cos(angle1) * innerRadius;
            y1 = centerY + (float)Math.sin(angle1) * innerRadius;
            x2 = centerX + (float)Math.cos(angle2) * innerRadius;
            y2 = centerY + (float)Math.sin(angle2) * innerRadius;
            buffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, borderAlpha);
            buffer.addVertex(matrix, x2, y2, 0.0f).setColor(r, g, b, borderAlpha);
        }
        for (i = 0; i < steps; ++i) {
            angle1 = (float)Math.toRadians(startAngle + (float)i * angleStep);
            angle2 = (float)Math.toRadians(startAngle + (float)(i + 1) * angleStep);
            x1 = centerX + (float)Math.cos(angle1) * outerRadius;
            y1 = centerY + (float)Math.sin(angle1) * outerRadius;
            x2 = centerX + (float)Math.cos(angle2) * outerRadius;
            y2 = centerY + (float)Math.sin(angle2) * outerRadius;
            buffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, borderAlpha);
            buffer.addVertex(matrix, x2, y2, 0.0f).setColor(r, g, b, borderAlpha);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private void drawLine(GuiGraphics graphics, float x1, float y1, float x2, float y2, int color) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float length = (float)Math.sqrt(dx * dx + dy * dy);
        if (length > 0.0f) {
            float thickness = 1.5f;
            float perpX = -dy / length * thickness / 2.0f;
            float perpY = dx / length * thickness / 2.0f;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Matrix4f matrix = graphics.pose().last().pose();
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            int a = color >> 24 & 0xFF;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            buffer.addVertex(matrix, x1 - perpX, y1 - perpY, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x1 + perpX, y1 + perpY, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x2 + perpX, y2 + perpY, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x2 - perpX, y2 - perpY, 0.0f).setColor(r, g, b, a);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            RenderSystem.disableBlend();
        }
    }

    private void drawSegmentContent(GuiGraphics graphics, PaletteData palette, float centerX, float centerY, float startAngle, float endAngle, float alpha) {
        boolean isHorizontal;
        float midAngle;
        if (startAngle > endAngle) {
            midAngle = (startAngle + endAngle + 360.0f) / 2.0f;
            if (midAngle >= 360.0f) {
                midAngle -= 360.0f;
            }
        } else {
            midAngle = (startAngle + endAngle) / 2.0f;
        }
        float midRadius = (this.innerRadius + this.outerRadius) / 2.0f;
        float angle = (float)Math.toRadians(midAngle);
        float contentX = centerX + (float)Math.cos(angle) * midRadius;
        float contentY = centerY + (float)Math.sin(angle) * midRadius;
        float segmentWidth = this.outerRadius - this.innerRadius;
        float maxTextWidth = segmentWidth * 1.2f;
        int textAlpha = (int)(255.0f * alpha);
        int color = textAlpha << 24 | 0xFFFFFF;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        boolean bl = isHorizontal = (double)midAngle >= 67.5 && (double)midAngle <= 112.5 || (double)midAngle >= 247.5 && (double)midAngle <= 292.5;
        if (palette.getIconBlock() != null) {
            ItemStack iconStack = new ItemStack((ItemLike)palette.getIconBlock().getBlock());
            graphics.pose().pushPose();
            graphics.pose().translate(contentX - 12.0f, contentY - 16.0f, 0.0f);
            float iconScale = this.isCompactMode ? 1.2f : 1.5f;
            graphics.pose().scale(iconScale, iconScale, iconScale);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            graphics.renderItem(iconStack, 0, 0);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.pose().popPose();
            String paletteName = palette.getName();
            float textScale = this.isCompactMode ? 0.7f : 0.85f;
            String truncatedName = this.truncateName(paletteName, maxTextWidth / textScale);
            MutableComponent name = Component.literal((String)truncatedName);
            graphics.pose().pushPose();
            graphics.pose().translate(contentX, contentY + 10.0f, 0.0f);
            graphics.pose().scale(textScale, textScale, textScale);
            graphics.drawCenteredString(this.font, (Component)name, 0, 0, color);
            graphics.pose().popPose();
        } else {
            String paletteName = palette.getName();
            float centerTextScale = this.isCompactMode ? 0.9f : 1.1f;
            String truncatedName = this.truncateName(paletteName, maxTextWidth / centerTextScale);
            MutableComponent name = Component.literal((String)truncatedName);
            graphics.pose().pushPose();
            graphics.pose().translate(contentX, contentY - 4.0f, 0.0f);
            graphics.pose().scale(centerTextScale, centerTextScale, centerTextScale);
            graphics.drawCenteredString(this.font, (Component)name, 0, 0, color);
            graphics.pose().popPose();
        }
        RenderSystem.disableBlend();
    }

    private void drawCenterCircle(GuiGraphics graphics, float centerX, float centerY, float progress) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float radius = this.centerRadius * progress;
        this.drawFilledCircle(graphics, centerX, centerY, radius, 0x44FFFFFF);
        if (progress > 0.3f) {
            this.drawCircleBorder(graphics, centerX, centerY, radius, -1426063361, (progress - 0.3f) / 0.7f);
        }
        if (progress > 0.7f && this.trowelData.getActivePalette() != null) {
            float contentAlpha = (progress - 0.7f) / 0.3f;
            int color = (int)(255.0f * contentAlpha) << 24 | 0xFFFFFF;
            PaletteData active = this.trowelData.getActivePalette();
            if (active.getIconBlock() != null) {
                ItemStack iconStack = new ItemStack((ItemLike)active.getIconBlock().getBlock());
                graphics.pose().pushPose();
                float iconScale = this.isCompactMode ? 1.2f : 1.5f;
                float iconOffset = 8.0f * iconScale;
                graphics.pose().translate(centerX - iconOffset, centerY - iconOffset, 0.0f);
                graphics.pose().scale(iconScale, iconScale, iconScale);
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)contentAlpha);
                graphics.renderItem(iconStack, 0, 0);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.pose().popPose();
            } else {
                MutableComponent name = Component.literal((String)active.getName());
                graphics.pose().pushPose();
                graphics.pose().translate(centerX, centerY - 4.0f, 0.0f);
                graphics.pose().scale(1.0f, 1.0f, 1.0f);
                graphics.drawCenteredString(this.font, (Component)name, 0, 0, color);
                graphics.pose().popPose();
            }
        }
        if (this.totalPages > 1 && progress > 0.5f) {
            float navAlpha = (progress - 0.5f) * 2.0f;
            this.drawNavigationButtons(graphics, centerX, centerY, navAlpha);
        }
        RenderSystem.disableBlend();
    }

    private void drawNavigationButtons(GuiGraphics graphics, float centerX, float centerY, float alpha) {
        float arrowScale;
        int buttonAlpha = (int)(255.0f * alpha);
        int buttonBgAlpha = (int)(100.0f * alpha);
        if (this.currentPage > 0) {
            float leftX = centerX - this.outerRadius - 40.0f * this.scaleFactor;
            float leftY = centerY;
            this.drawFilledCircle(graphics, leftX, leftY, 20.0f, buttonBgAlpha << 24 | 0xFFFFFF);
            this.drawCircleBorder(graphics, leftX, leftY, 20.0f, buttonAlpha << 24 | 0xFFFFFF, 1.0f);
            graphics.pose().pushPose();
            graphics.pose().translate(leftX, leftY - 5.0f, 0.0f);
            arrowScale = this.isCompactMode ? 1.0f : 1.2f;
            graphics.pose().scale(arrowScale, arrowScale, arrowScale);
            graphics.drawCenteredString(this.font, "\u25c0", 0, 0, buttonAlpha << 24 | 0xFFFFFF);
            graphics.pose().popPose();
        }
        if (this.currentPage < this.totalPages - 1) {
            float rightX = centerX + this.outerRadius + 40.0f * this.scaleFactor;
            float rightY = centerY;
            this.drawFilledCircle(graphics, rightX, rightY, 20.0f, buttonBgAlpha << 24 | 0xFFFFFF);
            this.drawCircleBorder(graphics, rightX, rightY, 20.0f, buttonAlpha << 24 | 0xFFFFFF, 1.0f);
            graphics.pose().pushPose();
            graphics.pose().translate(rightX, rightY - 5.0f, 0.0f);
            arrowScale = this.isCompactMode ? 1.0f : 1.2f;
            graphics.pose().scale(arrowScale, arrowScale, arrowScale);
            graphics.drawCenteredString(this.font, "\u25b6", 0, 0, buttonAlpha << 24 | 0xFFFFFF);
            graphics.pose().popPose();
        }
    }

    private void drawCircleBorder(GuiGraphics graphics, float centerX, float centerY, float radius, int color, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.lineWidth((float)2.0f);
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        int a = (int)((float)(color >> 24 & 0xFF) * alpha * 0.7f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        for (int i = 0; i <= 64; ++i) {
            float angle = (float)((double)(i * 2) * Math.PI / 64.0);
            float x = centerX + (float)Math.cos(angle) * radius;
            float y = centerY + (float)Math.sin(angle) * radius;
            buffer.addVertex(matrix, x, y, 0.0f).setColor(r, g, b, a);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.disableBlend();
    }

    private void drawFilledCircle(GuiGraphics graphics, float centerX, float centerY, float radius, int color) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        buffer.addVertex(matrix, centerX, centerY, 0.0f).setColor(r, g, b, a);
        for (int i = 0; i <= 64; ++i) {
            float angle = (float)((double)(i * 2) * Math.PI / 64.0);
            float x = centerX + (float)Math.cos(angle) * radius;
            float y = centerY + (float)Math.sin(angle) * radius;
            buffer.addVertex(matrix, x, y, 0.0f).setColor(r, g, b, a);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private void drawPageIndicator(GuiGraphics graphics, float centerX, float centerY) {
        float textY;
        String pageText = String.format("Page %d/%d", this.currentPage + 1, this.totalPages);
        boolean insideCenter = false;
        int screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        if (screenHeight <= 360) {
            textY = centerY + 15.0f;
            insideCenter = true;
        } else {
            textY = centerY + this.outerRadius + 35.0f * this.scaleFactor;
        }
        float fadeAlpha = (this.animationProgress - 0.5f) * 2.0f;
        int bgAlpha = (int)(51.0f * fadeAlpha);
        int textAlpha = (int)(255.0f * fadeAlpha);
        float textScale = insideCenter ? 0.7f : 1.0f;
        int textWidth = (int)((float)this.font.width(pageText) * textScale);
        int pillX = (int)(centerX - (float)textWidth / 2.0f - 8.0f * textScale);
        int pillY = (int)(textY - 3.0f * textScale);
        int pillWidth = (int)((float)textWidth + 16.0f * textScale);
        Objects.requireNonNull(this.font);
        int pillHeight = (int)((float)(9 + 6) * textScale);
        graphics.fill(pillX + 2, pillY, pillX + pillWidth - 2, pillY + pillHeight, bgAlpha << 24 | 0xFFFFFF);
        graphics.fill(pillX, pillY + 2, pillX + pillWidth, pillY + pillHeight - 2, bgAlpha << 24 | 0xFFFFFF);
        int borderAlpha = (int)(100.0f * fadeAlpha);
        this.drawPillBorder(graphics, pillX, pillY, pillWidth, pillHeight, borderAlpha << 24 | 0xFFFFFF);
        if (textScale != 1.0f) {
            graphics.pose().pushPose();
            graphics.pose().translate(centerX, textY, 0.0f);
            graphics.pose().scale(textScale, textScale, textScale);
            graphics.drawCenteredString(this.font, pageText, 0, 0, textAlpha << 24 | 0xFFFFFF);
            graphics.pose().popPose();
        } else {
            graphics.drawCenteredString(this.font, pageText, (int)centerX, (int)textY, textAlpha << 24 | 0xFFFFFF);
        }
    }

    private void drawPillBorder(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.fill(x + 2, y, x + width - 2, y + 1, color);
        graphics.fill(x + 2, y + height - 1, x + width - 2, y + height, color);
        graphics.fill(x, y + 2, x + 1, y + height - 2, color);
        graphics.fill(x + width - 1, y + 2, x + width, y + height - 2, color);
        graphics.fill(x + 1, y + 1, x + 2, y + 2, color);
        graphics.fill(x + width - 2, y + 1, x + width - 1, y + 2, color);
        graphics.fill(x + 1, y + height - 2, x + 2, y + height - 1, color);
        graphics.fill(x + width - 2, y + height - 2, x + width - 1, y + height - 1, color);
    }

    private String truncateName(String name, float maxWidth) {
        if ((float)this.font.width(name) <= maxWidth) {
            return name;
        }
        String ellipsis = "...";
        int ellipsisWidth = this.font.width(ellipsis);
        int left = 0;
        int right = name.length();
        int bestFit = 0;
        while (left <= right) {
            int mid = (left + right) / 2;
            String truncated = name.substring(0, mid);
            if ((float)(this.font.width(truncated) + ellipsisWidth) <= maxWidth) {
                bestFit = mid;
                left = mid + 1;
                continue;
            }
            right = mid - 1;
        }
        return bestFit > 0 ? name.substring(0, bestFit) + ellipsis : ellipsis;
    }

    private int getSegmentColor(boolean isActive, boolean isHovered, float hoverProgress) {
        if (isActive) {
            int baseAlpha = 153;
            int targetAlpha = Math.min(255, baseAlpha + (int)(30.0f * hoverProgress));
            return targetAlpha << 24 | 0xFFFFFF;
        }
        if (isHovered) {
            return this.lerpColor(0x33FFFFFF, 0x66FFFFFF, hoverProgress);
        }
        return 0x33FFFFFF;
    }

    private int lerpColor(int color1, int color2, float t) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)Mth.lerp((float)t, (float)a1, (float)a2);
        int r = (int)Mth.lerp((float)t, (float)r1, (float)r2);
        int g = (int)Mth.lerp((float)t, (float)g1, (float)g2);
        int b = (int)Mth.lerp((float)t, (float)b1, (float)b2);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int lightenColor(int color, float amount) {
        int a = color >> 24 & 0xFF;
        int r = Math.min(255, (int)((float)(color >> 16 & 0xFF) * (1.0f + amount)));
        int g = Math.min(255, (int)((float)(color >> 8 & 0xFF) * (1.0f + amount)));
        int b = Math.min(255, (int)((float)(color & 0xFF) * (1.0f + amount)));
        return a << 24 | r << 16 | g << 8 | b;
    }

    private float easeOutQuart(float t) {
        return 1.0f - (float)Math.pow(1.0f - t, 4.0);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isClosing) {
            return false;
        }
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        if (this.totalPages > 1) {
            float rightY;
            float rightX;
            float leftY;
            float dy;
            float leftX;
            float dx;
            float distance;
            if (this.currentPage > 0 && (distance = (float)Math.sqrt((dx = (float)(mouseX - (double)(leftX = centerX - this.outerRadius - 40.0f * this.scaleFactor))) * dx + (dy = (float)(mouseY - (double)(leftY = centerY))) * dy)) <= 20.0f) {
                --this.currentPage;
                this.init();
                return true;
            }
            if (this.currentPage < this.totalPages - 1 && (distance = (float)Math.sqrt((dx = (float)(mouseX - (double)(rightX = centerX + this.outerRadius + 40.0f * this.scaleFactor))) * dx + (dy = (float)(mouseY - (double)(rightY = centerY))) * dy)) <= 20.0f) {
                ++this.currentPage;
                this.init();
                return true;
            }
        }
        for (SegmentInfo segment : this.segments) {
            if (!segment.contains(mouseX, mouseY, centerX, centerY, this.innerRadius, this.outerRadius)) continue;
            this.selectPalette(segment.index);
            return true;
        }
        return false;
    }

    private void selectPalette(int segmentIndex) {
        if (this.isClosing) {
            return;
        }
        int paletteIndex = this.currentPage * 8 + segmentIndex;
        if (paletteIndex >= 0 && paletteIndex < this.sortedPalettes.size()) {
            PaletteData selectedPalette = this.sortedPalettes.get(paletteIndex);
            int actualIndex = this.trowelData.getPalettes().indexOf(selectedPalette);
            if (actualIndex >= 0) {
                this.isClosing = true;
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.literal((String)selectedPalette.getName()), false);
                PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.SWITCH_PALETTE, actualIndex, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.onClose();
            }
        }
    }

    public void onClose() {
        int paletteIndex;
        if (this.isClosing) {
            Minecraft.getInstance().setScreen(null);
            return;
        }
        this.isClosing = true;
        if (this.hoveredIndex >= 0 && this.hoveredIndex < this.segments.size() && (paletteIndex = this.currentPage * 8 + this.hoveredIndex) >= 0 && paletteIndex < this.sortedPalettes.size()) {
            PaletteData selectedPalette = this.sortedPalettes.get(paletteIndex);
            int actualIndex = this.trowelData.getPalettes().indexOf(selectedPalette);
            if (actualIndex >= 0) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.literal((String)selectedPalette.getName()), false);
                PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.SWITCH_PALETTE, actualIndex, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        Minecraft.getInstance().setScreen(null);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.isClosing = true;
            Minecraft.getInstance().setScreen(null);
            return true;
        }
        if (keyCode == 263 && this.currentPage > 0) {
            --this.currentPage;
            this.init();
            return true;
        }
        if (keyCode == 262 && this.currentPage < this.totalPages - 1) {
            ++this.currentPage;
            this.init();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static class SegmentInfo {
        final float startAngle;
        final float endAngle;
        final int index;

        SegmentInfo(float startAngle, float endAngle, int index) {
            this.startAngle = startAngle;
            this.endAngle = endAngle;
            this.index = index;
        }

        boolean contains(double mouseX, double mouseY, float centerX, float centerY, float innerR, float outerR) {
            float end;
            float start;
            float dx = (float)(mouseX - (double)centerX);
            float dy = (float)(mouseY - (double)centerY);
            float distance = (float)Math.sqrt(dx * dx + dy * dy);
            if (distance < innerR || distance > outerR) {
                return false;
            }
            float angle = (float)Math.toDegrees(Math.atan2(dy, dx));
            if (angle < 0.0f) {
                angle += 360.0f;
            }
            if ((start = this.startAngle) > (end = this.endAngle)) {
                return angle >= start || angle <= end;
            }
            return angle >= start && angle <= end;
        }
    }
}

