/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.data;

import com.asger.mechtrowel.compat.create.CopycatBlockConfig;
import com.asger.mechtrowel.compat.create.CreateCompat;
import com.asger.mechtrowel.compat.framedblocks.FramedBlockConfig;
import com.asger.mechtrowel.compat.framedblocks.FramedBlocksCompat;
import com.asger.mechtrowel.util.PaletteBalancer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PaletteData {
    private static final String TAG_NAME = "Name";
    private static final String TAG_BLOCKS = "Blocks";
    private static final String TAG_ICON_BLOCK = "IconBlock";
    private static final String TAG_LAST_USED = "LastUsed";
    private String name;
    private final List<WeightedBlock> blocks;
    private BlockState iconBlock;
    private long lastUsedTime;

    public PaletteData() {
        this("New Palette");
    }

    public PaletteData(String name) {
        this.name = name;
        this.blocks = new ArrayList<WeightedBlock>();
        this.iconBlock = null;
        this.lastUsedTime = System.currentTimeMillis();
    }

    public void load(CompoundTag tag) {
        this.name = tag.getString(TAG_NAME);
        this.iconBlock = tag.contains(TAG_ICON_BLOCK) ? NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag.getCompound(TAG_ICON_BLOCK)) : null;
        this.lastUsedTime = tag.contains(TAG_LAST_USED) ? tag.getLong(TAG_LAST_USED) : System.currentTimeMillis();
        this.blocks.clear();
        if (tag.contains(TAG_BLOCKS)) {
            ListTag blockList = tag.getList(TAG_BLOCKS, 10);
            for (int i = 0; i < blockList.size(); ++i) {
                CompoundTag blockTag = blockList.getCompound(i);
                WeightedBlock weightedBlock = new WeightedBlock();
                weightedBlock.load(blockTag);
                this.blocks.add(weightedBlock);
            }
        }
        this.validateAndBalance();
    }

    public void save(CompoundTag tag) {
        tag.putString(TAG_NAME, this.name);
        if (this.iconBlock != null) {
            tag.put(TAG_ICON_BLOCK, (Tag)NbtUtils.writeBlockState((BlockState)this.iconBlock));
        }
        tag.putLong(TAG_LAST_USED, this.lastUsedTime);
        ListTag blockList = new ListTag();
        for (WeightedBlock block : this.blocks) {
            CompoundTag blockTag = new CompoundTag();
            block.save(blockTag);
            blockList.add((Object)blockTag);
        }
        tag.put(TAG_BLOCKS, (Tag)blockList);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<WeightedBlock> getBlocks() {
        return this.blocks;
    }

    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    public int getPercentage(int index) {
        if (index >= 0 && index < this.blocks.size()) {
            return Math.round(this.blocks.get(index).getWeight());
        }
        return 0;
    }

    public void setPercentage(int index, int percentage) {
        if (index >= 0 && index < this.blocks.size()) {
            this.blocks.get(index).setWeight(percentage);
        }
    }

    public boolean isLocked(int index) {
        if (index >= 0 && index < this.blocks.size()) {
            return this.blocks.get(index).isLocked();
        }
        return false;
    }

    public void setLocked(int index, boolean locked) {
        if (index >= 0 && index < this.blocks.size()) {
            this.blocks.get(index).setLocked(locked);
        }
    }

    private void validateAndBalance() {
        if (this.blocks.isEmpty()) {
            return;
        }
        for (WeightedBlock block : this.blocks) {
            int percentage = Math.round(block.getWeight());
            percentage = Math.max(1, Math.min(100, percentage));
            block.setWeight(percentage);
        }
        PaletteBalancer.autoBalance(this);
    }

    public BlockState getIconBlock() {
        return this.iconBlock;
    }

    public void setIconBlock(BlockState iconBlock) {
        this.iconBlock = iconBlock;
    }

    public long getLastUsedTime() {
        return this.lastUsedTime;
    }

    public void updateLastUsedTime() {
        this.lastUsedTime = System.currentTimeMillis();
    }

    public static class WeightedBlock {
        private static final String TAG_STATE = "BlockState";
        private static final String TAG_WEIGHT = "Weight";
        private static final String TAG_LOCKED = "Locked";
        private static final String TAG_SLOT_POSITION = "SlotPosition";
        private static final String TAG_COPYCAT_CONFIG = "CopycatConfig";
        private static final String TAG_FRAMED_CONFIG = "FramedConfig";
        private BlockState state;
        private float weight;
        private boolean locked;
        private int slotPosition = -1;
        private CopycatBlockConfig copycatConfig;
        private FramedBlockConfig framedConfig;

        public WeightedBlock() {
            this(Blocks.STONE.defaultBlockState(), 100.0f, false);
        }

        public WeightedBlock(BlockState state, float weight, boolean locked) {
            this.state = state;
            this.weight = weight;
            this.locked = locked;
            this.slotPosition = -1;
            this.copycatConfig = null;
            this.framedConfig = null;
        }

        public WeightedBlock(BlockState state, float weight, boolean locked, int slotPosition) {
            this.state = state;
            this.weight = weight;
            this.locked = locked;
            this.slotPosition = slotPosition;
            this.copycatConfig = null;
            this.framedConfig = null;
        }

        public void load(CompoundTag tag) {
            this.state = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag.getCompound(TAG_STATE));
            this.weight = tag.getFloat(TAG_WEIGHT);
            this.locked = tag.getBoolean(TAG_LOCKED);
            int n = this.slotPosition = tag.contains(TAG_SLOT_POSITION) ? tag.getInt(TAG_SLOT_POSITION) : -1;
            if (tag.contains(TAG_COPYCAT_CONFIG)) {
                this.copycatConfig = new CopycatBlockConfig();
                this.copycatConfig.load(tag.getCompound(TAG_COPYCAT_CONFIG));
            }
            if (tag.contains(TAG_FRAMED_CONFIG)) {
                this.framedConfig = new FramedBlockConfig();
                this.framedConfig.load(tag.getCompound(TAG_FRAMED_CONFIG));
            }
        }

        public void save(CompoundTag tag) {
            tag.put(TAG_STATE, (Tag)NbtUtils.writeBlockState((BlockState)this.state));
            tag.putFloat(TAG_WEIGHT, this.weight);
            tag.putBoolean(TAG_LOCKED, this.locked);
            if (this.slotPosition >= 0) {
                tag.putInt(TAG_SLOT_POSITION, this.slotPosition);
            }
            if (this.copycatConfig != null && this.copycatConfig.isConfigured()) {
                CompoundTag copycatTag = new CompoundTag();
                this.copycatConfig.save(copycatTag);
                tag.put(TAG_COPYCAT_CONFIG, (Tag)copycatTag);
            }
            if (this.framedConfig != null && this.framedConfig.isConfigured()) {
                CompoundTag framedTag = new CompoundTag();
                this.framedConfig.save(framedTag);
                tag.put(TAG_FRAMED_CONFIG, (Tag)framedTag);
            }
        }

        public BlockState getState() {
            return this.state;
        }

        public void setState(BlockState state) {
            this.state = state;
        }

        public float getWeight() {
            return this.weight;
        }

        public void setWeight(float weight) {
            this.weight = weight;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        public int getSlotPosition() {
            return this.slotPosition;
        }

        public void setSlotPosition(int slotPosition) {
            this.slotPosition = slotPosition;
        }

        public CopycatBlockConfig getCopycatConfig() {
            return this.copycatConfig;
        }

        public void setCopycatConfig(CopycatBlockConfig config) {
            this.copycatConfig = config;
        }

        public boolean isCopycat() {
            return this.state != null && CreateCompat.isCopycatBlock(this.state.getBlock());
        }

        public FramedBlockConfig getFramedConfig() {
            return this.framedConfig;
        }

        public void setFramedConfig(FramedBlockConfig config) {
            this.framedConfig = config;
        }

        public boolean isFramed() {
            return this.state != null && FramedBlocksCompat.isFramedBlock(this.state.getBlock());
        }
    }
}

