/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.events;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.item.ChippedConversionTemplateItem;
import com.asger.mechtrowel.item.MechTrowelItem;
import com.asger.mechtrowel.item.WandCapacityTemplateItem;
import com.asger.mechtrowel.item.WandTemplateItem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="mechtrowel")
public class SmithingUpgradeHandler {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isClientSide() || player.level().getGameTime() % 5L != 0L) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof SmithingMenu)) {
            return;
        }
        SmithingMenu smithingMenu = (SmithingMenu)abstractContainerMenu;
        ItemStack result = smithingMenu.getSlot(3).getItem();
        if (result.isEmpty() || !(result.getItem() instanceof MechTrowelItem)) {
            return;
        }
        ItemStack template = smithingMenu.getSlot(0).getItem();
        ItemStack base = smithingMenu.getSlot(1).getItem();
        ItemStack addition = smithingMenu.getSlot(2).getItem();
        if (base.isEmpty() || !(base.getItem() instanceof MechTrowelItem)) {
            return;
        }
        TrowelData resultData = TrowelData.getOrCreate(result);
        TrowelData baseData = TrowelData.getOrCreate(base);
        if (addition.getItem() instanceof WandTemplateItem) {
            if (!resultData.isWandEnabled() && !baseData.isWandEnabled() && MechTrowel.Config.isWandUpgradeEnabled()) {
                resultData.setWandEnabled(true);
                resultData.save(result);
                MechTrowel.LOGGER.debug("Applied wand upgrade to MechTrowel in smithing table");
            }
        } else if (addition.getItem() instanceof WandCapacityTemplateItem) {
            if (baseData.isWandEnabled() && !resultData.isCapacityUpgraded() && !baseData.isCapacityUpgraded() && MechTrowel.Config.isWandCapacityUpgradeEnabled()) {
                resultData.setWandEnabled(true);
                resultData.setCapacityUpgraded(true);
                resultData.save(result);
                MechTrowel.LOGGER.debug("Applied capacity upgrade to MechTrowel in smithing table");
            }
        } else if (addition.getItem() instanceof ChippedConversionTemplateItem && !resultData.isChippedConversionEnabled() && !baseData.isChippedConversionEnabled() && MechTrowel.Config.isChippedConversionUpgradeEnabled()) {
            resultData.setChippedConversionEnabled(true);
            resultData.setChippedConversionActive(true);
            resultData.save(result);
            MechTrowel.LOGGER.debug("Applied Chipped conversion upgrade to MechTrowel in smithing table");
        }
    }
}

