/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.events;

import com.asger.mechtrowel.compat.create.CopycatBlockConfig;
import com.asger.mechtrowel.compat.create.CreateCompat;
import com.asger.mechtrowel.compat.framedblocks.FramedBlockConfig;
import com.asger.mechtrowel.compat.framedblocks.FramedBlocksCompat;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.gui.PaletteMenu;
import com.asger.mechtrowel.gui.PaletteScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@OnlyIn(value=Dist.CLIENT)
public class TooltipEventHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        Item item;
        Item item2;
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (!(screen instanceof PaletteScreen)) {
            return;
        }
        PaletteScreen paletteScreen = (PaletteScreen)screen;
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty() || !((item2 = stack.getItem()) instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item2;
        boolean isCopycat = CreateCompat.isCopycatBlock(blockItem.getBlock());
        boolean isFramed = FramedBlocksCompat.isFramedBlock(blockItem.getBlock());
        if (!isCopycat && !isFramed) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = paletteScreen.getMenu();
        if (!(abstractContainerMenu instanceof PaletteMenu)) {
            return;
        }
        PaletteMenu paletteMenu = (PaletteMenu)abstractContainerMenu;
        int hoveredSlot = TooltipEventHandler.findHoveredPaletteSlot(paletteScreen, mc.mouseHandler.xpos(), mc.mouseHandler.ypos());
        if (hoveredSlot == -1) {
            return;
        }
        ItemStack hoveredStack = paletteMenu.paletteContainer.getItem(hoveredSlot);
        if (hoveredStack.isEmpty() || !((item = hoveredStack.getItem()) instanceof BlockItem)) {
            return;
        }
        BlockItem hoveredBlockItem = (BlockItem)item;
        TrowelData trowelData = paletteMenu.getTrowelData();
        PaletteData currentPalette = trowelData.getActivePalette();
        if (currentPalette == null) {
            return;
        }
        PaletteData.WeightedBlock paletteBlock = null;
        for (PaletteData.WeightedBlock block : currentPalette.getBlocks()) {
            if (block.getSlotPosition() != hoveredSlot) continue;
            paletteBlock = block;
            break;
        }
        if (paletteBlock == null) {
            return;
        }
        List tooltip = event.getToolTip();
        ArrayList<MutableComponent> customLines = new ArrayList<MutableComponent>();
        if (isCopycat && paletteBlock.getCopycatConfig() != null && paletteBlock.getCopycatConfig().isConfigured()) {
            config = paletteBlock.getCopycatConfig();
            customLines.add(Component.literal((String)"Material: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)((CopycatBlockConfig)config).getMaterial().getBlock().getName().getString()).withStyle(ChatFormatting.GREEN)));
            if (((CopycatBlockConfig)config).isLit()) {
                customLines.add(Component.literal((String)"\u2713 Lit").withStyle(ChatFormatting.YELLOW));
            }
            if (((CopycatBlockConfig)config).getAxisMode() != CopycatBlockConfig.AxisMode.OFF) {
                customLines.add(Component.literal((String)("\u2713 Axis: " + ((CopycatBlockConfig)config).getAxisMode().getDisplayName())).withStyle(ChatFormatting.AQUA));
            }
        } else if (isFramed && paletteBlock.getFramedConfig() != null && paletteBlock.getFramedConfig().isConfigured()) {
            config = paletteBlock.getFramedConfig();
            customLines.add(Component.literal((String)"Camo: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)((FramedBlockConfig)config).getCamo().getBlock().getName().getString()).withStyle(ChatFormatting.GREEN)));
        } else {
            customLines.add(Component.literal((String)"Left-click to configure").withStyle(ChatFormatting.GRAY));
        }
        if (!tooltip.isEmpty() && !customLines.isEmpty()) {
            customLines.add(Component.empty());
            int insertIndex = 1;
            for (Component component : customLines) {
                tooltip.add(insertIndex++, component);
            }
        }
    }

    private static int findHoveredPaletteSlot(PaletteScreen screen, double screenMouseX, double screenMouseY) {
        int actualRow;
        int mouseX = (int)(screenMouseX * (double)screen.getMinecraft().getWindow().getGuiScaledWidth() / (double)screen.getMinecraft().getWindow().getScreenWidth());
        int mouseY = (int)(screenMouseY * (double)screen.getMinecraft().getWindow().getGuiScaledHeight() / (double)screen.getMinecraft().getWindow().getScreenHeight());
        int SLOT_SIZE = 18;
        int LOCK_WIDTH = 5;
        int UNIT_GAP = 3;
        int VERTICAL_SPACING = 29;
        int unitWidth = 23;
        int totalWidth = unitWidth * 7 + 18;
        int startX = screen.getLeftPos() + (screen.getImageWidth() - totalWidth) / 2;
        int gridY = screen.getCalculatedGridY();
        int scrollOffset = screen.getScrollOffset();
        int visibleRows = screen.getVisibleRows();
        for (int row = 0; row < visibleRows && (actualRow = row + scrollOffset) < ((PaletteMenu)screen.getMenu()).paletteRows; ++row) {
            int slotIndex;
            for (int col = 0; col < 7 && (slotIndex = actualRow * 7 + col) < ((PaletteMenu)screen.getMenu()).paletteSlots; ++col) {
                int slotX = startX + col * (unitWidth + 3);
                int slotY = gridY + row * 29;
                if (mouseX < slotX || mouseX >= slotX + 18 || mouseY < slotY || mouseY >= slotY + 18) continue;
                return slotIndex;
            }
        }
        return -1;
    }
}

