/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui;

import com.asger.mechtrowel.data.GradientData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.item.MechTrowelItem;
import com.asger.mechtrowel.registry.ModRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class GradientMenu
extends AbstractContainerMenu {
    private final ItemStack trowelStack;
    private final int trowelSlot;
    private GradientData gradientData;
    private TrowelData trowelData;
    private final Player player;

    public GradientMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, extraData.readVarInt(), playerInventory.getItem(extraData.readVarInt()));
    }

    public GradientMenu(int containerId, Inventory playerInventory, int trowelSlot, ItemStack trowelStack) {
        super((MenuType)ModRegistry.GRADIENT_MENU_TYPE.get(), containerId);
        this.trowelSlot = trowelSlot;
        this.trowelStack = trowelStack;
        this.trowelData = TrowelData.getOrCreate(trowelStack);
        this.gradientData = this.trowelData.getGradientData();
        this.player = playerInventory.player;
    }

    public boolean stillValid(Player player) {
        ItemStack currentStack = player.getInventory().getItem(this.trowelSlot);
        return currentStack.getItem() instanceof MechTrowelItem && ItemStack.isSameItemSameComponents((ItemStack)currentStack, (ItemStack)this.trowelStack);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public GradientData getGradientData() {
        return this.gradientData;
    }

    public TrowelData getTrowelData() {
        return this.trowelData;
    }

    public int getTrowelSlot() {
        return this.trowelSlot;
    }
}

