/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.compat.create.CopycatBlockConfig;
import com.asger.mechtrowel.compat.create.CreateCompat;
import com.asger.mechtrowel.compat.framedblocks.FramedBlockConfig;
import com.asger.mechtrowel.compat.framedblocks.FramedBlocksCompat;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.RotationLockData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.gui.PaletteLayoutConstants;
import com.asger.mechtrowel.gui.PaletteMenu;
import com.asger.mechtrowel.gui.widget.GhostSlot;
import com.asger.mechtrowel.gui.widget.InteractivePercentageBar;
import com.asger.mechtrowel.gui.widget.NoFocusButton;
import com.asger.mechtrowel.gui.widget.PaletteDropdown;
import com.asger.mechtrowel.gui.widget.StyledToggleButton;
import com.asger.mechtrowel.gui.widget.VerticalLockToggle;
import com.asger.mechtrowel.network.TrowelPacket;
import com.asger.mechtrowel.util.PaletteBalancer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class PaletteScreen
extends AbstractContainerScreen<PaletteMenu> {
    private static final ResourceLocation TEXTURE = null;
    private static final int BUTTON_PALETTE_SEPARATOR_OFFSET = 0;
    private static final int CONTROLS_GLOBAL_SEPARATOR_OFFSET = 0;
    private int calculatedInventoryY;
    private int calculatedGridY;
    private int buttonPaletteSeparatorY;
    private int controlsGlobalSeparatorY;
    private int dropdownY;
    private TrowelData trowelData;
    private PaletteData currentPalette;
    private int currentPaletteIndex;
    private PaletteDropdown paletteSelector;
    private Button createButton;
    private Button renameButton;
    private Button deleteButton;
    private EditBox renameBox;
    private Button confirmDeleteButton;
    private Button cancelDeleteButton;
    private boolean isRenaming = false;
    private boolean isDeleting = false;
    private Button confirmRenameButton;
    private Button cancelRenameButton;
    private SimpleContainer iconContainer;
    private BlockState selectedIconBlock;
    private List<InteractivePercentageBar> percentageBars;
    private List<VerticalLockToggle> lockButtons;
    private Button resetButton;
    private Button equalButton;
    private boolean isUpdatingUI = false;
    private long lastUpdateTime = 0L;
    private boolean isConfiguringCopycat = false;
    private int copycatConfigSlot = -1;
    private CopycatBlockConfig workingCopycatConfig = null;
    private Button copycatLitButton;
    private Button copycatAxisButton;
    private Component copycatInstructionText;
    private boolean isConfiguringFramed = false;
    private int framedConfigSlot = -1;
    private FramedBlockConfig workingFramedConfig = null;
    private Component framedInstructionText;
    private StyledToggleButton replaceToggle;
    private StyledToggleButton previewToggle;
    private StyledToggleButton rotationButton;
    private StyledToggleButton gradientButton;
    private Button undoButton;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private boolean canScroll = false;
    private int visibleRows = 4;
    private boolean isScrolling = false;
    private double scrollingStartY = 0.0;
    private static final int LOCK_HEIGHT = 14;

    public PaletteScreen(PaletteMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 230;
        this.imageHeight = PaletteLayoutConstants.calculateTotalHeight();
        this.trowelData = menu.getTrowelData();
        if (this.trowelData.getPalettes().isEmpty()) {
            PaletteData defaultPalette = new PaletteData();
            defaultPalette.setName("Default");
            this.trowelData.addPalette(defaultPalette);
            this.trowelData.save(menu.getTrowelStack());
        }
        this.currentPaletteIndex = this.trowelData.getActivePaletteIndex();
        this.currentPalette = this.trowelData.getActivePalette();
        if (this.currentPalette == null && !this.trowelData.getPalettes().isEmpty()) {
            this.currentPaletteIndex = 0;
            this.currentPalette = this.trowelData.getPalettes().get(0);
            this.trowelData.setActivePaletteIndex(0);
            this.trowelData.save(menu.getTrowelStack());
        }
        this.percentageBars = new ArrayList<InteractivePercentageBar>();
        this.lockButtons = new ArrayList<VerticalLockToggle>();
        this.iconContainer = new SimpleContainer(1);
    }

    protected void init() {
        super.init();
        this.calculateVisibleRows();
        ((PaletteMenu)this.menu).setVisibleRows(this.visibleRows);
        int totalRows = ((PaletteMenu)this.menu).paletteRows;
        this.canScroll = totalRows > this.visibleRows;
        this.maxScrollOffset = this.canScroll ? totalRows - this.visibleRows : 0;
        this.scrollOffset = Math.min(this.scrollOffset, this.maxScrollOffset);
        ((PaletteMenu)this.menu).updateScrollOffset(this.scrollOffset);
        this.imageHeight = PaletteLayoutConstants.calculateTotalHeightWithRows(this.visibleRows);
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        int x = this.leftPos;
        PaletteLayoutConstants.LayoutCalculator layout = new PaletteLayoutConstants.LayoutCalculator(this.topPos);
        this.dropdownY = layout.getPositionForSection(PaletteLayoutConstants.DROPDOWN_SECTION);
        this.initPaletteDropdown(x, this.dropdownY);
        layout.addSection(PaletteLayoutConstants.DROPDOWN_SECTION);
        this.initPaletteButtons(x, layout.getPositionForSection(PaletteLayoutConstants.BUTTONS_SECTION));
        layout.addSection(PaletteLayoutConstants.BUTTONS_SECTION);
        this.buttonPaletteSeparatorY = layout.getCurrentY() - PaletteLayoutConstants.BUTTONS_SECTION.bottomPadding / 2 + 0;
        this.calculatedGridY = layout.getPositionForSection(PaletteLayoutConstants.PALETTE_SECTION);
        this.initPaletteGrid(x, this.calculatedGridY);
        int paletteContentHeight = this.visibleRows * 29 - 4;
        layout.addSectionWithCustomHeight(PaletteLayoutConstants.PALETTE_SECTION.topPadding + paletteContentHeight + PaletteLayoutConstants.PALETTE_SECTION.bottomPadding);
        this.initPaletteControls(x, layout.getPositionForSection(PaletteLayoutConstants.CONTROLS_SECTION));
        layout.addSection(PaletteLayoutConstants.CONTROLS_SECTION);
        this.controlsGlobalSeparatorY = layout.getCurrentY() - PaletteLayoutConstants.CONTROLS_SECTION.bottomPadding / 2 + 0;
        this.initGlobalSettings(x, layout.getPositionForSection(PaletteLayoutConstants.GLOBAL_SECTION));
        layout.addSection(PaletteLayoutConstants.GLOBAL_SECTION);
        this.calculatedInventoryY = layout.getPositionForSection(PaletteLayoutConstants.INVENTORY_SECTION);
        ((PaletteMenu)this.menu).syncContainerWithPalette();
        this.updateUI();
        this.applyScrollToWidgets();
    }

    private void initPaletteDropdown(int x, int y) {
        if (this.trowelData.getPalettes().isEmpty()) {
            PaletteData defaultPalette = new PaletteData();
            defaultPalette.setName("Default");
            this.trowelData.addPalette(defaultPalette);
            this.currentPaletteIndex = 0;
            this.currentPalette = defaultPalette;
        }
        ArrayList<Integer> paletteIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.trowelData.getPalettes().size(); ++i) {
            paletteIndices.add(i);
        }
        this.paletteSelector = new PaletteDropdown(x + 10, y + 5, 210, 20, paletteIndices, this.currentPaletteIndex, idx -> {
            if (idx >= 0 && idx < this.trowelData.getPalettes().size()) {
                return Component.literal((String)this.trowelData.getPalettes().get((int)idx).getName());
            }
            return Component.literal((String)"No Palette");
        }, value -> {
            if (value != this.currentPaletteIndex) {
                PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.SWITCH_PALETTE, (int)value, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
        this.paletteSelector.setIconProvider(idx -> {
            if (idx >= 0 && idx < this.trowelData.getPalettes().size()) {
                return this.trowelData.getPalettes().get((int)idx).getIconBlock();
            }
            return null;
        });
        this.addRenderableWidget((GuiEventListener)this.paletteSelector);
    }

    private void initPaletteGrid(int x, int y) {
        this.percentageBars.clear();
        this.lockButtons.clear();
        int unitWidth = 23;
        int totalWidth = unitWidth * 7 + 18;
        int startX = x + (this.imageWidth - totalWidth) / 2;
        PaletteData palette = this.currentPalette;
        for (int i = 0; i < ((PaletteMenu)this.menu).paletteSlots; ++i) {
            int row = i / 7;
            int col = i % 7;
            int slotX = startX + col * (unitWidth + 3);
            int slotY = y + row * 29;
            ItemStack containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
            boolean hasBlock = !containerItem.isEmpty() && containerItem.getItem() instanceof BlockItem;
            PaletteData.WeightedBlock paletteBlock = null;
            if (hasBlock && palette != null) {
                for (PaletteData.WeightedBlock block : palette.getBlocks()) {
                    if (block.getSlotPosition() != i) continue;
                    paletteBlock = block;
                    break;
                }
            }
            int slotIndex = i;
            int barY = slotY + 18 + 2 - 2;
            InteractivePercentageBar percentBar = new InteractivePercentageBar(slotX, barY, 18, (Screen)this, newPercentage -> this.onPercentageChanged(slotIndex, (int)newPercentage));
            if (paletteBlock != null) {
                percentBar.setPercentage(Math.round(paletteBlock.getWeight()));
                percentBar.setLocked(paletteBlock.isLocked());
                percentBar.setVisible(true);
                percentBar.active = true;
            } else {
                percentBar.setPercentage(0);
                percentBar.setVisible(false);
                percentBar.active = false;
            }
            this.percentageBars.add(percentBar);
            this.addRenderableWidget((GuiEventListener)percentBar);
            int lockY = slotY + 0;
            boolean initialLocked = paletteBlock != null && paletteBlock.isLocked();
            VerticalLockToggle lockButton = new VerticalLockToggle(slotX + 18, lockY, initialLocked, locked -> this.onLockToggled(slotIndex, locked));
            lockButton.visible = paletteBlock != null;
            this.lockButtons.add(lockButton);
            this.addRenderableWidget((GuiEventListener)lockButton);
        }
    }

    private void initPaletteButtons(int x, int y) {
        int buttonWidth = 65;
        int buttonSpacing = 5;
        int totalButtonWidth = buttonWidth * 3 + buttonSpacing * 2;
        int buttonStartX = x + (this.imageWidth - totalButtonWidth) / 2;
        this.createButton = NoFocusButton.noFocusBuilder((Component)Component.translatable((String)"gui.mechtrowel.create"), btn -> this.createNewPalette()).bounds(buttonStartX, y, buttonWidth, PaletteLayoutConstants.BUTTONS_SECTION.contentHeight).build();
        this.addRenderableWidget((GuiEventListener)this.createButton);
        this.renameButton = NoFocusButton.noFocusBuilder((Component)Component.translatable((String)"gui.mechtrowel.rename"), btn -> this.startRename()).bounds(buttonStartX + buttonWidth + buttonSpacing, y, buttonWidth, PaletteLayoutConstants.BUTTONS_SECTION.contentHeight).build();
        this.addRenderableWidget((GuiEventListener)this.renameButton);
        this.deleteButton = NoFocusButton.noFocusBuilder((Component)Component.translatable((String)"gui.mechtrowel.delete"), btn -> this.startDelete()).bounds(buttonStartX + (buttonWidth + buttonSpacing) * 2, y, buttonWidth, PaletteLayoutConstants.BUTTONS_SECTION.contentHeight).build();
        this.addRenderableWidget((GuiEventListener)this.deleteButton);
        this.initRenameUI(x, y);
        int deleteButtonWidth = 70;
        int deleteButtonSpacing = 10;
        int deleteTotalWidth = deleteButtonWidth * 2 + deleteButtonSpacing;
        int deleteButtonStartX = x + (this.imageWidth - deleteTotalWidth) / 2;
        this.confirmDeleteButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Confirm \u2713").withStyle(ChatFormatting.RED), btn -> this.confirmDelete()).bounds(deleteButtonStartX, y, deleteButtonWidth, PaletteLayoutConstants.BUTTONS_SECTION.contentHeight).build();
        this.confirmDeleteButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.confirmDeleteButton);
        this.cancelDeleteButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Cancel \u2717").withStyle(ChatFormatting.GRAY), btn -> this.cancelDelete()).bounds(deleteButtonStartX + deleteButtonWidth + deleteButtonSpacing, y, deleteButtonWidth, PaletteLayoutConstants.BUTTONS_SECTION.contentHeight).build();
        this.cancelDeleteButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.cancelDeleteButton);
        int copycatButton1Width = 60;
        int copycatButton2Width = 70;
        int copycatButton3Width = 70;
        int copycatButtonSpacing = 5;
        int copycatTotalWidth = copycatButton1Width + copycatButton2Width + copycatButton3Width + copycatButtonSpacing * 2;
        int copycatButtonStartX = x + (this.imageWidth - copycatTotalWidth) / 2;
        this.copycatLitButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Lit \u2600"), btn -> this.toggleCopycatLit()).bounds(copycatButtonStartX, y, copycatButton1Width, PaletteLayoutConstants.BUTTONS_SECTION.contentHeight).build();
        this.copycatLitButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.copycatLitButton);
        this.copycatAxisButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Axis: Off"), btn -> this.cycleCopycatAxis()).bounds(copycatButtonStartX + copycatButton1Width + copycatButtonSpacing, y, copycatButton2Width, PaletteLayoutConstants.BUTTONS_SECTION.contentHeight).build();
        this.copycatAxisButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.copycatAxisButton);
        NoFocusButton copycatDoneButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Confirm ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)"\u2713").withStyle(ChatFormatting.GREEN)), btn -> {
            if (this.isConfiguringCopycat) {
                this.finishCopycatConfig();
            } else if (this.isConfiguringFramed) {
                this.finishFramedConfig();
            }
        }).bounds(copycatButtonStartX + copycatButton1Width + copycatButton2Width + copycatButtonSpacing * 2, y, copycatButton3Width, PaletteLayoutConstants.BUTTONS_SECTION.contentHeight).build();
        copycatDoneButton.visible = false;
        this.addRenderableWidget((GuiEventListener)copycatDoneButton);
        this.updateUI();
    }

    private void initPaletteControls(int x, int y) {
        int buttonWidth = 60;
        int buttonSpacing = 10;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int buttonStartX = x + (this.imageWidth - totalButtonWidth) / 2;
        this.resetButton = NoFocusButton.noFocusBuilder((Component)Component.translatable((String)"gui.mechtrowel.reset"), btn -> this.resetPalette()).bounds(buttonStartX, y, buttonWidth, PaletteLayoutConstants.BUTTONS_SECTION.contentHeight).tooltip(Tooltip.create((Component)Component.literal((String)"Reset Palette").withStyle(ChatFormatting.WHITE).append("\n").append((Component)Component.literal((String)"Clear all locks and distribute evenly").withStyle(ChatFormatting.GRAY)))).build();
        this.addRenderableWidget((GuiEventListener)this.resetButton);
        this.equalButton = NoFocusButton.noFocusBuilder((Component)Component.translatable((String)"gui.mechtrowel.equal"), btn -> this.equalDistribution()).bounds(buttonStartX + buttonWidth + buttonSpacing, y, buttonWidth, PaletteLayoutConstants.BUTTONS_SECTION.contentHeight).tooltip(Tooltip.create((Component)Component.literal((String)"Equal Distribution").withStyle(ChatFormatting.WHITE).append("\n").append((Component)Component.literal((String)"Distribute evenly (respects locks)").withStyle(ChatFormatting.GRAY)))).build();
        this.addRenderableWidget((GuiEventListener)this.equalButton);
        int undoButtonWidth = 25;
        int undoButtonX = buttonStartX + buttonWidth * 2 + buttonSpacing + 10;
        this.undoButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"\u27f2"), btn -> PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UNDO_WAND, 0, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0])).bounds(undoButtonX, y, undoButtonWidth, PaletteLayoutConstants.BUTTONS_SECTION.contentHeight).tooltip(Tooltip.create((Component)Component.literal((String)"Undo Last Wand Action").withStyle(ChatFormatting.WHITE).append("\n").append((Component)Component.literal((String)"Revert up to the last 3 wand actions").withStyle(ChatFormatting.GRAY)))).build();
        this.addRenderableWidget((GuiEventListener)this.undoButton);
        this.undoButton.visible = this.trowelData.getBuildingMode() == TrowelData.BuildingMode.WAND;
    }

    private void initRenameUI(int x, int buttonsY) {
        int renameBoxWidth = 170;
        this.renameBox = new EditBox(this.font, x + 10, this.dropdownY + 5, renameBoxWidth, 20, (Component)Component.literal((String)"New Name"));
        this.renameBox.setMaxLength(20);
        this.renameBox.setVisible(false);
        this.addRenderableWidget((GuiEventListener)this.renameBox);
        int renameButtonWidth = 70;
        int renameButtonSpacing = 10;
        int renameTotalWidth = renameButtonWidth * 2 + renameButtonSpacing;
        int renameButtonStartX = x + (this.imageWidth - renameTotalWidth) / 2;
        this.confirmRenameButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Confirm ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)"\u2713").withStyle(ChatFormatting.GREEN)), btn -> this.finishRename()).bounds(renameButtonStartX, buttonsY, renameButtonWidth, PaletteLayoutConstants.BUTTONS_SECTION.contentHeight).build();
        this.confirmRenameButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.confirmRenameButton);
        this.cancelRenameButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Cancel ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)"\u2717").withStyle(ChatFormatting.RED)), btn -> this.cancelRename()).bounds(renameButtonStartX + renameButtonWidth + renameButtonSpacing, buttonsY, renameButtonWidth, PaletteLayoutConstants.BUTTONS_SECTION.contentHeight).build();
        this.cancelRenameButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.cancelRenameButton);
    }

    private void initGlobalSettings(int x, int y) {
        int startX;
        int toggleWidth = 52;
        int featureWidth = 52;
        int buttonSpacing = 3;
        boolean showReplace = MechTrowel.Config.isReplaceModeEnabled();
        int buttonCount = showReplace ? 4 : 3;
        int toggleCount = showReplace ? 2 : 1;
        int featureCount = 2;
        int totalWidth = toggleWidth * toggleCount + featureWidth * featureCount + buttonSpacing * (buttonCount - 1);
        int currentX = startX = x + (this.imageWidth - totalWidth) / 2;
        if (showReplace) {
            this.replaceToggle = new StyledToggleButton(currentX, y, toggleWidth, PaletteLayoutConstants.GLOBAL_SECTION.contentHeight, (Component)Component.literal((String)"Replace"), this.trowelData.isReplaceMode(), value -> {
                this.trowelData.setReplaceMode((boolean)value);
                this.sendSettingsUpdate();
            });
            this.replaceToggle.setTooltip(Tooltip.create((Component)Component.literal((String)"Replace Mode").withStyle(ChatFormatting.WHITE).append("\n").append((Component)Component.literal((String)"Replace existing blocks when placing").withStyle(ChatFormatting.GRAY))));
            this.addRenderableWidget((GuiEventListener)this.replaceToggle);
            currentX += toggleWidth + buttonSpacing;
        }
        this.previewToggle = new StyledToggleButton(currentX, y, toggleWidth, PaletteLayoutConstants.GLOBAL_SECTION.contentHeight, (Component)Component.literal((String)"Preview"), this.trowelData.isPreviewActive(), value -> PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.TOGGLE_PREVIEW, 0, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]));
        this.previewToggle.setTooltip(Tooltip.create((Component)Component.literal((String)"Preview Mode").withStyle(ChatFormatting.WHITE).append("\n").append((Component)Component.literal((String)"Show wireframe preview before placing").withStyle(ChatFormatting.GRAY))));
        this.addRenderableWidget((GuiEventListener)this.previewToggle);
        boolean hasActiveRotations = this.hasActiveRotationSettings();
        this.rotationButton = new StyledToggleButton(currentX += toggleWidth + buttonSpacing, y, featureWidth, PaletteLayoutConstants.GLOBAL_SECTION.contentHeight, (Component)Component.literal((String)"Rotation"), hasActiveRotations, value -> this.openRotationScreen()){

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.visible && this.active && this.isMouseOver(mouseX, mouseY)) {
                    if (button == 1) {
                        RotationLockData rotationData = PaletteScreen.this.trowelData.getRotationLockData();
                        rotationData.clearLocks();
                        rotationData.setStairMode(RotationLockData.StairMode.AUTO);
                        rotationData.setSlabMode(RotationLockData.SlabMode.AUTO);
                        rotationData.setStairLink(true);
                        CompoundTag tag = new CompoundTag();
                        rotationData.save(tag);
                        PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.SAVE_ROTATION, 0, tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        this.setToggled(false);
                        PaletteScreen.this.updateRotationButtonTooltip();
                        return true;
                    }
                    if (button == 0) {
                        this.playDownSound(PaletteScreen.this.minecraft.getSoundManager());
                        PaletteScreen.this.openRotationScreen();
                        return true;
                    }
                }
                return false;
            }
        };
        this.updateRotationButtonTooltip();
        this.addRenderableWidget((GuiEventListener)this.rotationButton);
        boolean hasGradientActive = !this.trowelData.getGradientData().getSections().isEmpty() && this.trowelData.isGradientEnabled();
        this.gradientButton = new StyledToggleButton(currentX += featureWidth + buttonSpacing, y, featureWidth, PaletteLayoutConstants.GLOBAL_SECTION.contentHeight, (Component)Component.literal((String)"Gradient"), hasGradientActive, value -> this.openGradientScreen()){

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.visible && this.active && this.isMouseOver(mouseX, mouseY)) {
                    if (button == 1) {
                        if (!PaletteScreen.this.trowelData.getGradientData().getSections().isEmpty()) {
                            boolean newState = !PaletteScreen.this.trowelData.isGradientEnabled();
                            PaletteScreen.this.trowelData.setGradientEnabled(newState);
                            this.setToggled(newState);
                            PaletteScreen.this.sendSettingsUpdate();
                            PaletteScreen.this.updateGradientButtonTooltip();
                            this.playDownSound(PaletteScreen.this.minecraft.getSoundManager());
                            return true;
                        }
                    } else if (button == 0) {
                        this.playDownSound(PaletteScreen.this.minecraft.getSoundManager());
                        PaletteScreen.this.openGradientScreen();
                        return true;
                    }
                }
                return false;
            }
        };
        this.updateGradientButtonTooltip();
        this.addRenderableWidget((GuiEventListener)this.gradientButton);
    }

    private void updateUI() {
        boolean normalState;
        int i;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime < 50L) {
            return;
        }
        this.lastUpdateTime = currentTime;
        this.isUpdatingUI = true;
        if (this.paletteSelector != null) {
            if (!this.paletteSelector.isOpen()) {
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (i = 0; i < this.trowelData.getPalettes().size(); ++i) {
                    indices.add(i);
                }
                this.paletteSelector.updateOptions(indices, this.currentPaletteIndex);
            }
            this.paletteSelector.setIconProvider(idx -> {
                if (idx >= 0 && idx < this.trowelData.getPalettes().size()) {
                    return this.trowelData.getPalettes().get((int)idx).getIconBlock();
                }
                return null;
            });
        }
        this.paletteSelector.visible = normalState = !this.isRenaming && !this.isDeleting && !this.isConfiguringCopycat && !this.isConfiguringFramed;
        this.createButton.visible = normalState;
        this.renameButton.visible = normalState;
        this.deleteButton.visible = normalState;
        this.renameBox.visible = this.isRenaming;
        this.confirmRenameButton.visible = this.isRenaming;
        this.cancelRenameButton.visible = this.isRenaming;
        this.confirmDeleteButton.visible = this.isDeleting;
        this.cancelDeleteButton.visible = this.isDeleting;
        this.copycatLitButton.visible = this.isConfiguringCopycat;
        this.copycatAxisButton.visible = this.isConfiguringCopycat;
        if (!this.renderables.isEmpty()) {
            for (Renderable widget : this.renderables) {
                Button btn;
                if (!(widget instanceof Button) || !(btn = (Button)widget).getMessage().getString().contains("Confirm") || !btn.getMessage().getString().contains("\u2713") || btn == this.confirmRenameButton || btn == this.confirmDeleteButton) continue;
                btn.visible = this.isConfiguringCopycat || this.isConfiguringFramed;
            }
        }
        this.createButton.active = this.trowelData.getPalettes().size() < MechTrowel.Config.getMaxPalettes();
        this.deleteButton.active = this.trowelData.getPalettes().size() > 1;
        this.trowelData = ((PaletteMenu)this.menu).getTrowelData();
        this.currentPalette = this.trowelData.getActivePalette();
        for (i = 0; i < this.percentageBars.size(); ++i) {
            boolean hasBlock;
            ItemStack containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
            boolean bl = hasBlock = !containerItem.isEmpty() && containerItem.getItem() instanceof BlockItem;
            if (hasBlock && this.currentPalette != null) {
                PaletteData.WeightedBlock paletteBlock = null;
                for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                    if (block.getSlotPosition() != i) continue;
                    paletteBlock = block;
                    break;
                }
                if (paletteBlock != null) {
                    this.percentageBars.get(i).setVisible(true);
                    this.percentageBars.get((int)i).active = true;
                    int percentage = Math.round(paletteBlock.getWeight());
                    this.percentageBars.get(i).setPercentage(percentage);
                    this.percentageBars.get(i).setLocked(paletteBlock.isLocked());
                    this.lockButtons.get(i).setLocked(paletteBlock.isLocked());
                    this.lockButtons.get((int)i).visible = true;
                    continue;
                }
                int existingBlockCount = this.currentPalette.getBlocks().size();
                int tempPercentage = existingBlockCount > 0 ? 100 / (existingBlockCount + 1) : 100;
                this.percentageBars.get(i).setVisible(true);
                this.percentageBars.get((int)i).active = true;
                this.percentageBars.get(i).setPercentage(tempPercentage);
                this.percentageBars.get(i).setLocked(false);
                this.lockButtons.get(i).setLocked(false);
                this.lockButtons.get((int)i).visible = true;
                continue;
            }
            this.percentageBars.get(i).setPercentage(0);
            this.percentageBars.get(i).setVisible(false);
            this.percentageBars.get((int)i).active = false;
            this.lockButtons.get((int)i).visible = false;
        }
        if (this.replaceToggle != null) {
            this.replaceToggle.setToggled(this.trowelData.isReplaceMode());
        }
        if (this.previewToggle != null) {
            this.previewToggle.setToggled(this.trowelData.isPreviewActive());
        }
        if (this.rotationButton != null) {
            this.rotationButton.setToggled(this.hasActiveRotationSettings());
            this.updateRotationButtonTooltip();
        }
        if (this.gradientButton != null) {
            this.gradientButton.setToggled(!this.trowelData.getGradientData().getSections().isEmpty() && this.trowelData.isGradientEnabled());
            this.updateGradientButtonTooltip();
        }
        if (this.undoButton != null) {
            boolean shouldShowUndo;
            this.undoButton.visible = shouldShowUndo = this.trowelData.getBuildingMode() == TrowelData.BuildingMode.WAND;
        }
        this.isUpdatingUI = false;
    }

    private void onPercentageChanged(int slot, int newPercentage) {
        boolean isTextInputChange = false;
        if (slot < this.percentageBars.size()) {
            isTextInputChange = this.percentageBars.get(slot).isInTextInputMode();
        }
        if (this.currentPalette == null || this.isUpdatingUI && !isTextInputChange) {
            return;
        }
        PaletteData.WeightedBlock targetBlock = null;
        int paletteIndex = -1;
        for (int i = 0; i < this.currentPalette.getBlocks().size(); ++i) {
            if (this.currentPalette.getBlocks().get(i).getSlotPosition() != slot) continue;
            targetBlock = this.currentPalette.getBlocks().get(i);
            paletteIndex = i;
            break;
        }
        if (targetBlock == null || paletteIndex == -1) {
            return;
        }
        newPercentage = Math.max(1, Math.min(100, newPercentage));
        int oldPercentage = Math.round(targetBlock.getWeight());
        if (oldPercentage != newPercentage) {
            PaletteBalancer.handlePercentageChange(this.currentPalette, paletteIndex, oldPercentage, newPercentage);
            if (!this.isUpdatingUI) {
                for (int i = 0; i < this.percentageBars.size(); ++i) {
                    boolean hasBlock;
                    if (i == slot) continue;
                    ItemStack containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
                    boolean bl = hasBlock = !containerItem.isEmpty() && containerItem.getItem() instanceof BlockItem;
                    if (!hasBlock || this.currentPalette == null) continue;
                    PaletteData.WeightedBlock paletteBlock = null;
                    for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                        if (block.getSlotPosition() != i) continue;
                        paletteBlock = block;
                        break;
                    }
                    if (paletteBlock == null) continue;
                    int balancedPercentage = Math.round(paletteBlock.getWeight());
                    this.percentageBars.get(i).setPercentage(balancedPercentage);
                }
            }
            this.savePalette();
        }
    }

    private void onLockToggled(int slot, boolean locked) {
        if (this.currentPalette == null || this.isUpdatingUI) {
            return;
        }
        this.trowelData = ((PaletteMenu)this.menu).getTrowelData();
        this.currentPalette = this.trowelData.getActivePalette();
        if (this.currentPalette == null) {
            return;
        }
        PaletteData.WeightedBlock targetBlock = null;
        for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
            if (block.getSlotPosition() != slot) continue;
            targetBlock = block;
            break;
        }
        if (targetBlock == null) {
            return;
        }
        targetBlock.setLocked(locked);
        if (slot < this.lockButtons.size()) {
            this.lockButtons.get(slot).setLocked(locked);
        }
        if (slot < this.percentageBars.size()) {
            this.percentageBars.get(slot).setLocked(locked);
        }
        this.savePalette();
    }

    private void checkAndBalance() {
        if (this.currentPalette == null) {
            return;
        }
        if (!PaletteBalancer.isBalanced(this.currentPalette)) {
            PaletteBalancer.autoBalance(this.currentPalette);
            this.updateUI();
        }
    }

    private void createNewPalette() {
        if (this.trowelData.getPalettes().size() < MechTrowel.Config.getMaxPalettes()) {
            CompoundTag nameTag = new CompoundTag();
            nameTag.putString("name", "Palette " + (this.trowelData.getPalettes().size() + 1));
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.CREATE_PALETTE, 0, nameTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void startRename() {
        this.isRenaming = true;
        this.isDeleting = false;
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            this.paletteSelector.close();
        }
        this.renameBox.setValue(this.currentPalette.getName());
        this.renameBox.setFocused(true);
        this.renameBox.setHighlightPos(0);
        this.renameBox.setCursorPosition(this.renameBox.getValue().length());
        if (this.currentPalette.getIconBlock() != null) {
            this.selectedIconBlock = this.currentPalette.getIconBlock();
            ItemStack iconStack = new ItemStack((ItemLike)this.selectedIconBlock.getBlock());
            this.iconContainer.setItem(0, iconStack);
        } else {
            this.selectedIconBlock = null;
            this.iconContainer.setItem(0, ItemStack.EMPTY);
        }
        this.updateUI();
    }

    private void finishRename() {
        if (this.isRenaming && this.currentPalette != null) {
            boolean iconChanged;
            Object newName = this.renameBox.getValue().trim();
            if (((String)newName).isEmpty()) {
                newName = "Palette " + (this.currentPaletteIndex + 1);
            }
            this.isRenaming = false;
            boolean nameChanged = !((String)newName).equals(this.currentPalette.getName());
            boolean bl = iconChanged = this.selectedIconBlock != null && !this.selectedIconBlock.equals(this.currentPalette.getIconBlock()) || this.selectedIconBlock == null && this.currentPalette.getIconBlock() != null;
            if (nameChanged || iconChanged) {
                CompoundTag nameTag = new CompoundTag();
                nameTag.putString("name", (String)newName);
                if (this.selectedIconBlock != null) {
                    nameTag.put("iconBlock", (Tag)NbtUtils.writeBlockState((BlockState)this.selectedIconBlock));
                } else if (this.currentPalette.getIconBlock() != null && this.selectedIconBlock == null) {
                    nameTag.putBoolean("clearIcon", true);
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.RENAME_PALETTE, this.currentPaletteIndex, nameTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.selectedIconBlock = null;
            this.iconContainer.setItem(0, ItemStack.EMPTY);
            this.updateUI();
            if (this.paletteSelector != null) {
                this.paletteSelector.refreshDisplay();
            }
        }
    }

    private void cancelRename() {
        this.isRenaming = false;
        this.selectedIconBlock = null;
        this.iconContainer.setItem(0, ItemStack.EMPTY);
        this.updateUI();
        if (this.paletteSelector != null) {
            this.paletteSelector.refreshDisplay();
        }
    }

    private void startDelete() {
        if (this.trowelData.getPalettes().size() > 1) {
            this.isDeleting = true;
            this.isRenaming = false;
            if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
                this.paletteSelector.close();
            }
            this.updateUI();
        }
    }

    private void confirmDelete() {
        if (this.trowelData.getPalettes().size() > 1 && this.isDeleting) {
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.DELETE_PALETTE, this.currentPaletteIndex, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.isDeleting = false;
        }
    }

    private void cancelDelete() {
        this.isDeleting = false;
        this.updateUI();
    }

    private void resetPalette() {
        if (this.currentPalette == null || this.currentPalette.isEmpty()) {
            return;
        }
        if (this.resetButton != null) {
            this.resetButton.active = false;
        }
        this.trowelData = ((PaletteMenu)this.menu).getTrowelData();
        this.currentPalette = this.trowelData.getActivePalette();
        if (this.currentPalette != null && !this.currentPalette.isEmpty()) {
            int i;
            for (i = 0; i < this.currentPalette.getBlocks().size(); ++i) {
                this.currentPalette.setLocked(i, false);
                this.currentPalette.getBlocks().get(i).setSlotPosition(i);
            }
            PaletteBalancer.equalDistribution(this.currentPalette);
            ((PaletteMenu)this.menu).syncContainerWithPalette();
            for (i = 0; i < this.currentPalette.getBlocks().size(); ++i) {
                int slot = this.currentPalette.getBlocks().get(i).getSlotPosition();
                if (slot < this.percentageBars.size()) {
                    this.percentageBars.get(slot).setLocked(false);
                    this.percentageBars.get(slot).setPercentage(Math.round(this.currentPalette.getBlocks().get(i).getWeight()));
                }
                if (slot >= this.lockButtons.size()) continue;
                this.lockButtons.get(slot).setLocked(false);
            }
            this.savePalette();
            if (this.resetButton != null) {
                this.resetButton.active = true;
            }
        }
    }

    private void equalDistribution() {
        if (this.currentPalette == null || this.currentPalette.isEmpty()) {
            return;
        }
        if (this.equalButton != null) {
            this.equalButton.active = false;
        }
        this.trowelData = ((PaletteMenu)this.menu).getTrowelData();
        this.currentPalette = this.trowelData.getActivePalette();
        if (this.currentPalette != null && !this.currentPalette.isEmpty()) {
            PaletteBalancer.equalDistribution(this.currentPalette, true);
            this.updateUI();
            this.savePalette();
            if (this.equalButton != null) {
                this.equalButton.active = true;
            }
        }
    }

    private void savePalette() {
        if (this.currentPalette != null) {
            TrowelData freshTrowelData = ((PaletteMenu)this.menu).getTrowelData();
            if (this.currentPaletteIndex < freshTrowelData.getPalettes().size()) {
                PaletteData containerPalette = freshTrowelData.getPalettes().get(this.currentPaletteIndex);
                for (int i = 0; i < ((PaletteMenu)this.menu).paletteSlots; ++i) {
                    ItemStack containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
                    if (containerItem.isEmpty() || !(containerItem.getItem() instanceof BlockItem)) continue;
                    for (PaletteData.WeightedBlock block : containerPalette.getBlocks()) {
                        if (block.getSlotPosition() == i) break;
                    }
                }
                freshTrowelData.getPalettes().set(this.currentPaletteIndex, this.currentPalette);
            }
            freshTrowelData.save(((PaletteMenu)this.menu).getTrowelStack());
            ((PaletteMenu)this.menu).broadcastChanges();
            CompoundTag paletteTag = new CompoundTag();
            this.currentPalette.save(paletteTag);
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.SAVE_PALETTE, this.currentPaletteIndex, paletteTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void sendSettingsUpdate() {
        CompoundTag settingsTag = new CompoundTag();
        this.trowelData.save(settingsTag);
        PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UPDATE_SETTINGS, 0, settingsTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void openRotationScreen() {
        PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.OPEN_ROTATION_GUI, 0, null), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void openGradientScreen() {
        PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.OPEN_GRADIENT_GUI, 0, null), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private boolean hasActiveRotationSettings() {
        RotationLockData rotationData = this.trowelData.getRotationLockData();
        if (!rotationData.getLockedFaces().isEmpty()) {
            return true;
        }
        if (rotationData.getStairMode() != RotationLockData.StairMode.AUTO) {
            return true;
        }
        if (rotationData.getSlabMode() != RotationLockData.SlabMode.AUTO) {
            return true;
        }
        return !rotationData.isStairLink();
    }

    private void updateGradientButtonTooltip() {
        boolean hasGradientConfigured;
        if (this.gradientButton == null) {
            return;
        }
        ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
        tooltipLines.add(Component.literal((String)"Gradient Settings").withStyle(ChatFormatting.WHITE));
        boolean bl = hasGradientConfigured = !this.trowelData.getGradientData().getSections().isEmpty();
        if (hasGradientConfigured) {
            if (this.trowelData.isGradientEnabled()) {
                tooltipLines.add(Component.literal((String)"Active").withStyle(ChatFormatting.GREEN));
            } else {
                tooltipLines.add(Component.literal((String)"Disabled").withStyle(ChatFormatting.RED));
            }
            tooltipLines.add(Component.empty());
            tooltipLines.add(Component.literal((String)"Left-click: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"Configure settings").withStyle(ChatFormatting.GRAY)));
            tooltipLines.add(Component.literal((String)"Right-click: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"Toggle on/off").withStyle(ChatFormatting.GRAY)));
        } else {
            tooltipLines.add(Component.literal((String)"Not configured").withStyle(ChatFormatting.GRAY));
            tooltipLines.add(Component.empty());
            tooltipLines.add(Component.literal((String)"Left-click: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"Configure settings").withStyle(ChatFormatting.GRAY)));
        }
        if (tooltipLines.size() > 1) {
            Component combinedTooltip = (Component)tooltipLines.get(0);
            for (int i = 1; i < tooltipLines.size(); ++i) {
                combinedTooltip = Component.empty().append(combinedTooltip).append("\n").append((Component)tooltipLines.get(i));
            }
            this.gradientButton.setTooltip(Tooltip.create((Component)combinedTooltip));
        } else if (!tooltipLines.isEmpty()) {
            this.gradientButton.setTooltip(Tooltip.create((Component)((Component)tooltipLines.get(0))));
        }
    }

    private void updateRotationButtonTooltip() {
        if (this.rotationButton == null) {
            return;
        }
        RotationLockData rotationData = this.trowelData.getRotationLockData();
        ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
        tooltipLines.add(Component.literal((String)"Rotation Settings").withStyle(ChatFormatting.WHITE));
        boolean hasActiveSettings = false;
        if (!rotationData.getLockedFaces().isEmpty()) {
            hasActiveSettings = true;
            if (rotationData.getLockedFaces().size() == 1) {
                Direction lockedDir = rotationData.getLockedFaces().iterator().next();
                String dirName = switch (lockedDir) {
                    default -> throw new MatchException(null, null);
                    case Direction.DOWN -> "Down";
                    case Direction.UP -> "Up";
                    case Direction.NORTH -> "North";
                    case Direction.SOUTH -> "South";
                    case Direction.WEST -> "West";
                    case Direction.EAST -> "East";
                };
                tooltipLines.add(Component.literal((String)"Locked: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)dirName).withStyle(ChatFormatting.YELLOW)));
            } else {
                tooltipLines.add(Component.literal((String)"Locked: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(rotationData.getLockedFaces().size() + " faces")).withStyle(ChatFormatting.YELLOW)));
                StringBuilder dirs = new StringBuilder();
                boolean first = true;
                for (Direction dir : rotationData.getLockedFaces()) {
                    if (!first) {
                        dirs.append(", ");
                    }
                    first = false;
                    dirs.append(switch (dir) {
                        default -> throw new MatchException(null, null);
                        case Direction.DOWN -> "Down";
                        case Direction.UP -> "Up";
                        case Direction.NORTH -> "North";
                        case Direction.SOUTH -> "South";
                        case Direction.WEST -> "West";
                        case Direction.EAST -> "East";
                    });
                }
                tooltipLines.add(Component.literal((String)("  " + dirs.toString())).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        if (rotationData.getStairMode() != RotationLockData.StairMode.AUTO) {
            hasActiveSettings = true;
            String stairModeName = rotationData.getStairMode().getName();
            String capitalizedStairMode = stairModeName.substring(0, 1).toUpperCase() + stairModeName.substring(1);
            tooltipLines.add(Component.literal((String)"Stairs: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)capitalizedStairMode).withStyle(ChatFormatting.YELLOW)));
        }
        if (rotationData.getSlabMode() != RotationLockData.SlabMode.AUTO) {
            hasActiveSettings = true;
            String slabModeName = rotationData.getSlabMode().getName();
            String capitalizedSlabMode = slabModeName.substring(0, 1).toUpperCase() + slabModeName.substring(1);
            tooltipLines.add(Component.literal((String)"Slabs: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)capitalizedSlabMode).withStyle(ChatFormatting.YELLOW)));
        }
        if (!rotationData.isStairLink()) {
            hasActiveSettings = true;
            tooltipLines.add(Component.literal((String)"Stair Link: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"OFF").withStyle(ChatFormatting.RED)));
        }
        if (!hasActiveSettings) {
            tooltipLines.add(Component.literal((String)"All default").withStyle(ChatFormatting.GRAY));
        }
        tooltipLines.add(Component.literal((String)""));
        tooltipLines.add(Component.literal((String)"Left-click: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"Open settings").withStyle(ChatFormatting.GRAY)));
        tooltipLines.add(Component.literal((String)"Right-click: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"Reset all").withStyle(ChatFormatting.GRAY)));
        if (tooltipLines.size() > 1) {
            Component combinedTooltip = (Component)tooltipLines.get(0);
            for (int i = 1; i < tooltipLines.size(); ++i) {
                combinedTooltip = Component.empty().append(combinedTooltip).append("\n").append((Component)tooltipLines.get(i));
            }
            this.rotationButton.setTooltip(Tooltip.create((Component)combinedTooltip));
        } else {
            this.rotationButton.setTooltip(Tooltip.create((Component)((Component)tooltipLines.get(0))));
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int y;
        int x;
        int col;
        graphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -3750202);
        graphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + 1, -1);
        graphics.fill(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + this.imageHeight, -1);
        graphics.fill(this.leftPos, this.topPos + this.imageHeight - 1, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -11184811);
        graphics.fill(this.leftPos + this.imageWidth - 1, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -11184811);
        int unitWidth = 23;
        int totalWidth = unitWidth * 7 + 18;
        int startX = this.leftPos + (this.imageWidth - totalWidth) / 2;
        int gridY = this.calculatedGridY;
        if (this.canScroll) {
            int scissorLeft = startX - 5;
            int scissorRight = startX + totalWidth + 5;
            int scissorTop = gridY - 2;
            int scissorBottom = gridY + this.visibleRows * 29 - 4;
            graphics.enableScissor(scissorLeft, scissorTop, scissorRight, scissorBottom);
        }
        int rowsToDraw = Math.min(this.visibleRows, ((PaletteMenu)this.menu).paletteRows - this.scrollOffset);
        block0: for (int row = 0; row < rowsToDraw; ++row) {
            int actualRow = row + this.scrollOffset;
            for (col = 0; col < 7; ++col) {
                x = startX + col * (unitWidth + 3);
                y = gridY + row * 29;
                int slotIndex = actualRow * 7 + col;
                if (slotIndex >= ((PaletteMenu)this.menu).paletteSlots) continue block0;
                if (this.isConfiguringCopycat && this.copycatConfigSlot == slotIndex) {
                    this.drawCopycatConfigSlot(graphics, x, y);
                    continue;
                }
                this.drawSlot(graphics, x, y);
            }
        }
        if (this.canScroll) {
            graphics.disableScissor();
        }
        int inventoryY = this.calculatedInventoryY;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                x = this.leftPos + 35 + col * 18;
                y = inventoryY + 7 + row * 18;
                this.drawSlot(graphics, x - 1, y - 1);
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            int x2 = this.leftPos + 35 + col2 * 18;
            int y2 = inventoryY + 65;
            this.drawSlot(graphics, x2 - 1, y2 - 1);
        }
        int x3 = this.leftPos;
        int separatorPadding = 6;
        int separatorLeft = x3 + separatorPadding;
        int separatorRight = x3 + this.imageWidth - separatorPadding;
        graphics.fill(separatorLeft, this.buttonPaletteSeparatorY, separatorRight, this.buttonPaletteSeparatorY + 1, -14013910);
        graphics.fill(separatorLeft, this.buttonPaletteSeparatorY + 1, separatorRight, this.buttonPaletteSeparatorY + 2, -10855846);
        graphics.fill(separatorLeft, this.controlsGlobalSeparatorY, separatorRight, this.controlsGlobalSeparatorY + 1, -14013910);
        graphics.fill(separatorLeft, this.controlsGlobalSeparatorY + 1, separatorRight, this.controlsGlobalSeparatorY + 2, -10855846);
    }

    private void drawSlot(GuiGraphics graphics, int x, int y) {
        graphics.fill(x, y, x + 18, y + 1, -13158601);
        graphics.fill(x, y, x + 1, y + 18, -13158601);
        graphics.fill(x + 1, y + 17, x + 18, y + 18, -1);
        graphics.fill(x + 17, y + 1, x + 18, y + 18, -1);
        graphics.fill(x + 1, y + 1, x + 17, y + 17, -7631989);
    }

    private void drawCopycatConfigSlot(GuiGraphics graphics, int x, int y) {
        graphics.fill(x, y, x + 18, y + 1, -13158601);
        graphics.fill(x, y, x + 1, y + 18, -13158601);
        graphics.fill(x + 1, y + 17, x + 18, y + 18, -1);
        graphics.fill(x + 17, y + 1, x + 18, y + 18, -1);
        graphics.fill(x + 1, y + 1, x + 17, y + 17, -6255688);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            return;
        }
        super.renderTooltip(graphics, mouseX, mouseY);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int highlightY;
        int highlightX;
        int maxTextWidth;
        int boxX;
        int boxHeight;
        int boxWidth;
        int boxWidth2;
        int boxY;
        int boxX2;
        int slotY;
        int slotX;
        int remainingSpace;
        int centerY;
        int slotY2;
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.applyScrollToWidgets();
        super.render(graphics, mouseX, mouseY, partialTick);
        this.restoreWidgetPositions();
        int x = this.leftPos;
        int y = this.topPos;
        int unitWidth = 23;
        int totalWidth = unitWidth * 7 + 18;
        int startX = x + (this.imageWidth - totalWidth) / 2;
        int gridY = this.calculatedGridY;
        if (this.canScroll) {
            int scissorLeft = startX - 5;
            int scissorRight = startX + totalWidth + 5;
            int scissorTop = gridY - 2;
            int scissorBottom = gridY + this.visibleRows * 29 - 4;
            graphics.enableScissor(scissorLeft, scissorTop, scissorRight, scissorBottom);
        }
        int rowsToDraw = Math.min(this.visibleRows, ((PaletteMenu)this.menu).paletteRows - this.scrollOffset);
        for (int row = 0; row < rowsToDraw; ++row) {
            int i;
            int actualRow = row + this.scrollOffset;
            for (int col = 0; col < 7 && (i = actualRow * 7 + col) < ((PaletteMenu)this.menu).paletteSlots; ++col) {
                ItemStack containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
                if (!containerItem.isEmpty()) continue;
                int slotX2 = startX + col * (unitWidth + 3);
                slotY2 = gridY + row * 29;
                int plusSize = 4;
                int centerX = slotX2 + 9;
                centerY = slotY2 + 9;
                graphics.fill(centerX, centerY - plusSize / 2, centerX + 1, centerY + plusSize / 2 + 1, -9013642);
                graphics.fill(centerX - plusSize / 2, centerY, centerX + plusSize / 2 + 1, centerY + 1, -9013642);
            }
        }
        if (this.canScroll) {
            graphics.disableScissor();
        }
        if (this.canScroll) {
            this.drawScrollBar(graphics, mouseX, mouseY);
        }
        if (this.createButton.isHoveredOrFocused() && !this.createButton.active) {
            graphics.renderTooltip(this.font, (Component)Component.literal((String)("Maximum palettes reached (" + MechTrowel.Config.getMaxPalettes() + ")")), mouseX, mouseY);
        }
        if (this.deleteButton.isHoveredOrFocused() && !this.deleteButton.active) {
            graphics.renderTooltip(this.font, (Component)Component.literal((String)"Cannot delete the last palette"), mouseX, mouseY);
        }
        if (this.isRenaming) {
            remainingSpace = this.leftPos + this.imageWidth - (this.renameBox.getX() + this.renameBox.getWidth());
            slotX = this.renameBox.getX() + this.renameBox.getWidth() + (remainingSpace - 18) / 2;
            slotY = this.renameBox.getY() + 1;
            this.drawSlot(graphics, slotX - 1, slotY - 1);
            if (!this.iconContainer.getItem(0).isEmpty()) {
                graphics.renderItem(this.iconContainer.getItem(0), slotX, slotY);
            } else {
                int plusSize = 4;
                int centerX = slotX + 8;
                int centerY2 = slotY + 8;
                graphics.fill(centerX, centerY2 - plusSize / 2, centerX + 1, centerY2 + plusSize / 2 + 1, -9013642);
                graphics.fill(centerX - plusSize / 2, centerY2, centerX + plusSize / 2 + 1, centerY2 + 1, -9013642);
            }
        }
        if (this.isDeleting && this.currentPalette != null) {
            boxX2 = this.paletteSelector.getX();
            boxY = this.paletteSelector.getY();
            boxWidth2 = 210;
            int boxHeight2 = this.paletteSelector.getHeight();
            graphics.fill(boxX2, boxY, boxX2 + boxWidth2, boxY + boxHeight2, -12829636);
            graphics.fill(boxX2, boxY, boxX2 + boxWidth2, boxY + 1, -14803426);
            graphics.fill(boxX2, boxY, boxX2 + 1, boxY + boxHeight2, -14803426);
            graphics.fill(boxX2 + 1, boxY + boxHeight2 - 1, boxX2 + boxWidth2, boxY + boxHeight2, -10855846);
            graphics.fill(boxX2 + boxWidth2 - 1, boxY + 1, boxX2 + boxWidth2, boxY + boxHeight2, -10855846);
            graphics.fill(boxX2 + 1, boxY + 1, boxX2 + boxWidth2 - 1, boxY + boxHeight2 - 1, 0x20FF0000);
            MutableComponent deleteText = Component.literal((String)"DELETE \"").withStyle(ChatFormatting.RED);
            int textX = boxX2 + 5;
            int textY = boxY + 6;
            if (this.currentPalette.getIconBlock() != null) {
                graphics.drawString(this.font, (Component)deleteText, textX, textY, 0xFFFFFF, false);
                ItemStack iconStack = new ItemStack((ItemLike)this.currentPalette.getIconBlock().getBlock());
                graphics.pose().pushPose();
                graphics.pose().translate((float)(textX += this.font.width((FormattedText)deleteText)), (float)(boxY + 2), 0.0f);
                graphics.pose().scale(0.75f, 0.75f, 0.75f);
                graphics.renderItem(iconStack, 0, 0);
                graphics.pose().popPose();
                MutableComponent nameAndQuote = Component.literal((String)this.currentPalette.getName()).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)"\"?").withStyle(ChatFormatting.RED));
                graphics.drawString(this.font, (Component)nameAndQuote, textX += 14, textY, 0xFFFFFF, false);
            } else {
                MutableComponent fullMessage = deleteText.append((Component)Component.literal((String)this.currentPalette.getName()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"\"?").withStyle(ChatFormatting.RED));
                graphics.drawString(this.font, (Component)fullMessage, textX, textY, 0xFFFFFF, false);
            }
        }
        if (this.isRenaming) {
            remainingSpace = this.leftPos + this.imageWidth - (this.renameBox.getX() + this.renameBox.getWidth());
            slotX = this.renameBox.getX() + this.renameBox.getWidth() + (remainingSpace - 18) / 2;
            slotY = this.renameBox.getY() + 1;
            if (mouseX >= slotX - 1 && mouseX < slotX + 17 && mouseY >= slotY - 1 && mouseY < slotY + 17) {
                ArrayList<Object> tooltip = new ArrayList<Object>();
                if (this.iconContainer.getItem(0).isEmpty()) {
                    tooltip.add(Component.literal((String)"Click to set icon"));
                    tooltip.add(Component.literal((String)"Left-click any block").withStyle(ChatFormatting.GRAY));
                } else {
                    tooltip.add(this.iconContainer.getItem(0).getHoverName());
                    tooltip.add(Component.literal((String)"Right-click to remove").withStyle(ChatFormatting.GRAY));
                }
                graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
        if (this.isConfiguringCopycat) {
            boxX2 = this.leftPos + 10;
            boxY = this.dropdownY + 5;
            boxWidth2 = 183;
            int slotX3 = boxX2 + boxWidth2 + 10;
            int slotY3 = boxY + 1;
            if (mouseX >= slotX3 - 1 && mouseX < slotX3 + 17 && mouseY >= slotY3 - 1 && mouseY < slotY3 + 17) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                if (this.workingCopycatConfig == null || this.workingCopycatConfig.getMaterial() == null) {
                    tooltip.add(Component.literal((String)"Click to set material"));
                    tooltip.add(Component.literal((String)"Left-click any block").withStyle(ChatFormatting.GRAY));
                } else {
                    tooltip.add(Component.literal((String)this.workingCopycatConfig.getMaterial().getBlock().getName().getString()));
                    tooltip.add(Component.literal((String)"Click another block to change").withStyle(ChatFormatting.GRAY));
                }
                graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
        if (this.isConfiguringCopycat) {
            MutableComponent materialText;
            boxWidth = 183;
            boxHeight = 20;
            boxX = this.leftPos + 10;
            int boxY2 = this.dropdownY + 5;
            graphics.fill(boxX, boxY2, boxX + boxWidth, boxY2 + boxHeight, -12829636);
            graphics.fill(boxX, boxY2, boxX + boxWidth, boxY2 + 1, -14803426);
            graphics.fill(boxX, boxY2, boxX + 1, boxY2 + boxHeight, -14803426);
            graphics.fill(boxX + 1, boxY2 + boxHeight - 1, boxX + boxWidth, boxY2 + boxHeight, -10855846);
            graphics.fill(boxX + boxWidth - 1, boxY2 + 1, boxX + boxWidth, boxY2 + boxHeight, -10855846);
            if (this.workingCopycatConfig != null && this.workingCopycatConfig.getMaterial() != null) {
                Object blockName = this.workingCopycatConfig.getMaterial().getBlock().getName().getString();
                maxTextWidth = boxWidth - 85;
                if (this.font.width((String)blockName) > maxTextWidth) {
                    while (this.font.width((String)blockName + "...") > maxTextWidth && ((String)blockName).length() > 0) {
                        blockName = ((String)blockName).substring(0, ((String)blockName).length() - 1);
                    }
                    blockName = (String)blockName + "...";
                }
                materialText = Component.literal((String)"Select Material: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)blockName).withStyle(ChatFormatting.WHITE));
            } else {
                materialText = Component.literal((String)"Select Material: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"None").withStyle(ChatFormatting.DARK_GRAY));
            }
            graphics.drawString(this.font, (Component)materialText, boxX + 5, boxY2 + 6, 0xFFFFFF, false);
            int slotX4 = boxX + boxWidth + 10;
            slotY2 = boxY2 + 1;
            this.drawSlot(graphics, slotX4 - 1, slotY2 - 1);
            if (this.workingCopycatConfig != null && this.workingCopycatConfig.getMaterial() != null) {
                ItemStack materialStack = new ItemStack((ItemLike)this.workingCopycatConfig.getMaterial().getBlock());
                graphics.renderItem(materialStack, slotX4, slotY2);
            } else {
                int plusSize = 4;
                int centerX = slotX4 + 8;
                centerY = slotY2 + 8;
                graphics.fill(centerX, centerY - plusSize / 2, centerX + 1, centerY + plusSize / 2 + 1, -9013642);
                graphics.fill(centerX - plusSize / 2, centerY, centerX + plusSize / 2 + 1, centerY + 1, -9013642);
            }
            if (this.copycatConfigSlot >= 0 && this.copycatConfigSlot < ((PaletteMenu)this.menu).paletteSlots) {
                int row = this.copycatConfigSlot / 7;
                int col = this.copycatConfigSlot % 7;
                if (row >= this.scrollOffset && row < this.scrollOffset + this.visibleRows) {
                    highlightX = startX + col * (unitWidth + 3);
                    highlightY = this.calculatedGridY + (row - this.scrollOffset) * 29;
                    graphics.fill(highlightX - 1, highlightY - 1, highlightX + 18 + 1, highlightY, -3372801);
                    graphics.fill(highlightX - 1, highlightY + 18, highlightX + 18 + 1, highlightY + 18 + 1, -3372801);
                    graphics.fill(highlightX - 1, highlightY, highlightX, highlightY + 18, -3372801);
                    graphics.fill(highlightX + 18, highlightY, highlightX + 18 + 1, highlightY + 18, -3372801);
                }
            }
        }
        if (this.isConfiguringFramed) {
            boxX2 = this.leftPos + 10;
            boxY = this.dropdownY + 5;
            boxWidth2 = 183;
            int slotX5 = boxX2 + boxWidth2 + 10;
            int slotY4 = boxY + 1;
            if (mouseX >= slotX5 - 1 && mouseX < slotX5 + 17 && mouseY >= slotY4 - 1 && mouseY < slotY4 + 17) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                if (this.workingFramedConfig == null || this.workingFramedConfig.getCamo() == null) {
                    tooltip.add(Component.literal((String)"Click to set camo"));
                    tooltip.add(Component.literal((String)"Left-click any block").withStyle(ChatFormatting.GRAY));
                } else {
                    tooltip.add(Component.literal((String)this.workingFramedConfig.getCamo().getBlock().getName().getString()));
                    tooltip.add(Component.literal((String)"Click another block to change").withStyle(ChatFormatting.GRAY));
                }
                graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
        if (this.isConfiguringFramed) {
            MutableComponent camoText;
            boxWidth = 183;
            boxHeight = 20;
            boxX = this.leftPos + 10;
            int boxY3 = this.dropdownY + 5;
            graphics.fill(boxX, boxY3, boxX + boxWidth, boxY3 + boxHeight, -12829636);
            graphics.fill(boxX, boxY3, boxX + boxWidth, boxY3 + 1, -14803426);
            graphics.fill(boxX, boxY3, boxX + 1, boxY3 + boxHeight, -14803426);
            graphics.fill(boxX + 1, boxY3 + boxHeight - 1, boxX + boxWidth, boxY3 + boxHeight, -10855846);
            graphics.fill(boxX + boxWidth - 1, boxY3 + 1, boxX + boxWidth, boxY3 + boxHeight, -10855846);
            if (this.workingFramedConfig != null && this.workingFramedConfig.getCamo() != null) {
                Object blockName = this.workingFramedConfig.getCamo().getBlock().getName().getString();
                maxTextWidth = boxWidth - 85;
                if (this.font.width((String)blockName) > maxTextWidth) {
                    while (this.font.width((String)blockName + "...") > maxTextWidth && ((String)blockName).length() > 0) {
                        blockName = ((String)blockName).substring(0, ((String)blockName).length() - 1);
                    }
                    blockName = (String)blockName + "...";
                }
                camoText = Component.literal((String)"Select Camo: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)blockName).withStyle(ChatFormatting.WHITE));
            } else {
                camoText = Component.literal((String)"Select Camo: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"None").withStyle(ChatFormatting.DARK_GRAY));
            }
            graphics.drawString(this.font, (Component)camoText, boxX + 5, boxY3 + 6, 0xFFFFFF, false);
            int slotX6 = boxX + boxWidth + 10;
            slotY2 = boxY3 + 1;
            this.drawSlot(graphics, slotX6 - 1, slotY2 - 1);
            if (this.workingFramedConfig != null && this.workingFramedConfig.getCamo() != null) {
                ItemStack camoStack = new ItemStack((ItemLike)this.workingFramedConfig.getCamo().getBlock());
                graphics.renderItem(camoStack, slotX6, slotY2);
            } else {
                int plusSize = 4;
                int centerX = slotX6 + 8;
                centerY = slotY2 + 8;
                graphics.fill(centerX, centerY - plusSize / 2, centerX + 1, centerY + plusSize / 2 + 1, -9013642);
                graphics.fill(centerX - plusSize / 2, centerY, centerX + plusSize / 2 + 1, centerY + 1, -9013642);
            }
            if (this.framedConfigSlot >= 0 && this.framedConfigSlot < ((PaletteMenu)this.menu).paletteSlots) {
                int row = this.framedConfigSlot / 7;
                int col = this.framedConfigSlot % 7;
                if (row >= this.scrollOffset && row < this.scrollOffset + this.visibleRows) {
                    highlightX = startX + col * (unitWidth + 3);
                    highlightY = this.calculatedGridY + (row - this.scrollOffset) * 29;
                    graphics.fill(highlightX - 1, highlightY - 1, highlightX + 18 + 1, highlightY, -3372801);
                    graphics.fill(highlightX - 1, highlightY + 18, highlightX + 18 + 1, highlightY + 18 + 1, -3372801);
                    graphics.fill(highlightX - 1, highlightY, highlightX, highlightY + 18, -3372801);
                    graphics.fill(highlightX + 18, highlightY, highlightX + 18 + 1, highlightY + 18, -3372801);
                }
            }
        }
        this.renderTooltip(graphics, mouseX, mouseY);
        if (this.paletteSelector != null) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 300.0f);
            this.paletteSelector.renderDropdownOverlay(graphics, mouseX, mouseY);
            graphics.pose().popPose();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (InteractivePercentageBar bar : this.percentageBars) {
            if (!bar.isInTextInputMode()) continue;
            if (keyCode == 257) {
                bar.keyPressed(keyCode, scanCode, modifiers);
                return true;
            }
            if (keyCode == 256) {
                bar.keyPressed(keyCode, scanCode, modifiers);
                return true;
            }
            bar.keyPressed(keyCode, scanCode, modifiers);
            return true;
        }
        if (this.isRenaming) {
            if (keyCode == 257) {
                this.finishRename();
                return true;
            }
            if (keyCode == 256) {
                this.cancelRename();
                return true;
            }
            this.renameBox.keyPressed(keyCode, scanCode, modifiers);
            return true;
        }
        if (this.isDeleting) {
            if (keyCode == 256) {
                this.cancelDelete();
                return true;
            }
            return true;
        }
        if (this.isConfiguringCopycat) {
            if (keyCode == 256) {
                this.finishCopycatConfig();
                return true;
            }
            return true;
        }
        if (this.isConfiguringFramed) {
            if (keyCode == 256) {
                this.finishFramedConfig();
                return true;
            }
            return true;
        }
        if (keyCode == 256 && this.paletteSelector != null && this.paletteSelector.isOpen()) {
            this.paletteSelector.close();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        for (InteractivePercentageBar bar : this.percentageBars) {
            if (!bar.isInTextInputMode()) continue;
            bar.charTyped(codePoint, modifiers);
            return true;
        }
        if (this.isRenaming) {
            this.renameBox.charTyped(codePoint, modifiers);
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    protected void containerTick() {
        BlockItem blockItem;
        Item item;
        ItemStack slotItem;
        int i;
        super.containerTick();
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            if (this.rotationButton != null) {
                boolean hasActiveRotations = this.hasActiveRotationSettings();
                this.rotationButton.setToggled(hasActiveRotations);
                this.updateRotationButtonTooltip();
            }
            return;
        }
        TrowelData latestData = ((PaletteMenu)this.menu).getTrowelData();
        boolean dataChanged = false;
        if (this.trowelData.getPalettes().size() != latestData.getPalettes().size()) {
            dataChanged = true;
        }
        if (this.trowelData.getActivePaletteIndex() != latestData.getActivePaletteIndex()) {
            dataChanged = true;
        }
        if (this.currentPalette != null && this.currentPaletteIndex < latestData.getPalettes().size()) {
            boolean iconChanged;
            PaletteData latestPalette = latestData.getPalettes().get(this.currentPaletteIndex);
            if (!this.currentPalette.getName().equals(latestPalette.getName())) {
                dataChanged = true;
            }
            boolean bl = iconChanged = this.currentPalette.getIconBlock() == null && latestPalette.getIconBlock() != null || this.currentPalette.getIconBlock() != null && latestPalette.getIconBlock() == null || this.currentPalette.getIconBlock() != null && latestPalette.getIconBlock() != null && !this.currentPalette.getIconBlock().equals(latestPalette.getIconBlock());
            if (iconChanged) {
                dataChanged = true;
            }
            if (this.currentPalette.getBlocks().size() != latestPalette.getBlocks().size()) {
                dataChanged = true;
            }
            for (i = 0; i < latestPalette.getBlocks().size(); ++i) {
                if (i >= this.currentPalette.getBlocks().size()) continue;
                PaletteData.WeightedBlock currentBlock = this.currentPalette.getBlocks().get(i);
                PaletteData.WeightedBlock latestBlock = latestPalette.getBlocks().get(i);
                if (currentBlock.getSlotPosition() == latestBlock.getSlotPosition() && !(Math.abs(currentBlock.getWeight() - latestBlock.getWeight()) > 0.1f)) continue;
                dataChanged = true;
                break;
            }
        }
        if (dataChanged) {
            this.trowelData = latestData;
            this.currentPaletteIndex = this.trowelData.getActivePaletteIndex();
            this.currentPalette = this.trowelData.getActivePalette();
            if (this.isRenaming) {
                this.isRenaming = false;
            }
            if (this.isDeleting) {
                this.isDeleting = false;
            }
            if (this.isConfiguringCopycat) {
                this.isConfiguringCopycat = false;
                this.copycatConfigSlot = -1;
                this.workingCopycatConfig = null;
            }
            if (this.paletteSelector == null || !this.paletteSelector.isOpen()) {
                this.updateUI();
            } else {
                this.paletteSelector.setIconProvider(idx -> {
                    if (idx >= 0 && idx < this.trowelData.getPalettes().size()) {
                        return this.trowelData.getPalettes().get((int)idx).getIconBlock();
                    }
                    return null;
                });
            }
            if (this.paletteSelector != null) {
                this.paletteSelector.refreshDisplay();
            }
        }
        boolean containerChanged = false;
        if (this.currentPalette != null) {
            ItemStack containerItem;
            int containerBlockCount = 0;
            for (i = 0; i < ((PaletteMenu)this.menu).paletteSlots; ++i) {
                containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
                if (containerItem.isEmpty() || !(containerItem.getItem() instanceof BlockItem)) continue;
                ++containerBlockCount;
            }
            if (containerBlockCount != this.currentPalette.getBlocks().size()) {
                containerChanged = true;
                this.trowelData = latestData;
                this.currentPalette = this.trowelData.getActivePalette();
            }
            for (i = 0; i < ((PaletteMenu)this.menu).paletteSlots; ++i) {
                boolean barVisible;
                containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
                boolean hasBlock = !containerItem.isEmpty() && containerItem.getItem() instanceof BlockItem;
                if (hasBlock == (barVisible = this.percentageBars.get((int)i).visible)) continue;
                containerChanged = true;
                break;
            }
        }
        if (containerChanged || dataChanged) {
            this.trowelData = ((PaletteMenu)this.menu).getTrowelData();
            this.currentPalette = this.trowelData.getActivePalette();
            if (this.paletteSelector == null || !this.paletteSelector.isOpen()) {
                this.updateUI();
            } else {
                for (int i2 = 0; i2 < this.percentageBars.size(); ++i2) {
                    boolean hasBlock;
                    ItemStack containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i2);
                    boolean bl = hasBlock = !containerItem.isEmpty() && containerItem.getItem() instanceof BlockItem;
                    if (hasBlock && this.currentPalette != null) {
                        PaletteData.WeightedBlock paletteBlock = null;
                        for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                            if (block.getSlotPosition() != i2) continue;
                            paletteBlock = block;
                            break;
                        }
                        if (paletteBlock != null) {
                            this.percentageBars.get(i2).setVisible(true);
                            this.percentageBars.get((int)i2).active = true;
                            this.percentageBars.get(i2).setPercentage(Math.round(paletteBlock.getWeight()));
                            this.percentageBars.get(i2).setLocked(paletteBlock.isLocked());
                            this.lockButtons.get(i2).setLocked(paletteBlock.isLocked());
                            this.lockButtons.get((int)i2).visible = true;
                            continue;
                        }
                        this.percentageBars.get(i2).setPercentage(0);
                        this.percentageBars.get(i2).setVisible(false);
                        this.percentageBars.get((int)i2).active = false;
                        this.lockButtons.get((int)i2).visible = false;
                        continue;
                    }
                    this.percentageBars.get(i2).setPercentage(0);
                    this.percentageBars.get(i2).setVisible(false);
                    this.percentageBars.get((int)i2).active = false;
                    this.lockButtons.get((int)i2).visible = false;
                }
            }
            if (this.paletteSelector != null) {
                this.paletteSelector.refreshDisplay();
            }
        }
        if (this.rotationButton != null) {
            boolean hasActiveRotations = this.hasActiveRotationSettings();
            this.rotationButton.setToggled(hasActiveRotations);
            this.updateRotationButtonTooltip();
        }
        if (this.isConfiguringCopycat && this.copycatConfigSlot >= 0 && ((slotItem = ((PaletteMenu)this.menu).paletteContainer.getItem(this.copycatConfigSlot)).isEmpty() || !((item = slotItem.getItem()) instanceof BlockItem) || !CreateCompat.isCopycatBlock((blockItem = (BlockItem)item).getBlock()))) {
            this.finishCopycatConfig();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int slotIndex;
        int col;
        int actualRow;
        int row;
        int totalWidth;
        int unitWidth;
        int totalWidth2;
        int unitWidth2;
        int slotY;
        int slotX;
        int boxHeight;
        int boxWidth;
        int boxY;
        int boxX;
        if (this.canScroll && button == 0) {
            int scrollBarWidth = 6;
            int scrollBarX = this.leftPos + this.imageWidth - scrollBarWidth - 2;
            int scrollBarTop = this.calculatedGridY;
            int scrollBarHeight = this.visibleRows * 29 - 4;
            if (mouseX >= (double)scrollBarX && mouseX < (double)(scrollBarX + scrollBarWidth) && mouseY >= (double)scrollBarTop && mouseY < (double)(scrollBarTop + scrollBarHeight)) {
                this.isScrolling = true;
                return true;
            }
        }
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            boolean handled = this.paletteSelector.mouseClicked(mouseX, mouseY, button);
            if (!handled) {
                this.paletteSelector.close();
            }
            return true;
        }
        for (int i = 0; i < this.percentageBars.size(); ++i) {
            InteractivePercentageBar bar = this.percentageBars.get(i);
            if (!bar.visible) continue;
            if (bar.isInTextInputMode()) {
                if (bar.isMouseOver(mouseX, mouseY)) {
                    return bar.mouseClicked(mouseX, mouseY, button);
                }
                bar.keyPressed(256, 0, 0);
                return true;
            }
            if (!bar.active || !bar.isMouseOver(mouseX, mouseY)) continue;
            return bar.mouseClicked(mouseX, mouseY, button);
        }
        if (this.isConfiguringCopycat) {
            boxX = this.leftPos + 10;
            boxY = this.dropdownY + 5;
            boxWidth = 183;
            boxHeight = 20;
            slotX = boxX + boxWidth + 10;
            slotY = boxY + 1;
            boolean clickOnCopycatElements = mouseX >= (double)boxX && mouseX < (double)(boxX + boxWidth) && mouseY >= (double)boxY && mouseY < (double)(boxY + boxHeight) || mouseX >= (double)(slotX - 1) && mouseX < (double)(slotX + 17) && mouseY >= (double)(slotY - 1) && mouseY < (double)(slotY + 17) || this.copycatLitButton.isMouseOver(mouseX, mouseY) || this.copycatAxisButton.isMouseOver(mouseX, mouseY);
            for (Object widget : this.renderables) {
                Button btn;
                if (!(widget instanceof Button) || !(btn = (Button)widget).getMessage().getString().contains("\u2713") || !btn.visible || !btn.isMouseOver(mouseX, mouseY)) continue;
                clickOnCopycatElements = true;
                break;
            }
            boolean clickOnSlots = false;
            for (Slot slot : ((PaletteMenu)this.menu).slots) {
                if (!this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY)) continue;
                clickOnSlots = true;
                break;
            }
            if (!clickOnSlots) {
                int actualRow2;
                int unitWidth3 = 23;
                int totalWidth3 = unitWidth3 * 7 + 18;
                int paletteStartX = this.leftPos + (this.imageWidth - totalWidth3) / 2;
                for (int row2 = 0; row2 < this.visibleRows && (actualRow2 = row2 + this.scrollOffset) < ((PaletteMenu)this.menu).paletteRows; ++row2) {
                    int slotIndex2;
                    for (int col2 = 0; col2 < 7 && (slotIndex2 = actualRow2 * 7 + col2) < ((PaletteMenu)this.menu).paletteSlots; ++col2) {
                        int checkSlotX = paletteStartX + col2 * (unitWidth3 + 3);
                        int checkSlotY = this.calculatedGridY + row2 * 29;
                        if (!(mouseX >= (double)checkSlotX) || !(mouseX < (double)(checkSlotX + 18)) || !(mouseY >= (double)checkSlotY) || !(mouseY < (double)(checkSlotY + 18))) continue;
                        clickOnSlots = true;
                        break;
                    }
                    if (clickOnSlots) break;
                }
            }
            if (!clickOnCopycatElements && !clickOnSlots) {
                this.finishCopycatConfig();
                return true;
            }
        }
        if (this.isRenaming) {
            int remainingSpace = this.leftPos + this.imageWidth - (this.renameBox.getX() + this.renameBox.getWidth());
            int slotX2 = this.renameBox.getX() + this.renameBox.getWidth() + (remainingSpace - 18) / 2;
            int slotY2 = this.renameBox.getY() + 1;
            if (mouseX >= (double)(slotX2 - 1) && mouseX < (double)(slotX2 + 17) && mouseY >= (double)(slotY2 - 1) && mouseY < (double)(slotY2 + 17) && button == 1) {
                this.selectedIconBlock = null;
                this.iconContainer.setItem(0, ItemStack.EMPTY);
                return true;
            }
            boolean clickOnRenameElements = this.renameBox.isMouseOver(mouseX, mouseY) || this.confirmRenameButton.isMouseOver(mouseX, mouseY) || this.cancelRenameButton.isMouseOver(mouseX, mouseY) || mouseX >= (double)(slotX2 - 1) && mouseX < (double)(slotX2 + 17) && mouseY >= (double)(slotY2 - 1) && mouseY < (double)(slotY2 + 17);
            boolean clickOnSlots = false;
            unitWidth2 = 23;
            totalWidth2 = unitWidth2 * 7 + 18;
            int startX = this.leftPos + (this.imageWidth - totalWidth2) / 2;
            int gridY = this.calculatedGridY;
            for (int i2 = 0; i2 < ((PaletteMenu)this.menu).paletteSlots && i2 < ((PaletteMenu)this.menu).slots.size(); ++i2) {
                Slot slot = (Slot)((PaletteMenu)this.menu).slots.get(i2);
                if (!(slot instanceof GhostSlot) || slot.y < 0 || !(mouseX >= (double)slot.x) || !(mouseX < (double)(slot.x + 18)) || !(mouseY >= (double)slot.y) || !(mouseY < (double)(slot.y + 18))) continue;
                clickOnSlots = true;
                break;
            }
            if (!clickOnSlots) {
                for (Slot slot : ((PaletteMenu)this.menu).slots) {
                    if (!this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY)) continue;
                    clickOnSlots = true;
                    break;
                }
            }
            if (!clickOnRenameElements && !clickOnSlots) {
                this.cancelRename();
                return true;
            }
        }
        if (this.isDeleting) {
            boolean clickOnDeleteElements;
            boxX = this.paletteSelector.getX();
            boxY = this.paletteSelector.getY();
            boxWidth = 210;
            boxHeight = this.paletteSelector.getHeight();
            boolean bl = clickOnDeleteElements = this.confirmDeleteButton.isMouseOver(mouseX, mouseY) || this.cancelDeleteButton.isMouseOver(mouseX, mouseY) || mouseX >= (double)boxX && mouseX < (double)(boxX + boxWidth) && mouseY >= (double)boxY && mouseY < (double)(boxY + boxHeight);
            if (!clickOnDeleteElements) {
                this.cancelDelete();
                return true;
            }
        }
        if (this.isConfiguringCopycat) {
            int actualRow3;
            boxX = this.leftPos + 10;
            boxY = this.dropdownY + 5;
            boxWidth = 183;
            int slotX3 = boxX + boxWidth + 10;
            int slotY3 = boxY + 1;
            if (mouseX >= (double)(slotX3 - 1) && mouseX < (double)(slotX3 + 17) && mouseY >= (double)(slotY3 - 1) && mouseY < (double)(slotY3 + 17)) {
                return true;
            }
            for (int i = 0; i < ((PaletteMenu)this.menu).slots.size(); ++i) {
                Item i2;
                ItemStack stack;
                Slot slot = (Slot)((PaletteMenu)this.menu).slots.get(i);
                if (!(slot.container instanceof Inventory) || !this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY) || (stack = slot.getItem()).isEmpty() || !((i2 = stack.getItem()) instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)i2;
                if (!CreateCompat.isValidCopycatMaterial(blockItem.getBlock())) {
                    if (this.minecraft != null && this.minecraft.player != null) {
                        this.minecraft.player.playSound(SoundEvents.ITEM_BREAK, 0.5f, 1.5f);
                    }
                    return true;
                }
                if (this.workingCopycatConfig != null) {
                    this.workingCopycatConfig.setMaterial(blockItem.getBlock().defaultBlockState());
                    this.updateCopycatConfigButtons();
                }
                return true;
            }
            unitWidth2 = 23;
            totalWidth2 = unitWidth2 * 7 + 18;
            int paletteStartX = this.leftPos + (this.imageWidth - totalWidth2) / 2;
            for (int row3 = 0; row3 < this.visibleRows && (actualRow3 = row3 + this.scrollOffset) < ((PaletteMenu)this.menu).paletteRows; ++row3) {
                int slotIndex3;
                for (int col3 = 0; col3 < 7 && (slotIndex3 = actualRow3 * 7 + col3) < ((PaletteMenu)this.menu).paletteSlots; ++col3) {
                    Item checkSlotY;
                    ItemStack slotItem;
                    int checkSlotX = paletteStartX + col3 * (unitWidth2 + 3);
                    int checkSlotY2 = this.calculatedGridY + row3 * 29;
                    if (!(mouseX >= (double)checkSlotX) || !(mouseX < (double)(checkSlotX + 18)) || !(mouseY >= (double)checkSlotY2) || !(mouseY < (double)(checkSlotY2 + 18)) || (slotItem = ((PaletteMenu)this.menu).paletteContainer.getItem(slotIndex3)).isEmpty() || !((checkSlotY = slotItem.getItem()) instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)checkSlotY;
                    if (slotIndex3 == this.copycatConfigSlot) continue;
                    if (!CreateCompat.isValidCopycatMaterial(blockItem.getBlock())) {
                        if (this.minecraft != null && this.minecraft.player != null) {
                            this.minecraft.player.playSound(SoundEvents.ITEM_BREAK, 0.5f, 1.5f);
                        }
                        return true;
                    }
                    if (this.workingCopycatConfig != null) {
                        this.workingCopycatConfig.setMaterial(blockItem.getBlock().defaultBlockState());
                        this.updateCopycatConfigButtons();
                    }
                    return true;
                }
            }
        }
        if (this.isConfiguringFramed) {
            int actualRow4;
            boxX = this.leftPos + 10;
            boxY = this.dropdownY + 5;
            boxWidth = 183;
            boxHeight = 20;
            slotX = boxX + boxWidth + 10;
            slotY = boxY + 1;
            if (mouseX >= (double)(slotX - 1) && mouseX < (double)(slotX + 17) && mouseY >= (double)(slotY - 1) && mouseY < (double)(slotY + 17)) {
                return true;
            }
            for (int i = 0; i < ((PaletteMenu)this.menu).slots.size(); ++i) {
                Item col3;
                ItemStack stack;
                Slot slot = (Slot)((PaletteMenu)this.menu).slots.get(i);
                if (!(slot.container instanceof Inventory) || !this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY) || (stack = slot.getItem()).isEmpty() || !((col3 = stack.getItem()) instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)col3;
                if (!FramedBlocksCompat.isValidFramedCamo(blockItem.getBlock())) {
                    if (this.minecraft != null && this.minecraft.player != null) {
                        this.minecraft.player.playSound(SoundEvents.ITEM_BREAK, 0.5f, 1.5f);
                    }
                    return true;
                }
                if (this.workingFramedConfig != null) {
                    this.workingFramedConfig.setCamo(blockItem.getBlock().defaultBlockState());
                }
                return true;
            }
            int unitWidth4 = 23;
            int totalWidth4 = unitWidth4 * 7 + 18;
            int paletteStartX = this.leftPos + (this.imageWidth - totalWidth4) / 2;
            for (int row4 = 0; row4 < this.visibleRows && (actualRow4 = row4 + this.scrollOffset) < ((PaletteMenu)this.menu).paletteRows; ++row4) {
                int slotIndex4;
                for (int col4 = 0; col4 < 7 && (slotIndex4 = actualRow4 * 7 + col4) < ((PaletteMenu)this.menu).paletteSlots; ++col4) {
                    Item item;
                    ItemStack slotItem;
                    int checkSlotX = paletteStartX + col4 * (unitWidth4 + 3);
                    int checkSlotY = this.calculatedGridY + row4 * 29;
                    if (!(mouseX >= (double)checkSlotX) || !(mouseX < (double)(checkSlotX + 18)) || !(mouseY >= (double)checkSlotY) || !(mouseY < (double)(checkSlotY + 18)) || (slotItem = ((PaletteMenu)this.menu).paletteContainer.getItem(slotIndex4)).isEmpty() || !((item = slotItem.getItem()) instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)item;
                    if (slotIndex4 == this.framedConfigSlot) continue;
                    if (!FramedBlocksCompat.isValidFramedCamo(blockItem.getBlock())) {
                        if (this.minecraft != null && this.minecraft.player != null) {
                            this.minecraft.player.playSound(SoundEvents.ITEM_BREAK, 0.5f, 1.5f);
                        }
                        return true;
                    }
                    if (this.workingFramedConfig != null) {
                        this.workingFramedConfig.setCamo(blockItem.getBlock().defaultBlockState());
                    }
                    return true;
                }
            }
        }
        if (this.isRenaming) {
            unitWidth = 23;
            totalWidth = unitWidth * 7 + 18;
            int paletteStartX = this.leftPos + (this.imageWidth - totalWidth) / 2;
            for (row = 0; row < this.visibleRows && (actualRow = row + this.scrollOffset) < ((PaletteMenu)this.menu).paletteRows; ++row) {
                for (col = 0; col < 7 && (slotIndex = actualRow * 7 + col) < ((PaletteMenu)this.menu).paletteSlots; ++col) {
                    Item item;
                    ItemStack slotItem;
                    int checkSlotX = paletteStartX + col * (unitWidth + 3);
                    int checkSlotY = this.calculatedGridY + row * 29;
                    if (!(mouseX >= (double)checkSlotX) || !(mouseX < (double)(checkSlotX + 18)) || !(mouseY >= (double)checkSlotY) || !(mouseY < (double)(checkSlotY + 18)) || (slotItem = ((PaletteMenu)this.menu).paletteContainer.getItem(slotIndex)).isEmpty() || !((item = slotItem.getItem()) instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)item;
                    this.selectedIconBlock = blockItem.getBlock().defaultBlockState();
                    this.iconContainer.setItem(0, new ItemStack((ItemLike)blockItem));
                    return true;
                }
            }
            for (int i = 0; i < ((PaletteMenu)this.menu).slots.size(); ++i) {
                Item checkSlotX;
                ItemStack stack;
                Slot slot = (Slot)((PaletteMenu)this.menu).slots.get(i);
                if (!(slot.container instanceof Inventory) || !this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY) || (stack = slot.getItem()).isEmpty() || !((checkSlotX = stack.getItem()) instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)checkSlotX;
                this.selectedIconBlock = blockItem.getBlock().defaultBlockState();
                this.iconContainer.setItem(0, new ItemStack((ItemLike)blockItem));
                return true;
            }
        }
        if (button == 0 && !this.isConfiguringCopycat && !this.isConfiguringFramed) {
            unitWidth = 23;
            totalWidth = unitWidth * 7 + 18;
            int startX = this.leftPos + (this.imageWidth - totalWidth) / 2;
            for (row = 0; row < this.visibleRows && (actualRow = row + this.scrollOffset) < ((PaletteMenu)this.menu).paletteRows; ++row) {
                for (col = 0; col < 7 && (slotIndex = actualRow * 7 + col) < ((PaletteMenu)this.menu).paletteSlots; ++col) {
                    Item item;
                    int slotX4 = startX + col * (unitWidth + 3);
                    int slotY4 = this.calculatedGridY + row * 29;
                    if (!(mouseX >= (double)slotX4) || !(mouseX < (double)(slotX4 + 18)) || !(mouseY >= (double)slotY4) || !(mouseY < (double)(slotY4 + 18))) continue;
                    ItemStack slotItem = ((PaletteMenu)this.menu).paletteContainer.getItem(slotIndex);
                    if (!slotItem.isEmpty() && (item = slotItem.getItem()) instanceof BlockItem) {
                        BlockItem blockItem = (BlockItem)item;
                        if (CreateCompat.isCopycatBlock(blockItem.getBlock())) {
                            this.openCopycatConfig(slotIndex);
                            return true;
                        }
                        if (FramedBlocksCompat.isFramedBlock(blockItem.getBlock())) {
                            this.openFramedConfig(slotIndex);
                            return true;
                        }
                    }
                    return false;
                }
            }
        }
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot instanceof GhostSlot) {
            super.slotClicked(slot, slotId, mouseButton, type);
            return;
        }
        super.slotClicked(slot, slotId, mouseButton, type);
        if (slotId >= 0 && slotId < ((PaletteMenu)this.menu).paletteSlots) {
            this.trowelData = ((PaletteMenu)this.menu).getTrowelData();
            this.currentPalette = this.trowelData.getActivePalette();
            this.updateUI();
        }
    }

    public void onClose() {
        super.onClose();
    }

    private void calculateVisibleRows() {
        this.visibleRows = Math.min(4, ((PaletteMenu)this.menu).paletteRows);
        int screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        int fixedHeight = PaletteLayoutConstants.DROPDOWN_SECTION.getTotalHeight() + PaletteLayoutConstants.BUTTONS_SECTION.getTotalHeight() + PaletteLayoutConstants.CONTROLS_SECTION.getTotalHeight() + PaletteLayoutConstants.GLOBAL_SECTION.getTotalHeight() + PaletteLayoutConstants.INVENTORY_SECTION.getTotalHeight();
        int paletteHeight = this.visibleRows * 29;
        int totalRequiredHeight = fixedHeight + paletteHeight + 40;
        while (this.visibleRows > 2 && totalRequiredHeight > screenHeight) {
            --this.visibleRows;
            paletteHeight = this.visibleRows * 29;
            totalRequiredHeight = fixedHeight + paletteHeight + 40;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        for (int i = 0; i < this.percentageBars.size(); ++i) {
            InteractivePercentageBar bar = this.percentageBars.get(i);
            int row = i / 7;
            if (row < this.scrollOffset || row >= this.scrollOffset + this.visibleRows) continue;
            double adjustedMouseY = mouseY + (double)(this.scrollOffset * 29);
            if (!bar.visible || !bar.active || !bar.mouseScrolled(mouseX, adjustedMouseY, deltaX, deltaY)) continue;
            return true;
        }
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            return this.paletteSelector.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        if (this.canScroll && this.isMouseInPaletteArea(mouseX, mouseY)) {
            double scrollAmount = deltaY;
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.maxScrollOffset, (double)this.scrollOffset - scrollAmount));
            ((PaletteMenu)this.menu).updateScrollOffset(this.scrollOffset);
            this.applyScrollToWidgets();
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private boolean isMouseInPaletteArea(double mouseX, double mouseY) {
        int paletteTop = this.calculatedGridY;
        int paletteBottom = this.calculatedGridY + this.visibleRows * 29;
        return mouseX >= (double)this.leftPos && mouseX < (double)(this.leftPos + this.imageWidth) && mouseY >= (double)paletteTop && mouseY < (double)paletteBottom;
    }

    private void drawScrollBar(GuiGraphics graphics, int mouseX, int mouseY) {
        int scrollBarWidth = 6;
        int scrollBarX = this.leftPos + this.imageWidth - scrollBarWidth - 2;
        int scrollBarTop = this.calculatedGridY;
        int scrollBarHeight = this.visibleRows * 29 - 4;
        graphics.fill(scrollBarX, scrollBarTop, scrollBarX + scrollBarWidth, scrollBarTop + scrollBarHeight, -11184811);
        float scrollPercent = this.maxScrollOffset > 0 ? (float)this.scrollOffset / (float)this.maxScrollOffset : 0.0f;
        int thumbHeight = Math.max(20, (int)((float)this.visibleRows / (float)((PaletteMenu)this.menu).paletteRows * (float)scrollBarHeight));
        int thumbY = scrollBarTop + (int)((float)(scrollBarHeight - thumbHeight) * scrollPercent);
        boolean isHoveringThumb = mouseX >= scrollBarX && mouseX < scrollBarX + scrollBarWidth && mouseY >= thumbY && mouseY < thumbY + thumbHeight;
        int thumbColor = isHoveringThumb || this.isScrolling ? -5592406 : -7829368;
        graphics.fill(scrollBarX, thumbY, scrollBarX + scrollBarWidth, thumbY + thumbHeight, thumbColor);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.paletteSelector != null && this.paletteSelector.isOpen() && this.paletteSelector.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.isScrolling && this.canScroll) {
            int scrollBarTop = this.calculatedGridY;
            int scrollBarHeight = this.visibleRows * 29 - 4;
            int thumbHeight = Math.max(20, (int)((float)this.visibleRows / (float)((PaletteMenu)this.menu).paletteRows * (float)scrollBarHeight));
            double scrollRange = scrollBarHeight - thumbHeight;
            double scrollPercent = (mouseY - (double)scrollBarTop - (double)thumbHeight / 2.0) / scrollRange;
            scrollPercent = Math.max(0.0, Math.min(1.0, scrollPercent));
            this.scrollOffset = (int)((double)this.maxScrollOffset * scrollPercent);
            ((PaletteMenu)this.menu).updateScrollOffset(this.scrollOffset);
            this.applyScrollToWidgets();
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.paletteSelector != null) {
            this.paletteSelector.mouseReleased(mouseX, mouseY, button);
        }
        if (button == 0) {
            this.isScrolling = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected void renderSlot(GuiGraphics graphics, Slot slot) {
        if (slot instanceof GhostSlot && slot.index < ((PaletteMenu)this.menu).paletteSlots) {
            if (slot.y < 0) {
                return;
            }
            int x = slot.x;
            int y = slot.y;
            ItemStack stack = slot.getItem();
            boolean hasConfiguredCamo = false;
            if (this.currentPalette != null && !stack.isEmpty()) {
                for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                    if (block.getSlotPosition() != slot.index) continue;
                    if (block.getCopycatConfig() != null && block.getCopycatConfig().isConfigured()) {
                        hasConfiguredCamo = true;
                    }
                    if (block.getFramedConfig() == null || !block.getFramedConfig().isConfigured()) break;
                    hasConfiguredCamo = true;
                    break;
                }
            }
            if (hasConfiguredCamo && this.hoveredSlot != slot) {
                graphics.fill(x - 1, y - 1, x + 17, y + 17, -2134079233);
            }
            if (this.hoveredSlot == slot && slot.isActive()) {
                graphics.fill(x - 1, y - 1, x + 17, y + 17, -2130706433);
            }
            graphics.renderItem(stack, x, y);
            graphics.renderItemDecorations(this.font, stack, x, y);
        } else {
            super.renderSlot(graphics, slot);
        }
    }

    private boolean isSlotHovered(Slot slot, double mouseX, double mouseY) {
        if (slot instanceof GhostSlot && slot.index < ((PaletteMenu)this.menu).paletteSlots && slot.y < 0) {
            return false;
        }
        return this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY);
    }

    private void applyScrollToWidgets() {
        for (int i = 0; i < this.percentageBars.size() && i < this.lockButtons.size() && i < ((PaletteMenu)this.menu).slots.size(); ++i) {
            boolean hasBlock;
            Slot slot = (Slot)((PaletteMenu)this.menu).slots.get(i);
            if (!(slot instanceof GhostSlot)) continue;
            InteractivePercentageBar bar = this.percentageBars.get(i);
            VerticalLockToggle lock = this.lockButtons.get(i);
            if (slot.y < 0) {
                bar.visible = false;
                lock.visible = false;
                continue;
            }
            int screenX = this.leftPos + slot.x;
            int screenY = this.topPos + slot.y;
            bar.setX(screenX - 1);
            bar.setY(screenY + 18 + 2 - 2 - 1);
            lock.setX(screenX + 18 - 1);
            lock.setY(screenY + -1);
            ItemStack containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
            boolean bl = hasBlock = !containerItem.isEmpty() && containerItem.getItem() instanceof BlockItem;
            if (hasBlock && this.currentPalette != null) {
                PaletteData.WeightedBlock paletteBlock = null;
                for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                    if (block.getSlotPosition() != i) continue;
                    paletteBlock = block;
                    break;
                }
                if (paletteBlock != null) {
                    bar.visible = true;
                    lock.visible = true;
                    continue;
                }
                bar.visible = false;
                lock.visible = false;
                continue;
            }
            bar.visible = false;
            lock.visible = false;
        }
    }

    private void restoreWidgetPositions() {
    }

    public boolean isPauseScreen() {
        return false;
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getTopPos() {
        return this.topPos;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public int getCalculatedGridY() {
        return this.calculatedGridY;
    }

    private void openCopycatConfig(int slot) {
        PaletteData.WeightedBlock paletteBlock = null;
        if (this.currentPalette != null) {
            for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                if (block.getSlotPosition() != slot) continue;
                paletteBlock = block;
                break;
            }
        }
        if (paletteBlock == null) {
            return;
        }
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            this.paletteSelector.close();
        }
        this.isConfiguringCopycat = true;
        this.copycatConfigSlot = slot;
        if (paletteBlock.getCopycatConfig() != null) {
            this.workingCopycatConfig = new CopycatBlockConfig();
            this.workingCopycatConfig.setMaterial(paletteBlock.getCopycatConfig().getMaterial());
            this.workingCopycatConfig.setLit(paletteBlock.getCopycatConfig().isLit());
            this.workingCopycatConfig.setAxisMode(paletteBlock.getCopycatConfig().getAxisMode());
        } else {
            this.workingCopycatConfig = new CopycatBlockConfig();
        }
        this.updateCopycatConfigButtons();
        this.updateUI();
    }

    private void finishCopycatConfig() {
        if (this.workingCopycatConfig == null || this.copycatConfigSlot == -1) {
            this.isConfiguringCopycat = false;
            this.copycatConfigSlot = -1;
            this.workingCopycatConfig = null;
            this.updateUI();
            return;
        }
        this.onCopycatConfigChanged(this.copycatConfigSlot, this.workingCopycatConfig);
        this.isConfiguringCopycat = false;
        this.copycatConfigSlot = -1;
        this.workingCopycatConfig = null;
        this.updateUI();
    }

    private void toggleCopycatLit() {
        if (this.workingCopycatConfig != null) {
            this.workingCopycatConfig.setLit(!this.workingCopycatConfig.isLit());
            this.updateCopycatConfigButtons();
        }
    }

    private void cycleCopycatAxis() {
        if (this.workingCopycatConfig != null) {
            this.workingCopycatConfig.setAxisMode(this.workingCopycatConfig.getAxisMode().next());
            this.updateCopycatConfigButtons();
        }
    }

    public void updateCopycatConfigButtons() {
        if (this.workingCopycatConfig == null) {
            return;
        }
        if (this.copycatLitButton != null) {
            boolean supportsLit = false;
            if (this.workingCopycatConfig.getMaterial() != null) {
                supportsLit = CreateCompat.supportsLitProperty(this.workingCopycatConfig.getMaterial());
            }
            if (!supportsLit && this.workingCopycatConfig.isLit()) {
                this.workingCopycatConfig.setLit(false);
            }
            if (supportsLit && this.workingCopycatConfig.isLit()) {
                this.copycatLitButton.setMessage((Component)Component.literal((String)"Lit ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)"\u2600").withStyle(ChatFormatting.YELLOW)));
            } else {
                this.copycatLitButton.setMessage((Component)Component.literal((String)"Lit ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"\u2600").withStyle(ChatFormatting.DARK_GRAY)));
            }
            this.copycatLitButton.active = supportsLit;
        }
        if (this.copycatAxisButton != null) {
            boolean supportsAxis = false;
            if (this.workingCopycatConfig.getMaterial() != null) {
                supportsAxis = CreateCompat.supportsAxisProperty(this.workingCopycatConfig.getMaterial());
            }
            if (!supportsAxis && this.workingCopycatConfig.getAxisMode() != CopycatBlockConfig.AxisMode.OFF) {
                this.workingCopycatConfig.setAxisMode(CopycatBlockConfig.AxisMode.OFF);
            }
            String axisText = "Axis: " + this.workingCopycatConfig.getAxisMode().getDisplayName();
            if (supportsAxis && this.workingCopycatConfig.getAxisMode() != CopycatBlockConfig.AxisMode.OFF) {
                this.copycatAxisButton.setMessage((Component)Component.literal((String)axisText).withStyle(ChatFormatting.WHITE));
            } else {
                this.copycatAxisButton.setMessage((Component)Component.literal((String)axisText).withStyle(ChatFormatting.GRAY));
            }
            this.copycatAxisButton.active = supportsAxis;
        }
    }

    private void onCopycatConfigChanged(int slot, CopycatBlockConfig config) {
        if (this.currentPalette == null) {
            return;
        }
        PaletteData.WeightedBlock paletteBlock = null;
        for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
            if (block.getSlotPosition() != slot) continue;
            paletteBlock = block;
            break;
        }
        if (paletteBlock != null) {
            paletteBlock.setCopycatConfig(config);
            this.savePalette();
            CompoundTag updateTag = new CompoundTag();
            updateTag.putInt("slot", slot);
            CompoundTag configTag = new CompoundTag();
            config.save(configTag);
            updateTag.put("config", (Tag)configTag);
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UPDATE_COPYCAT_CONFIG, this.currentPaletteIndex, updateTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void openFramedConfig(int slot) {
        PaletteData.WeightedBlock paletteBlock = null;
        if (this.currentPalette != null) {
            for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                if (block.getSlotPosition() != slot) continue;
                paletteBlock = block;
                break;
            }
        }
        if (paletteBlock == null) {
            return;
        }
        if (this.isConfiguringCopycat || this.isRenaming || this.isDeleting) {
            return;
        }
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            this.paletteSelector.close();
        }
        this.isConfiguringFramed = true;
        this.framedConfigSlot = slot;
        if (paletteBlock.getFramedConfig() != null) {
            this.workingFramedConfig = new FramedBlockConfig();
            this.workingFramedConfig.setCamo(paletteBlock.getFramedConfig().getCamo());
        } else {
            this.workingFramedConfig = new FramedBlockConfig();
        }
        this.framedInstructionText = Component.literal((String)"Drag a block from your inventory or JEI to set camo");
        this.updateUI();
    }

    private void finishFramedConfig() {
        if (this.workingFramedConfig == null || this.framedConfigSlot == -1) {
            this.isConfiguringFramed = false;
            this.framedConfigSlot = -1;
            this.workingFramedConfig = null;
            this.updateUI();
            return;
        }
        this.onFramedConfigChanged(this.framedConfigSlot, this.workingFramedConfig);
        this.isConfiguringFramed = false;
        this.framedConfigSlot = -1;
        this.workingFramedConfig = null;
        this.updateUI();
    }

    private void onFramedConfigChanged(int slot, FramedBlockConfig config) {
        if (this.currentPalette == null) {
            return;
        }
        PaletteData.WeightedBlock paletteBlock = null;
        for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
            if (block.getSlotPosition() != slot) continue;
            paletteBlock = block;
            break;
        }
        if (paletteBlock != null) {
            paletteBlock.setFramedConfig(config);
            this.savePalette();
            CompoundTag updateTag = new CompoundTag();
            updateTag.putInt("slot", slot);
            CompoundTag configTag = new CompoundTag();
            config.save(configTag);
            updateTag.put("config", (Tag)configTag);
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UPDATE_FRAMED_CONFIG, this.currentPaletteIndex, updateTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isConfiguringFramed() {
        return this.isConfiguringFramed;
    }

    public FramedBlockConfig getWorkingFramedConfig() {
        return this.workingFramedConfig;
    }

    public boolean isRenaming() {
        return this.isRenaming;
    }

    public boolean isConfiguringCopycat() {
        return this.isConfiguringCopycat;
    }

    public EditBox getRenameBox() {
        return this.renameBox;
    }

    public void setSelectedIconBlock(BlockState blockState) {
        this.selectedIconBlock = blockState;
    }

    public SimpleContainer getIconContainer() {
        return this.iconContainer;
    }

    public int getDropdownY() {
        return this.dropdownY;
    }

    public CopycatBlockConfig getWorkingCopycatConfig() {
        return this.workingCopycatConfig;
    }
}

