/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui;

import com.asger.mechtrowel.compat.framedblocks.FramedBlocksCompat;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.RotationLockData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.gui.RotationMenu;
import com.asger.mechtrowel.gui.widget.Block3DPreview;
import com.asger.mechtrowel.gui.widget.NoFocusButton;
import com.asger.mechtrowel.gui.widget.StyledRadioButton;
import com.asger.mechtrowel.gui.widget.StyledToggleButton;
import com.asger.mechtrowel.network.TrowelPacket;
import com.asger.mechtrowel.util.CopycatRenderHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class RotationScreen
extends AbstractContainerScreen<RotationMenu> {
    private static final int GUI_WIDTH = 230;
    private static final int GUI_HEIGHT = 245;
    private static final int TITLE_HEIGHT = 30;
    private static final int PREVIEW_HEIGHT = 165;
    private static final int CONTROLS_HEIGHT = 50;
    private static final int PREVIEW_SIZE = 80;
    private static final int BG_COLOR = -3750202;
    private static final int BORDER_LIGHT = -1;
    private static final int BORDER_DARK = -11184811;
    private static final int SEPARATOR_COLOR = -8355712;
    private TrowelData trowelData;
    private RotationLockData rotationData;
    private Block3DPreview blockPreview;
    private final Map<Direction, StyledToggleButton> directionButtons = new HashMap<Direction, StyledToggleButton>();
    private StyledToggleButton topButton;
    private StyledToggleButton bottomButton;
    private StyledToggleButton leftButton;
    private StyledToggleButton rightButton;
    private StyledToggleButton upButton;
    private StyledToggleButton downButton;
    private StyledRadioButton.RadioButtonGroup stairGroup;
    private StyledRadioButton.RadioButtonGroup slabGroup;
    private StyledToggleButton stairLinkButton;
    private Button resetButton;
    private Button dynamicRotationToggle;
    private Button helpButton;
    private List<BlockState> availableBlocks = new ArrayList<BlockState>();
    private List<PaletteData.WeightedBlock> availableWeightedBlocks = new ArrayList<PaletteData.WeightedBlock>();
    private int currentBlockIndex = 0;
    private long lastCycleTime = 0L;
    private static final long CYCLE_INTERVAL = 3000L;
    private boolean isShowingStairs = false;
    private boolean isShowingSlabs = false;
    private final Player player;
    private Direction lastPlayerFacing = null;

    public RotationScreen(RotationMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 230;
        this.imageHeight = 245;
        this.trowelData = menu.getTrowelData();
        this.rotationData = this.trowelData.getRotationLockData();
        this.player = playerInventory.player;
        this.stairGroup = new StyledRadioButton.RadioButtonGroup();
        this.slabGroup = new StyledRadioButton.RadioButtonGroup();
        this.updateAvailableBlocks();
    }

    protected void init() {
        super.init();
        int centerX = this.leftPos + this.imageWidth / 2;
        int y = this.topPos;
        this.resetButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"R"), btn -> {
            this.resetAllLocks();
            this.resetToNormalCycling();
            if (this.blockPreview != null) {
                this.blockPreview.resetViewRotation();
                this.blockPreview.resetZoom();
                this.blockPreview.resumeCycling();
            }
            this.lastPlayerFacing = null;
            if (this.rotationData.isDynamicRotation()) {
                this.updateDirectionButtonsForModeChange();
            }
        }).bounds(this.leftPos + 8, y + 5, 20, 19).build();
        this.addRenderableWidget((GuiEventListener)this.resetButton);
        this.dynamicRotationToggle = NoFocusButton.noFocusBuilder((Component)Component.literal((String)(this.rotationData.isDynamicRotation() ? "D" : "S")), btn -> {
            this.rotationData.setDynamicRotation(!this.rotationData.isDynamicRotation());
            btn.setMessage((Component)Component.literal((String)(this.rotationData.isDynamicRotation() ? "D" : "S")));
            this.lastPlayerFacing = null;
            this.updateDirectionButtonsForModeChange();
            this.updatePreview();
            this.saveRotationData();
        }).bounds(this.leftPos + this.imageWidth - 28, y + 5, 20, 19).build();
        this.addRenderableWidget((GuiEventListener)this.dynamicRotationToggle);
        this.helpButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"?"), btn -> {}).bounds(this.leftPos + this.imageWidth - 20, this.topPos + this.imageHeight - 20, 15, 15).tooltip(this.createHelpTooltip()).build();
        this.addRenderableWidget((GuiEventListener)this.helpButton);
        int previewY = y + 30;
        int previewSectionHeight = 165;
        int previewCenterY = previewY + previewSectionHeight / 2 - 12;
        int previewX = centerX - 40;
        int previewBoxY = previewCenterY - 40;
        BlockState initialBlock = this.getCurrentPreviewBlock();
        this.blockPreview = new Block3DPreview(previewX, previewBoxY, 80, 80, initialBlock);
        this.blockPreview.setWeightedBlock(this.getCurrentWeightedBlock());
        this.blockPreview.setPlayer(this.player);
        this.blockPreview.setPlayerYaw(this.player.getYRot());
        this.blockPreview.setRotationData(this.rotationData);
        this.blockPreview.setTrowelData(this.trowelData);
        this.addRenderableWidget((GuiEventListener)this.blockPreview);
        this.createDirectionButtons(centerX, previewCenterY);
        if (this.rotationData.isDynamicRotation()) {
            this.lastPlayerFacing = this.getPlayerFacing(this.player.getYRot());
        }
        int controlsY = y + 30 + 165 + 8;
        int controlsSeparatorY = controlsY - 5;
        int controlsAreaStart = controlsSeparatorY + 2;
        int stairY = controlsAreaStart + 3;
        int buttonWidth = 40;
        int smallButtonWidth = 35;
        int buttonSpacing = 3;
        int labelWidth = 45;
        int stairStartX = this.leftPos + 10 + labelWidth;
        StyledRadioButton stairAutoButton = new StyledRadioButton(stairStartX, stairY, buttonWidth, 18, (Component)Component.literal((String)"Auto"), this.rotationData.getStairMode() == RotationLockData.StairMode.AUTO, btn -> {
            this.rotationData.setStairMode(RotationLockData.StairMode.AUTO);
            this.showStairs();
            this.updatePreview();
            this.saveRotationData();
        });
        this.stairGroup.add(stairAutoButton);
        this.addRenderableWidget((GuiEventListener)stairAutoButton);
        StyledRadioButton stairTopButton = new StyledRadioButton(stairStartX + buttonWidth + buttonSpacing, stairY, smallButtonWidth, 18, (Component)Component.literal((String)"Top"), this.rotationData.getStairMode() == RotationLockData.StairMode.TOP, btn -> {
            this.rotationData.setStairMode(RotationLockData.StairMode.TOP);
            this.showStairs();
            this.updatePreview();
            this.saveRotationData();
        });
        this.stairGroup.add(stairTopButton);
        this.addRenderableWidget((GuiEventListener)stairTopButton);
        StyledRadioButton stairBottomButton = new StyledRadioButton(stairStartX + buttonWidth + smallButtonWidth + buttonSpacing * 2, stairY, smallButtonWidth, 18, (Component)Component.literal((String)"Bot"), this.rotationData.getStairMode() == RotationLockData.StairMode.BOTTOM, btn -> {
            this.rotationData.setStairMode(RotationLockData.StairMode.BOTTOM);
            this.showStairs();
            this.updatePreview();
            this.saveRotationData();
        });
        this.stairGroup.add(stairBottomButton);
        this.addRenderableWidget((GuiEventListener)stairBottomButton);
        this.stairLinkButton = new StyledToggleButton(stairStartX + buttonWidth + smallButtonWidth * 2 + buttonSpacing * 3, stairY, smallButtonWidth, 18, (Component)Component.literal((String)"Link"), this.rotationData.isStairLink(), value -> {
            this.rotationData.setStairLink((boolean)value);
            if (this.isShowingStairs) {
                this.showStairs();
            }
            this.saveRotationData();
        });
        this.addRenderableWidget((GuiEventListener)this.stairLinkButton);
        int slabY = stairY + 20;
        StyledRadioButton slabAutoButton = new StyledRadioButton(stairStartX, slabY, buttonWidth, 18, (Component)Component.literal((String)"Auto"), this.rotationData.getSlabMode() == RotationLockData.SlabMode.AUTO, btn -> {
            this.rotationData.setSlabMode(RotationLockData.SlabMode.AUTO);
            this.showSlabs();
            this.updatePreview();
            this.saveRotationData();
        });
        this.slabGroup.add(slabAutoButton);
        this.addRenderableWidget((GuiEventListener)slabAutoButton);
        StyledRadioButton slabTopButton = new StyledRadioButton(stairStartX + buttonWidth + buttonSpacing, slabY, smallButtonWidth, 18, (Component)Component.literal((String)"Top"), this.rotationData.getSlabMode() == RotationLockData.SlabMode.TOP, btn -> {
            this.rotationData.setSlabMode(RotationLockData.SlabMode.TOP);
            this.showSlabs();
            this.updatePreview();
            this.saveRotationData();
        });
        this.slabGroup.add(slabTopButton);
        this.addRenderableWidget((GuiEventListener)slabTopButton);
        StyledRadioButton slabBottomButton = new StyledRadioButton(stairStartX + buttonWidth + smallButtonWidth + buttonSpacing * 2, slabY, smallButtonWidth, 18, (Component)Component.literal((String)"Bot"), this.rotationData.getSlabMode() == RotationLockData.SlabMode.BOTTOM, btn -> {
            this.rotationData.setSlabMode(RotationLockData.SlabMode.BOTTOM);
            this.showSlabs();
            this.updatePreview();
            this.saveRotationData();
        });
        this.slabGroup.add(slabBottomButton);
        this.addRenderableWidget((GuiEventListener)slabBottomButton);
        if (!this.availableBlocks.isEmpty()) {
            this.updatePreview();
        }
    }

    private void createDirectionButtons(int centerX, int centerY) {
        this.directionButtons.clear();
        int buttonWidth = 50;
        int buttonHeight = 20;
        int horizontalDistance = 40 + buttonWidth / 2 + 8;
        int verticalDistance = 40 + buttonHeight / 2 + 8;
        Direction topDir = this.rotationData.isDynamicRotation() ? this.getDirectionForPosition("top") : Direction.NORTH;
        Direction bottomDir = this.rotationData.isDynamicRotation() ? this.getDirectionForPosition("bottom") : Direction.SOUTH;
        Direction leftDir = this.rotationData.isDynamicRotation() ? this.getDirectionForPosition("left") : Direction.WEST;
        Direction rightDir = this.rotationData.isDynamicRotation() ? this.getDirectionForPosition("right") : Direction.EAST;
        this.topButton = this.addDirectionButton(topDir, centerX - buttonWidth / 2, centerY - verticalDistance - buttonHeight / 2, buttonWidth, buttonHeight);
        this.bottomButton = this.addDirectionButton(bottomDir, centerX - buttonWidth / 2, centerY + verticalDistance - buttonHeight / 2, buttonWidth, buttonHeight);
        this.leftButton = this.addDirectionButton(leftDir, centerX - horizontalDistance - buttonWidth / 2, centerY - buttonHeight / 2, buttonWidth, buttonHeight);
        this.rightButton = this.addDirectionButton(rightDir, centerX + horizontalDistance - buttonWidth / 2, centerY - buttonHeight / 2, buttonWidth, buttonHeight);
        int upDownY = centerY + verticalDistance + buttonHeight - 4;
        int upDownSpacing = 70;
        this.upButton = this.addDirectionButton(Direction.UP, centerX - buttonWidth - upDownSpacing / 2, upDownY, buttonWidth, buttonHeight);
        this.downButton = this.addDirectionButton(Direction.DOWN, centerX + upDownSpacing / 2, upDownY, buttonWidth, buttonHeight);
    }

    private StyledToggleButton addDirectionButton(Direction dir, int x, int y, int width, int height) {
        StyledToggleButton[] btnHolder;
        String label = switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> "North";
            case Direction.SOUTH -> "South";
            case Direction.EAST -> "East";
            case Direction.WEST -> "West";
            case Direction.UP -> "Up";
            case Direction.DOWN -> "Down";
        };
        StyledToggleButton btn = new StyledToggleButton(x, y, width, height, (Component)Component.literal((String)label), this.rotationData.isDirectionLocked(dir), locked -> {
            if (locked.booleanValue()) {
                this.rotationData.clearLocks();
                Direction actualDir = null;
                for (Map.Entry<Direction, StyledToggleButton> entry : this.directionButtons.entrySet()) {
                    if (entry.getValue() != btnHolder[0]) continue;
                    actualDir = entry.getKey();
                    break;
                }
                if (actualDir != null) {
                    this.rotationData.getLockedFaces().add(actualDir);
                }
                for (Map.Entry<Direction, StyledToggleButton> entry : this.directionButtons.entrySet()) {
                    if (entry.getValue() == btnHolder[0]) continue;
                    entry.getValue().setToggled(false);
                }
                if (this.blockPreview != null) {
                    this.blockPreview.resetViewRotation();
                }
            } else {
                Direction actualDir = null;
                for (Map.Entry<Direction, StyledToggleButton> entry : this.directionButtons.entrySet()) {
                    if (entry.getValue() != btnHolder[0]) continue;
                    actualDir = entry.getKey();
                    break;
                }
                if (actualDir != null) {
                    this.rotationData.getLockedFaces().remove(actualDir);
                }
            }
            if (this.isShowingStairs || this.isShowingSlabs) {
                this.resetToNormalCycling();
            }
            this.updatePreview();
            this.saveRotationData();
        });
        btnHolder = new StyledToggleButton[]{btn};
        this.directionButtons.put(dir, btn);
        this.addRenderableWidget((GuiEventListener)btn);
        return btn;
    }

    private Direction getDirectionForPosition(String position) {
        if (!this.rotationData.isDynamicRotation()) {
            return switch (position) {
                case "top" -> Direction.NORTH;
                case "bottom" -> Direction.SOUTH;
                case "left" -> Direction.WEST;
                case "right" -> Direction.EAST;
                default -> Direction.NORTH;
            };
        }
        Direction playerFacing = this.getPlayerFacing(this.player.getYRot());
        return switch (playerFacing) {
            case Direction.NORTH -> {
                switch (position) {
                    case "top": {
                        yield Direction.NORTH;
                    }
                    case "bottom": {
                        yield Direction.SOUTH;
                    }
                    case "left": {
                        yield Direction.WEST;
                    }
                    case "right": {
                        yield Direction.EAST;
                    }
                }
                yield Direction.NORTH;
            }
            case Direction.SOUTH -> {
                switch (position) {
                    case "top": {
                        yield Direction.SOUTH;
                    }
                    case "bottom": {
                        yield Direction.NORTH;
                    }
                    case "left": {
                        yield Direction.EAST;
                    }
                    case "right": {
                        yield Direction.WEST;
                    }
                }
                yield Direction.SOUTH;
            }
            case Direction.EAST -> {
                switch (position) {
                    case "top": {
                        yield Direction.EAST;
                    }
                    case "bottom": {
                        yield Direction.WEST;
                    }
                    case "left": {
                        yield Direction.NORTH;
                    }
                    case "right": {
                        yield Direction.SOUTH;
                    }
                }
                yield Direction.EAST;
            }
            case Direction.WEST -> {
                switch (position) {
                    case "top": {
                        yield Direction.WEST;
                    }
                    case "bottom": {
                        yield Direction.EAST;
                    }
                    case "left": {
                        yield Direction.SOUTH;
                    }
                    case "right": {
                        yield Direction.NORTH;
                    }
                }
                yield Direction.WEST;
            }
            default -> Direction.NORTH;
        };
    }

    private Direction getPlayerFacing(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw >= 315.0f || yaw < 45.0f) {
            return Direction.SOUTH;
        }
        if (yaw >= 45.0f && yaw < 135.0f) {
            return Direction.WEST;
        }
        if (yaw >= 135.0f && yaw < 225.0f) {
            return Direction.NORTH;
        }
        return Direction.EAST;
    }

    private void updateAvailableBlocks() {
        this.availableBlocks.clear();
        this.availableWeightedBlocks.clear();
        if (this.trowelData.getBuildingMode() == TrowelData.BuildingMode.QUICK) {
            for (int i = 0; i < 9; ++i) {
                BlockItem blockItem;
                Block block;
                Item item;
                ItemStack stack = this.player.getInventory().getItem(i);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || (block = (blockItem = (BlockItem)item).getBlock()) == Blocks.AIR) continue;
                this.availableBlocks.add(block.defaultBlockState());
                this.availableWeightedBlocks.add(null);
            }
        } else {
            PaletteData palette = this.trowelData.getActivePalette();
            if (palette != null) {
                for (PaletteData.WeightedBlock weightedBlock : palette.getBlocks()) {
                    this.availableBlocks.add(weightedBlock.getState());
                    this.availableWeightedBlocks.add(weightedBlock);
                }
            }
        }
        if (this.availableBlocks.isEmpty()) {
            this.availableBlocks.add(Blocks.CHEST.defaultBlockState());
            this.availableWeightedBlocks.add(null);
        }
    }

    private void showStairs() {
        this.isShowingStairs = true;
        this.isShowingSlabs = false;
        if (this.blockPreview != null) {
            this.blockPreview.resumeCycling();
        }
        ArrayList<BlockState> stairBlocks = new ArrayList<BlockState>();
        ArrayList<PaletteData.WeightedBlock> stairWeightedBlocks = new ArrayList<PaletteData.WeightedBlock>();
        if (this.trowelData.getBuildingMode() == TrowelData.BuildingMode.QUICK) {
            for (int i = 0; i < 9; ++i) {
                BlockItem blockItem;
                Block block;
                Item item;
                ItemStack stack = this.player.getInventory().getItem(i);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || !((block = (blockItem = (BlockItem)item).getBlock()) instanceof StairBlock)) continue;
                stairBlocks.add(block.defaultBlockState());
                stairWeightedBlocks.add(null);
            }
        } else {
            PaletteData palette = this.trowelData.getActivePalette();
            if (palette != null) {
                for (PaletteData.WeightedBlock weightedBlock : palette.getBlocks()) {
                    if (!(weightedBlock.getState().getBlock() instanceof StairBlock)) continue;
                    stairBlocks.add(weightedBlock.getState());
                    stairWeightedBlocks.add(weightedBlock);
                }
            }
        }
        if (stairBlocks.isEmpty()) {
            stairBlocks.add(Blocks.OAK_STAIRS.defaultBlockState());
            stairWeightedBlocks.add(null);
        }
        this.availableBlocks = stairBlocks;
        this.availableWeightedBlocks = stairWeightedBlocks;
        this.currentBlockIndex = 0;
        this.lastCycleTime = System.currentTimeMillis();
        this.updatePreview();
    }

    private void showSlabs() {
        this.isShowingStairs = false;
        this.isShowingSlabs = true;
        if (this.blockPreview != null) {
            this.blockPreview.resumeCycling();
        }
        ArrayList<BlockState> slabBlocks = new ArrayList<BlockState>();
        ArrayList<PaletteData.WeightedBlock> slabWeightedBlocks = new ArrayList<PaletteData.WeightedBlock>();
        if (this.trowelData.getBuildingMode() == TrowelData.BuildingMode.QUICK) {
            for (int i = 0; i < 9; ++i) {
                BlockItem blockItem;
                Block block;
                Item item;
                ItemStack stack = this.player.getInventory().getItem(i);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || !((block = (blockItem = (BlockItem)item).getBlock()) instanceof SlabBlock)) continue;
                slabBlocks.add(block.defaultBlockState());
                slabWeightedBlocks.add(null);
            }
        } else {
            PaletteData palette = this.trowelData.getActivePalette();
            if (palette != null) {
                for (PaletteData.WeightedBlock weightedBlock : palette.getBlocks()) {
                    if (!(weightedBlock.getState().getBlock() instanceof SlabBlock)) continue;
                    slabBlocks.add(weightedBlock.getState());
                    slabWeightedBlocks.add(weightedBlock);
                }
            }
        }
        if (slabBlocks.isEmpty()) {
            slabBlocks.add(Blocks.OAK_SLAB.defaultBlockState());
            slabWeightedBlocks.add(null);
        }
        this.availableBlocks = slabBlocks;
        this.availableWeightedBlocks = slabWeightedBlocks;
        this.currentBlockIndex = 0;
        this.lastCycleTime = System.currentTimeMillis();
        this.updatePreview();
    }

    private void resetToNormalCycling() {
        this.isShowingStairs = false;
        this.isShowingSlabs = false;
        if (this.blockPreview != null) {
            this.blockPreview.resumeCycling();
        }
        this.stairGroup.select(null);
        this.slabGroup.select(null);
        this.updateAvailableBlocks();
        this.currentBlockIndex = !this.availableBlocks.isEmpty() ? (this.currentBlockIndex %= this.availableBlocks.size()) : 0;
        this.lastCycleTime = System.currentTimeMillis();
        this.updatePreview();
    }

    private BlockState getCurrentPreviewBlock() {
        if (this.availableBlocks.isEmpty()) {
            return Blocks.CHEST.defaultBlockState();
        }
        if (this.currentBlockIndex >= this.availableBlocks.size()) {
            this.currentBlockIndex = 0;
        }
        return this.availableBlocks.get(this.currentBlockIndex);
    }

    private PaletteData.WeightedBlock getCurrentWeightedBlock() {
        if (this.availableWeightedBlocks.isEmpty() || this.currentBlockIndex >= this.availableWeightedBlocks.size()) {
            return null;
        }
        return this.availableWeightedBlocks.get(this.currentBlockIndex);
    }

    private void updatePreview() {
        if (this.blockPreview != null) {
            this.blockPreview.setBlockState(this.getCurrentPreviewBlock());
            this.blockPreview.setWeightedBlock(this.getCurrentWeightedBlock());
            this.blockPreview.setRotationData(this.rotationData);
            this.blockPreview.setPlayer(this.player);
        }
    }

    private void saveRotationData() {
        CompoundTag tag = new CompoundTag();
        this.rotationData.save(tag);
        PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.SAVE_ROTATION, 0, tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void resetAllLocks() {
        this.rotationData.clearLocks();
        this.rotationData.setStairMode(RotationLockData.StairMode.AUTO);
        this.rotationData.setSlabMode(RotationLockData.SlabMode.AUTO);
        this.rotationData.setStairLink(true);
        for (StyledToggleButton btn : this.directionButtons.values()) {
            btn.setToggled(false);
        }
        this.stairLinkButton.setToggled(true);
        this.stairGroup.select(this.stairGroup.getFirst());
        this.slabGroup.select(this.slabGroup.getFirst());
        this.updatePreview();
        this.saveRotationData();
    }

    private void renderCopycatInfoInTitle(GuiGraphics graphics) {
        if (this.blockPreview == null) {
            return;
        }
        BlockState currentBlock = this.getCurrentPreviewBlock();
        if (!CopycatRenderHelper.isCopycatBlock(currentBlock.getBlock())) {
            return;
        }
        String copycatType = currentBlock.getBlock().getName().getString();
        if (copycatType.toLowerCase().contains("copycat")) {
            copycatType = copycatType.replaceFirst("(?i)copycat\\s*", "");
        }
        int centerY = 7;
        ItemStack copycatItemStack = new ItemStack((ItemLike)currentBlock.getBlock());
        MutableComponent text = Component.literal((String)copycatType).withStyle(ChatFormatting.BLACK);
        int textWidth = this.font.width((FormattedText)text);
        int totalWidth = 20 + textWidth;
        int startX = (this.imageWidth - totalWidth) / 2;
        int bgPadding = 4;
        int bgX = startX - bgPadding;
        int bgY = centerY - 2;
        int bgWidth = totalWidth + bgPadding * 2;
        int bgHeight = 20;
        graphics.fill(bgX, bgY, bgX + bgWidth, bgY + bgHeight, 0x22000000);
        graphics.renderOutline(bgX, bgY, bgWidth, bgHeight, 0x44000000);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 200.0f);
        graphics.renderItem(copycatItemStack, startX, centerY);
        graphics.pose().popPose();
        int glowColor = 0x22FFFFFF;
        graphics.fill(startX - 1, centerY - 1, startX + 17, centerY + 17, glowColor);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 201.0f);
        graphics.renderItem(copycatItemStack, startX, centerY);
        graphics.pose().popPose();
        int textX = startX + 20;
        int textY = centerY + 4;
        graphics.drawString(this.font, (Component)text, textX, textY, 0, false);
    }

    private void renderFramedInfoInTitle(GuiGraphics graphics) {
        if (this.blockPreview == null) {
            return;
        }
        BlockState currentBlock = this.getCurrentPreviewBlock();
        if (!FramedBlocksCompat.isFramedBlock(currentBlock.getBlock())) {
            return;
        }
        String framedType = currentBlock.getBlock().getName().getString();
        if (framedType.toLowerCase().contains("framed")) {
            framedType = framedType.replaceFirst("(?i)framed\\s*", "");
        }
        int centerY = 7;
        ItemStack framedItemStack = new ItemStack((ItemLike)currentBlock.getBlock());
        MutableComponent text = Component.literal((String)framedType).withStyle(ChatFormatting.BLACK);
        int textWidth = this.font.width((FormattedText)text);
        int totalWidth = 20 + textWidth;
        int startX = (this.imageWidth - totalWidth) / 2;
        int bgPadding = 4;
        int bgX = startX - bgPadding;
        int bgY = centerY - 2;
        int bgWidth = totalWidth + bgPadding * 2;
        int bgHeight = 20;
        graphics.fill(bgX, bgY, bgX + bgWidth, bgY + bgHeight, 0x22000000);
        graphics.renderOutline(bgX, bgY, bgWidth, bgHeight, 0x44000000);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 200.0f);
        graphics.renderItem(framedItemStack, startX, centerY);
        graphics.pose().popPose();
        int glowColor = 0x22FFFFFF;
        graphics.fill(startX - 1, centerY - 1, startX + 17, centerY + 17, glowColor);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 201.0f);
        graphics.renderItem(framedItemStack, startX, centerY);
        graphics.pose().popPose();
        int textX = startX + 20;
        int textY = centerY + 4;
        graphics.drawString(this.font, (Component)text, textX, textY, 0, false);
    }

    protected void containerTick() {
        Direction currentFacing;
        long currentTime;
        super.containerTick();
        if (!(this.availableBlocks.size() <= 1 || this.blockPreview != null && this.blockPreview.isCyclingPaused() || (currentTime = System.currentTimeMillis()) - this.lastCycleTime < 3000L)) {
            this.currentBlockIndex = (this.currentBlockIndex + 1) % this.availableBlocks.size();
            this.lastCycleTime = currentTime;
            this.updatePreview();
        }
        if (this.rotationData.isDynamicRotation() && (currentFacing = this.getPlayerFacing(this.player.getYRot())) != this.lastPlayerFacing) {
            this.lastPlayerFacing = currentFacing;
            this.updateDirectionButtonPositions(this.player.getYRot());
        }
        if (this.blockPreview != null) {
            this.blockPreview.setPlayer(this.player);
            this.blockPreview.setRotationData(this.rotationData);
        }
    }

    private void updateDirectionButtonPositions(float playerYaw) {
        Direction newTopDir = this.getDirectionForPosition("top");
        Direction newBottomDir = this.getDirectionForPosition("bottom");
        Direction newLeftDir = this.getDirectionForPosition("left");
        Direction newRightDir = this.getDirectionForPosition("right");
        this.updateSingleDirectionButton(this.topButton, newTopDir);
        this.updateSingleDirectionButton(this.bottomButton, newBottomDir);
        this.updateSingleDirectionButton(this.leftButton, newLeftDir);
        this.updateSingleDirectionButton(this.rightButton, newRightDir);
    }

    private void updateDirectionButtonsForModeChange() {
        this.directionButtons.clear();
        Direction topDir = this.getDirectionForPosition("top");
        Direction bottomDir = this.getDirectionForPosition("bottom");
        Direction leftDir = this.getDirectionForPosition("left");
        Direction rightDir = this.getDirectionForPosition("right");
        this.updateButtonForDirection(this.topButton, topDir);
        this.updateButtonForDirection(this.bottomButton, bottomDir);
        this.updateButtonForDirection(this.leftButton, leftDir);
        this.updateButtonForDirection(this.rightButton, rightDir);
        this.directionButtons.put(Direction.UP, this.upButton);
        this.directionButtons.put(Direction.DOWN, this.downButton);
        if (this.rotationData.isDynamicRotation()) {
            this.lastPlayerFacing = this.getPlayerFacing(this.player.getYRot());
        }
    }

    private void updateButtonForDirection(StyledToggleButton button, Direction dir) {
        String label = switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> "North";
            case Direction.SOUTH -> "South";
            case Direction.EAST -> "East";
            case Direction.WEST -> "West";
            case Direction.UP -> "Up";
            case Direction.DOWN -> "Down";
        };
        button.setMessage((Component)Component.literal((String)label));
        button.setToggled(this.rotationData.isDirectionLocked(dir));
        this.directionButtons.put(dir, button);
    }

    private void updateSingleDirectionButton(StyledToggleButton button, Direction newDir) {
        Direction currentDir = null;
        for (Map.Entry<Direction, StyledToggleButton> entry : this.directionButtons.entrySet()) {
            if (entry.getValue() != button) continue;
            currentDir = entry.getKey();
            break;
        }
        if (currentDir != null && currentDir != newDir) {
            this.directionButtons.remove(currentDir);
            String label = switch (newDir) {
                case Direction.NORTH -> "North";
                case Direction.SOUTH -> "South";
                case Direction.EAST -> "East";
                case Direction.WEST -> "West";
                default -> "";
            };
            button.setMessage((Component)Component.literal((String)label));
            button.setToggled(this.rotationData.isDirectionLocked(newDir));
            this.directionButtons.put(newDir, button);
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -3750202);
        graphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + 1, -1);
        graphics.fill(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + this.imageHeight, -1);
        graphics.fill(this.leftPos, this.topPos + this.imageHeight - 1, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -11184811);
        graphics.fill(this.leftPos + this.imageWidth - 1, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -11184811);
        int y = this.topPos;
        graphics.fill(this.leftPos + 5, y + 30 - 3, this.leftPos + this.imageWidth - 5, y + 30 - 2, -8355712);
        int controlsSeparatorY = y + 30 + 165 + 3;
        graphics.fill(this.leftPos + 5, controlsSeparatorY, this.leftPos + this.imageWidth - 5, controlsSeparatorY + 1, -8355712);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        boolean showingFramed;
        int titleY = 10;
        boolean showingCopycat = this.blockPreview != null && this.blockPreview.isShowingCopycat();
        boolean bl = showingFramed = this.blockPreview != null && this.blockPreview.isShowingFramed();
        if (showingCopycat) {
            this.renderCopycatInfoInTitle(graphics);
        } else if (showingFramed) {
            this.renderFramedInfoInTitle(graphics);
        } else {
            Component titleText = this.title;
            int titleWidth = this.font.width((FormattedText)titleText);
            int titleX = (this.imageWidth - titleWidth) / 2;
            graphics.drawString(this.font, titleText, titleX, titleY, 0x2D2D2D, false);
        }
        int controlsSeparatorY = 190;
        int controlsAreaStart = controlsSeparatorY + 6;
        int stairLabelY = controlsAreaStart + 3 + 8;
        int slabLabelY = stairLabelY + 20;
        graphics.drawString(this.font, (Component)Component.literal((String)"Stairs:"), 10, stairLabelY, 0x404040, false);
        graphics.drawString(this.font, (Component)Component.literal((String)"Slabs:"), 10, slabLabelY, 0x404040, false);
        MutableComponent resetText = Component.literal((String)"Reset");
        graphics.drawString(this.font, (Component)resetText, 31, titleY, 0x808080, false);
        MutableComponent dynText = Component.literal((String)(this.rotationData.isDynamicRotation() ? "Dynamic" : "Static"));
        int dynTextWidth = this.font.width((FormattedText)dynText);
        graphics.drawString(this.font, (Component)dynText, this.imageWidth - dynTextWidth - 31, titleY, 0x808080, false);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.blockPreview != null && this.blockPreview.isMouseOver(mouseX, mouseY)) {
            if (this.blockPreview.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
        } else if (this.blockPreview != null && button == 0) {
            this.blockPreview.setFocused(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.blockPreview != null && this.blockPreview.isFocused() && this.blockPreview.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.blockPreview != null && button == 0) {
            this.blockPreview.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private Tooltip createHelpTooltip() {
        MutableComponent builder = Component.empty();
        builder.append((Component)Component.literal((String)"Rotation Controls").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        builder.append("\n\n");
        builder.append((Component)Component.literal((String)"3D Preview:").withStyle(ChatFormatting.YELLOW));
        builder.append("\n");
        builder.append((Component)Component.literal((String)"\u2022 Drag: Rotate").withStyle(ChatFormatting.GRAY));
        builder.append(" | ");
        builder.append((Component)Component.literal((String)"Right-Click: Reset").withStyle(ChatFormatting.GRAY));
        builder.append("\n");
        builder.append((Component)Component.literal((String)"\u2022 Scroll: Zoom").withStyle(ChatFormatting.GRAY));
        builder.append(" | ");
        builder.append((Component)Component.literal((String)"Middle: Pause").withStyle(ChatFormatting.GRAY));
        builder.append("\n");
        builder.append((Component)Component.literal((String)"\u2022 Hover: Show Palette").withStyle(ChatFormatting.DARK_AQUA));
        builder.append("\n\n");
        builder.append((Component)Component.literal((String)"Direction Locks:").withStyle(ChatFormatting.YELLOW));
        builder.append("\n");
        builder.append((Component)Component.literal((String)"Lock blocks to always place on selected face").withStyle(ChatFormatting.GRAY));
        builder.append("\n\n");
        builder.append((Component)Component.literal((String)"R Button:").withStyle(ChatFormatting.YELLOW));
        builder.append("\n");
        builder.append((Component)Component.literal((String)"Reset all settings & view").withStyle(ChatFormatting.GRAY));
        builder.append("\n\n");
        builder.append((Component)Component.literal((String)"D/S Button:").withStyle(ChatFormatting.YELLOW));
        builder.append("\n");
        builder.append((Component)Component.literal((String)"Dynamic: ").withStyle(ChatFormatting.GREEN));
        builder.append((Component)Component.literal((String)"Relative to view").withStyle(ChatFormatting.GRAY));
        builder.append("\n");
        builder.append((Component)Component.literal((String)"Static: ").withStyle(ChatFormatting.AQUA));
        builder.append((Component)Component.literal((String)"Fixed directions").withStyle(ChatFormatting.GRAY));
        builder.append("\n\n");
        builder.append((Component)Component.literal((String)"Stairs/Slabs:").withStyle(ChatFormatting.YELLOW));
        builder.append("\n");
        builder.append((Component)Component.literal((String)"Auto/Top/Bot placement modes").withStyle(ChatFormatting.GRAY));
        builder.append("\n");
        builder.append((Component)Component.literal((String)"Link: Connect adjacent stairs").withStyle(ChatFormatting.GRAY));
        return Tooltip.create((Component)builder);
    }
}

