/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.item;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.client.KeyBindings;
import com.asger.mechtrowel.compat.create.CopycatBlockConfig;
import com.asger.mechtrowel.compat.create.CreateCompat;
import com.asger.mechtrowel.compat.framedblocks.FramedBlockConfig;
import com.asger.mechtrowel.compat.framedblocks.FramedBlocksCompat;
import com.asger.mechtrowel.data.GradientData;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.RotationLockData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.gui.GradientMenu;
import com.asger.mechtrowel.gui.PaletteMenu;
import com.asger.mechtrowel.util.BlockRotationHelper;
import com.asger.mechtrowel.util.BlockTransformHelper;
import com.asger.mechtrowel.util.CopycatSlabHelper;
import com.asger.mechtrowel.util.GradientBlockSelector;
import com.asger.mechtrowel.util.GradientSelector;
import com.asger.mechtrowel.util.InventorySearchHelper;
import com.asger.mechtrowel.util.ReplaceSystem;
import com.asger.mechtrowel.util.StairPlacementHelper;
import com.asger.mechtrowel.util.WandModeHelper;
import com.asger.mechtrowel.util.WandUndoManager;
import com.asger.mechtrowel.util.WeightedBlockSelector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MechTrowelItem
extends Item
implements MenuProvider {
    private static final WeakHashMap<ItemStack, CachedTooltipData> tooltipCache = new WeakHashMap();

    public MechTrowelItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide()) {
            boolean success;
            BlockState finalState;
            Block transformedBlock;
            boolean hasBlock;
            BlockPos placePos;
            TrowelData data = TrowelData.getOrCreate(stack);
            if (data.getPointSelectionMode() != TrowelData.PointSelectionMode.NONE) {
                return this.handlePointSelection(context, level, player, stack, pos, data);
            }
            if (data.getBuildingMode() == TrowelData.BuildingMode.WAND) {
                return this.handleWandMode(context, level, player, stack, pos, face, data);
            }
            BlockState selectedBlock = null;
            PaletteData.WeightedBlock selectedWeightedBlock = null;
            if (data.getBuildingMode() == TrowelData.BuildingMode.QUICK) {
                selectedBlock = this.selectBlockFromHotbar(player, level);
                if (selectedBlock == null) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.no_blocks_hotbar"), true);
                    return InteractionResult.FAIL;
                }
            } else {
                PaletteData palette = data.getActivePalette();
                if (palette == null || palette.isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.no_palette"), true);
                    return InteractionResult.FAIL;
                }
                selectedWeightedBlock = WeightedBlockSelector.selectWeightedBlock(palette, level.random);
                if (selectedWeightedBlock == null) {
                    return InteractionResult.FAIL;
                }
                selectedBlock = selectedWeightedBlock.getState();
            }
            BlockState targetState = level.getBlockState(pos);
            boolean isReplacing = false;
            if (ReplaceSystem.isReplaceModeActive(player, data.isReplaceMode()) && !targetState.isAir() && ReplaceSystem.canReplaceBlock(level, pos, targetState, player)) {
                placePos = pos;
                isReplacing = true;
            } else {
                placePos = pos.relative(face);
                targetState = level.getBlockState(placePos);
                if (!this.canPlaceBlock(level, placePos, player)) {
                    return InteractionResult.FAIL;
                }
            }
            if (data.getBuildingMode() == TrowelData.BuildingMode.BUILDER && data.isGradientEnabled() && !data.getGradientData().getSections().isEmpty()) {
                GradientSelector.GradientSectionResult gradientResult = GradientSelector.selectGradientSection(data, placePos, player);
                if (gradientResult.getPrimaryPalette() == null || gradientResult.getPrimaryPalette().isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.gradient_not_configured"), true);
                    return InteractionResult.FAIL;
                }
                selectedWeightedBlock = GradientBlockSelector.selectGradientBlock(gradientResult, level.random);
                if (selectedWeightedBlock == null) {
                    return InteractionResult.FAIL;
                }
                selectedBlock = selectedWeightedBlock.getState();
            }
            if (!((hasBlock = InventorySearchHelper.consumeBlockWithChippedFallback(player, transformedBlock = BlockTransformHelper.getPlacementBlock(selectedBlock.getBlock(), face), true, data)) || player.isCreative() || (hasBlock = InventorySearchHelper.consumeBlockWithChippedFallback(player, selectedBlock.getBlock(), true, data)))) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.no_blocks", (Object[])new Object[]{selectedBlock.getBlock().getName()}), true);
                return InteractionResult.FAIL;
            }
            ItemStack dummyStack = new ItemStack((ItemLike)transformedBlock);
            Vec3 hitVec = Vec3.atCenterOf((Vec3i)placePos);
            BlockHitResult blockHitResult = new BlockHitResult(hitVec, face, isReplacing ? pos : pos.relative(face), false);
            BlockPlaceContext placeContext = new BlockPlaceContext(player, InteractionHand.MAIN_HAND, dummyStack, blockHitResult);
            BlockState smartState = transformedBlock.getStateForPlacement(placeContext);
            if (smartState == null) {
                smartState = transformedBlock.defaultBlockState();
            }
            if (CopycatSlabHelper.isCopycatSlab(finalState = BlockRotationHelper.applyRotation(smartState, data.getRotationLockData(), player, face))) {
                finalState = CopycatSlabHelper.applyCopycatSlabRotation(finalState, data.getRotationLockData(), player, face, placeContext);
            }
            if (finalState.getBlock() instanceof StairBlock) {
                finalState = StairPlacementHelper.applyStairShape(finalState, level, placePos, data.getRotationLockData().isStairLink());
            }
            if (!finalState.canSurvive((LevelReader)level, placePos)) {
                if (smartState.canSurvive((LevelReader)level, placePos)) {
                    finalState = smartState;
                } else {
                    return InteractionResult.FAIL;
                }
            }
            CopycatBlockConfig copycatConfig = null;
            if (CreateCompat.isCopycatBlock(finalState.getBlock()) && data.getBuildingMode() == TrowelData.BuildingMode.BUILDER && selectedWeightedBlock != null) {
                copycatConfig = selectedWeightedBlock.getCopycatConfig();
            }
            FramedBlockConfig framedConfig = null;
            if (FramedBlocksCompat.isFramedBlock(finalState.getBlock()) && data.getBuildingMode() == TrowelData.BuildingMode.BUILDER && selectedWeightedBlock != null) {
                framedConfig = selectedWeightedBlock.getFramedConfig();
            }
            if (success = isReplacing ? ReplaceSystem.replaceBlock(level, placePos, targetState, finalState, player) : this.placeBlock(level, placePos, finalState, player, data.getRotationLockData())) {
                boolean consumed;
                if (copycatConfig != null && copycatConfig.isConfigured()) {
                    boolean hasConsumedMaterial;
                    ItemStack materialItem = new ItemStack((ItemLike)copycatConfig.getMaterial().getBlock());
                    boolean bl = hasConsumedMaterial = player.isCreative() || CreateCompat.consumeMaterial(player, materialItem);
                    if (hasConsumedMaterial) {
                        CreateCompat.applyCopycatMaterial(level, placePos, copycatConfig.getMaterial(), copycatConfig.isLit(), copycatConfig.getAxisMode(), player);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.no_copycat_material", (Object[])new Object[]{copycatConfig.getMaterial().getBlock().getName()}).withStyle(ChatFormatting.RED), true);
                    }
                }
                if (framedConfig != null && framedConfig.isConfigured()) {
                    boolean hasConsumedCamo;
                    ItemStack camoItem = new ItemStack((ItemLike)framedConfig.getCamo().getBlock());
                    boolean bl = hasConsumedCamo = player.isCreative() || FramedBlocksCompat.consumeCamo(player, camoItem);
                    if (hasConsumedCamo) {
                        FramedBlocksCompat.applyCamo(level, placePos, framedConfig.getCamo(), player);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.no_framed_camo", (Object[])new Object[]{framedConfig.getCamo().getBlock().getName()}).withStyle(ChatFormatting.RED), true);
                    }
                }
                if (finalState.getBlock() instanceof StairBlock) {
                    StairPlacementHelper.postProcessStairPlacement(level, placePos, finalState, data.getRotationLockData().isStairLink());
                }
                if (!player.isCreative() && !(consumed = InventorySearchHelper.consumeBlockWithChippedFallback(player, finalState.getBlock(), false, data))) {
                    InventorySearchHelper.consumeBlockWithChippedFallback(player, selectedBlock.getBlock(), false, data);
                }
                level.playSound(null, placePos, finalState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack trowel = player.getItemInHand(hand);
        return InteractionResultHolder.pass((Object)trowel);
    }

    private BlockState selectBlockFromHotbar(Player player, Level level) {
        ArrayList<BlockState> availableBlocks = new ArrayList<BlockState>();
        for (int i = 0; i < 9; ++i) {
            BlockItem blockItem;
            Block block;
            Item item;
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || (block = (blockItem = (BlockItem)item).getBlock()) == Blocks.AIR) continue;
            availableBlocks.add(block.defaultBlockState());
        }
        if (availableBlocks.isEmpty()) {
            return null;
        }
        return (BlockState)availableBlocks.get(level.random.nextInt(availableBlocks.size()));
    }

    private boolean canPlaceBlock(Level level, BlockPos pos, Player player) {
        Vec3 blockCenter;
        BlockState currentState = level.getBlockState(pos);
        if (!currentState.canBeReplaced()) {
            return false;
        }
        double reach = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vec3 eyePos = player.getEyePosition();
        return !(eyePos.distanceToSqr(blockCenter = Vec3.atCenterOf((Vec3i)pos)) > reach * reach);
    }

    private boolean placeBlock(Level level, BlockPos pos, BlockState state, Player player, RotationLockData rotationData) {
        int updateFlag = 3;
        if (state.getBlock() instanceof StairBlock && !rotationData.isStairLink()) {
            updateFlag = 18;
        }
        if (level.setBlock(pos, state, updateFlag)) {
            level.sendBlockUpdated(pos, Blocks.AIR.defaultBlockState(), state, updateFlag);
            return true;
        }
        return false;
    }

    private InteractionResult handlePointSelection(UseOnContext context, Level level, Player player, final ItemStack stack, BlockPos clickedPos, TrowelData data) {
        GradientData gradientData;
        boolean hadNoPoints;
        if (!data.isGradientEnabled()) {
            data.setGradientEnabled(true);
        }
        boolean bl = hadNoPoints = (gradientData = data.getGradientData()).getStartPos() == null && gradientData.getEndPos() == null;
        if (data.getPointSelectionMode() == TrowelData.PointSelectionMode.START_POINT) {
            gradientData.setStartPos(clickedPos);
            player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.gradient_start_set", (Object[])new Object[]{clickedPos.getX(), clickedPos.getY(), clickedPos.getZ()}), true);
        } else if (data.getPointSelectionMode() == TrowelData.PointSelectionMode.END_POINT) {
            gradientData.setEndPos(clickedPos);
            player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.gradient_end_set", (Object[])new Object[]{clickedPos.getX(), clickedPos.getY(), clickedPos.getZ()}), true);
        }
        data.setPointSelectionMode(TrowelData.PointSelectionMode.NONE);
        data.save(stack);
        player.getInventory().setChanged();
        level.playSound(null, clickedPos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            final ServerPlayer serverPlayer = (ServerPlayer)player;
            if (hadNoPoints) {
                if (serverPlayer.containerMenu != null) {
                    serverPlayer.containerMenu.broadcastChanges();
                }
                serverPlayer.server.execute(() -> serverPlayer.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"gui.mechtrowel.gradient");
                    }

                    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player p) {
                        ItemStack currentStack = serverPlayer.getInventory().getItem(serverPlayer.getInventory().findSlotMatchingItem(stack));
                        return new GradientMenu(windowId, inventory, serverPlayer.getInventory().findSlotMatchingItem(stack), currentStack);
                    }
                }, buf -> {
                    int slot = serverPlayer.getInventory().findSlotMatchingItem(stack);
                    buf.writeVarInt(slot);
                    buf.writeVarInt(slot);
                }));
            }
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleWandMode(UseOnContext context, Level level, Player player, ItemStack stack, BlockPos clickedPos, Direction clickedFace, TrowelData data) {
        List<BlockPos> positions;
        boolean isGradientMode = data.isGradientEnabled() && !data.getGradientData().getSections().isEmpty();
        BlockState clickedState = level.getBlockState(clickedPos);
        if (clickedState.isAir()) {
            return InteractionResult.FAIL;
        }
        ItemStack offhandItem = player.getOffhandItem();
        boolean isReplaceMode = ReplaceSystem.isReplaceModeActive(player, data.isReplaceMode());
        if (isGradientMode) {
            GradientData gradientData = data.getGradientData();
            List<PaletteData> allPalettes = data.getPalettes();
            if (isReplaceMode) {
                positions = WandModeHelper.findConnectedPositionsGradientReplace(level, clickedPos, gradientData, allPalettes, offhandItem, clickedFace, player, data.getMaxWandBlocks());
                if (positions.isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.wand_no_replaceable_blocks"), true);
                    return InteractionResult.FAIL;
                }
            } else if (!offhandItem.isEmpty() && offhandItem.getItem() instanceof BlockItem) {
                positions = WandModeHelper.findConnectedPositionsGradientWithOffhand(level, clickedPos, offhandItem, clickedFace, player, data.getMaxWandBlocks());
                if (positions.isEmpty()) {
                    BlockItem blockItem = (BlockItem)offhandItem.getItem();
                    player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.wand_no_offhand_blocks", (Object[])new Object[]{blockItem.getBlock().getName()}), true);
                    return InteractionResult.FAIL;
                }
            } else {
                positions = WandModeHelper.findConnectedPositionsGradient(level, clickedPos, gradientData, allPalettes, clickedFace, player, data.getMaxWandBlocks());
                if (positions.isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.wand_no_gradient_blocks"), true);
                    return InteractionResult.FAIL;
                }
            }
        } else {
            PaletteData palette = data.getActivePalette();
            if (palette == null || palette.isEmpty()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.no_palette"), true);
                return InteractionResult.FAIL;
            }
            if (isReplaceMode) {
                positions = WandModeHelper.findConnectedPositionsForReplace(level, clickedPos, palette, offhandItem, clickedFace, player, data.getMaxWandBlocks());
                if (positions.isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.wand_no_replaceable_blocks"), true);
                    return InteractionResult.FAIL;
                }
            } else if (!offhandItem.isEmpty() && offhandItem.getItem() instanceof BlockItem) {
                positions = WandModeHelper.findConnectedPositionsWithOffhand(level, clickedPos, offhandItem, clickedFace, player, data.getMaxWandBlocks());
                if (positions.isEmpty()) {
                    Block offhandBlock = ((BlockItem)offhandItem.getItem()).getBlock();
                    player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.wand_no_offhand_blocks", (Object[])new Object[]{offhandBlock.getName()}), true);
                    return InteractionResult.FAIL;
                }
            } else {
                positions = WandModeHelper.findConnectedPositions(level, clickedPos, palette, clickedFace, player, data.getMaxWandBlocks());
                if (positions.isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.wand_no_palette_blocks"), true);
                    return InteractionResult.FAIL;
                }
            }
        }
        if (!player.isCreative()) {
            boolean hasAnyBlocks = false;
            if (isGradientMode && !isReplaceMode) {
                HashSet<Integer> checkedPalettes = new HashSet<Integer>();
                for (GradientData.GradientSection section : data.getGradientData().getSections()) {
                    int paletteIndex = section.getPaletteIndex();
                    if (checkedPalettes.contains(paletteIndex) || paletteIndex < 0 || paletteIndex >= data.getPalettes().size()) continue;
                    checkedPalettes.add(paletteIndex);
                    PaletteData sectionPalette = data.getPalettes().get(paletteIndex);
                    for (PaletteData.WeightedBlock weightedBlock : sectionPalette.getBlocks()) {
                        Block block = weightedBlock.getState().getBlock();
                        int available = InventorySearchHelper.countBlocksWithChippedFallback(player, block, data);
                        if (available <= 0) continue;
                        hasAnyBlocks = true;
                        break;
                    }
                    if (!hasAnyBlocks && checkedPalettes.size() < 3) continue;
                    break;
                }
            } else {
                PaletteData palette = data.getActivePalette();
                if (palette != null) {
                    for (PaletteData.WeightedBlock weightedBlock : palette.getBlocks()) {
                        Block block = weightedBlock.getState().getBlock();
                        int available = InventorySearchHelper.countBlocksWithChippedFallback(player, block, data);
                        if (available <= 0) continue;
                        hasAnyBlocks = true;
                        break;
                    }
                }
            }
            if (!hasAnyBlocks) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.wand_no_blocks_available"), true);
                return InteractionResult.FAIL;
            }
        }
        int blocksPlaced = 0;
        ArrayList<WandUndoManager.BlockPlacement> placements = new ArrayList<WandUndoManager.BlockPlacement>();
        for (BlockPos placePos : positions) {
            FramedBlockConfig framedConfig;
            BlockState finalState;
            Vec3 hitVec;
            BlockHitResult blockHitResult;
            ItemStack dummyStack;
            BlockPlaceContext placeContext;
            PaletteData.WeightedBlock selectedWeightedBlock;
            if (isGradientMode) {
                GradientData gradientData = data.getGradientData();
                float gradientPosition = GradientSelector.calculateGradientPosition(gradientData, placePos, player);
                GradientSelector.GradientSectionResult gradientResult = GradientSelector.selectGradientSection(data, placePos, player);
                if (gradientResult == null) continue;
                selectedWeightedBlock = GradientBlockSelector.selectGradientBlock(gradientResult, level.random);
            } else {
                PaletteData palette = data.getActivePalette();
                if (palette == null) continue;
                selectedWeightedBlock = WeightedBlockSelector.selectWeightedBlock(palette, level.random);
            }
            if (selectedWeightedBlock == null) continue;
            BlockState selectedState = selectedWeightedBlock.getState();
            Block blockToPlace = selectedState.getBlock();
            if (!player.isCreative() && !InventorySearchHelper.consumeBlockWithChippedFallback(player, blockToPlace, true, data)) continue;
            Block transformedBlock = BlockTransformHelper.getPlacementBlock(blockToPlace, clickedFace);
            BlockState smartState = transformedBlock.getStateForPlacement(placeContext = new BlockPlaceContext(player, InteractionHand.MAIN_HAND, dummyStack = new ItemStack((ItemLike)transformedBlock), blockHitResult = new BlockHitResult(hitVec = Vec3.atCenterOf((Vec3i)placePos), clickedFace, placePos, false)));
            if (smartState == null) {
                smartState = transformedBlock.defaultBlockState();
            }
            if (CopycatSlabHelper.isCopycatSlab(finalState = BlockRotationHelper.applyRotation(smartState, data.getRotationLockData(), player, clickedFace))) {
                finalState = CopycatSlabHelper.applyCopycatSlabRotation(finalState, data.getRotationLockData(), player, clickedFace, placeContext);
            }
            if (finalState.getBlock() instanceof StairBlock) {
                finalState = StairPlacementHelper.applyStairShape(finalState, level, placePos, data.getRotationLockData().isStairLink());
            }
            BlockState originalState = level.getBlockState(placePos);
            CompoundTag originalBlockEntityData = null;
            if (level.getBlockEntity(placePos) != null) {
                originalBlockEntityData = level.getBlockEntity(placePos).saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            }
            boolean placed = false;
            if (isReplaceMode) {
                if (ReplaceSystem.replaceBlock(level, placePos, originalState, finalState, player)) {
                    placed = true;
                }
            } else if (this.placeBlock(level, placePos, finalState, player, data.getRotationLockData())) {
                placed = true;
            }
            if (!placed) continue;
            ++blocksPlaced;
            ItemStack usedItem = new ItemStack((ItemLike)finalState.getBlock());
            placements.add(new WandUndoManager.BlockPlacement(placePos, originalState, finalState, usedItem, originalBlockEntityData));
            CopycatBlockConfig copycatConfig = selectedWeightedBlock.getCopycatConfig();
            if (copycatConfig != null && copycatConfig.isConfigured() && CreateCompat.isCopycatBlock(finalState.getBlock())) {
                boolean hasConsumedMaterial;
                ItemStack materialItem = new ItemStack((ItemLike)copycatConfig.getMaterial().getBlock());
                boolean bl = hasConsumedMaterial = player.isCreative() || CreateCompat.consumeMaterial(player, materialItem);
                if (hasConsumedMaterial) {
                    CreateCompat.applyCopycatMaterial(level, placePos, copycatConfig.getMaterial(), copycatConfig.isLit(), copycatConfig.getAxisMode(), player);
                }
            }
            if ((framedConfig = selectedWeightedBlock.getFramedConfig()) != null && framedConfig.isConfigured() && FramedBlocksCompat.isFramedBlock(finalState.getBlock())) {
                boolean hasConsumedCamo;
                ItemStack camoItem = new ItemStack((ItemLike)framedConfig.getCamo().getBlock());
                boolean bl = hasConsumedCamo = player.isCreative() || FramedBlocksCompat.consumeCamo(player, camoItem);
                if (hasConsumedCamo) {
                    FramedBlocksCompat.applyCamo(level, placePos, framedConfig.getCamo(), player);
                }
            }
            if (finalState.getBlock() instanceof StairBlock) {
                StairPlacementHelper.postProcessStairPlacement(level, placePos, finalState, data.getRotationLockData().isStairLink());
            }
            if (player.isCreative()) continue;
            InventorySearchHelper.consumeBlockWithChippedFallback(player, finalState.getBlock(), false, data);
        }
        if (blocksPlaced > 0) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                WandUndoManager.recordAction(serverPlayer, placements);
            }
            level.playSound(null, clickedPos, clickedState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (blocksPlaced > 1) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.wand_blocks_placed", (Object[])new Object[]{blocksPlaced}), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        TrowelData data;
        super.appendHoverText(stack, context, tooltip, flag);
        CachedTooltipData cached = tooltipCache.get(stack);
        if (cached != null && cached.isValid()) {
            data = cached.data;
        } else {
            data = TrowelData.getOrCreate(stack);
            tooltipCache.put(stack, new CachedTooltipData(data));
        }
        tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.mode", (Object[])new Object[]{data.getBuildingMode().getDisplayName()}).withStyle(ChatFormatting.GOLD));
        if (data.isReplaceMode() && MechTrowel.Config.isReplaceModeEnabled()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.replace_on").withStyle(ChatFormatting.DARK_RED));
        }
        if (data.getBuildingMode() == TrowelData.BuildingMode.BUILDER) {
            PaletteData palette = data.getActivePalette();
            if (palette != null) {
                tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.active_palette", (Object[])new Object[]{palette.getName()}).withStyle(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.no_palette").withStyle(ChatFormatting.RED));
            }
        }
        if (data.isWandEnabled() || data.isChippedConversionEnabled()) {
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.upgrades").withStyle(ChatFormatting.LIGHT_PURPLE));
            if (data.isWandEnabled()) {
                tooltip.add((Component)Component.literal((String)"\u2713 ").withStyle(ChatFormatting.GREEN).append((Component)Component.translatable((String)"tooltip.mechtrowel.wand_enabled").withStyle(ChatFormatting.GRAY)));
                if (data.isCapacityUpgraded()) {
                    tooltip.add((Component)Component.literal((String)"\u2713 ").withStyle(ChatFormatting.GREEN).append((Component)Component.translatable((String)"tooltip.mechtrowel.capacity_upgraded").withStyle(ChatFormatting.GRAY)));
                }
            }
            if (data.isChippedConversionEnabled()) {
                if (data.isChippedConversionActive()) {
                    tooltip.add((Component)Component.literal((String)"\u2713 ").withStyle(ChatFormatting.GREEN).append((Component)Component.translatable((String)"tooltip.mechtrowel.chipped_enabled").withStyle(ChatFormatting.GRAY)));
                } else {
                    tooltip.add((Component)Component.literal((String)"\u2717 ").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"tooltip.mechtrowel.chipped_disabled").withStyle(ChatFormatting.GRAY)));
                }
            }
        }
        if (data.getBuildingMode() == TrowelData.BuildingMode.QUICK) {
            tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.quick_mode_info").withStyle(ChatFormatting.GRAY));
        } else if (data.getBuildingMode() == TrowelData.BuildingMode.WAND) {
            int maxBlocks = data.getMaxWandBlocks();
            tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.wand_capacity", (Object[])new Object[]{maxBlocks}).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
        tooltip.add((Component)Component.empty());
        if (context.level() != null && context.level().isClientSide()) {
            String toggleKey = MechTrowelItem.getKeybindName((KeyMapping)KeyBindings.TOGGLE_BUILD_MODE.get());
            String guiKey = MechTrowelItem.getKeybindName((KeyMapping)KeyBindings.OPEN_PALETTE_GUI.get());
            String replaceKey = MechTrowelItem.getKeybindName((KeyMapping)KeyBindings.TOGGLE_REPLACE.get());
            String chippedKey = MechTrowelItem.getKeybindName((KeyMapping)KeyBindings.TOGGLE_CHIPPED.get());
            tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.toggle_mode_dynamic", (Object[])new Object[]{toggleKey}).withStyle(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.open_gui_dynamic", (Object[])new Object[]{guiKey}).withStyle(ChatFormatting.DARK_GRAY));
            if (MechTrowel.Config.isReplaceModeEnabled()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.toggle_replace_dynamic", (Object[])new Object[]{replaceKey}).withStyle(ChatFormatting.DARK_GRAY));
            }
            if (data.isChippedConversionEnabled()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.toggle_chipped_dynamic", (Object[])new Object[]{chippedKey}).withStyle(ChatFormatting.DARK_GRAY));
            }
            if (!(data.getBuildingMode() != TrowelData.BuildingMode.BUILDER && data.getBuildingMode() != TrowelData.BuildingMode.WAND || data.isGradientEnabled())) {
                String radialKey = ((KeyMapping)KeyBindings.OPEN_RADIAL_MENU.get()).getTranslatedKeyMessage().getString();
                tooltip.add((Component)Component.literal((String)("[Hold " + radialKey + "] Quick palette menu")).withStyle(ChatFormatting.DARK_GRAY));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.toggle_mode").withStyle(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.open_gui").withStyle(ChatFormatting.DARK_GRAY));
            if (MechTrowel.Config.isReplaceModeEnabled()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.toggle_replace").withStyle(ChatFormatting.DARK_GRAY));
            }
            if (data.isChippedConversionEnabled()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.mechtrowel.toggle_chipped").withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String getKeybindName(KeyMapping keyMapping) {
        return keyMapping.getTranslatedKeyMessage().getString().toUpperCase();
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.mechtrowel.palette");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof MechTrowelItem) {
            return new PaletteMenu(windowId, playerInventory, stack);
        }
        return null;
    }

    private static class CachedTooltipData {
        final TrowelData data;
        final long timestamp;

        CachedTooltipData(TrowelData data) {
            this.data = data;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isValid() {
            return System.currentTimeMillis() - this.timestamp < 100L;
        }
    }
}

