/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.network;

import com.asger.mechtrowel.client.GradientMilestoneRenderer;
import com.asger.mechtrowel.registry.ModRegistry;
import com.asger.mechtrowel.util.GradientSelector;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record GradientMilestonePacket(BlockPos pos, GradientSelector.MilestoneInfo.MilestoneType milestoneType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GradientMilestonePacket> TYPE = new CustomPacketPayload.Type(ModRegistry.modLoc("gradient_milestone"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GradientMilestonePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, GradientMilestonePacket::pos, (StreamCodec)StreamCodec.of((buf, value) -> buf.writeEnum((Enum)value), buf -> (GradientSelector.MilestoneInfo.MilestoneType)buf.readEnum(GradientSelector.MilestoneInfo.MilestoneType.class)), GradientMilestonePacket::milestoneType, GradientMilestonePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(GradientMilestonePacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            if (ctx.flow().isClientbound()) {
                Minecraft mc = Minecraft.getInstance();
                if (mc.level != null) {
                    GradientMilestonePacket.triggerMilestoneEffect(mc, packet.pos, packet.milestoneType);
                }
            }
        });
    }

    private static void triggerMilestoneEffect(Minecraft mc, BlockPos pos, GradientSelector.MilestoneInfo.MilestoneType type) {
        double dz;
        double dy;
        double dx;
        int i;
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.5;
        double z = (double)pos.getZ() + 0.5;
        for (i = 0; i < 20; ++i) {
            dx = (mc.level.random.nextDouble() - 0.5) * 0.8;
            dy = (mc.level.random.nextDouble() - 0.5) * 0.8;
            dz = (mc.level.random.nextDouble() - 0.5) * 0.8;
            mc.level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, x + dx, y + dy, z + dz, dx * 0.1, dy * 0.1, dz * 0.1);
        }
        for (i = 0; i < 10; ++i) {
            dx = (mc.level.random.nextDouble() - 0.5) * 0.6;
            dy = (mc.level.random.nextDouble() - 0.5) * 0.6;
            dz = (mc.level.random.nextDouble() - 0.5) * 0.6;
            mc.level.addParticle((ParticleOptions)ParticleTypes.END_ROD, x + dx, y + dy, z + dz, 0.0, 0.0, 0.0);
        }
        GradientMilestoneRenderer.queueMilestoneEffect(pos);
    }
}

