/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import com.asger.mechtrowel.data.RotationLockData;
import com.asger.mechtrowel.util.CopycatSlabHelper;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class BlockRotationHelper {
    public static BlockState applyRotation(BlockState state, RotationLockData rotationData, Player player, Direction clickedFace) {
        Block block = state.getBlock();
        Direction lockedDirection = null;
        Iterator<Direction> iterator = rotationData.getLockedFaces().iterator();
        if (iterator.hasNext()) {
            Direction dir;
            lockedDirection = dir = iterator.next();
        }
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            state = lockedDirection != null ? (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)clickedFace);
        }
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && !(block instanceof StairBlock) && !(block instanceof FenceGateBlock)) {
            state = lockedDirection != null && lockedDirection.getAxis() != Direction.Axis.Y ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection().getOpposite());
        }
        if (block instanceof FenceGateBlock) {
            state = BlockRotationHelper.applyFenceGateRotation(state, rotationData, player, lockedDirection);
        }
        if (block instanceof StairBlock && state.hasProperty((Property)BlockStateProperties.HALF)) {
            state = BlockRotationHelper.applyStairRotation(state, rotationData, player, clickedFace, lockedDirection);
        }
        if (block instanceof SlabBlock && state.hasProperty((Property)BlockStateProperties.SLAB_TYPE) && !CopycatSlabHelper.isCopycatSlab(state)) {
            state = BlockRotationHelper.applySlabRotation(state, rotationData, player, clickedFace);
        }
        if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
            state = lockedDirection != null ? (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)lockedDirection.getAxis()) : (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)clickedFace.getAxis());
        }
        return state;
    }

    private static BlockState applyStairRotation(BlockState state, RotationLockData rotationData, Player player, Direction clickedFace, Direction lockedDirection) {
        state = (BlockState)state.setValue((Property)BlockStateProperties.HALF, (Comparable)(switch (rotationData.getStairMode()) {
            case RotationLockData.StairMode.TOP -> Half.TOP;
            case RotationLockData.StairMode.BOTTOM -> Half.BOTTOM;
            default -> clickedFace == Direction.DOWN || clickedFace != Direction.UP && player.getXRot() > 0.0f ? Half.TOP : Half.BOTTOM;
        }));
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            state = lockedDirection != null && lockedDirection.getAxis() != Direction.Axis.Y ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)lockedDirection.getOpposite()) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection());
        }
        return state;
    }

    private static BlockState applySlabRotation(BlockState state, RotationLockData rotationData, Player player, Direction clickedFace) {
        SlabType type;
        if (state.getValue((Property)BlockStateProperties.SLAB_TYPE) == SlabType.DOUBLE) {
            return state;
        }
        switch (rotationData.getSlabMode()) {
            case TOP: {
                type = SlabType.TOP;
                break;
            }
            case BOTTOM: {
                type = SlabType.BOTTOM;
                break;
            }
            default: {
                return state;
            }
        }
        return (BlockState)state.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)type);
    }

    private static BlockState applyFenceGateRotation(BlockState state, RotationLockData rotationData, Player player, Direction lockedDirection) {
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            state = lockedDirection != null && lockedDirection.getAxis() != Direction.Axis.Y ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection().getOpposite());
        }
        if (state.hasProperty((Property)BlockStateProperties.OPEN)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false));
        }
        if (state.hasProperty((Property)BlockStateProperties.IN_WALL)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.IN_WALL, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }
}

