/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.WallTorchBlock;

public class BlockTransformHelper {
    public static Block getPlacementBlock(Block originalBlock, Direction clickedFace) {
        if (originalBlock instanceof TorchBlock && !(originalBlock instanceof WallTorchBlock) && clickedFace != Direction.UP && clickedFace != Direction.DOWN) {
            if (originalBlock == Blocks.TORCH) {
                return Blocks.WALL_TORCH;
            }
            if (originalBlock == Blocks.SOUL_TORCH) {
                return Blocks.SOUL_WALL_TORCH;
            }
            if (originalBlock == Blocks.REDSTONE_TORCH) {
                return Blocks.REDSTONE_WALL_TORCH;
            }
        }
        if (originalBlock instanceof StandingSignBlock && clickedFace != Direction.UP && clickedFace != Direction.DOWN) {
            return BlockTransformHelper.getWallSignVariant(originalBlock);
        }
        if (originalBlock instanceof BannerBlock && !(originalBlock instanceof WallBannerBlock) && clickedFace != Direction.UP && clickedFace != Direction.DOWN) {
            return BlockTransformHelper.getWallBannerVariant(originalBlock);
        }
        if (originalBlock instanceof SkullBlock && !(originalBlock instanceof WallSkullBlock) && clickedFace != Direction.UP && clickedFace != Direction.DOWN) {
            return BlockTransformHelper.getWallSkullVariant(originalBlock);
        }
        return originalBlock;
    }

    public static Block getStandingVariant(Block block) {
        if (block == Blocks.WALL_TORCH) {
            return Blocks.TORCH;
        }
        if (block == Blocks.SOUL_WALL_TORCH) {
            return Blocks.SOUL_TORCH;
        }
        if (block == Blocks.REDSTONE_WALL_TORCH) {
            return Blocks.REDSTONE_TORCH;
        }
        if (block == Blocks.OAK_WALL_SIGN) {
            return Blocks.OAK_SIGN;
        }
        if (block == Blocks.SPRUCE_WALL_SIGN) {
            return Blocks.SPRUCE_SIGN;
        }
        if (block == Blocks.BIRCH_WALL_SIGN) {
            return Blocks.BIRCH_SIGN;
        }
        if (block == Blocks.JUNGLE_WALL_SIGN) {
            return Blocks.JUNGLE_SIGN;
        }
        if (block == Blocks.ACACIA_WALL_SIGN) {
            return Blocks.ACACIA_SIGN;
        }
        if (block == Blocks.DARK_OAK_WALL_SIGN) {
            return Blocks.DARK_OAK_SIGN;
        }
        if (block == Blocks.MANGROVE_WALL_SIGN) {
            return Blocks.MANGROVE_SIGN;
        }
        if (block == Blocks.CHERRY_WALL_SIGN) {
            return Blocks.CHERRY_SIGN;
        }
        if (block == Blocks.BAMBOO_WALL_SIGN) {
            return Blocks.BAMBOO_SIGN;
        }
        if (block == Blocks.CRIMSON_WALL_SIGN) {
            return Blocks.CRIMSON_SIGN;
        }
        if (block == Blocks.WARPED_WALL_SIGN) {
            return Blocks.WARPED_SIGN;
        }
        if (block instanceof WallBannerBlock) {
            if (block == Blocks.WHITE_WALL_BANNER) {
                return Blocks.WHITE_BANNER;
            }
            if (block == Blocks.ORANGE_WALL_BANNER) {
                return Blocks.ORANGE_BANNER;
            }
            if (block == Blocks.MAGENTA_WALL_BANNER) {
                return Blocks.MAGENTA_BANNER;
            }
            if (block == Blocks.LIGHT_BLUE_WALL_BANNER) {
                return Blocks.LIGHT_BLUE_BANNER;
            }
            if (block == Blocks.YELLOW_WALL_BANNER) {
                return Blocks.YELLOW_BANNER;
            }
            if (block == Blocks.LIME_WALL_BANNER) {
                return Blocks.LIME_BANNER;
            }
            if (block == Blocks.PINK_WALL_BANNER) {
                return Blocks.PINK_BANNER;
            }
            if (block == Blocks.GRAY_WALL_BANNER) {
                return Blocks.GRAY_BANNER;
            }
            if (block == Blocks.LIGHT_GRAY_WALL_BANNER) {
                return Blocks.LIGHT_GRAY_BANNER;
            }
            if (block == Blocks.CYAN_WALL_BANNER) {
                return Blocks.CYAN_BANNER;
            }
            if (block == Blocks.PURPLE_WALL_BANNER) {
                return Blocks.PURPLE_BANNER;
            }
            if (block == Blocks.BLUE_WALL_BANNER) {
                return Blocks.BLUE_BANNER;
            }
            if (block == Blocks.BROWN_WALL_BANNER) {
                return Blocks.BROWN_BANNER;
            }
            if (block == Blocks.GREEN_WALL_BANNER) {
                return Blocks.GREEN_BANNER;
            }
            if (block == Blocks.RED_WALL_BANNER) {
                return Blocks.RED_BANNER;
            }
            if (block == Blocks.BLACK_WALL_BANNER) {
                return Blocks.BLACK_BANNER;
            }
        }
        if (block == Blocks.SKELETON_WALL_SKULL) {
            return Blocks.SKELETON_SKULL;
        }
        if (block == Blocks.WITHER_SKELETON_WALL_SKULL) {
            return Blocks.WITHER_SKELETON_SKULL;
        }
        if (block == Blocks.PLAYER_WALL_HEAD) {
            return Blocks.PLAYER_HEAD;
        }
        if (block == Blocks.ZOMBIE_WALL_HEAD) {
            return Blocks.ZOMBIE_HEAD;
        }
        if (block == Blocks.CREEPER_WALL_HEAD) {
            return Blocks.CREEPER_HEAD;
        }
        if (block == Blocks.DRAGON_WALL_HEAD) {
            return Blocks.DRAGON_HEAD;
        }
        if (block == Blocks.PIGLIN_WALL_HEAD) {
            return Blocks.PIGLIN_HEAD;
        }
        return block;
    }

    private static Block getWallSignVariant(Block standingSign) {
        if (standingSign == Blocks.OAK_SIGN) {
            return Blocks.OAK_WALL_SIGN;
        }
        if (standingSign == Blocks.SPRUCE_SIGN) {
            return Blocks.SPRUCE_WALL_SIGN;
        }
        if (standingSign == Blocks.BIRCH_SIGN) {
            return Blocks.BIRCH_WALL_SIGN;
        }
        if (standingSign == Blocks.JUNGLE_SIGN) {
            return Blocks.JUNGLE_WALL_SIGN;
        }
        if (standingSign == Blocks.ACACIA_SIGN) {
            return Blocks.ACACIA_WALL_SIGN;
        }
        if (standingSign == Blocks.DARK_OAK_SIGN) {
            return Blocks.DARK_OAK_WALL_SIGN;
        }
        if (standingSign == Blocks.MANGROVE_SIGN) {
            return Blocks.MANGROVE_WALL_SIGN;
        }
        if (standingSign == Blocks.CHERRY_SIGN) {
            return Blocks.CHERRY_WALL_SIGN;
        }
        if (standingSign == Blocks.BAMBOO_SIGN) {
            return Blocks.BAMBOO_WALL_SIGN;
        }
        if (standingSign == Blocks.CRIMSON_SIGN) {
            return Blocks.CRIMSON_WALL_SIGN;
        }
        if (standingSign == Blocks.WARPED_SIGN) {
            return Blocks.WARPED_WALL_SIGN;
        }
        return standingSign;
    }

    private static Block getWallBannerVariant(Block standingBanner) {
        if (standingBanner == Blocks.WHITE_BANNER) {
            return Blocks.WHITE_WALL_BANNER;
        }
        if (standingBanner == Blocks.ORANGE_BANNER) {
            return Blocks.ORANGE_WALL_BANNER;
        }
        if (standingBanner == Blocks.MAGENTA_BANNER) {
            return Blocks.MAGENTA_WALL_BANNER;
        }
        if (standingBanner == Blocks.LIGHT_BLUE_BANNER) {
            return Blocks.LIGHT_BLUE_WALL_BANNER;
        }
        if (standingBanner == Blocks.YELLOW_BANNER) {
            return Blocks.YELLOW_WALL_BANNER;
        }
        if (standingBanner == Blocks.LIME_BANNER) {
            return Blocks.LIME_WALL_BANNER;
        }
        if (standingBanner == Blocks.PINK_BANNER) {
            return Blocks.PINK_WALL_BANNER;
        }
        if (standingBanner == Blocks.GRAY_BANNER) {
            return Blocks.GRAY_WALL_BANNER;
        }
        if (standingBanner == Blocks.LIGHT_GRAY_BANNER) {
            return Blocks.LIGHT_GRAY_WALL_BANNER;
        }
        if (standingBanner == Blocks.CYAN_BANNER) {
            return Blocks.CYAN_WALL_BANNER;
        }
        if (standingBanner == Blocks.PURPLE_BANNER) {
            return Blocks.PURPLE_WALL_BANNER;
        }
        if (standingBanner == Blocks.BLUE_BANNER) {
            return Blocks.BLUE_WALL_BANNER;
        }
        if (standingBanner == Blocks.BROWN_BANNER) {
            return Blocks.BROWN_WALL_BANNER;
        }
        if (standingBanner == Blocks.GREEN_BANNER) {
            return Blocks.GREEN_WALL_BANNER;
        }
        if (standingBanner == Blocks.RED_BANNER) {
            return Blocks.RED_WALL_BANNER;
        }
        if (standingBanner == Blocks.BLACK_BANNER) {
            return Blocks.BLACK_WALL_BANNER;
        }
        return standingBanner;
    }

    private static Block getWallSkullVariant(Block floorSkull) {
        if (floorSkull == Blocks.SKELETON_SKULL) {
            return Blocks.SKELETON_WALL_SKULL;
        }
        if (floorSkull == Blocks.WITHER_SKELETON_SKULL) {
            return Blocks.WITHER_SKELETON_WALL_SKULL;
        }
        if (floorSkull == Blocks.PLAYER_HEAD) {
            return Blocks.PLAYER_WALL_HEAD;
        }
        if (floorSkull == Blocks.ZOMBIE_HEAD) {
            return Blocks.ZOMBIE_WALL_HEAD;
        }
        if (floorSkull == Blocks.CREEPER_HEAD) {
            return Blocks.CREEPER_WALL_HEAD;
        }
        if (floorSkull == Blocks.DRAGON_HEAD) {
            return Blocks.DRAGON_WALL_HEAD;
        }
        if (floorSkull == Blocks.PIGLIN_HEAD) {
            return Blocks.PIGLIN_WALL_HEAD;
        }
        return floorSkull;
    }
}

