/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import com.asger.mechtrowel.compat.create.CopycatBlockConfig;
import com.asger.mechtrowel.data.PaletteData;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CopycatRenderHelper {
    public static boolean isCopycatBlock(Block block) {
        if (block == null) {
            return false;
        }
        String className = block.getClass().getName();
        if (className.contains("copycat") || className.contains("Copycat")) {
            return true;
        }
        String blockId = block.getDescriptionId();
        return blockId.contains("create") && blockId.contains("copycat") || blockId.contains("copycats") && blockId.contains("copycat");
    }

    public static BlockState getMaterialFromConfig(PaletteData.WeightedBlock weightedBlock) {
        CopycatBlockConfig config;
        BlockState material;
        if (weightedBlock.getCopycatConfig() != null && weightedBlock.getCopycatConfig().isConfigured() && (material = (config = weightedBlock.getCopycatConfig()).getMaterial()) != null) {
            Direction.Axis axis;
            if (CopycatRenderHelper.isCopycatBlock(material.getBlock())) {
                return null;
            }
            if (config.isLit() && material.hasProperty((Property)BlockStateProperties.LIT)) {
                material = (BlockState)material.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true));
            }
            if (config.getAxisMode() != CopycatBlockConfig.AxisMode.OFF && (axis = config.getAxisMode().toAxis()) != null && material.hasProperty((Property)BlockStateProperties.AXIS)) {
                material = (BlockState)material.setValue((Property)BlockStateProperties.AXIS, (Comparable)axis);
            }
            return material;
        }
        return null;
    }

    public static Optional<BlockState> getMaterialFromBlockEntity(BlockEntity blockEntity) {
        if (blockEntity == null) {
            return Optional.empty();
        }
        try {
            String blockId;
            Block block;
            CompoundTag itemTag;
            Object result;
            Method getMaterialMethod = null;
            for (Method method : blockEntity.getClass().getMethods()) {
                if (!method.getName().equals("getMaterial") && !method.getName().contains("Material") || method.getParameterCount() != 0 || !BlockState.class.isAssignableFrom(method.getReturnType())) continue;
                getMaterialMethod = method;
                break;
            }
            if (getMaterialMethod != null && (result = getMaterialMethod.invoke((Object)blockEntity, new Object[0])) instanceof BlockState) {
                BlockState material = (BlockState)result;
                return Optional.of(material);
            }
            CompoundTag nbt = blockEntity.saveWithoutMetadata((HolderLookup.Provider)blockEntity.getLevel().registryAccess());
            if (nbt.contains("Material")) {
                BlockState material = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)nbt.getCompound("Material"));
                return Optional.of(material);
            }
            if (nbt.contains("ConsumedItem") && (itemTag = nbt.getCompound("ConsumedItem")).contains("id") && (block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)(blockId = itemTag.getString("id"))))) != null) {
                CompoundTag customData;
                CompoundTag components;
                BlockState state = block.defaultBlockState();
                if (itemTag.contains("components") && (components = itemTag.getCompound("components")).contains("minecraft:custom_data") && (customData = components.getCompound("minecraft:custom_data")).contains("BlockStateTag")) {
                    CompoundTag blockStateTag = customData.getCompound("BlockStateTag");
                    for (String key : blockStateTag.getAllKeys()) {
                        state = CopycatRenderHelper.applyProperty(state, key, blockStateTag.getString(key));
                    }
                }
                return Optional.of(state);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static BlockState applyProperty(BlockState state, String propertyName, String value) {
        for (Property property : state.getProperties()) {
            if (!property.getName().equals(propertyName)) continue;
            return CopycatRenderHelper.applyTypedProperty(state, property, value);
        }
        return state;
    }

    private static <T extends Comparable<T>> BlockState applyTypedProperty(BlockState state, Property<T> property, String value) {
        Optional parsedValue = property.getValue(value);
        return parsedValue.map(t -> (BlockState)state.setValue(property, t)).orElse(state);
    }
}

