/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.client.screen;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.data.GradientData;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.gui.GradientMenu;
import com.asger.mechtrowel.gui.widget.NoFocusButton;
import com.asger.mechtrowel.network.GradientUpdatePacket;
import com.asger.mechtrowel.network.TrowelPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;

public class GradientScreen
extends AbstractContainerScreen<GradientMenu> {
    private static final int GUI_WIDTH = 480;
    private static final int BASE_GUI_HEIGHT = 320;
    private static final int BG_COLOR = -3750202;
    private static final int BORDER_LIGHT = -1;
    private static final int BORDER_DARK = -11184811;
    private static final int GRADIENT_PREVIEW_X = 20;
    private static final int GRADIENT_PREVIEW_Y = 43;
    private static final int GRADIENT_PREVIEW_WIDTH = 440;
    private static final int GRADIENT_PREVIEW_HEIGHT = 80;
    private static final int TRACK_HEIGHT = 15;
    private static final int TRACK_SPACING = 3;
    private static final int TOTAL_PREVIEW_HEIGHT = 116;
    private static final int POSITION_CONFIG_Y_OFFSET = 111;
    private static final int POSITION_CONFIG_HEIGHT = 55;
    private static final int SECTION_LIST_Y_OFFSET = 176;
    private static final int SECTION_HEIGHT = 25;
    private static final int MAX_VISIBLE_SECTIONS = 3;
    private int visibleSectionRows = 3;
    private int dynamicSectionListHeight = 75;
    private boolean isCompactMode = false;
    private List<GradientSectionWidget> sectionWidgets = new ArrayList<GradientSectionWidget>();
    private Button addSectionButton;
    private Button clearSectionsButton;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private Button relativeTabButton;
    private Button absoluteTabButton;
    private Button clickPointsTabButton;
    private Button axisHorizontalButton;
    private Button axisVerticalButton;
    private Button axisBothButton;
    private EditBox distanceInput;
    private EditBox startXInput;
    private EditBox startYInput;
    private EditBox startZInput;
    private EditBox endXInput;
    private EditBox endYInput;
    private EditBox endZInput;
    private Button setStartButton;
    private Button setEndButton;
    private Button setCurrentStartButton;
    private Button setCurrentEndButton;
    private Button setRelativePointsButton;
    private Button clearButton;
    private Button confirmButton;
    private boolean showingHexInput = false;
    private EditBox hexColorInput;
    private Button hexConfirmButton;
    private Button hexCancelButton;
    private GradientData.GradientSection editingSection;
    private PaletteDropdownWidget openDropdown = null;
    private DragType dragType = DragType.NONE;
    private int draggedIndex = -1;
    private float dragStartX = 0.0f;
    private float initialLeftSize = 0.0f;
    private float initialRightSize = 0.0f;
    private float initialLeftTransition = 0.0f;
    private float initialRightTransition = 0.0f;
    private DragType hoveredType = DragType.NONE;
    private int hoveredIndex = -1;
    private static final int[] PALETTE_COLORS = new int[]{-10185235, -3368449, -16711809, -10496, -65536, -16711936, -256, -65329, -16711681, -29696, -1, -5197648, -16777216};
    private int lastMouseX = 0;
    private int lastMouseY = 0;

    public GradientScreen(GradientMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 480;
        this.imageHeight = 320;
        this.inventoryLabelY = 1000;
    }

    protected void init() {
        super.init();
        this.calculateVisibleSections();
        this.imageHeight = this.calculateDynamicHeight();
        this.topPos = (this.height - this.imageHeight) / 2;
        this.initPositionConfigRow1();
        this.updatePositionWidgets();
        this.addSectionButton = (Button)this.addRenderableWidget((GuiEventListener)NoFocusButton.noFocusBuilder((Component)Component.literal((String)"+ Add Section"), button -> this.addSection()).bounds(this.leftPos + 10, this.topPos + this.getSectionListY() + this.dynamicSectionListHeight + 3, 100, 20).build());
        this.clearSectionsButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Clear Sections"), button -> this.clearAllSections()).bounds(this.leftPos + 115, this.topPos + this.getSectionListY() + this.dynamicSectionListHeight + 3, 100, 20).build());
        this.confirmButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2713 Save Configuration"), button -> this.confirmAndClose()).bounds(this.leftPos + 340, this.topPos + this.getSectionListY() + this.dynamicSectionListHeight + 3, 130, 20).build());
        this.updateSectionWidgets();
        if (((GradientMenu)this.menu).getGradientData().getSections().isEmpty()) {
            this.initializeDefaultSections();
        }
        this.updateConfirmButton();
    }

    private void initializeDefaultSections() {
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        ArrayList<GradientData.GradientSection> sections = new ArrayList<GradientData.GradientSection>();
        GradientData.GradientSection section1 = new GradientData.GradientSection();
        section1.setPaletteIndex(0);
        section1.setSize(0.5f);
        section1.setSmoothTransition(true);
        section1.setLeftTransitionPercent(0.25f);
        section1.setRightTransitionPercent(0.25f);
        section1.setColorIndex(0);
        GradientData.GradientSection section2 = new GradientData.GradientSection();
        section2.setPaletteIndex(1 % ((GradientMenu)this.menu).getTrowelData().getPalettes().size());
        section2.setSize(0.5f);
        section2.setSmoothTransition(true);
        section2.setLeftTransitionPercent(0.25f);
        section2.setRightTransitionPercent(0.25f);
        section2.setColorIndex(1);
        sections.add(section1);
        sections.add(section2);
        data.setSections(sections);
        this.updateSectionWidgets();
        this.sendUpdate();
    }

    private void updateSectionWidgets() {
        for (GradientSectionWidget widget : this.sectionWidgets) {
            this.removeWidget((GuiEventListener)widget.paletteButton);
            this.removeWidget((GuiEventListener)widget.colorButton);
            this.removeWidget((GuiEventListener)widget.transitionButton);
            this.removeWidget((GuiEventListener)widget.deleteButton);
        }
        this.sectionWidgets.clear();
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        for (int i = 0; i < data.getSections().size(); ++i) {
            GradientData.GradientSection section = data.getSections().get(i);
            GradientSectionWidget widget = new GradientSectionWidget(i, section);
            this.sectionWidgets.add(widget);
        }
        this.addSectionButton.active = data.getSections().size() < 10;
        this.clearSectionsButton.active = !data.getSections().isEmpty();
        int totalHeight = data.getSections().size() * 25;
        this.maxScroll = Math.max(0, totalHeight - this.dynamicSectionListHeight);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
        this.updateSectionWidgetVisibility();
        this.addSectionButton.setY(this.topPos + this.getSectionListY() + this.dynamicSectionListHeight + 3);
        this.clearSectionsButton.setY(this.topPos + this.getSectionListY() + this.dynamicSectionListHeight + 3);
        this.updateConfirmButton();
    }

    private void updateSectionWidgetVisibility() {
        int listStartY = this.topPos + this.getSectionListY();
        int listEndY = listStartY + this.dynamicSectionListHeight;
        for (int i = 0; i < this.sectionWidgets.size(); ++i) {
            boolean isVisible;
            GradientSectionWidget widget = this.sectionWidgets.get(i);
            int widgetY = listStartY + i * 25 - this.scrollOffset;
            widget.paletteButton.visible = isVisible = widgetY >= listStartY && widgetY + 25 <= listEndY;
            widget.colorButton.visible = isVisible;
            widget.transitionButton.visible = isVisible && i < this.sectionWidgets.size() - 1;
            widget.deleteButton.visible = isVisible;
            widget.moveUpButton.visible = isVisible;
            widget.moveDownButton.visible = isVisible;
            if (!isVisible) continue;
            int buttonY = widgetY + 2;
            widget.paletteButton.setY(buttonY);
            widget.colorButton.setY(buttonY);
            widget.transitionButton.setY(buttonY);
            widget.deleteButton.setY(buttonY);
            widget.moveUpButton.setY(buttonY);
            widget.moveDownButton.setY(buttonY);
        }
    }

    private void initPositionConfigRow1() {
        int row1Y = this.topPos + this.getPositionConfigY();
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        int tabWidth = 90;
        int tabX = this.leftPos + 10;
        this.relativeTabButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Relative"), button -> this.setPositionMode(GradientData.GradientPositionMode.RELATIVE)).bounds(tabX, row1Y, tabWidth, 20).build());
        this.absoluteTabButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Absolute"), button -> this.setPositionMode(GradientData.GradientPositionMode.ABSOLUTE)).bounds(tabX + tabWidth + 2, row1Y, tabWidth, 20).build());
        this.clickPointsTabButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Click Points"), button -> this.setPositionMode(GradientData.GradientPositionMode.CLICK_POINTS)).bounds(tabX + (tabWidth + 2) * 2, row1Y, tabWidth, 20).build());
        int axisX = this.leftPos + 310;
        int axisButtonWidth = 45;
        int axisSpacing = 5;
        this.axisHorizontalButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2b0c Hori"), button -> this.setAxis(GradientData.GradientAxis.HORIZONTAL)).bounds(axisX, row1Y, axisButtonWidth, 20).build());
        this.axisVerticalButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2b0d Vert"), button -> this.setAxis(GradientData.GradientAxis.VERTICAL)).bounds(axisX + axisButtonWidth + axisSpacing, row1Y, axisButtonWidth, 20).build());
        this.axisBothButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Both"), button -> this.setAxis(GradientData.GradientAxis.BOTH)).bounds(axisX + (axisButtonWidth + axisSpacing) * 2, row1Y, axisButtonWidth, 20).build());
        this.updatePositionModeButtons();
        this.updateAxisButtons();
    }

    private void setPositionMode(GradientData.GradientPositionMode mode) {
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        if (data.getPositionMode() != mode) {
            data.setPositionMode(mode);
            if (!(mode != GradientData.GradientPositionMode.ABSOLUTE && mode != GradientData.GradientPositionMode.CLICK_POINTS || data.getStartPos() == null && data.getEndPos() == null)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UNCONFIRM_GRADIENT, 0, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.updatePositionModeButtons();
            this.updatePositionWidgets();
            this.sendUpdate();
        }
    }

    private void setAxis(GradientData.GradientAxis axis) {
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        if (data.getAxis() != axis) {
            data.setAxis(axis);
            this.updateAxisButtons();
            this.sendUpdate();
        }
    }

    private void updatePositionModeButtons() {
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        GradientData.GradientPositionMode currentMode = data.getPositionMode();
        this.relativeTabButton.active = currentMode != GradientData.GradientPositionMode.RELATIVE;
        this.absoluteTabButton.active = currentMode != GradientData.GradientPositionMode.ABSOLUTE;
        this.clickPointsTabButton.active = currentMode != GradientData.GradientPositionMode.CLICK_POINTS;
    }

    private void updateAxisButtons() {
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        GradientData.GradientAxis currentAxis = data.getAxis();
        this.axisHorizontalButton.active = currentAxis != GradientData.GradientAxis.HORIZONTAL;
        this.axisVerticalButton.active = currentAxis != GradientData.GradientAxis.VERTICAL;
        this.axisBothButton.active = currentAxis != GradientData.GradientAxis.BOTH;
    }

    private void clearAllSections() {
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        data.setSections(new ArrayList<GradientData.GradientSection>());
        this.updateSectionWidgets();
        this.sendUpdate();
    }

    private void addSection() {
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        if (data.getSections().size() < 10) {
            ArrayList<GradientData.GradientSection> sections = new ArrayList<GradientData.GradientSection>(data.getSections());
            GradientData.GradientSection newSection = new GradientData.GradientSection();
            newSection.setSize(0.2f);
            newSection.setColorIndex(sections.size() % PALETTE_COLORS.length);
            if (sections.size() >= 4) {
                newSection.setLeftTransitionPercent(0.15f);
                newSection.setRightTransitionPercent(0.15f);
            }
            sections.add(newSection);
            data.setSections(sections);
            data.normalizeSections();
            this.updateSectionWidgets();
            this.sendUpdate();
        }
    }

    private void removeSection(int index) {
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        ArrayList<GradientData.GradientSection> sections = new ArrayList<GradientData.GradientSection>(data.getSections());
        if (index >= 0 && index < sections.size()) {
            sections.remove(index);
            data.setSections(sections);
            data.normalizeSections();
            this.updateSectionWidgets();
            this.sendUpdate();
        }
    }

    private void moveSectionUp(int index) {
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        ArrayList<GradientData.GradientSection> sections = new ArrayList<GradientData.GradientSection>(data.getSections());
        if (index > 0 && index < sections.size()) {
            GradientData.GradientSection temp = (GradientData.GradientSection)sections.get(index - 1);
            sections.set(index - 1, (GradientData.GradientSection)sections.get(index));
            sections.set(index, temp);
            data.setSections(sections);
            this.updateSectionWidgets();
            this.sendUpdate();
        }
    }

    private void moveSectionDown(int index) {
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        ArrayList<GradientData.GradientSection> sections = new ArrayList<GradientData.GradientSection>(data.getSections());
        if (index >= 0 && index < sections.size() - 1) {
            GradientData.GradientSection temp = (GradientData.GradientSection)sections.get(index + 1);
            sections.set(index + 1, (GradientData.GradientSection)sections.get(index));
            sections.set(index, temp);
            data.setSections(sections);
            this.updateSectionWidgets();
            this.sendUpdate();
        }
    }

    private void updatePositionWidgets() {
        if (this.distanceInput != null) {
            this.removeWidget((GuiEventListener)this.distanceInput);
        }
        if (this.startXInput != null) {
            this.removeWidget((GuiEventListener)this.startXInput);
        }
        if (this.startYInput != null) {
            this.removeWidget((GuiEventListener)this.startYInput);
        }
        if (this.startZInput != null) {
            this.removeWidget((GuiEventListener)this.startZInput);
        }
        if (this.endXInput != null) {
            this.removeWidget((GuiEventListener)this.endXInput);
        }
        if (this.endYInput != null) {
            this.removeWidget((GuiEventListener)this.endYInput);
        }
        if (this.endZInput != null) {
            this.removeWidget((GuiEventListener)this.endZInput);
        }
        if (this.setStartButton != null) {
            this.removeWidget((GuiEventListener)this.setStartButton);
        }
        if (this.setEndButton != null) {
            this.removeWidget((GuiEventListener)this.setEndButton);
        }
        if (this.setCurrentStartButton != null) {
            this.removeWidget((GuiEventListener)this.setCurrentStartButton);
        }
        if (this.setCurrentEndButton != null) {
            this.removeWidget((GuiEventListener)this.setCurrentEndButton);
        }
        if (this.setRelativePointsButton != null) {
            this.removeWidget((GuiEventListener)this.setRelativePointsButton);
        }
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        int row2Y = this.topPos + this.getPositionConfigY() + 25;
        switch (data.getPositionMode()) {
            case RELATIVE: {
                this.distanceInput = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.leftPos + 65, row2Y, 65, 20, (Component)Component.literal((String)"Distance")));
                this.distanceInput.setValue(String.valueOf(data.getRelativeDistance()));
                this.distanceInput.setHint((Component)Component.literal((String)"10"));
                this.distanceInput.setResponder(text -> {
                    try {
                        int distance = Integer.parseInt(text);
                        data.setRelativeDistance(distance);
                        this.updateConfirmButton();
                        this.sendUpdate();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                this.setRelativePointsButton = (Button)this.addRenderableWidget((GuiEventListener)NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Set Current"), button -> this.calculateRelativeStartEndPoints(data)).bounds(this.leftPos + 190, row2Y, 80, 20).build());
                break;
            }
            case ABSOLUTE: {
                int inputWidth = 40;
                int startX = this.leftPos + 42;
                this.startXInput = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, startX, row2Y, inputWidth, 20, (Component)Component.literal((String)"X")));
                this.startYInput = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, startX + inputWidth + 3, row2Y, inputWidth, 20, (Component)Component.literal((String)"Y")));
                this.startZInput = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, startX + (inputWidth + 3) * 2, row2Y, inputWidth, 20, (Component)Component.literal((String)"Z")));
                this.startXInput.setHint((Component)Component.literal((String)"0"));
                this.startYInput.setHint((Component)Component.literal((String)"0"));
                this.startZInput.setHint((Component)Component.literal((String)"0"));
                int endX = this.leftPos + 230;
                this.endXInput = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, endX, row2Y, inputWidth, 20, (Component)Component.literal((String)"X")));
                this.endYInput = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, endX + inputWidth + 3, row2Y, inputWidth, 20, (Component)Component.literal((String)"Y")));
                this.endZInput = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, endX + (inputWidth + 3) * 2, row2Y, inputWidth, 20, (Component)Component.literal((String)"Z")));
                this.endXInput.setHint((Component)Component.literal((String)"0"));
                this.endYInput.setHint((Component)Component.literal((String)"0"));
                this.endZInput.setHint((Component)Component.literal((String)"0"));
                if (data.getStartPos() != null) {
                    this.startXInput.setValue(String.valueOf(data.getStartPos().getX()));
                    this.startYInput.setValue(String.valueOf(data.getStartPos().getY()));
                    this.startZInput.setValue(String.valueOf(data.getStartPos().getZ()));
                }
                if (data.getEndPos() != null) {
                    this.endXInput.setValue(String.valueOf(data.getEndPos().getX()));
                    this.endYInput.setValue(String.valueOf(data.getEndPos().getY()));
                    this.endZInput.setValue(String.valueOf(data.getEndPos().getZ()));
                }
                this.startXInput.setResponder(text -> this.updateAbsoluteCoordinates());
                this.startYInput.setResponder(text -> this.updateAbsoluteCoordinates());
                this.startZInput.setResponder(text -> this.updateAbsoluteCoordinates());
                this.endXInput.setResponder(text -> this.updateAbsoluteCoordinates());
                this.endYInput.setResponder(text -> this.updateAbsoluteCoordinates());
                this.endZInput.setResponder(text -> this.updateAbsoluteCoordinates());
                this.setCurrentStartButton = (Button)this.addRenderableWidget((GuiEventListener)NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Set"), button -> this.setCurrentPlayerPosition(true)).bounds(startX + (inputWidth + 3) * 3 + 3, row2Y, 30, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Set to your current position"))).build());
                this.setCurrentEndButton = (Button)this.addRenderableWidget((GuiEventListener)NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Set"), button -> this.setCurrentPlayerPosition(false)).bounds(endX + (inputWidth + 3) * 3 + 3, row2Y, 30, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Set to your current position"))).build());
                break;
            }
            case CLICK_POINTS: {
                this.setStartButton = (Button)this.addRenderableWidget((GuiEventListener)NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Set Start Point"), button -> this.setClickPoint(true)).bounds(this.leftPos + 8, row2Y, 110, 20).build());
                this.setEndButton = (Button)this.addRenderableWidget((GuiEventListener)NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Set End Point"), button -> this.setClickPoint(false)).bounds(this.leftPos + 123, row2Y, 110, 20).build());
            }
        }
        if (this.clearButton != null) {
            this.removeWidget((GuiEventListener)this.clearButton);
        }
        this.clearButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Clear"), button -> this.clearCoordinates()).bounds(this.leftPos + 420, row2Y, 50, 20).build());
    }

    private void updateAbsoluteCoordinates() {
        try {
            GradientData data = ((GradientMenu)this.menu).getGradientData();
            int startX = Integer.parseInt(this.startXInput.getValue());
            int startY = Integer.parseInt(this.startYInput.getValue());
            int startZ = Integer.parseInt(this.startZInput.getValue());
            data.setStartPos(new BlockPos(startX, startY, startZ));
            int endX = Integer.parseInt(this.endXInput.getValue());
            int endY = Integer.parseInt(this.endYInput.getValue());
            int endZ = Integer.parseInt(this.endZInput.getValue());
            data.setEndPos(new BlockPos(endX, endY, endZ));
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UNCONFIRM_GRADIENT, 0, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.updateConfirmButton();
            this.sendUpdate();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void setClickPoint(boolean isStart) {
        TrowelPacket.Action action = isStart ? TrowelPacket.Action.SET_GRADIENT_START_POINT : TrowelPacket.Action.SET_GRADIENT_END_POINT;
        PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(action, 0, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    private void setCurrentPlayerPosition(boolean isStart) {
        if (this.minecraft != null && this.minecraft.player != null) {
            BlockPos playerPos = this.minecraft.player.blockPosition();
            GradientData data = ((GradientMenu)this.menu).getGradientData();
            if (isStart) {
                data.setStartPos(playerPos);
                if (this.startXInput != null) {
                    this.startXInput.setValue(String.valueOf(playerPos.getX()));
                }
                if (this.startYInput != null) {
                    this.startYInput.setValue(String.valueOf(playerPos.getY()));
                }
                if (this.startZInput != null) {
                    this.startZInput.setValue(String.valueOf(playerPos.getZ()));
                }
            } else {
                data.setEndPos(playerPos);
                if (this.endXInput != null) {
                    this.endXInput.setValue(String.valueOf(playerPos.getX()));
                }
                if (this.endYInput != null) {
                    this.endYInput.setValue(String.valueOf(playerPos.getY()));
                }
                if (this.endZInput != null) {
                    this.endZInput.setValue(String.valueOf(playerPos.getZ()));
                }
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UNCONFIRM_GRADIENT, 0, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.updateConfirmButton();
            this.sendUpdate();
        }
    }

    private void calculateRelativeStartEndPoints(GradientData data) {
        if (this.minecraft != null && this.minecraft.player != null) {
            BlockPos playerPos = this.minecraft.player.blockPosition();
            int distance = data.getRelativeDistance();
            data.setStartPos(playerPos);
            data.setEndPos(switch (data.getAxis()) {
                case GradientData.GradientAxis.HORIZONTAL -> playerPos.offset(distance, 0, 0);
                case GradientData.GradientAxis.VERTICAL -> playerPos.offset(0, distance, 0);
                case GradientData.GradientAxis.BOTH -> {
                    int diagDist = (int)((double)distance / Math.sqrt(2.0));
                    yield playerPos.offset(diagDist, diagDist, 0);
                }
                default -> playerPos.offset(distance, 0, 0);
            });
            MechTrowel.LOGGER.debug("Relative gradient center set: axis={}, radius={}", (Object)data.getAxis(), (Object)distance);
            MechTrowel.LOGGER.debug("  Center: {}", (Object)playerPos);
            String axisDesc = switch (data.getAxis()) {
                case GradientData.GradientAxis.HORIZONTAL -> "horizontal radius";
                case GradientData.GradientAxis.VERTICAL -> "vertical distance";
                case GradientData.GradientAxis.BOTH -> "3D radius";
                default -> "radius";
            };
            if (this.minecraft.player != null) {
                this.minecraft.player.displayClientMessage((Component)Component.literal((String)("\u2713 Gradient center set at " + String.valueOf(playerPos) + " with " + axisDesc + " of " + distance + " blocks")).withStyle(ChatFormatting.GREEN), true);
            }
            this.updateConfirmButton();
            this.sendUpdate();
        }
    }

    private void clearCoordinates() {
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        data.setStartPos(null);
        data.setEndPos(null);
        this.updatePositionWidgets();
        if (this.startXInput != null) {
            this.startXInput.setValue("");
            this.startYInput.setValue("");
            this.startZInput.setValue("");
        }
        if (this.endXInput != null) {
            this.endXInput.setValue("");
            this.endYInput.setValue("");
            this.endZInput.setValue("");
        }
        this.updateConfirmButton();
        this.sendUpdate();
    }

    private void sendUpdate() {
        PacketDistributor.sendToServer((CustomPacketPayload)new GradientUpdatePacket(((GradientMenu)this.menu).getTrowelSlot(), ((GradientMenu)this.menu).getGradientData()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void confirmAndClose() {
        this.sendUpdate();
        if (!((GradientMenu)this.menu).getTrowelData().isGradientEnabled()) {
            ((GradientMenu)this.menu).getTrowelData().setGradientEnabled(true);
            CompoundTag tag = new CompoundTag();
            ((GradientMenu)this.menu).getTrowelData().save(tag);
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UPDATE_SETTINGS, 0, tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.CONFIRM_GRADIENT, 0, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (this.minecraft.player != null) {
            this.minecraft.player.displayClientMessage((Component)Component.literal((String)"\u2713 Gradient configuration saved and enabled!").withStyle(ChatFormatting.GREEN), true);
        }
        this.onClose();
    }

    private void openHexColorInput(GradientData.GradientSection section) {
        this.showingHexInput = true;
        this.editingSection = section;
        int dialogX = this.width / 2 - 110;
        int dialogY = this.height / 2 - 50;
        this.hexColorInput = new EditBox(this.font, dialogX + 80, dialogY + 32, 120, 20, (Component)Component.literal((String)"Hex Color"));
        this.hexColorInput.setMaxLength(7);
        this.hexColorInput.setValue("#");
        this.hexColorInput.setFilter(s -> s.matches("^#?[0-9A-Fa-f]{0,6}$"));
        this.hexColorInput.setFocused(true);
        this.addWidget((GuiEventListener)this.hexColorInput);
        this.hexConfirmButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Confirm"), button -> this.applyHexColor()).bounds(dialogX + 25, dialogY + 58, 80, 20).build());
        this.hexCancelButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> this.closeHexColorInput()).bounds(dialogX + 115, dialogY + 58, 80, 20).build());
    }

    private void closeHexColorInput() {
        this.showingHexInput = false;
        this.removeWidget((GuiEventListener)this.hexColorInput);
        this.removeWidget((GuiEventListener)this.hexConfirmButton);
        this.removeWidget((GuiEventListener)this.hexCancelButton);
        this.hexColorInput = null;
        this.hexConfirmButton = null;
        this.hexCancelButton = null;
        this.editingSection = null;
    }

    private void applyHexColor() {
        block5: {
            if (this.hexColorInput != null && this.editingSection != null) {
                String hexValue = this.hexColorInput.getValue();
                if (hexValue.startsWith("#")) {
                    hexValue = hexValue.substring(1);
                }
                if (hexValue.length() == 6) {
                    try {
                        int color = 0xFF000000 | Integer.parseInt(hexValue, 16);
                        this.editingSection.setCustomColor(color);
                        this.editingSection.setUsingCustomColor(true);
                        this.sendUpdate();
                        this.closeHexColorInput();
                    }
                    catch (NumberFormatException e) {
                        if (this.minecraft.player == null) break block5;
                        this.minecraft.player.displayClientMessage((Component)Component.literal((String)"Invalid hex color format").withStyle(ChatFormatting.RED), true);
                    }
                }
            }
        }
    }

    private void updateHoveredElement(int mouseX, int mouseY) {
        if (this.dragType != DragType.NONE) {
            return;
        }
        this.hoveredType = DragType.NONE;
        this.hoveredIndex = -1;
        int x = this.leftPos + 20;
        int y = this.topPos + this.getAdjustedPreviewY();
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        if (data.getSections().size() <= 1) {
            return;
        }
        float totalSize = 0.0f;
        for (GradientData.GradientSection section : data.getSections()) {
            totalSize += section.getSize();
        }
        if (totalSize == 0.0f) {
            return;
        }
        float currentPos = 0.0f;
        for (int i = 0; i < data.getSections().size() - 1; ++i) {
            boolean inSquare;
            GradientData.GradientSection leftSection = data.getSections().get(i);
            GradientData.GradientSection rightSection = data.getSections().get(i + 1);
            float leftNormalizedSize = leftSection.getSize() / totalSize;
            float rightNormalizedSize = rightSection.getSize() / totalSize;
            int sectionBoundaryX = x + (int)((currentPos + leftNormalizedSize) * 440.0f);
            int squareSize = 16;
            int squareHalfSize = squareSize / 2;
            int squareCenterY = y + 40;
            boolean bl = inSquare = mouseX >= sectionBoundaryX - squareHalfSize && mouseX <= sectionBoundaryX + squareHalfSize && mouseY >= squareCenterY - squareHalfSize && mouseY <= squareCenterY + squareHalfSize;
            if (inSquare) {
                this.hoveredType = DragType.SECTION_BOUNDARY;
                this.hoveredIndex = i;
                return;
            }
            if (leftSection.isSmoothTransition()) {
                boolean inLowerTrackArea;
                boolean inTrackArea;
                int diamondSize = 12;
                int halfSize = diamondSize / 2;
                int leftTrackY = y - 15 - 3;
                int leftDiamondY = leftTrackY + 7;
                float leftTransitionOffset = leftNormalizedSize * leftSection.getLeftTransitionPercent();
                int leftHandleX = sectionBoundaryX - (int)(leftTransitionOffset * 440.0f);
                float leftDistance = Math.abs(mouseX - leftHandleX);
                float leftYDistance = Math.abs(mouseY - leftDiamondY);
                boolean bl2 = inTrackArea = mouseX >= leftHandleX - halfSize && mouseX <= leftHandleX + halfSize && mouseY >= leftTrackY && mouseY <= leftTrackY + 15;
                if (leftDistance <= (float)halfSize && leftYDistance <= (float)halfSize || inTrackArea) {
                    this.hoveredType = DragType.LEFT_TRANSITION;
                    this.hoveredIndex = i;
                    return;
                }
                int lowerTrackY = y + 80 + 3;
                int rightDiamondY = lowerTrackY + 7;
                float rightTransitionOffset = rightNormalizedSize * rightSection.getRightTransitionPercent();
                int rightHandleX = sectionBoundaryX + (int)(rightTransitionOffset * 440.0f);
                float rightDistance = Math.abs(mouseX - rightHandleX);
                float rightYDistance = Math.abs(mouseY - rightDiamondY);
                boolean bl3 = inLowerTrackArea = mouseX >= rightHandleX - halfSize && mouseX <= rightHandleX + halfSize && mouseY >= lowerTrackY && mouseY <= lowerTrackY + 15;
                if (rightDistance <= (float)halfSize && rightYDistance <= (float)halfSize || inLowerTrackArea) {
                    this.hoveredType = DragType.RIGHT_TRANSITION;
                    this.hoveredIndex = i;
                    return;
                }
            }
            currentPos += leftNormalizedSize;
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.updateHoveredElement(mouseX, mouseY);
        guiGraphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -3750202);
        guiGraphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + 1, -1);
        guiGraphics.fill(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + this.imageHeight, -1);
        guiGraphics.fill(this.leftPos, this.topPos + this.imageHeight - 1, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -11184811);
        guiGraphics.fill(this.leftPos + this.imageWidth - 1, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -11184811);
        if (!this.isCompactMode) {
            String title = "GRADIENT CONFIGURATION";
            int titleX = this.leftPos + this.imageWidth / 2;
            int titleY = this.topPos + 6;
            guiGraphics.drawCenteredString(this.font, title, titleX, titleY, 0xFFFFFF);
            int titleWidth = this.font.width(title);
            int lineY = titleY + 4;
            int lineLength = 40;
            int lineGap = 10;
            int leftLineStart = titleX - titleWidth / 2 - lineGap - lineLength;
            int leftLineEnd = titleX - titleWidth / 2 - lineGap;
            guiGraphics.fill(leftLineStart, lineY, leftLineEnd, lineY + 1, 0x666666);
            guiGraphics.fill(leftLineStart, lineY + 1, leftLineEnd, lineY + 2, 0x333333);
            int rightLineStart = titleX + titleWidth / 2 + lineGap;
            int rightLineEnd = titleX + titleWidth / 2 + lineGap + lineLength;
            guiGraphics.fill(rightLineStart, lineY, rightLineEnd, lineY + 1, 0x666666);
            guiGraphics.fill(rightLineStart, lineY + 1, rightLineEnd, lineY + 2, 0x333333);
            int titleSeparatorY = this.topPos + 18;
            guiGraphics.fill(this.leftPos + 10, titleSeparatorY, this.leftPos + this.imageWidth - 10, titleSeparatorY + 1, -11184811);
            guiGraphics.fill(this.leftPos + 10, titleSeparatorY + 1, this.leftPos + this.imageWidth - 10, titleSeparatorY + 2, -1);
        }
        this.renderGradientPreview(guiGraphics, this.lastMouseX, this.lastMouseY);
        int previewSeparatorY = this.topPos + this.getPositionConfigY() - (this.isCompactMode ? 2 : 5);
        guiGraphics.fill(this.leftPos + 10, previewSeparatorY, this.leftPos + this.imageWidth - 10, previewSeparatorY + 1, -11184811);
        guiGraphics.fill(this.leftPos + 10, previewSeparatorY + 1, this.leftPos + this.imageWidth - 10, previewSeparatorY + 2, -1);
        this.drawPositionTabBackgrounds(guiGraphics);
        this.renderPositionConfigLabels(guiGraphics);
        int sectionListSeparatorY = this.topPos + this.getSectionListY() - (this.isCompactMode ? 5 : 10);
        guiGraphics.fill(this.leftPos + 10, sectionListSeparatorY, this.leftPos + this.imageWidth - 10, sectionListSeparatorY + 1, -11184811);
        guiGraphics.fill(this.leftPos + 10, sectionListSeparatorY + 1, this.leftPos + this.imageWidth - 10, sectionListSeparatorY + 2, -1);
        int listX = this.leftPos + 10;
        int listY = this.topPos + this.getSectionListY();
        int listWidth = this.imageWidth - 20;
        int listHeight = this.dynamicSectionListHeight;
        guiGraphics.fill(listX - 1, listY - 1, listX + listWidth + 1, listY, -11184811);
        guiGraphics.fill(listX - 1, listY - 1, listX, listY + listHeight + 1, -11184811);
        guiGraphics.fill(listX - 1, listY + listHeight, listX + listWidth + 1, listY + listHeight + 1, -1);
        guiGraphics.fill(listX + listWidth, listY - 1, listX + listWidth + 1, listY + listHeight + 1, -1);
        guiGraphics.fill(listX, listY, listX + listWidth, listY + listHeight, -1513240);
        guiGraphics.enableScissor(listX, listY, listX + listWidth, listY + listHeight);
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        for (int i = 0; i < data.getSections().size(); ++i) {
            int rowY = listY + i * 25 - this.scrollOffset;
            if (rowY + 25 < listY || rowY > listY + listHeight || i <= 0 || rowY <= listY) continue;
            guiGraphics.fill(listX + 5, rowY - 1, listX + listWidth - 5, rowY, -3355444);
        }
        guiGraphics.disableScissor();
        if (this.maxScroll > 0) {
            int scrollbarX = listX + listWidth - 6;
            int scrollbarY = listY + 2;
            int scrollbarHeight = listHeight - 4;
            int thumbHeight = Math.max(20, (int)((float)this.dynamicSectionListHeight / (float)(data.getSections().size() * 25) * (float)scrollbarHeight));
            int thumbY = scrollbarY + (int)((float)this.scrollOffset / (float)this.maxScroll * (float)(scrollbarHeight - thumbHeight));
            guiGraphics.fill(scrollbarX, scrollbarY, scrollbarX + 4, scrollbarY + scrollbarHeight, -4473925);
            guiGraphics.fill(scrollbarX, thumbY, scrollbarX + 4, thumbY + thumbHeight, -7829368);
        }
    }

    private void renderPositionConfigLabels(GuiGraphics guiGraphics) {
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        int row2Y = this.topPos + this.getPositionConfigY() + 25;
        switch (data.getPositionMode()) {
            case RELATIVE: {
                String distanceLabel = data.getAxis() == GradientData.GradientAxis.VERTICAL ? "HEIGHT:" : "DISTANCE:";
                int labelX = this.leftPos + 35;
                guiGraphics.drawCenteredString(this.font, distanceLabel, labelX, row2Y + 6, 0xFFFFFF);
                String blocksLabel = "BLOCKS";
                int blocksX = this.leftPos + 155;
                guiGraphics.drawCenteredString(this.font, blocksLabel, blocksX, row2Y + 6, 0xFFFFFF);
                int relativeStatusX = this.leftPos + 280;
                int relativeBadgePadding = 4;
                int relativeBadgeHeight = 16;
                int relativeBadgeY = row2Y + 2;
                if (data.getStartPos() != null && data.getEndPos() != null) {
                    String statusText = "\u25cf SET";
                    int textWidth = this.font.width(statusText);
                    int badgeWidth = textWidth + relativeBadgePadding * 2;
                    guiGraphics.fill(relativeStatusX, relativeBadgeY, relativeStatusX + badgeWidth, relativeBadgeY + relativeBadgeHeight, -11751600);
                    guiGraphics.fill(relativeStatusX, relativeBadgeY + relativeBadgeHeight - 2, relativeStatusX + badgeWidth, relativeBadgeY + relativeBadgeHeight, -13070788);
                    guiGraphics.drawString(this.font, statusText, relativeStatusX + relativeBadgePadding, relativeBadgeY + 4, -1, false);
                    break;
                }
                String statusText = "\u25cb NOT SET";
                int textWidth = this.font.width(statusText);
                int badgeWidth = textWidth + relativeBadgePadding * 2;
                guiGraphics.fill(relativeStatusX, relativeBadgeY, relativeStatusX + badgeWidth, relativeBadgeY + relativeBadgeHeight, -7829368);
                guiGraphics.fill(relativeStatusX, relativeBadgeY + relativeBadgeHeight - 2, relativeStatusX + badgeWidth, relativeBadgeY + relativeBadgeHeight, -10066330);
                guiGraphics.drawString(this.font, statusText, relativeStatusX + relativeBadgePadding, relativeBadgeY + 4, -1, false);
                break;
            }
            case ABSOLUTE: {
                String startLabel = "START";
                String endLabel = "END";
                int startLabelX = this.leftPos + 22;
                guiGraphics.drawCenteredString(this.font, startLabel, startLabelX, row2Y + 6, 0xFFFFFF);
                int endLabelX = this.leftPos + 217;
                guiGraphics.drawCenteredString(this.font, endLabel, endLabelX, row2Y + 6, 0xFFFFFF);
                break;
            }
            case CLICK_POINTS: {
                int statusX = this.leftPos + 240;
                int badgePadding = 4;
                int badgeHeight = 16;
                int badgeY = row2Y + 2;
                if (data.getStartPos() != null && data.getEndPos() != null) {
                    int endTextWidth;
                    String startCoords = String.format("\u25cf START: (%d, %d, %d)", data.getStartPos().getX(), data.getStartPos().getY(), data.getStartPos().getZ());
                    String endCoords = String.format("\u25a0 END: (%d, %d, %d)", data.getEndPos().getX(), data.getEndPos().getY(), data.getEndPos().getZ());
                    int startTextWidth = this.font.width(startCoords);
                    if (statusX + startTextWidth + (endTextWidth = this.font.width(endCoords)) + badgePadding * 4 + 5 > this.leftPos + this.imageWidth - 10) {
                        startCoords = String.format("\u25cf (%d,%d,%d)", data.getStartPos().getX(), data.getStartPos().getY(), data.getStartPos().getZ());
                        endCoords = String.format("\u25a0 (%d,%d,%d)", data.getEndPos().getX(), data.getEndPos().getY(), data.getEndPos().getZ());
                        startTextWidth = this.font.width(startCoords);
                        endTextWidth = this.font.width(endCoords);
                    }
                    int startBadgeWidth = startTextWidth + badgePadding * 2;
                    int startBadgeX = statusX;
                    guiGraphics.fill(startBadgeX, badgeY, startBadgeX + startBadgeWidth, badgeY + badgeHeight, -11751600);
                    guiGraphics.fill(startBadgeX, badgeY + badgeHeight - 2, startBadgeX + startBadgeWidth, badgeY + badgeHeight, -13070788);
                    guiGraphics.drawString(this.font, startCoords, startBadgeX + badgePadding, badgeY + 4, -1, false);
                    int endBadgeWidth = endTextWidth + badgePadding * 2;
                    int endBadgeX = startBadgeX + startBadgeWidth + 5;
                    guiGraphics.fill(endBadgeX, badgeY, endBadgeX + endBadgeWidth, badgeY + badgeHeight, -1754827);
                    guiGraphics.fill(endBadgeX, badgeY + badgeHeight - 2, endBadgeX + endBadgeWidth, badgeY + badgeHeight, -3790808);
                    guiGraphics.drawString(this.font, endCoords, endBadgeX + badgePadding, badgeY + 4, -1, false);
                    break;
                }
                if (data.getStartPos() != null) {
                    String startCoords = String.format("\u25cf START: (%d, %d, %d)", data.getStartPos().getX(), data.getStartPos().getY(), data.getStartPos().getZ());
                    String endBadgeText = "\u25a0 END";
                    int startTextWidth = this.font.width(startCoords);
                    int startBadgeWidth = startTextWidth + badgePadding * 2;
                    int startBadgeX = statusX;
                    guiGraphics.fill(startBadgeX, badgeY, startBadgeX + startBadgeWidth, badgeY + badgeHeight, -11751600);
                    guiGraphics.fill(startBadgeX, badgeY + badgeHeight - 2, startBadgeX + startBadgeWidth, badgeY + badgeHeight, -13070788);
                    guiGraphics.drawString(this.font, startCoords, startBadgeX + badgePadding, badgeY + 4, -1, false);
                    int endTextWidth = this.font.width(endBadgeText);
                    int endBadgeWidth = endTextWidth + badgePadding * 2;
                    int endBadgeX = startBadgeX + startBadgeWidth + 5;
                    guiGraphics.fill(endBadgeX, badgeY, endBadgeX + endBadgeWidth, badgeY + badgeHeight, -7829368);
                    guiGraphics.fill(endBadgeX, badgeY + badgeHeight - 2, endBadgeX + endBadgeWidth, badgeY + badgeHeight, -10066330);
                    guiGraphics.drawString(this.font, endBadgeText, endBadgeX + badgePadding, badgeY + 4, -1, false);
                    break;
                }
                if (data.getEndPos() != null) {
                    String startBadgeText = "\u25cf START";
                    String endCoords = String.format("\u25a0 END: (%d, %d, %d)", data.getEndPos().getX(), data.getEndPos().getY(), data.getEndPos().getZ());
                    int startTextWidth = this.font.width(startBadgeText);
                    int startBadgeWidth = startTextWidth + badgePadding * 2;
                    int startBadgeX = statusX;
                    guiGraphics.fill(startBadgeX, badgeY, startBadgeX + startBadgeWidth, badgeY + badgeHeight, -7829368);
                    guiGraphics.fill(startBadgeX, badgeY + badgeHeight - 2, startBadgeX + startBadgeWidth, badgeY + badgeHeight, -10066330);
                    guiGraphics.drawString(this.font, startBadgeText, startBadgeX + badgePadding, badgeY + 4, -1, false);
                    int endTextWidth = this.font.width(endCoords);
                    int endBadgeWidth = endTextWidth + badgePadding * 2;
                    int endBadgeX = startBadgeX + startBadgeWidth + 5;
                    guiGraphics.fill(endBadgeX, badgeY, endBadgeX + endBadgeWidth, badgeY + badgeHeight, -1754827);
                    guiGraphics.fill(endBadgeX, badgeY + badgeHeight - 2, endBadgeX + endBadgeWidth, badgeY + badgeHeight, -3790808);
                    guiGraphics.drawString(this.font, endCoords, endBadgeX + badgePadding, badgeY + 4, -1, false);
                    break;
                }
                String startBadgeText = "\u25cf START";
                String endBadgeText = "\u25a0 END";
                int startTextWidth = this.font.width(startBadgeText);
                int startBadgeWidth = startTextWidth + badgePadding * 2;
                int startBadgeX = statusX;
                guiGraphics.fill(startBadgeX, badgeY, startBadgeX + startBadgeWidth, badgeY + badgeHeight, -7829368);
                guiGraphics.fill(startBadgeX, badgeY + badgeHeight - 2, startBadgeX + startBadgeWidth, badgeY + badgeHeight, -10066330);
                guiGraphics.drawString(this.font, startBadgeText, startBadgeX + badgePadding, badgeY + 4, -1, false);
                int endTextWidth = this.font.width(endBadgeText);
                int endBadgeWidth = endTextWidth + badgePadding * 2;
                int endBadgeX = startBadgeX + startBadgeWidth + 5;
                guiGraphics.fill(endBadgeX, badgeY, endBadgeX + endBadgeWidth, badgeY + badgeHeight, -7829368);
                guiGraphics.fill(endBadgeX, badgeY + badgeHeight - 2, endBadgeX + endBadgeWidth, badgeY + badgeHeight, -10066330);
                guiGraphics.drawString(this.font, endBadgeText, endBadgeX + badgePadding, badgeY + 4, -1, false);
            }
        }
    }

    private void drawPositionTabBackgrounds(GuiGraphics guiGraphics) {
        int tabX;
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        int row1Y = this.topPos + this.getPositionConfigY();
        int row2Y = row1Y + 23;
        int tabWidth = 90;
        int activeX = tabX = this.leftPos + 10;
        if (data.getPositionMode() == GradientData.GradientPositionMode.ABSOLUTE) {
            activeX = tabX + tabWidth + 2;
        } else if (data.getPositionMode() == GradientData.GradientPositionMode.CLICK_POINTS) {
            activeX = tabX + (tabWidth + 2) * 2;
        }
        int axisX = this.leftPos + 290;
        int axisButtonWidth = 30;
        int activeAxisX = axisX;
        if (data.getAxis() == GradientData.GradientAxis.VERTICAL) {
            activeAxisX = axisX + axisButtonWidth + 2;
        } else if (data.getAxis() == GradientData.GradientAxis.BOTH) {
            activeAxisX = axisX + (axisButtonWidth + 2) * 2;
        }
    }

    private void updateConfirmButton() {
        if (this.confirmButton != null) {
            this.confirmButton.setMessage((Component)Component.literal((String)"\u2713 Save Configuration"));
            this.confirmButton.active = true;
        }
    }

    private void renderGradientPreviewHeader(GuiGraphics guiGraphics, int x, int y) {
    }

    private void drawGradientDirectionIndicator(GuiGraphics guiGraphics, int x, int y, GradientData.GradientAxis axis) {
        int indicatorX = x + 440 - 30;
        int indicatorY = y + 10;
        int size = 20;
        int centerX = indicatorX + size / 2;
        int centerY = indicatorY + size / 2;
        for (int dy = -size / 2; dy <= size / 2; ++dy) {
            for (int dx = -size / 2; dx <= size / 2; ++dx) {
                if (dx * dx + dy * dy > size / 2 * (size / 2)) continue;
                guiGraphics.fill(centerX + dx, centerY + dy, centerX + dx + 1, centerY + dy + 1, -1157627904);
            }
        }
        for (int i = 0; i < 360; ++i) {
            double angle = Math.toRadians(i);
            int dx = (int)(Math.cos(angle) * (double)size / 2.0);
            int dy = (int)(Math.sin(angle) * (double)size / 2.0);
            guiGraphics.fill(centerX + dx, centerY + dy, centerX + dx + 1, centerY + dy + 1, -1);
        }
        switch (axis) {
            case HORIZONTAL: {
                this.drawArrow(guiGraphics, centerX - 6, centerY, centerX + 6, centerY, -1, true);
                break;
            }
            case VERTICAL: {
                this.drawArrow(guiGraphics, centerX, centerY - 6, centerX, centerY + 6, -1, true);
                break;
            }
            case BOTH: {
                this.drawArrow(guiGraphics, centerX - 5, centerY + 5, centerX + 5, centerY - 5, -1, true);
            }
        }
    }

    private void drawArrow(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int color, boolean thick) {
        if (thick) {
            guiGraphics.fill(x1, y1 - 1, x2, y1 + 2, color);
            guiGraphics.fill(x1 - 1, y1, x1 + 2, y2, color);
        } else {
            guiGraphics.fill(x1, y1, x2 + 1, y2 + 1, color);
        }
        double angle = Math.atan2(y2 - y1, x2 - x1);
        int arrowLength = 4;
        double arrowAngle = 0.5235987755982988;
        int ax1 = x2 - (int)((double)arrowLength * Math.cos(angle - arrowAngle));
        int ay1 = y2 - (int)((double)arrowLength * Math.sin(angle - arrowAngle));
        int ax2 = x2 - (int)((double)arrowLength * Math.cos(angle + arrowAngle));
        int ay2 = y2 - (int)((double)arrowLength * Math.sin(angle + arrowAngle));
        guiGraphics.fill(x2, y2, ax1 + 1, ay1 + 1, color);
        guiGraphics.fill(x2, y2, ax2 + 1, ay2 + 1, color);
    }

    private void renderGradientPreview(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int i;
        int i2;
        int x = this.leftPos + 20;
        int y = this.topPos + this.getAdjustedPreviewY();
        this.renderGradientPreviewHeader(guiGraphics, x, y);
        guiGraphics.fill(x - 2, y - 2, x + 440 + 2, y + 80 + 2, -6710887);
        guiGraphics.fill(x - 1, y - 1, x + 440 + 1, y, -11184811);
        guiGraphics.fill(x - 1, y - 1, x, y + 80 + 1, -11184811);
        guiGraphics.fill(x - 1, y + 80, x + 440 + 1, y + 80 + 1, -1);
        guiGraphics.fill(x + 440, y - 1, x + 440 + 1, y + 80 + 1, -1);
        guiGraphics.fill(x, y, x + 440, y + 80, -1118482);
        GradientData data = ((GradientMenu)this.menu).getGradientData();
        this.drawGradientDirectionIndicator(guiGraphics, x, y, data.getAxis());
        if (data.getSections().isEmpty()) {
            guiGraphics.drawCenteredString(this.font, "No gradient sections defined", x + 220, y + 40 - 4, 0x666666);
            return;
        }
        float totalSize = 0.0f;
        for (GradientData.GradientSection section : data.getSections()) {
            totalSize += section.getSize();
        }
        if (totalSize == 0.0f) {
            guiGraphics.drawCenteredString(this.font, "All sections have 0 size", x + 220, y + 40 - 4, 0x666666);
            return;
        }
        float currentPos = 0.0f;
        for (i2 = 0; i2 < data.getSections().size(); ++i2) {
            GradientData.GradientSection section = data.getSections().get(i2);
            float normalizedSize = section.getSize() / totalSize;
            int sectionWidth = (int)(440.0f * normalizedSize);
            int sectionX = x + (int)(currentPos * 440.0f);
            int color = section.isUsingCustomColor() ? section.getCustomColor() : PALETTE_COLORS[section.getColorIndex()];
            guiGraphics.fill(sectionX, y, sectionX + sectionWidth, y + 80, color);
            if (sectionWidth > 30) {
                TrowelData trowelData = ((GradientMenu)this.menu).getTrowelData();
                if (section.getPaletteIndex() < trowelData.getPalettes().size()) {
                    PaletteData palette = trowelData.getPalettes().get(section.getPaletteIndex());
                    Object name = palette.getName();
                    float textScale = Math.min(1.5f, Math.max(0.7f, (float)sectionWidth / 80.0f));
                    int maxChars = (int)((float)sectionWidth / (6.0f * textScale));
                    if (((String)name).length() > maxChars && maxChars > 3) {
                        name = ((String)name).substring(0, maxChars - 3) + "...";
                    }
                    String percent = String.format("%.0f%%", Float.valueOf(normalizedSize * 100.0f));
                    guiGraphics.pose().pushPose();
                    float textX = (float)sectionX + (float)sectionWidth / 2.0f;
                    float textY = (float)y + 40.0f - 8.0f * textScale;
                    guiGraphics.pose().translate(textX, textY, 100.0f);
                    guiGraphics.pose().scale(textScale, textScale, 1.0f);
                    guiGraphics.drawCenteredString(this.font, (String)name, 0, 0, -1);
                    guiGraphics.pose().popPose();
                    guiGraphics.pose().pushPose();
                    float percentScale = textScale * 0.75f;
                    guiGraphics.pose().translate(textX, textY + 10.0f * textScale, 100.0f);
                    guiGraphics.pose().scale(percentScale, percentScale, 1.0f);
                    int percentColor = this.dragType == DragType.SECTION_BOUNDARY && (i2 == this.draggedIndex || i2 == this.draggedIndex + 1) && Screen.hasShiftDown() ? -10496 : -1;
                    guiGraphics.drawCenteredString(this.font, percent, 0, 0, percentColor);
                    guiGraphics.pose().popPose();
                } else {
                    float textScale = Math.min(1.5f, Math.max(0.7f, (float)sectionWidth / 80.0f));
                    String text = "P" + section.getPaletteIndex();
                    String percent = String.format("%.0f%%", Float.valueOf(normalizedSize * 100.0f));
                    guiGraphics.pose().pushPose();
                    float textX = (float)sectionX + (float)sectionWidth / 2.0f;
                    float textY = (float)y + 40.0f - 8.0f * textScale;
                    guiGraphics.pose().translate(textX, textY, 100.0f);
                    guiGraphics.pose().scale(textScale, textScale, 1.0f);
                    guiGraphics.drawCenteredString(this.font, text, 0, 0, -1);
                    guiGraphics.pose().popPose();
                    guiGraphics.pose().pushPose();
                    float percentScale = textScale * 0.75f;
                    guiGraphics.pose().translate(textX, textY + 10.0f * textScale, 100.0f);
                    guiGraphics.pose().scale(percentScale, percentScale, 1.0f);
                    int percentColor = this.dragType == DragType.SECTION_BOUNDARY && (i2 == this.draggedIndex || i2 == this.draggedIndex + 1) && Screen.hasShiftDown() ? -10496 : -1;
                    guiGraphics.drawCenteredString(this.font, percent, 0, 0, percentColor);
                    guiGraphics.pose().popPose();
                }
            }
            currentPos += normalizedSize;
        }
        currentPos = 0.0f;
        for (i2 = 0; i2 < data.getSections().size() - 1; ++i2) {
            GradientData.GradientSection leftSection = data.getSections().get(i2);
            GradientData.GradientSection rightSection = data.getSections().get(i2 + 1);
            float leftNormalizedSize = leftSection.getSize() / totalSize;
            float rightNormalizedSize = rightSection.getSize() / totalSize;
            float leftTransitionPortion = leftNormalizedSize * leftSection.getLeftTransitionPercent();
            float rightTransitionPortion = rightNormalizedSize * rightSection.getRightTransitionPercent();
            float totalTransitionWidth = leftTransitionPortion + rightTransitionPortion;
            int leftSectionEnd = x + (int)((currentPos + leftNormalizedSize) * 440.0f);
            int transitionStartX = leftSectionEnd - (int)(leftTransitionPortion * 440.0f);
            int transitionEndX = leftSectionEnd + (int)(rightTransitionPortion * 440.0f);
            int transitionWidth = transitionEndX - transitionStartX;
            if (leftSection.isSmoothTransition() && transitionWidth > 0) {
                guiGraphics.fill(transitionStartX, y, transitionEndX, y + 80, 0x33000000);
                int leftColor = leftSection.isUsingCustomColor() ? leftSection.getCustomColor() : PALETTE_COLORS[leftSection.getColorIndex()];
                int rightColor = rightSection.isUsingCustomColor() ? rightSection.getCustomColor() : PALETTE_COLORS[rightSection.getColorIndex()];
                for (int j = 0; j < transitionWidth; ++j) {
                    float blend = (float)j / (float)transitionWidth;
                    int blendedColor = this.blendColors(leftColor, rightColor, blend);
                    guiGraphics.fill(transitionStartX + j, y, transitionStartX + j + 1, y + 80, blendedColor);
                }
            } else {
                guiGraphics.fill(leftSectionEnd - 2, y, leftSectionEnd - 1, y + 80, -13421773);
                guiGraphics.fill(leftSectionEnd + 1, y, leftSectionEnd + 2, y + 80, -2236963);
                guiGraphics.fill(leftSectionEnd - 1, y, leftSectionEnd, y + 80, -16777216);
                guiGraphics.fill(leftSectionEnd, y, leftSectionEnd + 1, y + 80, -1);
            }
            currentPos += leftNormalizedSize;
        }
        currentPos = 0.0f;
        for (i2 = 0; i2 < data.getSections().size() - 1; ++i2) {
            float normalizedSize = data.getSections().get(i2).getSize() / totalSize;
            int transitionX = x + (int)((currentPos += normalizedSize) * 440.0f);
            boolean isHovered = this.hoveredType == DragType.SECTION_BOUNDARY && this.hoveredIndex == i2;
            boolean isDragged = this.dragType == DragType.SECTION_BOUNDARY && this.draggedIndex == i2;
            int squareSize = 16;
            int squareHalfSize = squareSize / 2;
            int squareCenterY = y + 40;
            int lineColor = isDragged ? -10496 : (isHovered ? -10066330 : -13421773);
            guiGraphics.fill(transitionX - 1, y, transitionX + 1, y + 80, lineColor);
            int squareX = transitionX - squareHalfSize;
            int squareY = squareCenterY - squareHalfSize;
            if (!isDragged) {
                guiGraphics.fill(squareX + 2, squareY + 2, squareX + squareSize + 2, squareY + squareSize + 2, 0x44000000);
            }
            int bgColor = isDragged ? -10496 : (isHovered ? -1 : -2039584);
            guiGraphics.fill(squareX, squareY, squareX + squareSize, squareY + squareSize, bgColor);
            int borderColor = isDragged ? -3368704 : (isHovered ? -4473925 : -6710887);
            guiGraphics.fill(squareX, squareY, squareX + squareSize, squareY + 1, borderColor);
            guiGraphics.fill(squareX, squareY + squareSize - 1, squareX + squareSize, squareY + squareSize, borderColor);
            guiGraphics.fill(squareX, squareY, squareX + 1, squareY + squareSize, borderColor);
            guiGraphics.fill(squareX + squareSize - 1, squareY, squareX + squareSize, squareY + squareSize, borderColor);
            int totalGripWidth = 8;
            int gripX = transitionX - totalGripWidth / 2 + 1;
            int gripY = squareCenterY - 5;
            int gripHeight = 10;
            for (int gripLine = 0; gripLine < 3; ++gripLine) {
                int lineX = gripX + gripLine * 3;
                guiGraphics.fill(lineX, gripY, lineX + 1, gripY + gripHeight, -10066330);
            }
        }
        boolean hasLeftHandles = false;
        boolean hasRightHandles = false;
        for (i = 0; i < data.getSections().size() - 1; ++i) {
            if (!data.getSections().get(i).isSmoothTransition()) continue;
            hasLeftHandles = true;
            hasRightHandles = true;
            break;
        }
        if (hasLeftHandles || hasRightHandles) {
            if (hasLeftHandles) {
                int upperTrackY = y - 15 - 3;
                this.drawBlendHandleTrack(guiGraphics, x, upperTrackY, 440, 15, hasLeftHandles);
            }
            if (hasRightHandles) {
                int lowerTrackY = y + 80 + 3;
                this.drawBlendHandleTrack(guiGraphics, x, lowerTrackY, 440, 15, hasRightHandles);
            }
        }
        currentPos = 0.0f;
        for (i = 0; i < data.getSections().size() - 1; ++i) {
            boolean rightHovered;
            GradientData.GradientSection leftSection = data.getSections().get(i);
            GradientData.GradientSection rightSection = data.getSections().get(i + 1);
            float leftNormalizedSize = leftSection.getSize() / totalSize;
            float rightNormalizedSize = rightSection.getSize() / totalSize;
            int sectionBoundaryX = x + (int)((currentPos += leftNormalizedSize) * 440.0f);
            if (!leftSection.isSmoothTransition()) continue;
            float leftTransitionOffset = leftNormalizedSize * leftSection.getLeftTransitionPercent();
            int leftHandleX = sectionBoundaryX - (int)(leftTransitionOffset * 440.0f);
            float rightTransitionOffset = rightNormalizedSize * rightSection.getRightTransitionPercent();
            int rightHandleX = sectionBoundaryX + (int)(rightTransitionOffset * 440.0f);
            boolean leftHovered = this.hoveredType == DragType.LEFT_TRANSITION && this.hoveredIndex == i;
            boolean bl = rightHovered = this.hoveredType == DragType.RIGHT_TRANSITION && this.hoveredIndex == i;
            int leftLineColor = this.dragType == DragType.LEFT_TRANSITION && this.draggedIndex == i ? -855648512 : (leftHovered ? -860111941 : -864585865);
            guiGraphics.fill(leftHandleX - 1, y, leftHandleX + 1, y + 80, leftLineColor);
            int rightLineColor = this.dragType == DragType.RIGHT_TRANSITION && this.draggedIndex == i ? -855648512 : (rightHovered ? -860111941 : -864585865);
            guiGraphics.fill(rightHandleX - 1, y, rightHandleX + 1, y + 80, rightLineColor);
            int leftColor = leftSection.isUsingCustomColor() ? leftSection.getCustomColor() : PALETTE_COLORS[leftSection.getColorIndex()];
            int rightColor = rightSection.isUsingCustomColor() ? rightSection.getCustomColor() : PALETTE_COLORS[rightSection.getColorIndex()];
            boolean leftDragging = this.dragType == DragType.LEFT_TRANSITION && this.draggedIndex == i;
            this.drawDiamondHandle(guiGraphics, leftHandleX, y, 80, leftDragging, leftHovered, leftSection.getLeftTransitionPercent(), true, leftColor, leftDragging && Screen.hasShiftDown());
            boolean rightDragging = this.dragType == DragType.RIGHT_TRANSITION && this.draggedIndex == i;
            this.drawDiamondHandle(guiGraphics, rightHandleX, y, 80, rightDragging, rightHovered, rightSection.getRightTransitionPercent(), false, rightColor, rightDragging && Screen.hasShiftDown());
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.showingHexInput && this.hexColorInput != null) {
            if (keyCode == 256) {
                this.closeHexColorInput();
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.applyHexColor();
                return true;
            }
            return this.hexColorInput.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.distanceInput != null && this.distanceInput.isFocused()) {
            return this.distanceInput.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.startXInput != null && this.startXInput.isFocused()) {
            return this.startXInput.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.startYInput != null && this.startYInput.isFocused()) {
            return this.startYInput.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.startZInput != null && this.startZInput.isFocused()) {
            return this.startZInput.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.endXInput != null && this.endXInput.isFocused()) {
            return this.endXInput.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.endYInput != null && this.endYInput.isFocused()) {
            return this.endYInput.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.endZInput != null && this.endZInput.isFocused()) {
            return this.endZInput.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char character, int modifiers) {
        if (this.showingHexInput && this.hexColorInput != null) {
            return this.hexColorInput.charTyped(character, modifiers);
        }
        if (this.distanceInput != null && this.distanceInput.isFocused()) {
            return this.distanceInput.charTyped(character, modifiers);
        }
        if (this.startXInput != null && this.startXInput.isFocused()) {
            return this.startXInput.charTyped(character, modifiers);
        }
        if (this.startYInput != null && this.startYInput.isFocused()) {
            return this.startYInput.charTyped(character, modifiers);
        }
        if (this.startZInput != null && this.startZInput.isFocused()) {
            return this.startZInput.charTyped(character, modifiers);
        }
        if (this.endXInput != null && this.endXInput.isFocused()) {
            return this.endXInput.charTyped(character, modifiers);
        }
        if (this.endYInput != null && this.endYInput.isFocused()) {
            return this.endYInput.charTyped(character, modifiers);
        }
        if (this.endZInput != null && this.endZInput.isFocused()) {
            return this.endZInput.charTyped(character, modifiers);
        }
        return super.charTyped(character, modifiers);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.openDropdown != null && this.openDropdown.isOpen) {
            this.openDropdown.renderDropdown(guiGraphics, mouseX, mouseY);
        }
        if (!this.showingHexInput) {
            if (this.confirmButton == null || this.confirmButton.active || mouseX < this.confirmButton.getX() || mouseX > this.confirmButton.getX() + this.confirmButton.getWidth() || mouseY < this.confirmButton.getY() || mouseY <= this.confirmButton.getY() + this.confirmButton.getHeight()) {
                // empty if block
            }
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
        if (this.showingHexInput && this.hexColorInput != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 1000.0f);
            guiGraphics.fill(0, 0, this.width, this.height, Integer.MIN_VALUE);
            int dialogX = this.width / 2 - 110;
            int dialogY = this.height / 2 - 50;
            int dialogWidth = 220;
            int dialogHeight = 85;
            guiGraphics.fill(dialogX + 3, dialogY + 3, dialogX + dialogWidth + 3, dialogY + dialogHeight + 3, 0x44000000);
            guiGraphics.fill(dialogX, dialogY, dialogX + dialogWidth, dialogY + dialogHeight, -3750202);
            guiGraphics.fill(dialogX, dialogY, dialogX + dialogWidth, dialogY + 1, -1);
            guiGraphics.fill(dialogX, dialogY, dialogX + 1, dialogY + dialogHeight, -1);
            guiGraphics.fill(dialogX, dialogY + dialogHeight - 1, dialogX + dialogWidth, dialogY + dialogHeight, -11184811);
            guiGraphics.fill(dialogX + dialogWidth - 1, dialogY, dialogX + dialogWidth, dialogY + dialogHeight, -11184811);
            String title = "CUSTOM COLOR";
            guiGraphics.drawCenteredString(this.font, title, this.width / 2, dialogY + 8, 0xFFFFFF);
            guiGraphics.fill(dialogX + 10, dialogY + 22, dialogX + dialogWidth - 10, dialogY + 23, -11184811);
            guiGraphics.fill(dialogX + 10, dialogY + 23, dialogX + dialogWidth - 10, dialogY + 24, -1);
            int inputBoxY = dialogY + 32;
            Objects.requireNonNull(this.font);
            int labelY = inputBoxY + (20 - 9) / 2 + 1;
            guiGraphics.drawString(this.font, "Hex Code:", dialogX + 15, labelY, 0x404040, false);
            this.hexColorInput.render(guiGraphics, mouseX, mouseY, partialTick);
            if (this.hexConfirmButton != null) {
                this.hexConfirmButton.render(guiGraphics, mouseX, mouseY, partialTick);
            }
            if (this.hexCancelButton != null) {
                this.hexCancelButton.render(guiGraphics, mouseX, mouseY, partialTick);
            }
            guiGraphics.pose().popPose();
        }
    }

    private int blendColors(int color1, int color2, float blend) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * blend);
        int r = (int)((float)r1 + (float)(r2 - r1) * blend);
        int g = (int)((float)g1 + (float)(g2 - g1) * blend);
        int b = (int)((float)b1 + (float)(b2 - b1) * blend);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int brightenColor(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = Math.min(255, (int)((float)r * 1.3f));
        g = Math.min(255, (int)((float)g * 1.3f));
        b = Math.min(255, (int)((float)b * 1.3f));
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int darkenColor(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = (int)((float)r * 0.7f);
        g = (int)((float)g * 0.7f);
        b = (int)((float)b * 0.7f);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private void drawBlendHandleTrack(GuiGraphics guiGraphics, int x, int y, int width, int height, boolean hasHandles) {
        guiGraphics.fill(x, y, x + width, y + 1, -10066330);
        guiGraphics.fill(x, y, x + 1, y + height, -10066330);
        guiGraphics.fill(x + 1, y + height - 1, x + width, y + height, -1118482);
        guiGraphics.fill(x + width - 1, y + 1, x + width, y + height, -1118482);
        guiGraphics.fill(x + 1, y + 1, x + width - 1, y + height - 1, -5592406);
        guiGraphics.fill(x + 1, y + 1, x + width - 1, y + 2, -6710887);
        guiGraphics.fill(x + 1, y + 1, x + 2, y + height - 1, -6710887);
        if (hasHandles) {
            int centerY = y + height / 2;
            guiGraphics.fill(x + 10, centerY, x + width - 10, centerY + 1, -7829368);
        }
    }

    private void drawDiamondHandle(GuiGraphics guiGraphics, int x, int previewY, int previewHeight, boolean isDragged, boolean isHovered, float transitionPercent, boolean isAbove, int paletteColor, boolean isSnapping) {
        int i;
        int mainColor = isDragged ? -10496 : (isHovered ? this.brightenColor(paletteColor) : paletteColor);
        int darkColor = isDragged ? -2842624 : this.darkenColor(paletteColor);
        int shadowColor = 0x66000000;
        int diamondSize = 12;
        int halfSize = diamondSize / 2;
        int trackY = isAbove ? previewY - 15 - 3 : previewY + previewHeight + 3;
        int diamondY = trackY + 7;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
        for (i = 0; i < halfSize; ++i) {
            int width = i + 1;
            guiGraphics.fill(x - width, diamondY - halfSize + i, x + width, diamondY - halfSize + i + 1, mainColor);
            guiGraphics.fill(x - width, diamondY + halfSize - i - 1, x + width, diamondY + halfSize - i, mainColor);
        }
        for (i = 0; i < halfSize; ++i) {
            guiGraphics.fill(x - i - 1, diamondY - halfSize + i, x - i, diamondY - halfSize + i + 1, darkColor);
            guiGraphics.fill(x + i, diamondY - halfSize + i, x + i + 1, diamondY - halfSize + i + 1, darkColor);
        }
        for (i = 0; i < halfSize; ++i) {
            guiGraphics.fill(x - halfSize + i, diamondY + i, x - halfSize + i + 1, diamondY + i + 1, darkColor);
            guiGraphics.fill(x + halfSize - i - 1, diamondY + i, x + halfSize - i, diamondY + i + 1, darkColor);
        }
        String percentText = String.format("%.0f%%", Float.valueOf(transitionPercent * 100.0f));
        int textWidth = this.font.width(percentText);
        Objects.requireNonNull(this.font);
        int textHeight = 9;
        int badgeWidth = textWidth + 12;
        int badgeHeight = 14;
        int badgeX = x - badgeWidth / 2;
        int badgeY = isAbove ? previewY : previewY + previewHeight - badgeHeight;
        int badgeColor = isSnapping ? -2868 : -3355444;
        guiGraphics.fill(badgeX, badgeY, badgeX + badgeWidth, badgeY + badgeHeight, badgeColor);
        guiGraphics.fill(badgeX + 1, badgeY + 1, badgeX + badgeWidth - 1, badgeY + 2, -2039584);
        guiGraphics.fill(badgeX, badgeY + badgeHeight - 2, badgeX + badgeWidth, badgeY + badgeHeight, -6710887);
        guiGraphics.fill(badgeX, badgeY, badgeX + 1, badgeY + badgeHeight - 2, -6710887);
        guiGraphics.fill(badgeX + badgeWidth - 1, badgeY, badgeX + badgeWidth, badgeY + badgeHeight - 2, -6710887);
        int textX = badgeX + (badgeWidth - textWidth) / 2;
        int textY = badgeY + (badgeHeight - textHeight) / 2 + 1;
        int textColor = isSnapping ? -2842624 : -13421773;
        guiGraphics.drawString(this.font, percentText, textX, textY, textColor, false);
        guiGraphics.pose().popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean handled;
        if (this.showingHexInput) {
            if (this.hexColorInput != null && this.hexColorInput.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (this.hexConfirmButton != null && this.hexConfirmButton.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (this.hexCancelButton != null && this.hexCancelButton.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            return true;
        }
        if (this.openDropdown != null && this.openDropdown.isOpen) {
            int dropdownMenuY = this.openDropdown.getY() + this.openDropdown.getHeight();
            int dropdownMenuHeight = 60;
            if (mouseX >= (double)this.openDropdown.getX() && mouseX <= (double)(this.openDropdown.getX() + this.openDropdown.getWidth()) && mouseY >= (double)dropdownMenuY && mouseY <= (double)(dropdownMenuY + dropdownMenuHeight)) {
                return this.openDropdown.mouseClicked(mouseX, mouseY, button);
            }
            if (this.openDropdown.isMouseOver(mouseX, mouseY)) {
                return this.openDropdown.mouseClicked(mouseX, mouseY, button);
            }
            for (Renderable widget : this.renderables) {
                PaletteDropdownWidget dropdown;
                if (!(widget instanceof PaletteDropdownWidget) || !(dropdown = (PaletteDropdownWidget)widget).isMouseOver(mouseX, mouseY)) continue;
                this.openDropdown.setOpen(false);
                return dropdown.mouseClicked(mouseX, mouseY, button);
            }
            this.openDropdown.setOpen(false);
            return true;
        }
        if (button == 1) {
            x = this.leftPos + 20;
            int y = this.topPos + this.getAdjustedPreviewY();
            GradientData data = ((GradientMenu)this.menu).getGradientData();
            if (data.getSections().size() > 1) {
                float totalSize = 0.0f;
                for (GradientData.GradientSection section : data.getSections()) {
                    totalSize += section.getSize();
                }
                if (totalSize > 0.0f) {
                    float currentPos = 0.0f;
                    for (int i = 0; i < data.getSections().size() - 1; ++i) {
                        GradientData.GradientSection leftSection = data.getSections().get(i);
                        float leftNormalizedSize = leftSection.getSize() / totalSize;
                        int sectionBoundaryX = x + (int)((currentPos + leftNormalizedSize) * 440.0f);
                        float boundaryDistance = (float)Math.abs(mouseX - (double)sectionBoundaryX);
                        int handleExtension = 8;
                        if (boundaryDistance <= 10.0f && mouseY >= (double)(y - handleExtension) && mouseY <= (double)(y + 80 + handleExtension)) {
                            leftSection.setSmoothTransition(!leftSection.isSmoothTransition());
                            if (i < this.sectionWidgets.size()) {
                                GradientSectionWidget widget = this.sectionWidgets.get(i);
                                String transitionText = leftSection.isSmoothTransition() ? "Blend" : "Sharp";
                                widget.transitionButton.setMessage((Component)Component.literal((String)transitionText));
                            }
                            this.sendUpdate();
                            return true;
                        }
                        currentPos += leftNormalizedSize;
                    }
                }
            }
        } else if (button == 0) {
            x = this.leftPos + 20;
            int y = this.topPos + this.getAdjustedPreviewY();
            GradientData data = ((GradientMenu)this.menu).getGradientData();
            if (data.getSections().size() > 1) {
                float totalSize = 0.0f;
                for (GradientData.GradientSection section : data.getSections()) {
                    totalSize += section.getSize();
                }
                if (totalSize > 0.0f) {
                    float currentPos = 0.0f;
                    for (int i = 0; i < data.getSections().size() - 1; ++i) {
                        boolean inSquare;
                        GradientData.GradientSection leftSection = data.getSections().get(i);
                        GradientData.GradientSection rightSection = data.getSections().get(i + 1);
                        float leftNormalizedSize = leftSection.getSize() / totalSize;
                        float rightNormalizedSize = rightSection.getSize() / totalSize;
                        int sectionBoundaryX = x + (int)((currentPos + leftNormalizedSize) * 440.0f);
                        int squareSize = 16;
                        int squareHalfSize = squareSize / 2;
                        int squareCenterY = y + 40;
                        boolean bl = inSquare = mouseX >= (double)(sectionBoundaryX - squareHalfSize) && mouseX <= (double)(sectionBoundaryX + squareHalfSize) && mouseY >= (double)(squareCenterY - squareHalfSize) && mouseY <= (double)(squareCenterY + squareHalfSize);
                        if (inSquare) {
                            this.dragType = DragType.SECTION_BOUNDARY;
                            this.draggedIndex = i;
                            this.dragStartX = (float)mouseX;
                            this.initialLeftSize = data.getSections().get(i).getSize();
                            this.initialRightSize = data.getSections().get(i + 1).getSize();
                            return true;
                        }
                        if (leftSection.isSmoothTransition()) {
                            boolean inLowerTrackArea;
                            boolean inTrackArea;
                            int diamondSize = 12;
                            int halfSize = diamondSize / 2;
                            int leftTrackY = y - 15 - 3;
                            int leftDiamondY = leftTrackY + 7;
                            float leftTransitionOffset = leftNormalizedSize * leftSection.getLeftTransitionPercent();
                            int leftHandleX = sectionBoundaryX - (int)(leftTransitionOffset * 440.0f);
                            float leftDistance = (float)Math.abs(mouseX - (double)leftHandleX);
                            float leftYDistance = (float)Math.abs(mouseY - (double)leftDiamondY);
                            boolean bl2 = inTrackArea = mouseX >= (double)(leftHandleX - halfSize) && mouseX <= (double)(leftHandleX + halfSize) && mouseY >= (double)leftTrackY && mouseY <= (double)(leftTrackY + 15);
                            if (leftDistance <= (float)halfSize && leftYDistance <= (float)halfSize || inTrackArea) {
                                this.dragType = DragType.LEFT_TRANSITION;
                                this.draggedIndex = i;
                                this.dragStartX = (float)mouseX;
                                this.initialLeftTransition = leftSection.getLeftTransitionPercent();
                                return true;
                            }
                            int lowerTrackY = y + 80 + 3;
                            int rightDiamondY = lowerTrackY + 7;
                            float rightTransitionOffset = rightNormalizedSize * rightSection.getRightTransitionPercent();
                            int rightHandleX = sectionBoundaryX + (int)(rightTransitionOffset * 440.0f);
                            float rightDistance = (float)Math.abs(mouseX - (double)rightHandleX);
                            float rightYDistance = (float)Math.abs(mouseY - (double)rightDiamondY);
                            boolean bl3 = inLowerTrackArea = mouseX >= (double)(rightHandleX - halfSize) && mouseX <= (double)(rightHandleX + halfSize) && mouseY >= (double)lowerTrackY && mouseY <= (double)(lowerTrackY + 15);
                            if (rightDistance <= (float)halfSize && rightYDistance <= (float)halfSize || inLowerTrackArea) {
                                this.dragType = DragType.RIGHT_TRANSITION;
                                this.draggedIndex = i;
                                this.dragStartX = (float)mouseX;
                                this.initialRightTransition = rightSection.getRightTransitionPercent();
                                return true;
                            }
                        }
                        currentPos += leftNormalizedSize;
                    }
                }
            }
        }
        if (!(handled = super.mouseClicked(mouseX, mouseY, button)) && this.openDropdown != null && this.openDropdown.isOpen) {
            this.openDropdown.setOpen(false);
            return true;
        }
        return handled;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.showingHexInput) {
            return true;
        }
        if (button == 0 && this.dragType != DragType.NONE) {
            if (this.dragType == DragType.SECTION_BOUNDARY) {
                GradientData data = ((GradientMenu)this.menu).getGradientData();
                data.normalizeSections();
            }
            this.dragType = DragType.NONE;
            this.draggedIndex = -1;
            this.sendUpdate();
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.showingHexInput) {
            return true;
        }
        if (this.dragType != DragType.NONE && this.draggedIndex >= 0) {
            GradientData data = ((GradientMenu)this.menu).getGradientData();
            double deltaX = mouseX - (double)this.dragStartX;
            switch (this.dragType.ordinal()) {
                case 1: {
                    if (this.draggedIndex >= data.getSections().size() - 1) break;
                    double deltaPercent = deltaX / 440.0;
                    double totalSize = 0.0;
                    for (GradientData.GradientSection section : data.getSections()) {
                        totalSize += (double)section.getSize();
                    }
                    double sizeChange = deltaPercent * totalSize;
                    double newLeftSize = (double)this.initialLeftSize + sizeChange;
                    double newRightSize = (double)this.initialRightSize - sizeChange;
                    if (Screen.hasShiftDown()) {
                        double leftPercent = newLeftSize / totalSize * 100.0;
                        double snappedLeftPercent = (double)Math.round(leftPercent / 5.0) * 5.0;
                        newLeftSize = snappedLeftPercent / 100.0 * totalSize;
                        newRightSize = (double)(this.initialLeftSize + this.initialRightSize) - newLeftSize;
                    }
                    double SOFT_MIN = 0.095;
                    if (!(newLeftSize >= 0.095) || !(newRightSize >= 0.095)) break;
                    data.getSections().get(this.draggedIndex).setSize((float)newLeftSize);
                    data.getSections().get(this.draggedIndex + 1).setSize((float)newRightSize);
                    break;
                }
                case 2: {
                    if (this.draggedIndex >= data.getSections().size() - 1) break;
                    GradientData.GradientSection section = data.getSections().get(this.draggedIndex);
                    float totalSize = 0.0f;
                    for (GradientData.GradientSection s : data.getSections()) {
                        totalSize += s.getSize();
                    }
                    float sectionWidthPixels = section.getSize() / totalSize * 440.0f;
                    float percentChange = (float)(-deltaX / (double)sectionWidthPixels);
                    float newPercent = Math.max(0.0f, Math.min(1.0f, this.initialLeftTransition + percentChange));
                    if (Screen.hasShiftDown()) {
                        float percentValue = newPercent * 100.0f;
                        float snappedPercent = (float)Math.round(percentValue / 5.0f) * 5.0f;
                        newPercent = snappedPercent / 100.0f;
                        newPercent = Math.max(0.0f, Math.min(1.0f, newPercent));
                    }
                    section.setLeftTransitionPercent(newPercent);
                    break;
                }
                case 3: {
                    if (this.draggedIndex >= data.getSections().size() - 1) break;
                    GradientData.GradientSection rightSection = data.getSections().get(this.draggedIndex + 1);
                    float totalSize = 0.0f;
                    for (GradientData.GradientSection s : data.getSections()) {
                        totalSize += s.getSize();
                    }
                    float sectionWidthPixels = rightSection.getSize() / totalSize * 440.0f;
                    float percentChange = (float)(deltaX / (double)sectionWidthPixels);
                    float newPercent = Math.max(0.0f, Math.min(1.0f, this.initialRightTransition + percentChange));
                    if (Screen.hasShiftDown()) {
                        float percentValue = newPercent * 100.0f;
                        float snappedPercent = (float)Math.round(percentValue / 5.0f) * 5.0f;
                        newPercent = snappedPercent / 100.0f;
                        newPercent = Math.max(0.0f, Math.min(1.0f, newPercent));
                    }
                    rightSection.setRightTransitionPercent(newPercent);
                }
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.openDropdown != null && this.openDropdown.mouseScrolled(mouseX, mouseY, deltaX, deltaY)) {
            return true;
        }
        int listX = this.leftPos + 10;
        int listY = this.topPos + this.getSectionListY();
        int listWidth = 460;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listWidth) && mouseY >= (double)listY && mouseY <= (double)(listY + this.dynamicSectionListHeight)) {
            int rowHeight = 25;
            int scrollAmount = deltaY > 0.0 ? -rowHeight : rowHeight;
            this.scrollOffset += scrollAmount;
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
            if (this.scrollOffset % rowHeight != 0) {
                this.scrollOffset = Math.round((float)this.scrollOffset / (float)rowHeight) * rowHeight;
            }
            this.updateSectionWidgetVisibility();
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private void calculateVisibleSections() {
        int screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        this.visibleSectionRows = 3;
        this.dynamicSectionListHeight = this.visibleSectionRows * 25;
        this.isCompactMode = false;
        if (screenHeight <= 270) {
            this.isCompactMode = true;
            int fixedHeight = 229;
            int availableHeight = screenHeight - fixedHeight;
            this.visibleSectionRows = Math.max(1, Math.min(3, availableHeight / 25));
            this.dynamicSectionListHeight = this.visibleSectionRows * 25;
        }
    }

    private int calculateDynamicHeight() {
        if (this.visibleSectionRows == 3) {
            return 320;
        }
        int buttonY = this.getSectionListY() + this.dynamicSectionListHeight + 3;
        int buttonBottom = buttonY + 20;
        return buttonBottom + 2;
    }

    private int getAdjustedPreviewY() {
        if (this.isCompactMode) {
            return 20;
        }
        return 43;
    }

    private int getPositionConfigY() {
        if (this.isCompactMode) {
            int compactOffset = 114;
            return this.getAdjustedPreviewY() + compactOffset;
        }
        return this.getAdjustedPreviewY() + 111;
    }

    private int getSectionListY() {
        if (this.isCompactMode) {
            int compactOffset = 174;
            return this.getAdjustedPreviewY() + compactOffset;
        }
        return this.getAdjustedPreviewY() + 176;
    }

    private class PaletteDropdownWidget
    extends AbstractWidget {
        private final TrowelData trowelData;
        private final Consumer<Integer> onSelectionChange;
        private int selectedIndex;
        private boolean isOpen;
        private int hoveredIndex;
        private int scrollOffset;
        static final int VISIBLE_ITEMS = 3;
        static final int ITEM_HEIGHT = 20;

        public PaletteDropdownWidget(int x, int y, int width, int height, int initialIndex, TrowelData trowelData, Consumer<Integer> onSelectionChange) {
            super(x, y, width, height, (Component)Component.empty());
            this.isOpen = false;
            this.hoveredIndex = -1;
            this.scrollOffset = 0;
            this.trowelData = trowelData;
            this.selectedIndex = initialIndex;
            this.onSelectionChange = onSelectionChange;
            this.updateMessage();
        }

        private void setOpen(boolean open) {
            this.isOpen = open;
            if (open) {
                if (GradientScreen.this.openDropdown != null && GradientScreen.this.openDropdown != this) {
                    GradientScreen.this.openDropdown.isOpen = false;
                }
                GradientScreen.this.openDropdown = this;
                this.scrollToSelected();
            } else if (GradientScreen.this.openDropdown == this) {
                GradientScreen.this.openDropdown = null;
            }
        }

        private void scrollToSelected() {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.trowelData.getPalettes().size()) {
                int maxScroll = Math.max(0, (this.trowelData.getPalettes().size() - 3) * 20);
                this.scrollOffset = Math.max(0, Math.min(maxScroll, (this.selectedIndex - 1) * 20));
            } else {
                this.scrollOffset = 0;
            }
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
            if (this.isOpen && this.trowelData.getPalettes().size() > 3) {
                int dropdownY = this.getY() + this.height;
                int visibleHeight = 60;
                if (mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)dropdownY && mouseY < (double)(dropdownY + visibleHeight)) {
                    int maxScroll = (this.trowelData.getPalettes().size() - 3) * 20;
                    this.scrollOffset -= (int)(deltaY * 20.0);
                    this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, maxScroll));
                    return true;
                }
            }
            return false;
        }

        private void updateMessage() {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.trowelData.getPalettes().size()) {
                this.setMessage((Component)Component.literal((String)this.trowelData.getPalettes().get(this.selectedIndex).getName()));
            } else {
                this.setMessage((Component)Component.literal((String)"No Palette"));
            }
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -12829636);
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + 1, -10855846);
            graphics.fill(this.getX(), this.getY() + this.height - 1, this.getX() + this.width, this.getY() + this.height, -14803426);
            graphics.fill(this.getX(), this.getY(), this.getX() + 1, this.getY() + this.height, -10855846);
            graphics.fill(this.getX() + this.width - 1, this.getY(), this.getX() + this.width, this.getY() + this.height, -14803426);
            graphics.drawString(GradientScreen.this.font, this.getMessage(), this.getX() + 5, this.getY() + 6, 0xFFFFFF);
            String arrow = this.isOpen ? "\u25b2" : "\u25bc";
            graphics.drawString(GradientScreen.this.font, arrow, this.getX() + this.width - 12, this.getY() + 6, 0xFFFFFF);
        }

        public void renderDropdown(GuiGraphics graphics, int mouseX, int mouseY) {
            if (!this.isOpen) {
                return;
            }
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 400.0f);
            int dropdownY = this.getY() + this.height;
            int visibleHeight = 60;
            int totalItems = this.trowelData.getPalettes().size();
            boolean needsScroll = totalItems > 3;
            graphics.fill(this.getX(), dropdownY, this.getX() + this.width, dropdownY + visibleHeight, -13882324);
            graphics.fill(this.getX(), dropdownY, this.getX() + this.width, dropdownY + 1, -10855846);
            graphics.fill(this.getX(), dropdownY + visibleHeight - 1, this.getX() + this.width, dropdownY + visibleHeight, -14803426);
            graphics.fill(this.getX(), dropdownY, this.getX() + 1, dropdownY + visibleHeight, -10855846);
            graphics.fill(this.getX() + this.width - 1, dropdownY, this.getX() + this.width, dropdownY + visibleHeight, -14803426);
            graphics.enableScissor(this.getX() + 1, dropdownY + 1, this.getX() + this.width - 1, dropdownY + visibleHeight - 1);
            this.hoveredIndex = -1;
            if (mouseX >= this.getX() && mouseX < this.getX() + this.width - (needsScroll ? 10 : 0) && mouseY >= dropdownY && mouseY < dropdownY + visibleHeight) {
                int relativeY = mouseY - dropdownY + this.scrollOffset;
                this.hoveredIndex = relativeY / 20;
                if (this.hoveredIndex >= totalItems || this.hoveredIndex < 0) {
                    this.hoveredIndex = -1;
                }
            }
            for (int i = 0; i < totalItems; ++i) {
                int optionY = dropdownY + i * 20 - this.scrollOffset;
                if (optionY + 20 < dropdownY || optionY >= dropdownY + visibleHeight) continue;
                if (i == this.hoveredIndex || i == this.selectedIndex) {
                    graphics.fill(this.getX() + 1, optionY, this.getX() + this.width - (needsScroll ? 10 : 1), optionY + 20, i == this.selectedIndex ? 0x40FFFFFF : 0x20FFFFFF);
                }
                String paletteName = this.trowelData.getPalettes().get(i).getName();
                graphics.drawString(GradientScreen.this.font, paletteName, this.getX() + 5, optionY + 6, 0xFFFFFF);
            }
            graphics.disableScissor();
            if (needsScroll) {
                int scrollbarX = this.getX() + this.width - 8;
                int scrollbarY = dropdownY + 2;
                int scrollbarHeight = visibleHeight - 4;
                int maxScroll = (totalItems - 3) * 20;
                int thumbHeight = Math.max(20, (int)((float)visibleHeight / (float)(totalItems * 20) * (float)scrollbarHeight));
                int thumbY = scrollbarY + (int)((float)this.scrollOffset / (float)maxScroll * (float)(scrollbarHeight - thumbHeight));
                graphics.fill(scrollbarX, scrollbarY, scrollbarX + 6, scrollbarY + scrollbarHeight, -15066598);
                graphics.fill(scrollbarX + 1, thumbY, scrollbarX + 5, thumbY + thumbHeight, -10066330);
            }
            graphics.pose().popPose();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0) {
                if (this.isMouseOver(mouseX, mouseY)) {
                    this.setOpen(!this.isOpen);
                    return true;
                }
                if (this.isOpen) {
                    boolean needsScroll;
                    int dropdownY = this.getY() + this.height;
                    int visibleHeight = 60;
                    boolean bl = needsScroll = this.trowelData.getPalettes().size() > 3;
                    if (mouseX >= (double)this.getX()) {
                        int relativeY;
                        int clickedIndex;
                        int n = this.getX() + this.width;
                        int n2 = needsScroll ? 10 : 0;
                        if (mouseX < (double)(n - n2) && mouseY >= (double)dropdownY && mouseY < (double)(dropdownY + visibleHeight) && (clickedIndex = (relativeY = (int)(mouseY - (double)dropdownY) + this.scrollOffset) / 20) >= 0 && clickedIndex < this.trowelData.getPalettes().size()) {
                            this.selectedIndex = clickedIndex;
                            this.updateMessage();
                            this.onSelectionChange.accept(this.selectedIndex);
                            this.setOpen(false);
                            return true;
                        }
                    }
                    this.setOpen(false);
                    return true;
                }
            }
            return false;
        }

        public void setY(int y) {
            super.setY(y);
        }

        protected void updateWidgetNarration(NarrationElementOutput output) {
        }
    }

    private static enum DragType {
        NONE,
        SECTION_BOUNDARY,
        LEFT_TRANSITION,
        RIGHT_TRANSITION;

    }

    private class GradientSectionWidget {
        final int index;
        final PaletteDropdownWidget paletteButton;
        final Button colorButton;
        final Button transitionButton;
        final Button deleteButton;
        final Button moveUpButton;
        final Button moveDownButton;

        GradientSectionWidget(int index, GradientData.GradientSection section) {
            this.index = index;
            int rowY = GradientScreen.this.topPos + GradientScreen.this.getSectionListY() + index * 25;
            int buttonY = rowY + 2;
            TrowelData trowelData = ((GradientMenu)GradientScreen.this.menu).getTrowelData();
            this.paletteButton = (PaletteDropdownWidget)GradientScreen.this.addRenderableWidget((GuiEventListener)new PaletteDropdownWidget(GradientScreen.this.leftPos + 15, buttonY, 130, 20, section.getPaletteIndex(), trowelData, newIndex -> {
                section.setPaletteIndex((int)newIndex);
                GradientScreen.this.sendUpdate();
            }));
            this.colorButton = (Button)GradientScreen.this.addRenderableWidget((GuiEventListener)new ColorButton(GradientScreen.this.leftPos + 150, buttonY, 20, 20, section));
            String transitionText = section.isSmoothTransition() ? "Blend" : "Sharp";
            this.transitionButton = (Button)GradientScreen.this.addRenderableWidget((GuiEventListener)NoFocusButton.noFocusBuilder((Component)Component.literal((String)transitionText), button -> this.toggleTransition()).bounds(GradientScreen.this.leftPos + 175, buttonY, 70, 20).build());
            if (index >= ((GradientMenu)GradientScreen.this.menu).getGradientData().getSections().size() - 1) {
                this.transitionButton.visible = false;
            }
            this.deleteButton = (Button)GradientScreen.this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Remove"), button -> GradientScreen.this.removeSection(index)).bounds(GradientScreen.this.leftPos + 250, buttonY, 55, 20).build());
            this.moveUpButton = (Button)GradientScreen.this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2191"), button -> GradientScreen.this.moveSectionUp(index)).bounds(GradientScreen.this.leftPos + 320, buttonY, 20, 20).build());
            this.moveDownButton = (Button)GradientScreen.this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2193"), button -> GradientScreen.this.moveSectionDown(index)).bounds(GradientScreen.this.leftPos + 345, buttonY, 20, 20).build());
            if (index == 0) {
                this.moveUpButton.active = false;
            }
            if (index >= ((GradientMenu)GradientScreen.this.menu).getGradientData().getSections().size() - 1) {
                this.moveDownButton.active = false;
            }
        }

        void toggleTransition() {
            GradientData.GradientSection section;
            section.setSmoothTransition(!(section = ((GradientMenu)GradientScreen.this.menu).getGradientData().getSections().get(this.index)).isSmoothTransition());
            String transitionText = section.isSmoothTransition() ? "Blend" : "Sharp";
            this.transitionButton.setMessage((Component)Component.literal((String)transitionText));
            GradientScreen.this.sendUpdate();
        }
    }

    private class ColorButton
    extends Button {
        private final GradientData.GradientSection section;

        public ColorButton(int x, int y, int width, int height, GradientData.GradientSection section) {
            super(x, y, width, height, (Component)Component.empty(), button -> {
                section.setUsingCustomColor(false);
                section.setColorIndex((section.getColorIndex() + 1) % PALETTE_COLORS.length);
                GradientScreen.this.sendUpdate();
            }, Button.DEFAULT_NARRATION);
            this.section = section;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.active && this.visible) {
                if (button == 1 && this.clicked(mouseX, mouseY)) {
                    this.playDownSound(GradientScreen.this.minecraft.getSoundManager());
                    GradientScreen.this.openHexColorInput(this.section);
                    return true;
                }
                if (button == 0) {
                    return super.mouseClicked(mouseX, mouseY, button);
                }
            }
            return false;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int color = this.section.isUsingCustomColor() ? this.section.getCustomColor() : PALETTE_COLORS[this.section.getColorIndex()];
            guiGraphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + 19, this.getY() + 19, color);
            boolean hovered = this.isHovered();
            int borderColor = hovered ? -1 : -16777216;
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + 20, this.getY() + 1, borderColor);
            guiGraphics.fill(this.getX(), this.getY() + 19, this.getX() + 20, this.getY() + 20, borderColor);
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + 1, this.getY() + 20, borderColor);
            guiGraphics.fill(this.getX() + 19, this.getY(), this.getX() + 20, this.getY() + 20, borderColor);
            if (hovered) {
                String tooltip = this.section.isUsingCustomColor() ? String.format("Custom: #%06X | Right-click to change", this.section.getCustomColor() & 0xFFFFFF) : "Left-click to cycle | Right-click for custom";
                guiGraphics.renderTooltip(GradientScreen.this.font, (Component)Component.literal((String)tooltip), mouseX, mouseY);
            }
        }
    }
}

