/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.compat.create;

import com.asger.mechtrowel.compat.create.CopycatBlockConfig;
import com.asger.mechtrowel.compat.create.CopycatIntegration;
import com.asger.mechtrowel.compat.framedblocks.FramedBlocksCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;

public class CreateCompat {
    private static boolean createLoaded = false;
    private static boolean copycatsLoaded = false;

    public static boolean isCreateLoaded() {
        return createLoaded;
    }

    public static boolean isCopycatsLoaded() {
        return copycatsLoaded;
    }

    public static boolean isCopycatBlock(Block block) {
        if (!createLoaded && !copycatsLoaded) {
            return false;
        }
        String blockId = block.getDescriptionId();
        if (createLoaded && blockId.contains("create") && blockId.contains("copycat")) {
            return true;
        }
        return copycatsLoaded && blockId.contains("copycats") && blockId.contains("copycat");
    }

    public static boolean isValidCopycatMaterial(Block block) {
        if (CreateCompat.isCopycatBlock(block)) {
            return false;
        }
        return !FramedBlocksCompat.isFramedBlock(block);
    }

    public static boolean applyCopycatMaterial(Level level, BlockPos pos, BlockState material, boolean lit, CopycatBlockConfig.AxisMode axisMode, Player player) {
        if (!createLoaded && !copycatsLoaded) {
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return false;
        }
        String className = blockEntity.getClass().getName();
        if (!className.contains("copycat") && !className.contains("Copycat")) {
            return false;
        }
        try {
            return CopycatIntegration.applyMaterial(blockEntity, material, lit, axisMode, player);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean supportsLitProperty(BlockState material) {
        if (!createLoaded && !copycatsLoaded) {
            return false;
        }
        if (material.hasProperty((Property)BlockStateProperties.LIT)) {
            return true;
        }
        for (Property property : material.getProperties()) {
            if (!property.getName().equals("powering") || !(property instanceof BooleanProperty)) continue;
            return true;
        }
        return false;
    }

    public static boolean supportsAxisProperty(BlockState material) {
        if (!createLoaded && !copycatsLoaded) {
            return false;
        }
        return material.hasProperty((Property)BlockStateProperties.AXIS) || material.hasProperty((Property)BlockStateProperties.FACING);
    }

    public static boolean consumeMaterial(Player player, ItemStack material) {
        if (player.isCreative()) {
            return true;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)material)) continue;
            stack.shrink(1);
            return true;
        }
        return false;
    }

    static {
        createLoaded = ModList.get().isLoaded("create");
        copycatsLoaded = ModList.get().isLoaded("copycats");
    }
}

