/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.compat.jei;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.compat.create.CopycatBlockConfig;
import com.asger.mechtrowel.compat.create.CreateCompat;
import com.asger.mechtrowel.compat.framedblocks.FramedBlockConfig;
import com.asger.mechtrowel.compat.framedblocks.FramedBlocksCompat;
import com.asger.mechtrowel.gui.PaletteMenu;
import com.asger.mechtrowel.gui.PaletteScreen;
import com.asger.mechtrowel.gui.widget.GhostSlot;
import com.asger.mechtrowel.network.TrowelPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class GhostIngredientHandler {
    public List<Object> getTargets(PaletteScreen gui, Object ingredient, boolean doStart) {
        ArrayList<Object> targets = new ArrayList<Object>();
        if (!(ingredient instanceof ItemStack)) {
            return targets;
        }
        ItemStack itemStack = (ItemStack)ingredient;
        if (!(itemStack.getItem() instanceof BlockItem)) {
            return targets;
        }
        PaletteMenu menu = (PaletteMenu)gui.getMenu();
        for (int i = 0; i < menu.slots.size(); ++i) {
            Slot slot = (Slot)menu.slots.get(i);
            if (!(slot instanceof GhostSlot)) continue;
            GhostSlot ghostSlot = (GhostSlot)slot;
            GhostIngredientTarget target = new GhostIngredientTarget(gui, ghostSlot, i, TargetType.PALETTE_SLOT);
            targets.add(target);
        }
        if (gui.isRenaming()) {
            IconSlotTarget iconTarget = new IconSlotTarget(gui);
            targets.add(iconTarget);
        }
        if (gui.isConfiguringCopycat()) {
            CopycatMaterialTarget materialTarget = new CopycatMaterialTarget(gui);
            targets.add(materialTarget);
        }
        if (gui.isConfiguringFramed()) {
            FramedCamoTarget camoTarget = new FramedCamoTarget(gui);
            targets.add(camoTarget);
        }
        return targets;
    }

    public void onComplete() {
    }

    public static class GhostIngredientTarget {
        private final PaletteScreen screen;
        private final GhostSlot slot;
        private final int slotIndex;
        private final TargetType type;

        public GhostIngredientTarget(PaletteScreen screen, GhostSlot slot, int slotIndex, TargetType type) {
            this.screen = screen;
            this.slot = slot;
            this.slotIndex = slotIndex;
            this.type = type;
        }

        public Rect2i getArea() {
            int x = this.screen.getGuiLeft() + this.slot.x;
            int y = this.screen.getGuiTop() + this.slot.y;
            return new Rect2i(x, y, 16, 16);
        }

        public void accept(Object ingredient) {
            if (!(ingredient instanceof ItemStack)) {
                return;
            }
            ItemStack itemStack = (ItemStack)ingredient;
            if (!(itemStack.getItem() instanceof BlockItem)) {
                return;
            }
            ItemStack ghostStack = itemStack.copy();
            ghostStack.setCount(1);
            this.slot.set(ghostStack);
            CompoundTag data = new CompoundTag();
            data.putInt("slotIndex", this.slotIndex);
            data.putString("blockId", BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString());
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UPDATE_GHOST_SLOT, this.slotIndex, data), (CustomPacketPayload[])new CustomPacketPayload[0]);
            MechTrowel.LOGGER.debug("Accepted JEI ghost ingredient: {} in slot {}", (Object)itemStack.getItem(), (Object)this.slotIndex);
        }
    }

    public static enum TargetType {
        PALETTE_SLOT,
        ICON_SLOT,
        COPYCAT_MATERIAL;

    }

    public static class IconSlotTarget {
        private final PaletteScreen screen;

        public IconSlotTarget(PaletteScreen screen) {
            this.screen = screen;
        }

        public Rect2i getArea() {
            EditBox renameBox = this.screen.getRenameBox();
            if (renameBox == null) {
                return new Rect2i(0, 0, 0, 0);
            }
            int remainingSpace = this.screen.getGuiLeft() + this.screen.getImageWidth() - (renameBox.getX() + renameBox.getWidth());
            int slotX = renameBox.getX() + renameBox.getWidth() + (remainingSpace - 18) / 2;
            int slotY = renameBox.getY() + 1;
            return new Rect2i(slotX, slotY, 16, 16);
        }

        public void accept(Object ingredient) {
            if (!(ingredient instanceof ItemStack)) {
                return;
            }
            ItemStack itemStack = (ItemStack)ingredient;
            Item item = itemStack.getItem();
            if (!(item instanceof BlockItem)) {
                return;
            }
            BlockItem blockItem = (BlockItem)item;
            this.screen.setSelectedIconBlock(blockItem.getBlock().defaultBlockState());
            this.screen.getIconContainer().setItem(0, new ItemStack((ItemLike)blockItem));
            MechTrowel.LOGGER.debug("Accepted JEI ghost ingredient for icon: {}", (Object)itemStack.getItem());
        }
    }

    public static class CopycatMaterialTarget {
        private final PaletteScreen screen;

        public CopycatMaterialTarget(PaletteScreen screen) {
            this.screen = screen;
        }

        public Rect2i getArea() {
            int boxX = this.screen.getGuiLeft() + 10;
            int boxY = this.screen.getDropdownY() + 5;
            int boxWidth = 183;
            int slotX = boxX + boxWidth + 10;
            int slotY = boxY + 1;
            return new Rect2i(slotX, slotY, 16, 16);
        }

        public void accept(Object ingredient) {
            if (!(ingredient instanceof ItemStack)) {
                return;
            }
            ItemStack itemStack = (ItemStack)ingredient;
            Item item = itemStack.getItem();
            if (!(item instanceof BlockItem)) {
                return;
            }
            BlockItem blockItem = (BlockItem)item;
            if (!CreateCompat.isValidCopycatMaterial(blockItem.getBlock())) {
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft != null && minecraft.player != null) {
                    minecraft.player.playSound(SoundEvents.ITEM_BREAK, 0.5f, 1.5f);
                }
                return;
            }
            CopycatBlockConfig workingConfig = this.screen.getWorkingCopycatConfig();
            if (workingConfig != null) {
                workingConfig.setMaterial(blockItem.getBlock().defaultBlockState());
                this.screen.updateCopycatConfigButtons();
            }
            MechTrowel.LOGGER.debug("Accepted JEI ghost ingredient for copycat material: {}", (Object)itemStack.getItem());
        }
    }

    public static class FramedCamoTarget {
        private final PaletteScreen screen;

        public FramedCamoTarget(PaletteScreen screen) {
            this.screen = screen;
        }

        public Rect2i getArea() {
            int boxX = this.screen.getGuiLeft() + 10;
            int boxY = this.screen.getDropdownY() + 5;
            int boxWidth = 183;
            int slotX = boxX + boxWidth + 10;
            int slotY = boxY + 1;
            return new Rect2i(slotX, slotY, 16, 16);
        }

        public void accept(Object ingredient) {
            if (!(ingredient instanceof ItemStack)) {
                return;
            }
            ItemStack itemStack = (ItemStack)ingredient;
            Item item = itemStack.getItem();
            if (!(item instanceof BlockItem)) {
                return;
            }
            BlockItem blockItem = (BlockItem)item;
            if (!FramedBlocksCompat.isValidFramedCamo(blockItem.getBlock())) {
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft != null && minecraft.player != null) {
                    minecraft.player.playSound(SoundEvents.ITEM_BREAK, 0.5f, 1.5f);
                }
                return;
            }
            FramedBlockConfig workingConfig = this.screen.getWorkingFramedConfig();
            if (workingConfig != null) {
                workingConfig.setCamo(blockItem.getBlock().defaultBlockState());
            }
            MechTrowel.LOGGER.debug("Accepted JEI ghost ingredient for framed camo: {}", (Object)itemStack.getItem());
        }
    }
}

