/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui;

public class PaletteLayoutConstants {
    public static final Section DROPDOWN_SECTION = new Section("dropdown", 25, 0, 2);
    public static final Section BUTTONS_SECTION = new Section("buttons", 20, 0, 6);
    public static final Section PALETTE_SECTION = new Section("palette", 112, 2, 6);
    public static final Section CONTROLS_SECTION = new Section("controls", 20, 0, 5);
    public static final Section GLOBAL_SECTION = new Section("global", 20, 3, 0);
    public static final Section INVENTORY_SECTION = new Section("inventory", 83, 0, 3);
    public static final int GUI_WIDTH = 230;
    public static final int SLOT_SIZE = 18;
    public static final int LOCK_WIDTH = 5;
    public static final int UNIT_GAP = 3;
    public static final int BAR_HEIGHT = 5;
    public static final int SLOT_TO_BAR_GAP = 2;
    public static final int VERTICAL_SPACING = 29;
    public static final int INVENTORY_SLOT_Y_OFFSET = 7;
    public static final int HOTBAR_Y_OFFSET = 65;

    public static int calculateTotalHeight() {
        return DROPDOWN_SECTION.getTotalHeight() + BUTTONS_SECTION.getTotalHeight() + PALETTE_SECTION.getTotalHeight() + CONTROLS_SECTION.getTotalHeight() + GLOBAL_SECTION.getTotalHeight() + INVENTORY_SECTION.getTotalHeight();
    }

    public static int calculateTotalHeightWithRows(int visibleRows) {
        int paletteContentHeight = visibleRows * 29 - 4;
        return DROPDOWN_SECTION.getTotalHeight() + BUTTONS_SECTION.getTotalHeight() + PaletteLayoutConstants.PALETTE_SECTION.topPadding + paletteContentHeight + PaletteLayoutConstants.PALETTE_SECTION.bottomPadding + CONTROLS_SECTION.getTotalHeight() + GLOBAL_SECTION.getTotalHeight() + INVENTORY_SECTION.getTotalHeight();
    }

    public static int calculateGridY(int topPos) {
        LayoutCalculator calc = new LayoutCalculator(topPos);
        calc.addSection(DROPDOWN_SECTION);
        calc.addSection(BUTTONS_SECTION);
        return calc.getPositionForSection(PALETTE_SECTION);
    }

    public static int calculateGridY(int topPos, int visibleRows) {
        LayoutCalculator calc = new LayoutCalculator(topPos);
        calc.addSection(DROPDOWN_SECTION);
        calc.addSection(BUTTONS_SECTION);
        return calc.getPositionForSection(PALETTE_SECTION);
    }

    public static int calculateInventoryY(int topPos) {
        LayoutCalculator calc = new LayoutCalculator(topPos);
        calc.addSection(DROPDOWN_SECTION);
        calc.addSection(BUTTONS_SECTION);
        calc.addSection(PALETTE_SECTION);
        calc.addSection(CONTROLS_SECTION);
        calc.addSection(GLOBAL_SECTION);
        return calc.getPositionForSection(INVENTORY_SECTION);
    }

    public static int calculateInventoryY(int topPos, int visibleRows) {
        LayoutCalculator calc = new LayoutCalculator(topPos);
        calc.addSection(DROPDOWN_SECTION);
        calc.addSection(BUTTONS_SECTION);
        int paletteContentHeight = visibleRows * 29 - 4;
        calc.addSectionWithCustomHeight(PaletteLayoutConstants.PALETTE_SECTION.topPadding + paletteContentHeight + PaletteLayoutConstants.PALETTE_SECTION.bottomPadding);
        calc.addSection(CONTROLS_SECTION);
        calc.addSection(GLOBAL_SECTION);
        return calc.getPositionForSection(INVENTORY_SECTION);
    }

    public static class Section {
        final String name;
        final int contentHeight;
        final int topPadding;
        final int bottomPadding;

        Section(String name, int contentHeight, int topPadding, int bottomPadding) {
            this.name = name;
            this.contentHeight = contentHeight;
            this.topPadding = topPadding;
            this.bottomPadding = bottomPadding;
        }

        public int getTotalHeight() {
            return this.topPadding + this.contentHeight + this.bottomPadding;
        }
    }

    public static class LayoutCalculator {
        private int currentY;
        private final int startY;

        public LayoutCalculator(int startY) {
            this.startY = startY;
            this.currentY = startY;
        }

        public int getPositionForSection(Section section) {
            return this.currentY + section.topPadding;
        }

        public void addSection(Section section) {
            this.currentY += section.getTotalHeight();
        }

        public void addSectionWithCustomHeight(int height) {
            this.currentY += height;
        }

        public int getCurrentY() {
            return this.currentY;
        }

        public int getTotalHeight() {
            return this.currentY - this.startY;
        }
    }
}

