/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui;

import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.item.MechTrowelItem;
import com.asger.mechtrowel.registry.ModRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class RotationMenu
extends AbstractContainerMenu {
    private final int trowelSlot;
    private final Inventory playerInventory;
    private TrowelData trowelData;
    private CompoundTag lastKnownNBT;

    public RotationMenu(int windowId, Inventory playerInventory, ItemStack trowelStack) {
        super((MenuType)ModRegistry.ROTATION_MENU.get(), windowId);
        this.playerInventory = playerInventory;
        this.trowelSlot = playerInventory.findSlotMatchingItem(trowelStack);
        this.trowelData = TrowelData.getOrCreate(this.getTrowelStack());
        this.lastKnownNBT = ((CustomData)this.getTrowelStack().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().copy();
    }

    public RotationMenu(int windowId, Inventory playerInventory, int trowelSlot) {
        super((MenuType)ModRegistry.ROTATION_MENU.get(), windowId);
        this.playerInventory = playerInventory;
        this.trowelSlot = trowelSlot;
        this.trowelData = TrowelData.getOrCreate(this.getTrowelStack());
        this.lastKnownNBT = ((CustomData)this.getTrowelStack().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().copy();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.getTrowelStack().getItem() instanceof MechTrowelItem;
    }

    public TrowelData getTrowelData() {
        ItemStack currentStack = this.getTrowelStack();
        CompoundTag currentNBT = ((CustomData)currentStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (this.trowelData == null || !currentNBT.equals((Object)this.lastKnownNBT)) {
            this.trowelData = TrowelData.getOrCreate(currentStack);
            this.lastKnownNBT = currentNBT.copy();
        }
        return this.trowelData;
    }

    public ItemStack getTrowelStack() {
        return this.playerInventory.getItem(this.trowelSlot);
    }
}

