/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.network;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.compat.chipped.ChippedCompat;
import com.asger.mechtrowel.compat.create.CopycatBlockConfig;
import com.asger.mechtrowel.compat.framedblocks.FramedBlockConfig;
import com.asger.mechtrowel.compat.rechiseled.RechiseledCompat;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.gui.GradientMenu;
import com.asger.mechtrowel.gui.PaletteMenu;
import com.asger.mechtrowel.gui.RotationMenu;
import com.asger.mechtrowel.item.MechTrowelItem;
import com.asger.mechtrowel.registry.ModRegistry;
import com.asger.mechtrowel.util.WandUndoManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TrowelPacket(Action action, int intData, CompoundTag nbtData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TrowelPacket> TYPE = new CustomPacketPayload.Type(ModRegistry.modLoc("trowel_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TrowelPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, value) -> buf.writeEnum((Enum)value), buf -> (Action)buf.readEnum(Action.class)), TrowelPacket::action, (StreamCodec)StreamCodec.of((buf, value) -> buf.writeInt(value.intValue()), buf -> buf.readInt()), TrowelPacket::intData, (StreamCodec)StreamCodec.of((buf, value) -> buf.writeNbt((Tag)value), buf -> buf.readNbt()), TrowelPacket::nbtData, TrowelPacket::new);

    public static void handle(TrowelPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (!(player instanceof ServerPlayer)) {
                MechTrowel.LOGGER.warn("TrowelPacket received on wrong side or invalid player");
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = TrowelPacket.findTrowel(player);
            if (stack.isEmpty()) {
                MechTrowel.LOGGER.warn("Could not find trowel item for packet handling");
                return;
            }
            TrowelData trowelData = TrowelData.getOrCreate(stack);
            switch (packet.action.ordinal()) {
                case 0: {
                    int slot;
                    TrowelPacket.handleSavePalette(trowelData, packet.intData, packet.nbtData);
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    if (serverPlayer.containerMenu instanceof PaletteMenu) {
                        serverPlayer.containerMenu.broadcastChanges();
                    }
                    if ((slot = serverPlayer.getInventory().findSlotMatchingItem(stack)) >= 0) {
                        serverPlayer.inventoryMenu.getSlot(slot < 9 ? slot + 36 : slot).setChanged();
                    }
                    serverPlayer.inventoryMenu.broadcastFullState();
                    break;
                }
                case 1: {
                    int createSlot;
                    TrowelPacket.handleCreatePalette(trowelData, packet.nbtData);
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    AbstractContainerMenu patt0$temp = serverPlayer.containerMenu;
                    if (patt0$temp instanceof PaletteMenu) {
                        PaletteMenu paletteMenu = (PaletteMenu)patt0$temp;
                        paletteMenu.syncContainerWithPalette();
                        paletteMenu.broadcastChanges();
                    }
                    if ((createSlot = serverPlayer.getInventory().findSlotMatchingItem(stack)) >= 0) {
                        serverPlayer.inventoryMenu.getSlot(createSlot < 9 ? createSlot + 36 : createSlot).setChanged();
                    }
                    serverPlayer.inventoryMenu.broadcastFullState();
                    break;
                }
                case 2: {
                    int deleteSlot;
                    TrowelPacket.handleDeletePalette(trowelData, packet.intData);
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    AbstractContainerMenu patt1$temp = serverPlayer.containerMenu;
                    if (patt1$temp instanceof PaletteMenu) {
                        PaletteMenu paletteMenu = (PaletteMenu)patt1$temp;
                        paletteMenu.syncContainerWithPalette();
                        paletteMenu.broadcastChanges();
                    }
                    if ((deleteSlot = serverPlayer.getInventory().findSlotMatchingItem(stack)) >= 0) {
                        serverPlayer.inventoryMenu.getSlot(deleteSlot < 9 ? deleteSlot + 36 : deleteSlot).setChanged();
                    }
                    serverPlayer.inventoryMenu.broadcastFullState();
                    break;
                }
                case 3: {
                    int renameSlot;
                    TrowelPacket.handleRenamePalette(trowelData, packet.intData, packet.nbtData);
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    AbstractContainerMenu patt2$temp = serverPlayer.containerMenu;
                    if (patt2$temp instanceof PaletteMenu) {
                        PaletteMenu paletteMenu = (PaletteMenu)patt2$temp;
                        paletteMenu.broadcastChanges();
                    }
                    if ((renameSlot = serverPlayer.getInventory().findSlotMatchingItem(stack)) >= 0) {
                        serverPlayer.inventoryMenu.getSlot(renameSlot < 9 ? renameSlot + 36 : renameSlot).setChanged();
                    }
                    serverPlayer.inventoryMenu.broadcastFullState();
                    break;
                }
                case 4: {
                    int switchSlot;
                    trowelData.setActivePaletteIndex(packet.intData);
                    PaletteData activePalette = trowelData.getActivePalette();
                    if (activePalette != null) {
                        activePalette.updateLastUsedTime();
                    }
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    AbstractContainerMenu patt3$temp = serverPlayer.containerMenu;
                    if (patt3$temp instanceof PaletteMenu) {
                        PaletteMenu paletteMenu = (PaletteMenu)patt3$temp;
                        paletteMenu.syncContainerWithPalette();
                        paletteMenu.broadcastChanges();
                    }
                    if ((switchSlot = serverPlayer.getInventory().findSlotMatchingItem(stack)) >= 0) {
                        serverPlayer.inventoryMenu.getSlot(switchSlot < 9 ? switchSlot + 36 : switchSlot).setChanged();
                    }
                    serverPlayer.inventoryMenu.broadcastFullState();
                    break;
                }
                case 5: {
                    TrowelPacket.handleSaveRotation(trowelData, packet.nbtData);
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    break;
                }
                case 6: {
                    trowelData.load(packet.nbtData);
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    break;
                }
                case 7: {
                    trowelData.cycleActivePalette();
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    int cycleSlot = serverPlayer.getInventory().findSlotMatchingItem(stack);
                    if (cycleSlot >= 0) {
                        serverPlayer.inventoryMenu.getSlot(cycleSlot < 9 ? cycleSlot + 36 : cycleSlot).setChanged();
                    }
                    serverPlayer.inventoryMenu.broadcastFullState();
                    break;
                }
                case 8: {
                    trowelData.toggleBuildingMode();
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    TrowelData.BuildingMode mode = trowelData.getBuildingMode();
                    serverPlayer.displayClientMessage((Component)Component.literal((String)"Trowel Mode: ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)mode.getDisplayName()).withStyle(switch (mode) {
                        case TrowelData.BuildingMode.QUICK -> Style.EMPTY.withColor(ChatFormatting.WHITE).withBold(Boolean.valueOf(true));
                        case TrowelData.BuildingMode.BUILDER -> Style.EMPTY.withColor(ChatFormatting.BLUE).withBold(Boolean.valueOf(true));
                        case TrowelData.BuildingMode.WAND -> Style.EMPTY.withColor(ChatFormatting.LIGHT_PURPLE).withBold(Boolean.valueOf(true));
                        default -> Style.EMPTY.withBold(Boolean.valueOf(true));
                    })), true);
                    break;
                }
                case 9: {
                    trowelData.setReplaceMode(!trowelData.isReplaceMode());
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    serverPlayer.displayClientMessage((Component)Component.literal((String)"Replace Mode: ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)(trowelData.isReplaceMode() ? "ON" : "OFF")).withStyle(trowelData.isReplaceMode() ? Style.EMPTY.withColor(ChatFormatting.GREEN).withBold(Boolean.valueOf(true)) : Style.EMPTY.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true)))), true);
                    break;
                }
                case 10: {
                    if (!trowelData.isChippedConversionEnabled()) break;
                    trowelData.setChippedConversionActive(!trowelData.isChippedConversionActive());
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    ArrayList<String> activeMods = new ArrayList<String>();
                    if (ChippedCompat.isChippedLoaded()) {
                        activeMods.add("Chipped");
                    }
                    if (RechiseledCompat.isRechiseledLoaded()) {
                        activeMods.add("Rechiseled");
                    }
                    String modsText = String.join((CharSequence)" + ", activeMods);
                    serverPlayer.displayClientMessage((Component)Component.literal((String)("Variant Auto-Conversion (" + modsText + "): ")).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)(trowelData.isChippedConversionActive() ? "ON" : "OFF")).withStyle(trowelData.isChippedConversionActive() ? Style.EMPTY.withColor(ChatFormatting.GREEN).withBold(Boolean.valueOf(true)) : Style.EMPTY.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true)))), true);
                    break;
                }
                case 23: {
                    if (!trowelData.isCapacityUpgraded()) break;
                    trowelData.setCapacityActive(!trowelData.isCapacityActive());
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    serverPlayer.displayClientMessage((Component)Component.literal((String)"Wand Capacity (128 blocks): ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)(trowelData.isCapacityActive() ? "ON" : "OFF")).withStyle(trowelData.isCapacityActive() ? Style.EMPTY.withColor(ChatFormatting.GREEN).withBold(Boolean.valueOf(true)) : Style.EMPTY.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true)))), true);
                    break;
                }
                case 24: {
                    if (!trowelData.isReachUpgraded()) break;
                    trowelData.setReachActive(!trowelData.isReachActive());
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    double reachBonus = MechTrowel.Config.getReachUpgradeBonus();
                    serverPlayer.displayClientMessage((Component)Component.literal((String)("Extended Reach (+" + String.format("%.1f", reachBonus) + " blocks): ")).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)(trowelData.isReachActive() ? "ON" : "OFF")).withStyle(trowelData.isReachActive() ? Style.EMPTY.withColor(ChatFormatting.GREEN).withBold(Boolean.valueOf(true)) : Style.EMPTY.withColor(ChatFormatting.RED).withBold(Boolean.valueOf(true)))), true);
                    break;
                }
                case 11: {
                    trowelData.togglePreview();
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    serverPlayer.displayClientMessage((Component)Component.translatable((String)("message.mechtrowel.preview_" + (trowelData.isPreviewActive() ? "enabled" : "disabled"))).withStyle(ChatFormatting.YELLOW), true);
                    break;
                }
                case 12: {
                    TrowelPacket.openPaletteGui(serverPlayer, stack);
                    break;
                }
                case 13: {
                    TrowelPacket.openRotationGui(serverPlayer, stack);
                    break;
                }
                case 14: {
                    TrowelPacket.openGradientGui(serverPlayer, stack);
                    break;
                }
                case 15: {
                    TrowelPacket.handleUpdateCopycatConfig(trowelData, packet.intData, packet.nbtData);
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    if (!(serverPlayer.containerMenu instanceof PaletteMenu)) break;
                    serverPlayer.containerMenu.broadcastChanges();
                    break;
                }
                case 16: {
                    TrowelPacket.handleUpdateFramedConfig(trowelData, packet.intData, packet.nbtData);
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    if (!(serverPlayer.containerMenu instanceof PaletteMenu)) break;
                    serverPlayer.containerMenu.broadcastChanges();
                    break;
                }
                case 17: {
                    TrowelPacket.handleUndoWand(serverPlayer);
                    break;
                }
                case 18: {
                    trowelData.setPointSelectionMode(TrowelData.PointSelectionMode.START_POINT);
                    trowelData.setGradientConfirmed(false);
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.gradient_select_start"), true);
                    break;
                }
                case 19: {
                    trowelData.setPointSelectionMode(TrowelData.PointSelectionMode.END_POINT);
                    trowelData.setGradientConfirmed(false);
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.gradient_select_end"), true);
                    break;
                }
                case 20: {
                    trowelData.setGradientConfirmed(true);
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    break;
                }
                case 21: {
                    trowelData.setGradientConfirmed(false);
                    trowelData.save(stack);
                    serverPlayer.getInventory().setChanged();
                    break;
                }
                case 22: {
                    TrowelPacket.handleUpdateGhostSlot(serverPlayer, packet.intData, packet.nbtData);
                }
            }
        });
    }

    private static ItemStack findTrowel(Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof MechTrowelItem) {
            return stack;
        }
        stack = player.getOffhandItem();
        if (stack.getItem() instanceof MechTrowelItem) {
            return stack;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            stack = player.getInventory().getItem(i);
            if (!(stack.getItem() instanceof MechTrowelItem)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private static void handleSavePalette(TrowelData data, int paletteIndex, CompoundTag paletteData) {
        List<PaletteData> palettes = data.getPalettes();
        if (paletteIndex >= 0 && paletteIndex < palettes.size()) {
            PaletteData palette = palettes.get(paletteIndex);
            palette.load(paletteData);
            palette.updateLastUsedTime();
        } else {
            MechTrowel.LOGGER.warn("Invalid palette index: {} (total palettes: {})", (Object)paletteIndex, (Object)palettes.size());
        }
    }

    private static void handleCreatePalette(TrowelData data, CompoundTag paletteData) {
        if (data.getPalettes().size() < MechTrowel.Config.getMaxPalettes()) {
            PaletteData newPalette = new PaletteData();
            if (paletteData != null && paletteData.contains("name")) {
                newPalette.setName(paletteData.getString("name"));
            } else {
                newPalette.setName("Palette " + (data.getPalettes().size() + 1));
            }
            data.addPalette(newPalette);
            data.setActivePaletteIndex(data.getPalettes().size() - 1);
        }
    }

    private static void handleDeletePalette(TrowelData data, int paletteIndex) {
        if (data.getPalettes().size() > 1) {
            data.removePalette(paletteIndex);
            if (data.getActivePaletteIndex() >= data.getPalettes().size()) {
                data.setActivePaletteIndex(data.getPalettes().size() - 1);
            }
        }
    }

    private static void handleRenamePalette(TrowelData data, int paletteIndex, CompoundTag nameData) {
        List<PaletteData> palettes = data.getPalettes();
        if (paletteIndex >= 0 && paletteIndex < palettes.size() && nameData != null) {
            PaletteData palette = palettes.get(paletteIndex);
            if (nameData.contains("name")) {
                palette.setName(nameData.getString("name"));
            }
            if (nameData.contains("iconBlock")) {
                palette.setIconBlock(NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)nameData.getCompound("iconBlock")));
            } else if (nameData.getBoolean("clearIcon")) {
                palette.setIconBlock(null);
            }
        }
    }

    private static void handleSaveRotation(TrowelData data, CompoundTag rotationData) {
        data.getRotationLockData().load(rotationData);
    }

    private static void handleUpdateCopycatConfig(TrowelData data, int paletteIndex, CompoundTag updateData) {
        if (updateData == null || !updateData.contains("slot") || !updateData.contains("config")) {
            return;
        }
        int slot = updateData.getInt("slot");
        CompoundTag configTag = updateData.getCompound("config");
        List<PaletteData> palettes = data.getPalettes();
        if (paletteIndex >= 0 && paletteIndex < palettes.size()) {
            PaletteData palette = palettes.get(paletteIndex);
            for (PaletteData.WeightedBlock block : palette.getBlocks()) {
                if (block.getSlotPosition() != slot) continue;
                CopycatBlockConfig config = new CopycatBlockConfig();
                config.load(configTag);
                block.setCopycatConfig(config);
                break;
            }
        }
    }

    private static void handleUpdateFramedConfig(TrowelData data, int paletteIndex, CompoundTag updateData) {
        if (updateData == null || !updateData.contains("slot") || !updateData.contains("config")) {
            return;
        }
        int slot = updateData.getInt("slot");
        CompoundTag configTag = updateData.getCompound("config");
        List<PaletteData> palettes = data.getPalettes();
        if (paletteIndex >= 0 && paletteIndex < palettes.size()) {
            PaletteData palette = palettes.get(paletteIndex);
            for (PaletteData.WeightedBlock block : palette.getBlocks()) {
                if (block.getSlotPosition() != slot) continue;
                FramedBlockConfig config = new FramedBlockConfig();
                config.load(configTag);
                block.setFramedConfig(config);
                break;
            }
        }
    }

    private static void openPaletteGui(ServerPlayer player, final ItemStack stack) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)"gui.mechtrowel.palette");
            }

            public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
                return new PaletteMenu(windowId, inventory, stack);
            }
        }, buf -> {
            int slot = player.getInventory().findSlotMatchingItem(stack);
            buf.writeInt(slot);
        });
    }

    private static void openRotationGui(ServerPlayer player, final ItemStack stack) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)"gui.mechtrowel.rotation");
            }

            public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
                return new RotationMenu(windowId, inventory, stack);
            }
        }, buf -> buf.writeInt(player.getInventory().findSlotMatchingItem(stack)));
    }

    private static void openGradientGui(ServerPlayer player, final ItemStack stack) {
        TrowelData trowelData = TrowelData.getOrCreate(stack);
        if (trowelData.getPointSelectionMode() != TrowelData.PointSelectionMode.NONE) {
            trowelData.setPointSelectionMode(TrowelData.PointSelectionMode.NONE);
            trowelData.save(stack);
            player.getInventory().setChanged();
        }
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)"gui.mechtrowel.gradient");
            }

            public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
                return new GradientMenu(windowId, inventory, player.getInventory().findSlotMatchingItem(stack), stack);
            }
        }, buf -> {
            int slot = player.getInventory().findSlotMatchingItem(stack);
            buf.writeVarInt(slot);
            buf.writeVarInt(slot);
        });
    }

    private static void handleUndoWand(ServerPlayer player) {
        if (WandUndoManager.undoLastAction(player)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.wand_undo_success"), true);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.wand_undo_no_actions"), true);
        }
    }

    private static void handleUpdateGhostSlot(ServerPlayer player, int slotIndex, CompoundTag data) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof PaletteMenu)) {
            MechTrowel.LOGGER.warn("UPDATE_GHOST_SLOT received but player doesn't have PaletteMenu open");
            return;
        }
        PaletteMenu paletteMenu = (PaletteMenu)abstractContainerMenu;
        if (!data.contains("blockId")) {
            MechTrowel.LOGGER.warn("UPDATE_GHOST_SLOT received without blockId");
            return;
        }
        String blockId = data.getString("blockId");
        ResourceLocation blockRL = ResourceLocation.tryParse((String)blockId);
        if (blockRL == null) {
            MechTrowel.LOGGER.warn("Invalid block ID received: {}", (Object)blockId);
            return;
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(blockRL);
        if (!(item instanceof BlockItem)) {
            MechTrowel.LOGGER.warn("Item is not a block: {}", (Object)blockId);
            return;
        }
        ItemStack ghostStack = new ItemStack((ItemLike)item, 1);
        paletteMenu.updateGhostSlot(slotIndex, ghostStack);
        MechTrowel.LOGGER.debug("Updated ghost slot {} with block {}", (Object)slotIndex, (Object)blockId);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Action {
        SAVE_PALETTE,
        CREATE_PALETTE,
        DELETE_PALETTE,
        RENAME_PALETTE,
        SWITCH_PALETTE,
        SAVE_ROTATION,
        UPDATE_SETTINGS,
        CYCLE_PALETTE,
        TOGGLE_BUILD_MODE,
        TOGGLE_REPLACE,
        TOGGLE_CHIPPED,
        TOGGLE_PREVIEW,
        OPEN_PALETTE_GUI,
        OPEN_ROTATION_GUI,
        OPEN_GRADIENT_GUI,
        UPDATE_COPYCAT_CONFIG,
        UPDATE_FRAMED_CONFIG,
        UNDO_WAND,
        SET_GRADIENT_START_POINT,
        SET_GRADIENT_END_POINT,
        CONFIRM_GRADIENT,
        UNCONFIRM_GRADIENT,
        UPDATE_GHOST_SLOT,
        TOGGLE_CAPACITY,
        TOGGLE_REACH;

    }
}

