/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import top.xfunny.mod.BlockEntityTypes;
import top.xfunny.mod.Items;
import top.xfunny.mod.block.base.LiftDestinationDispatchTerminalBase;
import top.xfunny.mod.client.util.ArrayListToString;
import top.xfunny.mod.client.util.TransformPositionX;
import top.xfunny.mod.keymapping.SchindlerZLine3Keypad1KeyMapping;

public class SchindlerZLine3Keypad1
extends LiftDestinationDispatchTerminalBase {
    public SchindlerZLine3Keypad1() {
        super(true);
    }

    public static void hasButtonsClient(BlockPos trackPosition, LiftDestinationDispatchTerminalBase.FloorLiftCallback callback) {
        LiftDestinationDispatchTerminalBase.hasButtonsClient(trackPosition, callback);
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return IBlock.getVoxelShapeByDirection((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)1.2, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
    }

    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)UNLOCKED);
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        double hitX = MathHelper.fractionalPart((double)hit.getPos().getXMapped());
        double hitY = MathHelper.fractionalPart((double)hit.getPos().getYMapped());
        double hitZ = MathHelper.fractionalPart((double)hit.getPos().getZMapped());
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        double transformedX = TransformPositionX.transform(hitX, hitZ, facing);
        org.mtr.mapping.holder.BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity == null || !(blockEntity.data instanceof LiftDestinationDispatchTerminalBase.BlockEntityBase)) {
            return ActionResult.FAIL;
        }
        LiftDestinationDispatchTerminalBase.BlockEntityBase data = (LiftDestinationDispatchTerminalBase.BlockEntityBase)blockEntity.data;
        if (!(blockEntity.data instanceof BlockEntity)) {
            return ActionResult.FAIL;
        }
        BlockEntity data1 = (BlockEntity)blockEntity.data;
        SchindlerZLine3Keypad1KeyMapping mapping = new SchindlerZLine3Keypad1KeyMapping();
        String output = mapping.mapping(data.getScreenId(), transformedX, hitY);
        if (player.isHolding(Items.YTE_LIFT_BUTTONS_LINK_CONNECTOR.get()) || player.isHolding(Items.YTE_LIFT_BUTTONS_LINK_REMOVER.get()) || player.isHolding(Items.YTE_GROUP_LIFT_BUTTONS_LINK_CONNECTOR.get()) || player.isHolding(Items.YTE_GROUP_LIFT_BUTTONS_LINK_REMOVER.get())) {
            return ActionResult.PASS;
        }
        this.processKeyInput(world, pos, data1, data, data.getScreenId(), output);
        return ActionResult.SUCCESS;
    }

    private void processKeyInput(World world, BlockPos pos, BlockEntity data1, LiftDestinationDispatchTerminalBase.BlockEntityBase data, String screenId, String output) {
        HashMap<String, Integer> numberKeys = new HashMap<String, Integer>(){
            {
                this.put("number1", 1);
                this.put("number2", 2);
                this.put("number3", 3);
                this.put("number4", 4);
                this.put("number5", 5);
                this.put("number6", 6);
                this.put("number7", 7);
                this.put("number8", 8);
                this.put("number9", 9);
                this.put("number0", 0);
            }
        };
        BiConsumer<String, String> handleScreenAndInput = (screen, input) -> {
            data1.switchScreen(screen);
            data1.addInputString(world, pos, input, true, data1, data);
        };
        BiConsumer<String, String> handleLiftCall = (screen, callResult) -> {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            data1.switchScreen("schindler_z_line_3_keypad_1_key_mapping_identifier");
            if (!callResult.equals("?")) {
                data1.addInputString(world, pos, ">" + callResult, false, data1, data);
            } else {
                data1.addInputString(world, pos, "??", false, data1, data);
            }
            scheduler.schedule(() -> {
                data1.switchScreen(screen);
                data1.clearInputString();
            }, 3L, TimeUnit.SECONDS);
            scheduler.shutdown();
        };
        switch (screenId) {
            case "schindler_z_line_3_keypad_1_key_mapping_home": 
            case "schindler_z_line_3_keypad_1_key_mapping_accessibility": {
                if (numberKeys.containsKey(output)) {
                    handleScreenAndInput.accept("schindler_z_line_3_keypad_1_key_mapping_input", String.valueOf(numberKeys.get(output)));
                    break;
                }
                if ("basement".equals(output)) {
                    handleScreenAndInput.accept("schindler_z_line_3_keypad_1_key_mapping_input", "-");
                    break;
                }
                if ("accessibility".equals(output)) {
                    data1.switchScreen("schindler_z_line_3_keypad_1_key_mapping_accessibility");
                    break;
                }
                if (!"lobby".equals(output)) break;
                String callResult2 = data.callLift(world, pos, "1");
                callResult2 = callResult2.equals("?") ? data.callLift(world, pos, "G") : callResult2;
                handleLiftCall.accept("schindler_z_line_3_keypad_1_key_mapping_home", callResult2);
                break;
            }
            case "schindler_z_line_3_keypad_1_key_mapping_input": {
                if (numberKeys.containsKey(output)) {
                    data1.addInputString(world, pos, numberKeys.get(output), true, data1, data);
                    break;
                }
                if ("basement".equals(output)) {
                    data1.addInputString(world, pos, "-", true, data1, data);
                    break;
                }
                if ("accessibility".equals(output)) {
                    data1.addInputString(world, pos, "1", true, data1, data);
                    break;
                }
                if (!"lobby".equals(output)) break;
                String callResult3 = data.callLift(world, pos, "1");
                callResult3 = callResult3.equals("?") ? data.callLift(world, pos, "G") : callResult3;
                handleLiftCall.accept("schindler_z_line_3_keypad_1_key_mapping_home", callResult3);
                break;
            }
            case "schindler_z_line_3_keypad_1_key_mapping_identifier": {
                if (numberKeys.containsKey(output)) {
                    data1.clearInputString();
                    handleScreenAndInput.accept("schindler_z_line_3_keypad_1_key_mapping_input", String.valueOf(numberKeys.get(output)));
                    break;
                }
                if ("basement".equals(output)) {
                    data1.clearInputString();
                    handleScreenAndInput.accept("schindler_z_line_3_keypad_1_key_mapping_input", "-");
                    break;
                }
                if ("accessibility".equals(output)) {
                    data1.clearInputString();
                    data1.switchScreen("schindler_z_line_3_keypad_1_key_mapping_accessibility");
                    break;
                }
                if (!"lobby".equals(output)) break;
                String callResult4 = data.callLift(world, pos, "1");
                callResult4 = callResult4.equals("?") ? data.callLift(world, pos, "G") : callResult4;
                handleLiftCall.accept("schindler_z_line_3_keypad_1_key_mapping_home", callResult4);
            }
        }
    }

    public static class BlockEntity
    extends LiftDestinationDispatchTerminalBase.BlockEntityBase {
        public ArrayList<Object> inputString = new ArrayList();
        private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        private ScheduledFuture<?> scheduledTask;

        public BlockEntity(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.SCHINDLER_Z_LINE_3_KEYPAD_1.get(), pos, state);
            super.registerScreenId("schindler_z_line_3_keypad_1_key_mapping_home");
        }

        public void addInputString(World world, BlockPos pos, Object number, boolean callLift, BlockEntity data1, LiftDestinationDispatchTerminalBase.BlockEntityBase data) {
            if (callLift) {
                this.inputString.add(number);
                if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
                    this.scheduledTask.cancel(false);
                }
                Runnable task = () -> {
                    this.switchScreen("schindler_z_line_3_keypad_1_key_mapping_identifier");
                    this.callLift(world, pos, ArrayListToString.arrayListToString(data1.getInputString()));
                    String liftIdentifier = data.getLiftIdentifier();
                    data1.addInputString(world, pos, liftIdentifier.equals("?") ? "??" : "<" + liftIdentifier, false, data1, data);
                    ScheduledExecutorService scheduler1 = Executors.newSingleThreadScheduledExecutor();
                    scheduler1.schedule(() -> {
                        data1.clearInputString();
                        data1.switchScreen("schindler_z_line_3_keypad_1_key_mapping_home");
                    }, 3L, TimeUnit.SECONDS);
                    scheduler1.shutdown();
                };
                this.scheduledTask = this.scheduler.schedule(task, 3L, TimeUnit.SECONDS);
            } else {
                this.inputString.clear();
                this.inputString.add(number);
            }
        }

        public void clearInputString() {
            this.inputString.clear();
        }

        public ArrayList<Object> getInputString() {
            if (this.inputString.isEmpty()) {
                this.inputString.add("");
            }
            return this.inputString;
        }

        public void switchScreen(Object screenId) {
            super.registerScreenId((String)screenId);
        }
    }
}

