/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.Locale;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.mapping.holder.AbstractTexture;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.NativeImage;
import org.mtr.mapping.holder.NativeImageBackedTexture;
import org.mtr.mod.render.MainRenderer;
import top.xfunny.mod.client.YteRouteMapGenerator;
import top.xfunny.mod.client.resource.FontList;

public class TextureCache {
    private static final int COOL_DOWN_TIME = 10000;
    private static final Identifier DEFAULT_BLACK_RESOURCE = new Identifier("yte", "textures/block/black.png");
    private static final Identifier DEFAULT_WHITE_RESOURCE = new Identifier("yte", "textures/block/white.png");
    private static final Identifier DEFAULT_TRANSPARENT_RESOURCE = new Identifier("yte", "textures/block/transparent.png");
    public static TextureCache instance = new TextureCache();
    private final Object2ObjectLinkedOpenHashMap<String, DynamicResource> dynamicResources = new Object2ObjectLinkedOpenHashMap();
    private final ObjectOpenHashSet<String> generatingResources = new ObjectOpenHashSet();
    private final ObjectArrayList<Runnable> resourceRegistryQueue = new ObjectArrayList();
    public int totalWidth;

    public void reload() {
        FontList.instance.FontReload();
        this.dynamicResources.values().forEach(dynamicResource -> {
            dynamicResource.needsRefresh = true;
        });
        this.generatingResources.clear();
    }

    public byte[] getTextPixels(String text, int[] dimensions, int maxWidth, int fontSize, int padding, Font font, int letterSpacing) {
        if (maxWidth <= 0) {
            dimensions[0] = 0;
            dimensions[1] = 0;
            return new byte[0];
        }
        this.totalWidth = 0;
        FontRenderContext context = new FontRenderContext(new AffineTransform(), false, false);
        Font selectedFont = font.deriveFont(0, fontSize);
        FontMetrics fontMetrics = new Canvas().getFontMetrics(selectedFont);
        int totalTextWidth = 0;
        for (char c : text.toCharArray()) {
            totalTextWidth += fontMetrics.charWidth(c) + letterSpacing;
        }
        totalTextWidth -= letterSpacing;
        int textHeight = fontMetrics.getHeight() + 2 * padding;
        this.totalWidth = totalTextWidth += 2 * padding;
        BufferedImage textImage = new BufferedImage(totalTextWidth, textHeight, 10);
        Graphics2D graphics2D = textImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setFont(selectedFont);
        graphics2D.setColor(Color.WHITE);
        int x = padding;
        int y = padding + fontMetrics.getAscent();
        for (char c : text.toCharArray()) {
            graphics2D.drawString(String.valueOf(c), x, y);
            x += fontMetrics.charWidth(c) + letterSpacing;
        }
        graphics2D.dispose();
        dimensions[0] = totalTextWidth;
        dimensions[1] = textHeight;
        byte[] pixels = ((DataBufferByte)textImage.getRaster().getDataBuffer()).getData();
        textImage.flush();
        return pixels;
    }

    public DynamicResource getResource(String key, Supplier<NativeImage> supplier, DefaultRenderingColor defaultRenderingColor) {
        DynamicResource dynamicResource;
        Runnable runnable;
        if (!this.resourceRegistryQueue.isEmpty() && (runnable = (Runnable)this.resourceRegistryQueue.remove(0)) != null) {
            runnable.run();
        }
        if ((dynamicResource = (DynamicResource)this.dynamicResources.get((Object)key)) != null && !dynamicResource.needsRefresh) {
            dynamicResource.expiryTime = System.currentTimeMillis() + 10000L;
            return dynamicResource;
        }
        if (this.generatingResources.contains((Object)key)) {
            return defaultRenderingColor.dynamicResource;
        }
        MainRenderer.WORKER_THREAD.scheduleDynamicTextures(() -> {
            FontList.instance.FlonList();
            NativeImage nativeImage = (NativeImage)supplier.get();
            this.resourceRegistryQueue.add(() -> {
                DynamicResource staticTextureProviderOld = (DynamicResource)this.dynamicResources.get((Object)key);
                if (staticTextureProviderOld != null) {
                    staticTextureProviderOld.remove();
                }
                if (nativeImage != null) {
                    NativeImageBackedTexture nativeImageBackedTexture = new NativeImageBackedTexture(nativeImage);
                    Identifier identifier = new Identifier("yte", "id_" + Utilities.numberToPaddedHexString((long)new Random().nextLong()).toLowerCase(Locale.ENGLISH));
                    MinecraftClient.getInstance().getTextureManager().registerTexture(identifier, new AbstractTexture((net.minecraft.client.renderer.texture.AbstractTexture)nativeImageBackedTexture.data));
                    DynamicResource dynamicResourceNew = new DynamicResource(identifier, nativeImageBackedTexture);
                    this.dynamicResources.put((Object)key, (Object)dynamicResourceNew);
                }
                this.generatingResources.remove((Object)key);
            });
        });
        YteRouteMapGenerator.setConstants();
        this.generatingResources.add((Object)key);
        if (dynamicResource == null) {
            return defaultRenderingColor.dynamicResource;
        }
        dynamicResource.expiryTime = System.currentTimeMillis() + 10000L;
        dynamicResource.needsRefresh = false;
        return dynamicResource;
    }

    public static class DynamicResource {
        public final int width;
        public final int height;
        public final Identifier identifier;
        private long expiryTime;
        private boolean needsRefresh;

        private DynamicResource(Identifier identifier, @Nullable NativeImageBackedTexture nativeImageBackedTexture) {
            this.identifier = identifier;
            if (nativeImageBackedTexture != null) {
                NativeImage nativeImage = nativeImageBackedTexture.getImage();
                if (nativeImage != null) {
                    this.width = nativeImage.getWidth();
                    this.height = nativeImage.getHeight();
                } else {
                    this.width = 16;
                    this.height = 16;
                }
            } else {
                this.width = 16;
                this.height = 16;
            }
        }

        private void remove() {
            MinecraftClient.getInstance().getTextureManager().destroyTexture(this.identifier);
            MainRenderer.cancelRender((Identifier)this.identifier);
        }
    }

    public static enum DefaultRenderingColor {
        BLACK(DEFAULT_BLACK_RESOURCE),
        WHITE(DEFAULT_WHITE_RESOURCE),
        TRANSPARENT(DEFAULT_TRANSPARENT_RESOURCE);

        private final DynamicResource dynamicResource;

        private DefaultRenderingColor(Identifier identifier) {
            this.dynamicResource = new DynamicResource(identifier, null);
        }
    }
}

