/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client;

import java.awt.Font;
import java.util.Locale;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.NativeImage;
import org.mtr.mapping.holder.NativeImageFormat;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.IGui;
import top.xfunny.mod.client.TextureCache;

public class YteRouteMapGenerator
implements IGui {
    private static int scale;
    private static int lineSize;
    private static int fontSizeBig;
    private static int fontSizeSmall;

    public static NativeImage generateImage(String text, int textColor, Font font, int fontSize, int padding, int letterSpacing) {
        YteRouteMapGenerator.setConstants();
        try {
            int height = Math.round((float)scale * 1.5f);
            int[] dimensions = new int[2];
            byte[] pixels = TextureCache.instance.getTextPixels(text.toUpperCase(Locale.ENGLISH), dimensions, 90, fontSizeSmall * fontSize, padding, font, letterSpacing);
            int totalWidth = TextureCache.instance.totalWidth;
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), totalWidth, height, false);
            nativeImage.fillRect(0, 0, totalWidth, height, 0);
            YteRouteMapGenerator.drawString(nativeImage, pixels, totalWidth / 2, height / 2, dimensions, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, -16777216, textColor, false);
            YteRouteMapGenerator.clearColor(nativeImage, YteRouteMapGenerator.invertColor(-16777216), 19);
            return nativeImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setConstants() {
        scale = (int)Math.pow(2.0, Config.getClient().getDynamicTextureResolution() + 5);
        lineSize = scale / 8;
        fontSizeBig = lineSize * 2;
        fontSizeSmall = fontSizeBig / 2;
    }

    public static void clearColor(NativeImage nativeImage, int targetColor, int tolerance) {
        int width = nativeImage.getWidth();
        int height = nativeImage.getHeight();
        int targetR = targetColor >> 16 & 0xFF;
        int targetG = targetColor >> 8 & 0xFF;
        int targetB = targetColor & 0xFF;
        int targetA = targetColor >> 24 & 0xFF;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int currentColor = nativeImage.getColor(x, y);
                int currentR = currentColor >> 16 & 0xFF;
                int currentG = currentColor >> 8 & 0xFF;
                int currentB = currentColor & 0xFF;
                int currentA = currentColor >> 24 & 0xFF;
                int deltaR = Math.abs(currentR - targetR);
                int deltaG = Math.abs(currentG - targetG);
                int deltaB = Math.abs(currentB - targetB);
                int deltaA = Math.abs(currentA - targetA);
                if (deltaR <= tolerance && deltaG <= tolerance && deltaB <= tolerance && deltaA <= tolerance) {
                    nativeImage.setPixelColor(x, y, 0);
                    continue;
                }
                int blurredColor = YteRouteMapGenerator.applyFXAA(nativeImage, x, y);
                nativeImage.setPixelColor(x, y, blurredColor);
            }
        }
    }

    private static int applyFXAA(NativeImage image, int x, int y) {
        int colorDown;
        int width = image.getWidth();
        int height = image.getHeight();
        int colorCenter = image.getColor(x, y);
        int colorLeft = x > 0 ? image.getColor(x - 1, y) : colorCenter;
        int colorRight = x < width - 1 ? image.getColor(x + 1, y) : colorCenter;
        int colorUp = y > 0 ? image.getColor(x, y - 1) : colorCenter;
        int n = colorDown = y < height - 1 ? image.getColor(x, y + 1) : colorCenter;
        if ((colorCenter >> 24 & 0xFF) == 0) {
            return 0;
        }
        int blendedR = ((colorLeft >> 16 & 0xFF) + (colorRight >> 16 & 0xFF) + (colorUp >> 16 & 0xFF) + (colorDown >> 16 & 0xFF) + (colorCenter >> 16 & 0xFF)) / 5;
        int blendedG = ((colorLeft >> 8 & 0xFF) + (colorRight >> 8 & 0xFF) + (colorUp >> 8 & 0xFF) + (colorDown >> 8 & 0xFF) + (colorCenter >> 8 & 0xFF)) / 5;
        int blendedB = ((colorLeft & 0xFF) + (colorRight & 0xFF) + (colorUp & 0xFF) + (colorDown & 0xFF) + (colorCenter & 0xFF)) / 5;
        int blendedA = ((colorLeft >> 24 & 0xFF) + (colorRight >> 24 & 0xFF) + (colorUp >> 24 & 0xFF) + (colorDown >> 24 & 0xFF) + (colorCenter >> 24 & 0xFF)) / 5;
        return blendedA << 24 | blendedR << 16 | blendedG << 8 | blendedB;
    }

    public static void drawString(NativeImage nativeImage, byte[] pixels, int x, int y, int[] textDimensions, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, int backgroundColor, int textColor, boolean rotate90) {
        int drawY;
        int drawX;
        if ((backgroundColor >> 24 & 0xFF) > 0) {
            for (drawX = 0; drawX < textDimensions[rotate90 ? 1 : 0]; ++drawX) {
                for (drawY = 0; drawY < textDimensions[rotate90 ? 0 : 1]; ++drawY) {
                    YteRouteMapGenerator.drawPixelSafe(nativeImage, (int)horizontalAlignment.getOffset((float)(drawX + x), (float)textDimensions[rotate90 ? 1 : 0]), (int)verticalAlignment.getOffset((float)(drawY + y), (float)textDimensions[rotate90 ? 0 : 1]), backgroundColor);
                }
            }
        }
        drawX = 0;
        drawY = rotate90 ? textDimensions[0] - 1 : 0;
        for (int i = 0; i < textDimensions[0] * textDimensions[1]; ++i) {
            YteRouteMapGenerator.blendPixel(nativeImage, (int)horizontalAlignment.getOffset((float)(x + drawX), (float)textDimensions[rotate90 ? 1 : 0]), (int)verticalAlignment.getOffset((float)(y + drawY), (float)textDimensions[rotate90 ? 0 : 1]), ((pixels[i] & 0xFF) << 24) + (textColor & 0xFFFFFF));
            if (rotate90) {
                if (--drawY >= 0) continue;
                drawY = textDimensions[0] - 1;
                ++drawX;
                continue;
            }
            if (++drawX != textDimensions[0]) continue;
            drawX = 0;
            ++drawY;
        }
    }

    private static void blendPixel(NativeImage nativeImage, int x, int y, int color) {
        float percent;
        if (Utilities.isBetween((double)x, (double)0.0, (double)(nativeImage.getWidth() - 1)) && Utilities.isBetween((double)y, (double)0.0, (double)(nativeImage.getHeight() - 1)) && (percent = (float)(color >> 24 & 0xFF) / 255.0f) > 0.0f) {
            int existingPixel = nativeImage.getColor(x, y);
            boolean existingTransparent = (existingPixel >> 24 & 0xFF) == 0;
            int r1 = existingTransparent ? 255 : existingPixel & 0xFF;
            int g1 = existingTransparent ? 255 : existingPixel >> 8 & 0xFF;
            int b1 = existingTransparent ? 255 : existingPixel >> 16 & 0xFF;
            int r2 = color >> 16 & 0xFF;
            int g2 = color >> 8 & 0xFF;
            int b2 = color & 0xFF;
            float inversePercent = 1.0f - percent;
            int finalColor = 0xFF000000 | ((int)((float)r1 * inversePercent + (float)r2 * percent) << 16) + ((int)((float)g1 * inversePercent + (float)g2 * percent) << 8) + (int)((float)b1 * inversePercent + (float)b2 * percent);
            YteRouteMapGenerator.drawPixelSafe(nativeImage, x, y, finalColor);
        }
    }

    private static void drawPixelSafe(NativeImage nativeImage, int x, int y, int color) {
        if (Utilities.isBetween((double)x, (double)0.0, (double)(nativeImage.getWidth() - 1)) && Utilities.isBetween((double)y, (double)0.0, (double)(nativeImage.getHeight() - 1))) {
            nativeImage.setPixelColor(x, y, YteRouteMapGenerator.invertColor(color));
        }
    }

    public static int invertColor(int color) {
        return ((color & 0xFF000000) != 0 ? -16777216 : 0) + ((color & 0xFF) << 16) + (color & 0xFF00) + ((color & 0xFF0000) >> 16);
    }
}

