/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.HitachiB85Button1;
import top.xfunny.mod.block.HitachiB85Button2;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.resource.FontList;
import top.xfunny.mod.client.util.ReverseRendering;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.ImageView;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftArrowView;
import top.xfunny.mod.client.view.LiftButtonView;
import top.xfunny.mod.client.view.LiftFloorDisplayView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.view_group.FrameLayout;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;

public class RenderHitachiB85Button2
extends BlockEntityRenderer<HitachiB85Button2.BlockEntity>
implements DirectionHelper,
IGui,
IBlock {
    private static final int HOVER_COLOR = -3342371;
    private static final int PRESSED_COLOR = -13210;
    private static final Identifier ARROW_TEXTURE = new Identifier("yte", "textures/block/hitachi_dot_arrow_1.png");
    private static final Identifier BUTTON_TEXTURE = new Identifier("yte", "textures/block/hitachi_b85_button.png");
    private static final Identifier BUTTON_LIGHT_TEXTURE = new Identifier("yte", "textures/block/hitachi_b85_button_light.png");
    private static final Identifier SCREEN_BACKGROUND_TEXTURE = new Identifier("yte", "textures/block/hitachi_b85_screen_1.png");

    public RenderHitachiB85Button2(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    public void render(HitachiB85Button2.BlockEntity blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, 0.05887499995343387);
        });
        LinearLayout parentLayout = new LinearLayout(true);
        parentLayout.setBasicsAttributes(world, blockEntity.getPos2());
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(0.25f, 0.5546875f);
        parentLayout.setPosition(-0.125f, 0.0f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        LinearLayout screenLayout = new LinearLayout(false);
        screenLayout.setBasicsAttributes(world, blockEntity.getPos2());
        screenLayout.setWidth(LayoutSize.WRAP_CONTENT);
        screenLayout.setHeight(LayoutSize.WRAP_CONTENT);
        screenLayout.setGravity(Gravity.CENTER_HORIZONTAL);
        screenLayout.setMargin(0.0f, 0.0875f, 0.0f, 0.0f);
        screenLayout.setId("screen");
        FrameLayout buttonLayout = new FrameLayout();
        buttonLayout.setBasicsAttributes(world, blockEntity.getPos2());
        buttonLayout.setWidth(LayoutSize.MATCH_PARENT);
        buttonLayout.setHeight(LayoutSize.MATCH_PARENT);
        buttonLayout.setMargin(0.0f, 0.015625f, 0.0f, 0.0f);
        LiftButtonView button = new LiftButtonView();
        button.setBasicsAttributes(world, blockEntity.getPos2(), buttonDescriptor, true, false, false, false);
        button.setLight(light);
        button.setHover(false);
        button.setDefaultColor(-1);
        button.setPressedColor(-1);
        button.setHoverColor(-1);
        button.setTexture(BUTTON_TEXTURE, true);
        button.setWidth(0.0625f);
        button.setHeight(0.0625f);
        button.setSpacing(0.0125f);
        button.setGravity(Gravity.CENTER);
        LiftButtonView buttonLight = new LiftButtonView();
        buttonLight.setBasicsAttributes(world, blockEntity.getPos2(), buttonDescriptor, true, false, false, false);
        buttonLight.setLight(light);
        buttonLight.setHover(true);
        buttonLight.setDefaultColor(-1);
        buttonLight.setPressedColor(-13210);
        buttonLight.setHoverColor(-3342371);
        buttonLight.setTexture(BUTTON_LIGHT_TEXTURE, false);
        buttonLight.setWidth(0.0625f);
        buttonLight.setHeight(0.0625f);
        buttonLight.setClientMedian(0.125);
        buttonLight.setSpacing(0.0125f);
        buttonLight.setGravity(Gravity.CENTER);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockEntity.getPos2());
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        blockEntity.forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            HitachiB85Button1.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                instructionDirections.forEach(liftDirection -> {
                    switch (liftDirection) {
                        case DOWN: {
                            buttonLight.setDownButtonLight();
                            break;
                        }
                        case UP: {
                            buttonLight.setUpButtonLight();
                        }
                    }
                });
            });
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockEntity.getPos2().getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        if (!sortedPositionsAndLifts.isEmpty()) {
            int count = Math.min(2, sortedPositionsAndLifts.size());
            boolean reverseRendering = count > 1 && ReverseRendering.reverseRendering(facing.rotateYCounterclockwise(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(0)).left(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(1)).left());
            for (int i = 0; i < count; ++i) {
                LiftFloorDisplayView liftFloorDisplayView = new LiftFloorDisplayView();
                liftFloorDisplayView.setBasicsAttributes(world, blockEntity.getPos2(), (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), FontList.instance.getFont("hitachi_modern"), 12, -65536);
                liftFloorDisplayView.setTextScrolling(true, 2, 0.05f);
                liftFloorDisplayView.setTextureId("hitachi_b85_screen_2_display");
                liftFloorDisplayView.setWidth(0.0375f);
                liftFloorDisplayView.setHeight(0.0375f);
                liftFloorDisplayView.setMargin(0.00625f, 0.00625f, 0.0f, 0.0f);
                liftFloorDisplayView.setTextAlign(LiftFloorDisplayView.TextAlign.CENTER);
                LiftArrowView liftArrowView = new LiftArrowView();
                liftArrowView.setBasicsAttributes(world, blockEntity.getPos2(), (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right());
                liftArrowView.setTexture(ARROW_TEXTURE);
                liftArrowView.setArrowScrolling(false, 0.05f);
                liftArrowView.setWidth(0.034375f);
                liftArrowView.setHeight(0.034375f);
                liftArrowView.setGravity(Gravity.CENTER_HORIZONTAL);
                liftArrowView.setMargin(0.0f, 0.09375f, 0.0f, 0.0f);
                liftArrowView.setColor(-65536);
                FrameLayout backgroundLayout = new FrameLayout();
                backgroundLayout.setBasicsAttributes(world, blockEntity.getPos2());
                backgroundLayout.setWidth(LayoutSize.WRAP_CONTENT);
                backgroundLayout.setHeight(LayoutSize.WRAP_CONTENT);
                backgroundLayout.setMargin(0.015625f, 0.0234375f, 0.015625f, 0.0f);
                backgroundLayout.setId("background_" + i);
                ImageView screenBackground = new ImageView();
                screenBackground.setBasicsAttributes(world, blockEntity.getPos2());
                screenBackground.setTexture(SCREEN_BACKGROUND_TEXTURE);
                screenBackground.setWidth(0.08125f);
                screenBackground.setHeight(0.0375f);
                screenBackground.setScale(1.159292f);
                screenBackground.setMargin(0.0f, 0.046875f, 0.0f, 0.0f);
                screenBackground.setGravity(Gravity.CENTER);
                LinearLayout numberLayout = new LinearLayout(true);
                numberLayout.setBasicsAttributes(world, blockEntity.getPos2());
                numberLayout.setWidth(LayoutSize.WRAP_CONTENT);
                numberLayout.setHeight(LayoutSize.WRAP_CONTENT);
                numberLayout.addChild(liftArrowView);
                numberLayout.addChild(liftFloorDisplayView);
                numberLayout.setGravity(Gravity.CENTER);
                if (reverseRendering) {
                    backgroundLayout.addChild(screenBackground);
                    backgroundLayout.addChild(numberLayout);
                    screenLayout.addChild(backgroundLayout);
                    screenLayout.reverseChildren();
                    continue;
                }
                backgroundLayout.addChild(screenBackground);
                backgroundLayout.addChild(numberLayout);
                screenLayout.addChild(backgroundLayout);
            }
        }
        buttonLayout.addChild(button);
        buttonLayout.addChild(buttonLight);
        parentLayout.addChild(screenLayout);
        parentLayout.addChild(buttonLayout);
        parentLayout.render();
    }
}

