/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.OtisSeries1Button;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftButtonView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.view_group.FrameLayout;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;

public class RenderOtisSeries1Button
extends BlockEntityRenderer<OtisSeries1Button.BlockEntity>
implements DirectionHelper,
IGui,
IBlock {
    public RenderOtisSeries1Button(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    public void render(OtisSeries1Button.BlockEntity blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> graphicsHolder.rotateYDegrees(-facing.asRotation()));
        FrameLayout parentLayout = new FrameLayout();
        parentLayout.setBasicsAttributes(world, blockEntity.getPos2());
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(0.3f, 0.40625f);
        parentLayout.setPosition(-0.15f, 0.046875f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        FrameLayout backgroundLayout = new FrameLayout();
        backgroundLayout.setBasicsAttributes(world, blockEntity.getPos2());
        backgroundLayout.setWidth(LayoutSize.WRAP_CONTENT);
        backgroundLayout.setHeight(LayoutSize.WRAP_CONTENT);
        backgroundLayout.setGravity(Gravity.CENTER);
        backgroundLayout.setBackgroundColor(-50331648);
        backgroundLayout.addStoredMatrixTransformations(graphicsHolder -> graphicsHolder.translate(0.0, 0.0, (double)-0.009375f));
        LinearLayout buttonLayout = new LinearLayout(false);
        buttonLayout.setBasicsAttributes(world, blockEntity.getPos2());
        buttonLayout.setWidth(LayoutSize.WRAP_CONTENT);
        buttonLayout.setHeight(LayoutSize.WRAP_CONTENT);
        buttonLayout.setGravity(Gravity.CENTER);
        buttonLayout.setMargin(0.0f, 0.0f, 0.025f, 0.025f);
        LiftButtonView button = new LiftButtonView();
        button.setBasicsAttributes(world, blockEntity.getPos2(), buttonDescriptor, true, false, false, false);
        button.setLight(light);
        button.setHover(true);
        button.setDefaultColor(-1);
        button.setPressedColor(-13509);
        button.setHoverColor(-1);
        button.setTexture(new Identifier("yte", "textures/block/otis_s1_button.png"), true);
        button.setWidth(0.0625f);
        button.setHeight(0.0625f);
        button.setSpacing(0.03125f);
        button.setGravity(Gravity.START);
        LiftButtonView buttonArrow = new LiftButtonView();
        buttonArrow.setBasicsAttributes(world, blockEntity.getPos2(), buttonDescriptor, true, false, false, false);
        buttonArrow.setLight(light);
        buttonArrow.setHover(false);
        buttonArrow.setDefaultColor(-1);
        buttonArrow.setPressedColor(-1);
        buttonArrow.setHoverColor(-1);
        buttonArrow.setTexture(new Identifier("yte", "textures/block/otis_s1_arrow.png"), true);
        buttonArrow.setWidth(0.0625f);
        buttonArrow.setHeight(0.0625f);
        buttonArrow.setSpacing(0.03125f);
        buttonArrow.setMargin(0.0f, 0.0f, 0.025f, 0.0f);
        buttonArrow.setGravity(Gravity.END);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockEntity.getPos2());
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        blockEntity.forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            OtisSeries1Button.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                instructionDirections.forEach(liftDirection -> {
                    switch (liftDirection) {
                        case DOWN: {
                            button.setDownButtonLight();
                            break;
                        }
                        case UP: {
                            button.setUpButtonLight();
                        }
                    }
                });
            });
            buttonLayout.addChild(buttonArrow);
            buttonLayout.addChild(button);
            parentLayout.addChild(backgroundLayout);
            backgroundLayout.addChild(buttonLayout);
        });
        parentLayout.render();
    }
}

