/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.RenderLifts;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.SchindlerMSeriesScreen3Even;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.resource.FontList;
import top.xfunny.mod.client.util.ClientGetLiftDetails;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.ImageView;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftButtonView;
import top.xfunny.mod.client.view.LiftFloorDisplayView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.view_group.FrameLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;

public class RenderSchindlerMSeriesScreen3<T extends LiftButtonsBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements DirectionHelper,
IGui,
IBlock {
    private static final int PRESSED_COLOR = -13312;
    private static final Identifier BUTTON_TEXTURE = new Identifier("yte", "textures/block/schindler_m_series_panel_arrow_2.png");
    private static final Identifier ARROW_TEXTURE = new Identifier("yte", "textures/block/schindler_m_series_lantern_3.png");
    private static final Identifier SCREEN_TEXTURE = new Identifier("yte", "textures/block/schindler_m_series_screen_1_white.png");
    private final boolean isOdd;

    public RenderSchindlerMSeriesScreen3(BlockEntityRenderer.Argument dispatcher, Boolean isOdd) {
        super(dispatcher);
        this.isOdd = isOdd;
    }

    public void render(T blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, 0.056574999953433874);
        });
        FrameLayout parentLayout = new FrameLayout();
        parentLayout.setBasicsAttributes(world, blockEntity.getPos2());
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(1.125f, 0.28125f);
        parentLayout.setPosition(this.isOdd ? -0.5575f : -1.055f, 0.61f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        FrameLayout screenLayout = new FrameLayout();
        screenLayout.setBasicsAttributes(world, blockEntity.getPos2());
        screenLayout.setWidth(LayoutSize.WRAP_CONTENT);
        screenLayout.setHeight(LayoutSize.WRAP_CONTENT);
        screenLayout.setGravity(Gravity.CENTER);
        LiftButtonView button = new LiftButtonView();
        button.setBasicsAttributes(world, blockEntity.getPos2(), buttonDescriptor, false, true, true, false);
        button.setLight(light);
        button.setHover(false);
        button.setDefaultColor(-1);
        button.setPressedColor(-1);
        button.setHoverColor(-1);
        button.setTexture(BUTTON_TEXTURE, true);
        button.setWidth(0.203125f);
        button.setHeight(0.203125f);
        button.setSpacing(0.4f);
        button.setGravity(Gravity.CENTER);
        LiftButtonView button1 = new LiftButtonView();
        button1.setBasicsAttributes(world, blockEntity.getPos2(), buttonDescriptor, false, true, true, false);
        button1.setLight(light);
        button1.setHover(false);
        button1.setDefaultColor(-1);
        button.setPressedColor(-13312);
        button1.setHoverColor(-1);
        button1.setTexture(ARROW_TEXTURE, true);
        button1.setWidth(0.203125f);
        button1.setHeight(0.203125f);
        button1.setSpacing(0.4f);
        button1.setGravity(Gravity.CENTER);
        ImageView background = new ImageView();
        background.setBasicsAttributes(world, blockEntity.getPos2());
        background.setTexture(new Identifier("yte", "textures/block/schindler_m_series_screen_1_white.png"));
        background.setWidth(0.203125f);
        background.setLight(light);
        background.setScale(1.0f);
        background.setGravity(Gravity.CENTER);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockEntity.getPos2());
        LineComponent buttonLine = new LineComponent();
        buttonLine.setBasicsAttributes(world, blockEntity.getPos2());
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        ((LiftButtonsBase.BlockEntityBase)blockEntity).forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            SchindlerMSeriesScreen3Even.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                LiftDirection pressedButtonDirection = blockEntity.getPressedButtonDirection();
                ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(world, lift, Init.positionToBlockPos((Position)lift.getCurrentFloor().getPosition()));
                String floorNumber = (String)((ObjectObjectImmutablePair)liftDetails.right()).left();
                String currentFloorNumber = (String)((ObjectObjectImmutablePair)RenderLifts.getLiftDetails((World)world, (Lift)lift, (BlockPos)trackPosition).right()).left();
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                if (instructionDirections.isEmpty() && pressedButtonDirection != null && lift.getDoorValue() != 0.0f && floorNumber.equals(currentFloorNumber)) {
                    switch (pressedButtonDirection) {
                        case DOWN: {
                            button.setDownButtonLight();
                            break;
                        }
                        case UP: {
                            button.setUpButtonLight();
                        }
                    }
                }
                instructionDirections.forEach(liftDirection -> {
                    if (lift.getDoorValue() != 0.0f && floorNumber.equals(currentFloorNumber)) {
                        if (liftDirection == LiftDirection.NONE) {
                            if (pressedButtonDirection != null) {
                                switch (pressedButtonDirection) {
                                    case DOWN: {
                                        button.setDownButtonLight();
                                        break;
                                    }
                                    case UP: {
                                        button.setUpButtonLight();
                                    }
                                }
                            }
                        } else {
                            switch (liftDirection) {
                                case DOWN: {
                                    button.setDownButtonLight();
                                    break;
                                }
                                case UP: {
                                    button.setUpButtonLight();
                                }
                            }
                        }
                    }
                });
            });
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockEntity.getPos2().getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        if (!sortedPositionsAndLifts.isEmpty()) {
            boolean count = true;
            for (int i = 0; i < 1; ++i) {
                LiftFloorDisplayView liftFloorDisplayView = new LiftFloorDisplayView();
                liftFloorDisplayView.setBasicsAttributes(world, blockEntity.getPos2(), (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), FontList.instance.getFont("acmeled"), 5, -65536);
                liftFloorDisplayView.setTextScrolling(true, 2, 0.0f);
                liftFloorDisplayView.setTextureId("schindler_m_series_screen_3_display");
                liftFloorDisplayView.setLetterSpacing(10);
                liftFloorDisplayView.setWidth(0.125f);
                liftFloorDisplayView.setHeight(0.125f);
                liftFloorDisplayView.setTextAlign(LiftFloorDisplayView.TextAlign.RIGHT);
                liftFloorDisplayView.setMargin(-0.0140625f, 0.075f, 0.0375f, 0.0f);
                screenLayout.addChild(liftFloorDisplayView);
                parentLayout.addChild(background);
            }
        }
        ((LiftButtonsBase.BlockEntityBase)blockEntity).forEachLiftButtonPosition(buttonPosition -> buttonLine.RenderLine(holdingLinker, (BlockPos)buttonPosition, true));
        parentLayout.addChild(screenLayout);
        parentLayout.addChild(button1);
        parentLayout.addChild(button);
        parentLayout.render();
    }
}

