/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.SchindlerSSeriesGreyButton;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftButtonView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.view_group.FrameLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;

public class RenderSchindlerSSeriesGreyButton
extends BlockEntityRenderer<SchindlerSSeriesGreyButton.BlockEntity>
implements DirectionHelper,
IGui,
IBlock {
    private static final int HOVER_COLOR = -7274608;
    private static final int PRESSED_COLOR = -16711936;
    private final Identifier BUTTON_TEXTURE = new Identifier("yte", "textures/block/schindler_s_series_grey_button.png");
    private final Identifier BUTTON_LIGHT_TEXTURE = new Identifier("yte", "textures/block/schindler_s_series_grey_button_light.png");

    public RenderSchindlerSSeriesGreyButton(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    public void render(SchindlerSSeriesGreyButton.BlockEntity blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        StoredMatrixTransformations storedMatrixTransformations1 = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, 0.05887499995343387);
        });
        FrameLayout parentLayout = new FrameLayout();
        parentLayout.setBasicsAttributes(world, blockEntity.getPos2());
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(0.21875f, 0.5625f);
        parentLayout.setPosition(-0.109375f, 0.0f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        LiftButtonView button = new LiftButtonView();
        button.setBasicsAttributes(world, blockPos, buttonDescriptor, true, false, false, false);
        button.setLight(light);
        button.setDefaultColor(-1);
        button.setHover(false);
        button.setPressedColor(-1);
        button.setHoverColor(-1);
        button.setTexture(this.BUTTON_TEXTURE, true);
        button.setWidth(0.125f);
        button.setHeight(0.125f);
        button.setSpacing(0.0625f);
        button.setGravity(Gravity.CENTER);
        LiftButtonView buttonLight = new LiftButtonView();
        buttonLight.setBasicsAttributes(world, blockPos, buttonDescriptor, true, false, false, false);
        buttonLight.setLight(light);
        buttonLight.setDefaultColor(-16777216);
        buttonLight.setHover(true);
        buttonLight.setPressedColor(-16711936);
        buttonLight.setHoverColor(-7274608);
        buttonLight.setTexture(this.BUTTON_LIGHT_TEXTURE, true);
        buttonLight.setWidth(0.125f);
        buttonLight.setHeight(0.125f);
        buttonLight.setSpacing(0.0625f);
        buttonLight.setGravity(Gravity.CENTER);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockEntity.getPos2());
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        blockEntity.forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            SchindlerSSeriesGreyButton.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                instructionDirections.forEach(liftDirection -> {
                    switch (liftDirection) {
                        case DOWN: {
                            buttonLight.setDownButtonLight();
                            break;
                        }
                        case UP: {
                            buttonLight.setUpButtonLight();
                        }
                    }
                });
            });
        });
        parentLayout.addChild(button);
        parentLayout.addChild(buttonLight);
        parentLayout.render();
    }
}

