/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.HitResult;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockLiftTrackFloor;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.TestLiftButtonsWithoutScreen;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.render.RenderLiftObjectLink;
import top.xfunny.mod.client.util.ReverseRendering;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;

public class RenderTestLiftButtonsWithoutScreen
extends BlockEntityRenderer<TestLiftButtonsWithoutScreen.BlockEntity>
implements DirectionHelper,
IGui,
IBlock {
    private static final int HOVER_COLOR = -5943296;
    private static final int PRESSED_COLOR = -2686976;
    private static final Identifier BUTTON_TEXTURE = new Identifier("mtr", "textures/block/lift_button.png");

    public RenderTestLiftButtonsWithoutScreen(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    public void render(TestLiftButtonsWithoutScreen.BlockEntity blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        boolean lookingAtBottomHalf;
        boolean lookingAtTopHalf;
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        StoredMatrixTransformations storedMatrixTransformations1 = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        boolean[] buttonStates = new boolean[]{false, false};
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        blockEntity.forEachTrackPosition(trackPosition -> {
            if (world.getBlockState((BlockPos)trackPosition).getBlock().data instanceof BlockLiftTrackFloor) {
                Direction trackFacing = IBlock.getStatePropertySafe((World)world, (BlockPos)trackPosition, (DirectionProperty)FACING);
                RenderLiftObjectLink.RenderLiftObjectLink(storedMatrixTransformations1, new Vector3d((double)((float)facing.getOffsetX() / 2.0f), 0.5, (double)((float)facing.getOffsetZ() / 2.0f)), new Vector3d((double)((float)(trackPosition.getX() - blockPos.getX()) + (float)trackFacing.getOffsetX() / 2.0f), (double)(trackPosition.getY() - blockPos.getY()) + 0.5, (double)((float)(trackPosition.getZ() - blockPos.getZ()) + (float)trackFacing.getOffsetZ() / 2.0f)), holdingLinker);
            }
            TestLiftButtonsWithoutScreen.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                instructionDirections.forEach(liftDirection -> {
                    switch (liftDirection) {
                        case DOWN: {
                            buttonStates[0] = true;
                            break;
                        }
                        case UP: {
                            buttonStates[1] = true;
                        }
                    }
                });
            });
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockPos.getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        HitResult hitResult = MinecraftClient.getInstance().getCrosshairTargetMapped();
        if (hitResult == null || !IBlock.getStatePropertySafe((BlockState)blockState, (BooleanProperty)TestLiftButtonsWithoutScreen.UNLOCKED)) {
            lookingAtTopHalf = false;
            lookingAtBottomHalf = false;
        } else {
            Vector3d hitLocation = hitResult.getPos();
            double hitY = MathHelper.fractionalPart((double)hitLocation.getYMapped());
            boolean inBlock = hitY < 0.5 && Init.newBlockPos((double)hitLocation.getXMapped(), (double)hitLocation.getYMapped(), (double)hitLocation.getZMapped()).equals((Object)blockPos);
            lookingAtTopHalf = inBlock && (!buttonDescriptor.hasDownButton() || hitY > 0.25);
            lookingAtBottomHalf = inBlock && (!buttonDescriptor.hasUpButton() || hitY < 0.25);
        }
        StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations1.copy();
        storedMatrixTransformations2.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, 0.43437499995343387);
        });
        if (buttonDescriptor.hasDownButton()) {
            MainRenderer.scheduleRender((Identifier)BUTTON_TEXTURE, (boolean)false, (QueuedRenderLayer)(buttonStates[0] || lookingAtBottomHalf ? QueuedRenderLayer.LIGHT_TRANSLUCENT : QueuedRenderLayer.EXTERIOR), (graphicsHolder, offset) -> {
                storedMatrixTransformations2.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)-0.09375f, (float)((buttonDescriptor.hasUpButton() ? 0.5f : 2.5f) / 16.0f), (float)0.1875f, (float)0.1875f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)facing, (int)(buttonStates[0] ? -2686976 : (lookingAtBottomHalf ? -5943296 : -10066330)), (int)light);
                graphicsHolder.pop();
            });
        }
        if (buttonDescriptor.hasUpButton()) {
            MainRenderer.scheduleRender((Identifier)BUTTON_TEXTURE, (boolean)false, (QueuedRenderLayer)(buttonStates[1] || lookingAtTopHalf ? QueuedRenderLayer.LIGHT_TRANSLUCENT : QueuedRenderLayer.EXTERIOR), (graphicsHolder, offset) -> {
                storedMatrixTransformations2.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)-0.09375f, (float)((buttonDescriptor.hasDownButton() ? 4.5f : 2.5f) / 16.0f), (float)0.1875f, (float)0.1875f, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (Direction)facing, (int)(buttonStates[1] ? -2686976 : (lookingAtTopHalf ? -5943296 : -10066330)), (int)light);
                graphicsHolder.pop();
            });
        }
        if (!sortedPositionsAndLifts.isEmpty()) {
            int count = Math.min(2, sortedPositionsAndLifts.size());
            float width = count == 1 ? 0.25f : 0.375f;
            StoredMatrixTransformations storedMatrixTransformations3 = storedMatrixTransformations2.copy();
            storedMatrixTransformations3.add(graphicsHolder -> {
                graphicsHolder.rotateZDegrees(180.0f);
                graphicsHolder.translate((double)(-width / 2.0f), 0.0, 0.0);
            });
            boolean reverseRendering = count > 1 && ReverseRendering.reverseRendering(facing.rotateYCounterclockwise(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(0)).left(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(1)).left());
            for (int i = 0; i < count; ++i) {
                double x = ((double)(reverseRendering ? count - i - 1 : i) + 0.5) * (double)width / (double)count;
                StoredMatrixTransformations storedMatrixTransformations4 = storedMatrixTransformations3.copy();
                storedMatrixTransformations4.add(graphicsHolder -> graphicsHolder.translate(x, -0.875, (double)-0.003125f));
            }
        }
    }
}

