/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockLiftTrackFloor;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.TestLiftPanel;
import top.xfunny.mod.client.TextureCache;
import top.xfunny.mod.client.render.RenderLiftObjectLink;
import top.xfunny.mod.client.resource.TextureList;
import top.xfunny.mod.client.util.ClientGetLiftDetails;
import top.xfunny.mod.client.util.ReverseRendering;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;

public class RenderTestLiftPanel
extends BlockEntityRenderer<TestLiftPanel.BlockEntity>
implements DirectionHelper,
IGui,
IBlock {
    private static final float ARROW_SPEED = 0.04f;
    private static final Identifier ARROW_TEXTURE = new Identifier("mtr", "textures/block/lift_arrow.png");
    private final boolean isOdd;
    private Lift lift = null;

    public RenderTestLiftPanel(BlockEntityRenderer.Argument dispatcher, Boolean isOdd) {
        super(dispatcher);
        this.isOdd = isOdd;
    }

    public void render(TestLiftPanel.BlockEntity blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        StoredMatrixTransformations storedMatrixTransformations1 = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        blockEntity.forEachTrackPosition(trackPosition -> {
            if (world.getBlockState((BlockPos)trackPosition).getBlock().data instanceof BlockLiftTrackFloor) {
                Direction trackFacing = IBlock.getStatePropertySafe((World)world, (BlockPos)trackPosition, (DirectionProperty)FACING);
                RenderLiftObjectLink.RenderLiftObjectLink(storedMatrixTransformations1, new Vector3d((double)((float)facing.getOffsetX() / 2.0f), 0.5, (double)((float)facing.getOffsetZ() / 2.0f)), new Vector3d((double)((float)(trackPosition.getX() - blockPos.getX()) + (float)trackFacing.getOffsetX() / 2.0f), (double)(trackPosition.getY() - blockPos.getY()) + 0.5, (double)((float)(trackPosition.getZ() - blockPos.getZ()) + (float)trackFacing.getOffsetZ() / 2.0f)), holdingLinker);
            }
            TestLiftPanel.LiftCheck(trackPosition, (floorIndex, lift) -> sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift)));
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockPos.getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations1.copy();
        storedMatrixTransformations2.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, 0.43437499995343387);
        });
        if (!sortedPositionsAndLifts.isEmpty()) {
            int count = Math.min(2, sortedPositionsAndLifts.size());
            float width = count == 1 ? 0.25f : 0.495f;
            StoredMatrixTransformations storedMatrixTransformations3 = storedMatrixTransformations2.copy();
            storedMatrixTransformations3.add(graphicsHolder -> {
                graphicsHolder.rotateZDegrees(180.0f);
                graphicsHolder.translate((double)(-width / 2.0f), 0.0, 0.0);
            });
            MainRenderer.scheduleRender((Identifier)new Identifier("mtr", "textures/block/black.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
                storedMatrixTransformations3.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)0.0f, (float)-0.9375f, (float)width, (float)0.40625f, (Direction)Direction.UP, (int)light);
                graphicsHolder.pop();
            });
            boolean reverseRendering = count > 1 && ReverseRendering.reverseRendering(facing.rotateYCounterclockwise(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(0)).left(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(1)).left());
            for (int i = 0; i < count; ++i) {
                double x = ((double)(reverseRendering ? count - i - 1 : i) + 0.5) * (double)width / (double)count;
                StoredMatrixTransformations storedMatrixTransformations4 = storedMatrixTransformations3.copy();
                storedMatrixTransformations4.add(graphicsHolder -> graphicsHolder.translate(x, -0.875, (double)-0.003125f));
                this.renderLiftDisplay(storedMatrixTransformations4, world, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), width * 4.0f / (float)count, 0.2f, 0.2f, 0.2f);
            }
        }
    }

    private void renderLiftDisplay(StoredMatrixTransformations storedMatrixTransformations, World world, Lift lift, float width, float width1, float height1, float height) {
        ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(world, lift, Init.positionToBlockPos((Position)lift.getCurrentFloor().getPosition()));
        LiftDirection liftDirection = (LiftDirection)liftDetails.left();
        String floorNumber = (String)((ObjectObjectImmutablePair)liftDetails.right()).left();
        String floorDescription = (String)((ObjectObjectImmutablePair)liftDetails.right()).right();
        boolean noFloorNumber = floorNumber.isEmpty();
        boolean noFloorDisplay = floorDescription.isEmpty();
        float gameTick = InitClient.getGameTick();
        boolean goingUp = liftDirection == LiftDirection.UP;
        float arrowSize = width / 6.0f;
        float y = height;
        if (liftDirection != LiftDirection.NONE) {
            float uv = gameTick * 0.04f % 1.0f;
            int color = goingUp ? -16711936 : -65536;
            MainRenderer.scheduleRender((Identifier)ARROW_TEXTURE, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(-width / 4.0f + arrowSize), (float)(y - 0.24f), (float)arrowSize, (float)arrowSize, (float)0.0f, (float)((float)(!goingUp ? 1 : 0) + uv), (float)1.0f, (float)((float)(goingUp ? 1 : 0) + uv), (Direction)Direction.UP, (int)color, (int)GraphicsHolder.getDefaultLight());
                graphicsHolder.pop();
            });
        }
        if (!noFloorNumber || !noFloorDisplay) {
            String text = String.format("%s%s", floorNumber, noFloorNumber ? " " : "");
            if (text.length() > 2) {
                float scrollSpeed = 24.0f;
                float scaledSpeed = scrollSpeed * (width1 / (float)TextureCache.instance.totalWidth);
                float offset1 = gameTick * scaledSpeed % (float)TextureCache.instance.totalWidth;
                if (offset1 > (float)TextureCache.instance.totalWidth - width1) {
                    offset1 -= (float)TextureCache.instance.totalWidth;
                }
                float finalOffset = offset1;
                MainRenderer.scheduleRender((Identifier)TextureList.instance.getTestLiftPanelDisplay((String)text, (int)0xFFAA00).identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolder, offset);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(-width + 0.9f), (float)(y - 0.07f), (float)width1, (float)height1, (float)finalOffset, (float)0.0f, (float)(finalOffset + 1.0f / (float)text.length() + 1.0E-4f * (float)text.length()), (float)1.0f, (Direction)Direction.UP, (int)-1, (int)GraphicsHolder.getDefaultLight());
                    graphicsHolder.pop();
                });
            } else {
                MainRenderer.scheduleRender((Identifier)TextureList.instance.getTestLiftPanelDisplay((String)text, (int)0xFFAA00).identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolder, offset);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(-width + 0.9f), (float)(y - 0.07f), (float)width1, (float)height1, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)-1, (int)GraphicsHolder.getDefaultLight());
                    graphicsHolder.pop();
                });
            }
        }
    }
}

